/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.Messages;
import de.renier.vdr.channel.editor.util.Utils;

/**
 * SaveAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class SaveAction extends AbstractAction {

  private static final long serialVersionUID = -496038610815542654L;

  public SaveAction() {
    super(Messages.getString("SaveAction.0"), new ImageIcon(OpenAction.class.getResource("/org/javalobby/icons/20x20/Save.gif"))); //$NON-NLS-1$ //$NON-NLS-2$
    this.setEnabled(false);
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent e) {
    if (ChannelEditor.application.getChannelFile() != null && ChannelEditor.application.isModified()) {
      File saveFile = ChannelEditor.application.getChannelFile();
      try {
        // open output file
        FileWriter outFile = new FileWriter(saveFile);
        Utils.outputChannelTree(outFile, ChannelEditor.application.getChannelListingPanel().getRootNode());
        ChannelEditor.application.setModified(false);
      } catch (Exception ioe) {
        JOptionPane.showConfirmDialog(ChannelEditor.application, Messages.getString("SaveAction.2") + saveFile.getPath() //$NON-NLS-1$
            + Messages.getString("SaveAction.3") + ioe.getMessage(), Messages.getString("SaveAction.4"), JOptionPane.CLOSED_OPTION, JOptionPane.ERROR_MESSAGE); //$NON-NLS-1$ //$NON-NLS-2$
        ioe.printStackTrace();
      }
    } else {
      // call save as if no file
      if (ChannelEditor.application.getChannelFile() == null) {
        ActionManager.getInstance().getSaveAsAction().actionPerformed(e);
      }
    }

  }

}
