/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import javax.swing.Action;

/**
 * ActionManager
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class ActionManager {

  private static ActionManager instance = null;
  private Action openAction = null;
  private Action saveAction = null;
  private Action saveAsAction = null;
  private Action closeAction = null;
  private Action parkAction = null;
  private Action unparkAction = null;
  private Action aboutAction = null;
  private Action deleteChannelAction = null;
  private Action searchAction = null;
  private Action createCategoryAction = null;
  private Action multiRenameAction = null;
  private Action preferencesAction = null;
  private Action statisticAction = null;
  private Action createChannelAction = null;
  private Action importAliasAction = null;
  private Action exportAliasAction = null;

  /**
   * Singleton Constructor
   */
  private ActionManager() {
    openAction = new OpenAction();
    saveAction = new SaveAction();
    closeAction = new CloseAction();
    parkAction = new ParkAction();
    unparkAction = new UnparkAction();
    aboutAction = new AboutAction();
    saveAsAction = new SaveAsAction();
    deleteChannelAction = new DeleteChannelAction();
    searchAction = new SearchAction();
    createCategoryAction = new CreateCategoryAction();
    multiRenameAction = new MultiRenameAction();
    preferencesAction = new PreferencesAction();
    statisticAction = new StatisticAction();
    createChannelAction = new CreateChannelAction();
    importAliasAction = new ImportAliasAction();
    exportAliasAction = new ExportAliasAction();
  }

  /**
   * Access to signleton
   * 
   * @return
   */
  public static ActionManager getInstance() {
    if (instance == null) {
      instance = new ActionManager();
    }
    return instance;
  }

  public Action getAboutAction() {
    return aboutAction;
  }

  public Action getCloseAction() {
    return closeAction;
  }

  public Action getOpenAction() {
    return openAction;
  }

  public Action getParkAction() {
    return parkAction;
  }

  public Action getSaveAction() {
    return saveAction;
  }

  public Action getSaveAsAction() {
    return saveAsAction;
  }

  public Action getDeleteChannelAction() {
    return deleteChannelAction;
  }

  public void setDeleteChannelAction(Action deleteChannelAction) {
    this.deleteChannelAction = deleteChannelAction;
  }

  public Action getSearchAction() {
    return searchAction;
  }

  public void setSearchAction(Action searchAction) {
    this.searchAction = searchAction;
  }

  public Action getUnparkAction() {
    return unparkAction;
  }

  public Action getCreateCategoryAction() {
    return createCategoryAction;
  }

  public Action getMultiRenameAction() {
    return multiRenameAction;
  }

  public Action getPreferencesAction() {
    return preferencesAction;
  }

  public Action getStatisticAction() {
    return statisticAction;
  }

  public Action getCreateChannelAction() {
    return createChannelAction;
  }

  public Action getImportAliasAction() {
    return importAliasAction;
  }

  public Action getExportAliasAction() {
    return exportAliasAction;
  }
}
