/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor;

import java.awt.BorderLayout;

import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;

import de.renier.vdr.channel.editor.container.ChannelListRenderer;
import de.renier.vdr.channel.editor.container.DNDList;

import javax.swing.JButton;
import javax.swing.ImageIcon;

/**
 * ChannelDeletedPanel
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class ChannelDeletedPanel extends JPanel {

  private static final long serialVersionUID = -8746444058111392773L;
  private JLabel jLabel = null;
  private JScrollPane jScrollPane = null;
  private JList jList = null;

  private JPanel jPanel = null;
  private JButton jButton = null;

  /**
   * This is the default constructor
   */
  public ChannelDeletedPanel() {
    super();
    initialize();
  }

  /**
   * This method initializes this
   * 
   * @return void
   */
  private void initialize() {
    jLabel = new JLabel();
    this.setLayout(new BorderLayout());
    this.setSize(300, 200);
    jLabel.setText(Messages.getString("ChannelDeletedPanel.0")); //$NON-NLS-1$
    this.add(jLabel, java.awt.BorderLayout.NORTH);
    this.add(getJScrollPane(), java.awt.BorderLayout.CENTER);
    this.add(getJPanel(), java.awt.BorderLayout.SOUTH);
  }

  /**
   * This method initializes jScrollPane
   * 
   * @return javax.swing.JScrollPane
   */
  private JScrollPane getJScrollPane() {
    if (jScrollPane == null) {
      jScrollPane = new JScrollPane();
      jScrollPane.setViewportView(getJList());
    }
    return jScrollPane;
  }

  /**
   * This method initializes jList
   * 
   * @return javax.swing.JList
   */
  private JList getJList() {
    if (jList == null) {
      jList = new DNDList();
      // set icon renderer
      ChannelListRenderer channelRenderer = new ChannelListRenderer();
      jList.setCellRenderer(channelRenderer);
    }
    return jList;
  }

  public int getListSize() {
    return jList.getModel().getSize();
  }

  public void addElement(DefaultMutableTreeNode node) {
    ((DefaultListModel) jList.getModel()).addElement(node);
  }

  /**
   * This method initializes jPanel
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getJPanel() {
    if (jPanel == null) {
      jPanel = new JPanel();
      jPanel.add(getJButton(), null);
    }
    return jPanel;
  }

  /**
   * This method initializes jButton
   * 
   * @return javax.swing.JButton
   */
  private JButton getJButton() {
    if (jButton == null) {
      jButton = new JButton();
      jButton.setIcon(new ImageIcon(getClass().getResource("/org/javalobby/icons/20x20/Delete.gif"))); //$NON-NLS-1$
      jButton.setText(Messages.getString("ChannelDeletedPanel.2")); //$NON-NLS-1$
      jButton.addActionListener(new java.awt.event.ActionListener() {

        public void actionPerformed(java.awt.event.ActionEvent e) {
          ((DefaultListModel) jList.getModel()).removeAllElements();
        }
      });
    }
    return jButton;
  }
}