/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.testng.IExtraOutput;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.TestListenerAdapter;
import org.testng.internal.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHTMLReporter
extends TestListenerAdapter {
    private ITestContext m_testContext = null;
    private File m_htmlOutputFile = null;
    private static String HEAD = "\n<style type=\"text/css\">\n.log { visibility:hidden;} \n</style>\n<script type=\"text/javascript\">\n<!--\nfunction toggleBox(szDivId)\n{\n  if (document.getElementById) {\n    style = document.getElementById(szDivId).style;\n    current = style.visibility;\n    if (current == 'visible') {\n      style.visibility = 'hidden';\n    }\n    else {\n      style.visibility = 'visible';\n    }\n  }\n  else if (document.all) {\n    // this is the way old msie versions work\n    var style2 = document.all[szDivId].style;\n    style2.display = style2.display? \"\":\"block\";\n  }\n\n}\n// -->\n</script>\n\n";

    @Override
    public void onStart(ITestContext context) {
        this.m_testContext = context;
    }

    @Override
    public void onFinish(ITestContext context) {
        TestHTMLReporter.generateLog(this.m_testContext, null, this.m_testContext.getOutputDirectory(), this.getPassedTests(), this.getFailedTests(), this.getSkippedTests(), this.getFailedButWithinSuccessPercentageTests());
    }

    private static File getOutputFile(String outputDirectory, ITestContext context) {
        String result = outputDirectory + File.separator + context.getName() + ".html";
        return new File(result);
    }

    public static void generateTable(StringBuffer sb, String title, Collection<ITestResult> tests, String bgColor) {
        sb.append("<table width=\"100%\"border=\"1\" bgcolor=\"" + bgColor + "\">\n").append("<tr><td colspan=\"3\" align=\"center\"><b>").append(title).append("</b></td></tr>\n").append("<tr>").append("<td><b>Test method</b></td>\n").append("<td width=\"10%\"><b>Time (seconds)</b></td>\n").append("<td width=\"30%\"><b>Exception</b></td>\n").append("</tr>\n");
        Comparator<ITestResult> testResultComparator = new Comparator<ITestResult>(){

            @Override
            public int compare(ITestResult o1, ITestResult o2) {
                String c1 = o1.getName();
                String c2 = o2.getName();
                return c1.compareTo(c2);
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        };
        if (tests instanceof List) {
            Collections.sort((List)tests, testResultComparator);
        }
        boolean i = false;
        for (ITestResult tr : tests) {
            IExtraOutput extraOutput;
            sb.append("<tr>\n");
            ITestNGMethod method = tr.getMethod();
            String fqName = method.toString();
            sb.append("<td>").append(fqName);
            if (!Utils.isStringEmpty(method.getDescription())) {
                sb.append("<br><b>").append(method.getDescription()).append("</b><br>");
            }
            if ((extraOutput = method.getExtraOutput()) != null) {
                List<String> output = extraOutput.getParameterOutput();
                if (null != output && output.size() > 0) {
                    sb.append("<br>");
                    for (String s : output) {
                        sb.append(s).append("<br>");
                    }
                }
                if (null != (output = Reporter.getOutput(method)) && output.size() > 0) {
                    String methodName = method.getMethod().getName();
                    sb.append("\n<a href=\"#\" onClick=\"toggleBox('" + methodName + "');\">Show output</a>\n");
                    sb.append("<div class=\"log\" id=\"" + methodName + "\">\n");
                    for (String s : output) {
                        sb.append(s).append("<br>\n");
                    }
                    sb.append("</div>\n");
                }
            }
            sb.append("</td>\n");
            long time = (tr.getEndMillis() - tr.getStartMillis()) / 1000L;
            String strTime = new Long(time).toString();
            sb.append("<td>").append(strTime).append("</td>\n");
            Throwable tw = tr.getThrowable();
            String stackTrace = "";
            String t = "none";
            if (null != tw) {
                t = "";
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter writer = new PrintWriter(baos);
                writer.write("<p><pre>");
                StringWriter string = new StringWriter();
                PrintWriter printer = new PrintWriter(string);
                tw.printStackTrace(printer);
                String result = string.getBuffer().toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                writer.write(result);
                writer.write("</pre></p>");
                writer.flush();
                writer.close();
                stackTrace = baos.toString();
            }
            sb.append("<td>").append(t).append(stackTrace).append("</td>\n");
            sb.append("</tr>\n");
        }
        sb.append("</table><p>\n");
    }

    private static String arrayToString(String[] array) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            result.append(array[i]).append(" ");
        }
        return result.toString();
    }

    public static void generateLog(ITestContext testContext, String host, String outputDirectory, Collection<ITestResult> passedTests, Collection<ITestResult> failedTests, Collection<ITestResult> skippedTests, Collection<ITestResult> percentageTests) {
        File htmlOutputFile = TestHTMLReporter.getOutputFile(outputDirectory, testContext);
        StringBuffer sb = new StringBuffer();
        sb.append("<html>\n<head>\n").append("<title>TestNG:  ").append(testContext.getName()).append("</title>").append(HEAD).append("</head>\n").append("<body>\n");
        Date startDate = testContext.getStartDate();
        Date endDate = testContext.getEndDate();
        long duration = (endDate.getTime() - startDate.getTime()) / 1000L;
        int passed = Utils.calculateInvokedMethodCount(testContext.getPassedTests()) + Utils.calculateInvokedMethodCount(testContext.getFailedButWithinSuccessPercentageTests());
        int failed = Utils.calculateInvokedMethodCount(testContext.getFailedTests());
        int skipped = Utils.calculateInvokedMethodCount(testContext.getSkippedTests());
        String hostLine = Utils.isStringEmpty(host) ? "" : "<tr><td>Remote host:</td><td>" + host + "</td>\n</tr><tr>";
        sb.append("<h2><p align=\"center\">").append(testContext.getName()).append("</p></h2>").append("<table align=\"center\">\n").append("<tr>\n").append("<td>Tests passed/Failed/Skipped:</td><td>").append(passed).append("/").append(failed).append("/").append(skipped).append("</td>\n").append("</tr><tr>\n").append("<td>Started on:</td><td>").append(testContext.getStartDate().toString()).append("</td>\n").append("</tr>\n").append(hostLine).append("<td>Total time:</td><td>").append(duration).append(" seconds</td>\n").append("</tr><tr>\n").append("<td>Included groups:</td><td>").append(TestHTMLReporter.arrayToString(testContext.getIncludedGroups())).append("</td>\n").append("</tr><tr>\n").append("<td>Excluded groups:</td><td>").append(TestHTMLReporter.arrayToString(testContext.getExcludedGroups())).append("</td>\n").append("</tr>\n").append("</table><p>\n");
        if (failedTests.size() > 0) {
            TestHTMLReporter.generateTable(sb, "FAILED TESTS", failedTests, "#DD0000");
        }
        if (percentageTests.size() > 0) {
            TestHTMLReporter.generateTable(sb, "FAILED TESTS BUT WITHIN SUCCESS PERCENTAGE", percentageTests, "#006600");
        }
        if (passedTests.size() > 0) {
            TestHTMLReporter.generateTable(sb, "PASSED TESTS", passedTests, "#00AA00");
        }
        if (skippedTests.size() > 0) {
            TestHTMLReporter.generateTable(sb, "SKIPPED TESTS", skippedTests, "#CCCC00");
        }
        sb.append("</body>\n</html>");
        Utils.writeFile(htmlOutputFile, sb.toString());
    }

    private static void ppp(String s) {
        System.out.println("[TestHTMLReporter] " + s);
    }
}

