/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.testng.TestNG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGAntTask
extends Task {
    protected CommandlineJava m_javaCommand;
    protected List<FileSet> m_xmlFilesets = new ArrayList<FileSet>();
    protected List<FileSet> m_classFilesets = new ArrayList<FileSet>();
    protected Path m_sourceDirPath;
    protected File m_outputDir;
    protected File m_testjar;
    protected Boolean m_isJUnit;
    private String m_reporter;
    protected Environment m_environment = new Environment();
    protected String m_mainClass = TestNG.class.getName();
    protected String m_target;
    protected boolean m_dump;
    protected boolean m_assertEnabled = true;
    protected boolean m_haltOnFailure;
    protected String m_failurePropertyName;
    protected boolean m_haltOnSkipped;
    protected String m_skippedPropertyName;
    protected boolean m_haltOnFSP;
    protected String m_fspPropertyName;
    protected String m_includedGroups;
    protected String m_excludedGroups;
    private Integer m_verbose = null;

    public void setHaltonfailure(boolean value) {
        this.m_haltOnFailure = value;
    }

    public void setFailureProperty(String propertyName) {
        this.m_failurePropertyName = propertyName;
    }

    public void setHaltonskipped(boolean value) {
        this.m_haltOnSkipped = true;
    }

    public void setJUnit(boolean value) {
        this.m_isJUnit = new Boolean(value);
    }

    public void setSkippedProperty(String propertyName) {
        this.m_skippedPropertyName = propertyName;
    }

    public void setHaltonFSP(boolean value) {
        this.m_haltOnFSP = value;
    }

    public void setFSPProperty(String propertyName) {
        this.m_fspPropertyName = propertyName;
    }

    public void setDumpCommand(boolean verbose) {
        this.m_dump = verbose;
    }

    public void setEnableAssert(boolean flag) {
        this.m_assertEnabled = flag;
    }

    public void setTarget(String target) {
        this.m_target = target;
    }

    public Commandline.Argument createJvmarg() {
        return this.getJavaCommand().createVmArgument();
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.getJavaCommand().addSysproperty(sysp);
    }

    public void addEnv(Environment.Variable var) {
        this.m_environment.addVariable(var);
    }

    public Path createClasspath() {
        return this.getJavaCommand().createClasspath(this.getProject()).createPath();
    }

    public Path createBootclasspath() {
        return this.getJavaCommand().createBootclasspath(this.getProject()).createPath();
    }

    public void setClasspath(Path s) {
        this.createClasspath().append(s);
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void addXmlfileset(FileSet fs) {
        this.m_xmlFilesets.add(fs);
    }

    public void setXmlfilesetRef(Reference ref) {
        this.m_xmlFilesets.add(this.createFileSet(ref));
    }

    public void addClassfileset(FileSet fs) {
        this.m_classFilesets.add(fs);
    }

    public void setClassfilesetRef(Reference ref) {
        this.m_classFilesets.add(this.createFileSet(ref));
    }

    public void setSourcedir(Path srcDir) {
        if (this.m_sourceDirPath == null) {
            this.m_sourceDirPath = srcDir;
        } else {
            this.m_sourceDirPath.append(srcDir);
        }
    }

    public Path createSourceDir() {
        if (this.m_sourceDirPath == null) {
            this.m_sourceDirPath = new Path(this.getProject());
        }
        return this.m_sourceDirPath.createPath();
    }

    public void setSourceDirRef(Reference r) {
        this.createSourceDir().setRefid(r);
    }

    public void setSuiteRunnerClass(String s) {
        this.m_mainClass = s;
    }

    public void setOutputDir(File dir2) {
        this.m_outputDir = dir2;
    }

    public void setTestJar(File s) {
        this.m_testjar = s;
    }

    public void setGroups(String groups) {
        this.m_includedGroups = groups;
    }

    public void setExcludedGroups(String groups) {
        this.m_excludedGroups = groups;
    }

    public void setVerbose(Integer verbose) {
        this.m_verbose = verbose;
    }

    public void setReporter(String reporter) {
        this.m_reporter = reporter;
    }

    public void execute() throws BuildException {
        this.validateOptions();
        CommandlineJava cmd = this.getJavaCommand();
        cmd.setClassname(this.m_mainClass);
        if (null != this.m_isJUnit && this.m_isJUnit.booleanValue()) {
            cmd.createArgument().setValue("-junit");
        }
        if (null != this.m_verbose) {
            cmd.createArgument().setValue("-log");
            cmd.createArgument().setValue(this.m_verbose.toString());
        }
        if (this.m_assertEnabled) {
            cmd.createVmArgument().setValue("-ea");
        }
        if (null != this.m_outputDir) {
            if (!this.m_outputDir.exists()) {
                this.m_outputDir.mkdirs();
            }
            if (this.m_outputDir.isDirectory()) {
                cmd.createArgument().setValue("-d");
                cmd.createArgument().setValue(this.m_outputDir.getAbsolutePath());
            } else {
                throw new BuildException("Output directory is not a directory: " + this.m_outputDir);
            }
        }
        if (null != this.m_target) {
            cmd.createArgument().setValue("-target");
            cmd.createArgument().setValue(this.m_target);
        }
        if (null != this.m_testjar && this.m_testjar.isFile()) {
            cmd.createArgument().setValue("-testjar");
            cmd.createArgument().setValue(this.m_testjar.getAbsolutePath());
        }
        if (null != this.m_sourceDirPath) {
            String srcPath = this.createPathString(this.m_sourceDirPath, ";");
            cmd.createArgument().setValue("-sourcedir");
            cmd.createArgument().setValue(srcPath);
        }
        if (null != this.m_includedGroups) {
            cmd.createArgument().setValue("-groups");
            cmd.createArgument().setValue(this.m_includedGroups);
        }
        if (null != this.m_excludedGroups) {
            cmd.createArgument().setValue("-excludegroups");
            cmd.createArgument().setValue(this.m_excludedGroups);
        }
        if (this.m_classFilesets.size() > 0) {
            cmd.createArgument().setValue("-testclass");
            for (String file : this.fileset(this.m_classFilesets)) {
                cmd.createArgument().setValue(file);
            }
        }
        if (this.m_reporter != null) {
            cmd.createArgument().setValue("-listener");
            cmd.createArgument().setValue(this.m_reporter);
        }
        if (this.m_xmlFilesets.size() > 0) {
            for (String file : this.fileset(this.m_xmlFilesets)) {
                cmd.createArgument().setValue(file);
            }
        }
        this.createClasspath().setLocation(this.findJar());
        if (this.m_dump) {
            this.dumpCommand();
        }
        int exitValue = this.executeAsForked(cmd);
        this.actOnResult(exitValue);
    }

    protected void actOnResult(int exitValue) {
        if (exitValue == -1) {
            throw new BuildException("an error occured when running TestNG tests");
        }
        if ((exitValue & 1) == 1) {
            if (this.m_haltOnFailure) {
                throw new BuildException("There are TestNG FAILED tests");
            }
            if (null != this.m_failurePropertyName) {
                this.getProject().setNewProperty(this.m_failurePropertyName, "true");
            }
            this.log("There are TestNG FAILED tests", 4);
        }
        if ((exitValue & 2) == 2) {
            if (this.m_haltOnSkipped) {
                throw new BuildException("There are TestNG SKIPPED tests");
            }
            if (null != this.m_skippedPropertyName) {
                this.getProject().setNewProperty(this.m_skippedPropertyName, "true");
            }
            this.log("There are TestNG SKIPPED tests", 4);
        }
        if ((exitValue & 4) == 4) {
            if (this.m_haltOnFSP) {
                throw new BuildException("There are TestNG FAILED WITHIN SUCCESS PERCENTAGE tests");
            }
            if (null != this.m_fspPropertyName) {
                this.getProject().setNewProperty(this.m_fspPropertyName, "true");
            }
            this.log("There are TestNG FAILED WITHIN SUCCESS PERCENTAGE tests", 4);
        }
    }

    protected int executeAsForked(CommandlineJava cmd) {
        int retVal;
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1));
        execute.setCommandline(cmd.getCommandline());
        execute.setAntRun(this.getProject());
        String[] environment = this.m_environment.getVariables();
        if (null != environment) {
            for (String envEntry : environment) {
                this.log("Setting environment variable: " + envEntry, 3);
            }
        }
        execute.setEnvironment(environment);
        this.log(cmd.describeCommand(), 3);
        try {
            retVal = execute.execute();
        }
        catch (IOException e) {
            throw new BuildException("Process fork failed.", (Throwable)e, this.getLocation());
        }
        return retVal;
    }

    protected CommandlineJava getJavaCommand() {
        if (null == this.m_javaCommand) {
            this.m_javaCommand = new CommandlineJava();
        }
        return this.m_javaCommand;
    }

    protected void validateOptions() throws BuildException {
        if (!(this.m_xmlFilesets.size() != 0 || this.m_classFilesets.size() != 0 || null != this.m_testjar && this.m_testjar.isFile())) {
            throw new BuildException("No suite or classes or jar is specified.");
        }
        if (null != this.m_includedGroups && this.m_classFilesets.size() == 0) {
            throw new BuildException("No classfileset specified while using groups");
        }
        if (this.usesJavadocAnnotations()) {
            this.m_target = null;
            if (null == this.m_sourceDirPath) {
                throw new BuildException("No sourceDir is specified.");
            }
        } else if (null == this.m_target) {
            this.m_target = "1.5";
        } else if (!"1.4".equals(this.m_target) && !"1.5".equals(this.m_target)) {
            throw new BuildException("Target attribute value unknown. Must be 1.4 or 1.5.");
        }
    }

    private boolean usesJavadocAnnotations() {
        String jversion = this.getJavaCommand().getVmversion();
        return jversion.startsWith("1.1") || jversion.startsWith("1.2") || jversion.startsWith("1.3") || jversion.startsWith("1.4");
    }

    private FileSet createFileSet(Reference ref) {
        FileSet fs = new FileSet();
        fs.setRefid(ref);
        fs.setProject(this.getProject());
        return fs;
    }

    private File findJar() {
        Class<?> thisClass = ((Object)((Object)this)).getClass();
        String resource = thisClass.getName().replace('.', '/') + ".class";
        URL url = thisClass.getClassLoader().getResource(resource);
        if (null != url) {
            String u = url.toString();
            if (u.startsWith("jar:file:")) {
                int pling = u.indexOf("!");
                String jarName = u.substring(4, pling);
                return new File(this.fromURI(jarName));
            }
            if (u.startsWith("file:")) {
                int tail = u.indexOf(resource);
                String dirName = u.substring(0, tail);
                return new File(this.fromURI(dirName));
            }
        }
        return null;
    }

    private String fromURI(String uri) {
        String file;
        int queryPos;
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException murle) {
            // empty catch block
        }
        if (null == url || !"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Can only handle valid file: URIs");
        }
        StringBuffer buf = new StringBuffer(url.getHost());
        if (buf.length() > 0) {
            buf.insert(0, File.separatorChar).insert(0, File.separatorChar);
        }
        buf.append((queryPos = (file = url.getFile()).indexOf(63)) < 0 ? file : file.substring(0, queryPos));
        uri = buf.toString().replace('/', File.separatorChar);
        if (File.pathSeparatorChar == ';' && uri.startsWith("\\") && uri.length() > 2 && Character.isLetter(uri.charAt(1)) && uri.lastIndexOf(58) > -1) {
            uri = uri.substring(1);
        }
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(uri);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '%') {
                char c1 = iter.next();
                if (c1 != '\uffff') {
                    int i1 = Character.digit(c1, 16);
                    char c2 = iter.next();
                    if (c2 != '\uffff') {
                        int i2 = Character.digit(c2, 16);
                        sb.append((char)((i1 << 4) + i2));
                    }
                }
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        return sb.toString();
    }

    private List<String> fileset(List<FileSet> filesets) throws BuildException {
        ArrayList<String> files = new ArrayList<String>();
        for (FileSet fileset : filesets) {
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            for (String file : ds.getIncludedFiles()) {
                files.add(ds.getBasedir() + File.separator + file);
            }
        }
        return files;
    }

    private String createPathString(Path path, String sep) {
        if (path == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < path.list().length; ++i) {
            File file = this.getProject().resolveFile(path.list()[i]);
            if (!file.exists()) {
                this.log("Classpath entry not found: " + file, 1);
            }
            buf.append(file.getAbsolutePath()).append(sep);
        }
        if (path.list().length > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    private void dumpCommand() {
        for (String str : this.getJavaCommand().getCommandline()) {
            System.out.println(str);
        }
    }
}

