export class InvalidMetric extends Error {
    constructor(version, metric) {
        super('invalid CVSS v' + version + ' metric ' + metric);
        this.version = version;
        this.metric = metric;
    }
}
export class InvalidMetricValue extends Error {
    constructor(version, metric, value) {
        super('invalid CVSS v' + version + ' value ' + value + ' for metric ' + metric);
        this.version = version;
        this.metric = metric;
        this.value = value;
    }
}
