"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _react2 = require("@emotion/react");
var _tinyInvariant = _interopRequireDefault(require("tiny-invariant"));
var _hasTextAncestorContext = require("../utils/has-text-ancestor-context");
var _surfaceProvider = require("../utils/surface-provider");
var _styleMaps = require("../xcss/style-maps.partial");
/**
 * @jsxRuntime classic
 * @jsx jsx
 */

// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766

var asAllowlist = ['span', 'p', 'strong', 'em'];
// We're doing this because our CSS reset can add top margins to elements such as `p` which is totally insane.
// Long term we should remove those instances from the reset - it should be a reset to 0.
// For now, at least we know <Text> will be unaffected by this.
var resetStyles = (0, _react2.css)({
  margin: 0,
  overflowWrap: 'anywhere'
});
var strongStyles = (0, _react2.css)({
  fontWeight: "var(--ds-font-weight-bold, 700)"
});
var emStyles = (0, _react2.css)({
  fontStyle: 'italic'
});
var textAlignMap = {
  center: (0, _react2.css)({
    textAlign: 'center'
  }),
  end: (0, _react2.css)({
    textAlign: 'end'
  }),
  start: (0, _react2.css)({
    textAlign: 'start'
  })
};
var truncationStyles = (0, _react2.css)({
  display: '-webkit-box',
  overflow: 'hidden',
  WebkitBoxOrient: 'vertical'
});
var wordBreakMap = {
  breakAll: (0, _react2.css)({
    wordBreak: 'break-all'
  })
};

/**
 * Custom hook designed to abstract the parsing of the color props and make it clearer in the future how color is reconciled between themes and tokens.
 */
var useColor = function useColor(colorProp, hasTextAncestor) {
  var surface = (0, _surfaceProvider.useSurface)();
  if (colorProp === 'inherit') {
    return undefined;
  }
  if (colorProp) {
    return colorProp;
  }
  if (hasTextAncestor) {
    return undefined;
  }
  if (_styleMaps.inverseColorMap.hasOwnProperty(surface)) {
    return _styleMaps.inverseColorMap[surface];
  }
  return 'color.text';
};

/**
 * __Text__
 *
 * Text is a primitive component that has the Atlassian Design System's design guidelines baked in.
 * This includes considerations for text attributes such as color, font size, font weight, and line height.
 * It renders a `span` by default.
 *
 * @internal
 */
var Text = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _ref$as = _ref.as,
    Component = _ref$as === void 0 ? 'span' : _ref$as,
    colorProp = _ref.color,
    align = _ref.align,
    testId = _ref.testId,
    id = _ref.id,
    size = _ref.size,
    weight = _ref.weight,
    maxLines = _ref.maxLines,
    children = _ref.children;
  (0, _tinyInvariant.default)(asAllowlist.includes(Component), "@atlaskit/primitives: Text received an invalid \"as\" value of \"".concat(Component, "\""));
  var hasTextAncestor = (0, _hasTextAncestorContext.useHasTextAncestor)();
  var color = useColor(colorProp, hasTextAncestor);
  if (!size && !hasTextAncestor) {
    size = 'medium';
  }
  var component = (0, _react2.jsx)(Component, {
    ref: ref,
    css: [resetStyles,
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values
    size && _styleMaps.textSizeStylesMap[size],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values
    color && _styleMaps.textColorStylesMap[color], maxLines && truncationStyles, maxLines === 1 && wordBreakMap.breakAll, align && textAlignMap[align],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values
    weight && _styleMaps.textWeightStylesMap[weight], Component === 'em' && emStyles, Component === 'strong' && strongStyles],
    style: {
      WebkitLineClamp: maxLines
    },
    "data-testid": testId,
    id: id
  }, children);
  return hasTextAncestor ?
  // no need to re-apply context if the text is already wrapped
  component : (0, _react2.jsx)(_hasTextAncestorContext.HasTextAncestorProvider, {
    value: true
  }, component);
});
var _default = exports.default = Text;