import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import { useEffect, useState } from 'react';
var noop = function noop() {};
function createCleanupManager() {
  var cleanupFn = noop;
  var setCleanupFn = function setCleanupFn(newCleanupFn) {
    cleanupFn = newCleanupFn;
  };
  var runCleanupFn = function runCleanupFn() {
    cleanupFn();
    cleanupFn = noop;
  };
  return {
    setCleanupFn: setCleanupFn,
    runCleanupFn: runCleanupFn
  };
}
export function useCleanupFn() {
  var _useState = useState(createCleanupManager),
    _useState2 = _slicedToArray(_useState, 1),
    cleanupManager = _useState2[0];

  /**
   * Run the cleanup function on unmount.
   */
  useEffect(function () {
    return cleanupManager.runCleanupFn;
  }, [cleanupManager.runCleanupFn]);
  return cleanupManager;
}