"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dampenValueByTime = void 0;
var _config = _interopRequireDefault(require("../../config"));
var _constants = require("../../constants");
var _getPercentage = require("../../get-percentage");
// Source: https://github.com/atlassian/react-beautiful-dnd

var accelerateAt = _config.default.durationDampening.accelerateAt;
var stopAt = _config.default.durationDampening.stopDampeningAt;
var dampenValueByTime = exports.dampenValueByTime = function dampenValueByTime(proposedScroll, dragStartTime) {
  var startOfRange = dragStartTime;
  var endOfRange = stopAt;
  var now = Date.now();
  var runTime = now - startOfRange;

  // we have finished the time dampening period
  if (runTime >= stopAt) {
    return proposedScroll;
  }

  // Up to this point we know there is a proposed scroll
  // but we have not reached our accelerate point
  // Return the minimum amount of scroll
  if (runTime < accelerateAt) {
    return _constants.minScroll;
  }
  var betweenAccelerateAtAndStopAtPercentage = (0, _getPercentage.getPercentage)({
    startOfRange: accelerateAt,
    endOfRange: endOfRange,
    current: runTime
  });
  var scroll = proposedScroll * _config.default.ease(betweenAccelerateAtAndStopAtPercentage);
  return Math.ceil(scroll);
};