/*  job_mergesectormappings.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_MERGESECTORMAPPINGS_H_
#define JOB_MERGESECTORMAPPINGS_H_

#include "job.h"

namespace Reduze {

/// Merger for sector mappings
class MergeSectorMappings: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("merge_sector_mappings");
		s.set_short_description("Merge sector mappings.");
		s.set_long_description("Job to combine sector mappings. This job"
				" can also be used to just read and write a single file,"
				" which helps to overcome GiNaC's ambiguities in ordering"
				" variables.");
		s.add_option("name", true, "string", "Name of integral family.");
		s.add_option("input_files", true, "sequence of strings",
				"Input file names. Files must all contain sector mappings"
						" for the same integral family.");
		s.add_option("output_file", true, "string", "Output file name.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	MergeSectorMappings() {
		add_auto_options();
	}
	virtual ~MergeSectorMappings() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&, //
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;
protected:
	virtual void add_auto_options() {
		add_auto_io("name", name_);
		add_auto_io("input_files", input_files_);
		add_auto_io("output_file", output_file_);
	}
	virtual void init();
private:
	std::string name_;
	std::list<std::string> input_files_;
	std::string output_file_;
};

} // namespace Reduze

#endif /* JOB_MERGESECTORMAPPINGS_H_ */
