/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.ArraySetJvmUtil;
import androidx.collection.ArraySetKt;
import androidx.collection.IndexBasedArrayIterator;
import androidx.collection.internal.ContainerHelpersKt;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010)\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001?B\u0019\b\u0016\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0016\u0012\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u0011\b\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020$2\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000J\u0016\u0010#\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\b\u0010&\u001a\u00020$H\u0016J\u0016\u0010'\u001a\u00020 2\u0006\u0010!\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\"J\u0016\u0010(\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u000e\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\fJ\u0013\u0010+\u001a\u00020 2\b\u0010,\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010-\u001a\u00020\fH\u0016J\u0010\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u0012J\b\u00100\u001a\u00020 H\u0016J\u000f\u00101\u001a\b\u0012\u0004\u0012\u00028\u000002H\u0096\u0002J\u0015\u00103\u001a\u00020 2\u0006\u0010!\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\u0016\u00104\u001a\u00020 2\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000J\u0016\u00104\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0013\u00105\u001a\u00028\u00002\u0006\u00106\u001a\u00020\f\u00a2\u0006\u0002\u00107J\u0016\u00108\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0013\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\t\u00a2\u0006\u0002\u0010\u0014J%\u00109\u001a\b\u0012\u0004\u0012\u0002H:0\t\"\u0004\b\u0001\u0010:2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H:0\t\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020=H\u0016J\u0013\u0010>\u001a\u00028\u00002\u0006\u00106\u001a\u00020\f\u00a2\u0006\u0002\u00107R\u001a\u0010\u000e\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\rR$\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\tX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\nR\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010\u00a8\u0006@"}, d2={"Landroidx/collection/ArraySet;", "E", "", "", "set", "(Landroidx/collection/ArraySet;)V", "", "(Ljava/util/Collection;)V", "array", "", "([Ljava/lang/Object;)V", "capacity", "", "(I)V", "_size", "get_size$collection", "()I", "set_size$collection", "", "getArray$collection", "()[Ljava/lang/Object;", "setArray$collection", "[Ljava/lang/Object;", "hashes", "", "getHashes$collection", "()[I", "setHashes$collection", "([I)V", "size", "getSize", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "", "elements", "clear", "contains", "containsAll", "ensureCapacity", "minimumCapacity", "equals", "other", "hashCode", "indexOf", "key", "isEmpty", "iterator", "", "remove", "removeAll", "removeAt", "index", "(I)Ljava/lang/Object;", "retainAll", "toArray", "T", "([Ljava/lang/Object;)[Ljava/lang/Object;", "toString", "", "valueAt", "ElementIterator", "collection"})
@SourceDebugExtension(value={"SMAP\nArraySet.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArraySet.jvm.kt\nandroidx/collection/ArraySet\n+ 2 ArraySet.kt\nandroidx/collection/ArraySetKt\n*L\n1#1,300:1\n304#2,10:301\n317#2,14:311\n334#2:325\n339#2:326\n345#2:327\n350#2:328\n355#2,61:329\n420#2,17:390\n440#2,6:407\n450#2,60:413\n518#2,9:473\n531#2,22:482\n557#2,7:504\n568#2,19:511\n591#2,6:530\n601#2,6:536\n611#2,5:542\n620#2,8:547\n*S KotlinDebug\n*F\n+ 1 ArraySet.jvm.kt\nandroidx/collection/ArraySet\n*L\n98#1:301,10\n108#1:311,14\n118#1:325\n128#1:326\n138#1:327\n145#1:328\n157#1:329,61\n167#1:390,17\n177#1:407,6\n188#1:413,60\n197#1:473,9\n224#1:482,22\n231#1:504,7\n240#1:511,19\n267#1:530,6\n276#1:536,6\n286#1:542,5\n297#1:547,8\n*E\n"})
public final class ArraySet<E>
implements Collection<E>,
Set<E>,
KMutableCollection,
KMutableSet {
    @NotNull
    private int[] hashes;
    @NotNull
    private Object[] array;
    private int _size;

    @JvmOverloads
    public ArraySet(int capacity) {
        this.hashes = ContainerHelpersKt.EMPTY_INTS;
        this.array = ContainerHelpersKt.EMPTY_OBJECTS;
        if (capacity > 0) {
            ArraySetKt.allocArrays(this, capacity);
        }
    }

    public /* synthetic */ ArraySet(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    @NotNull
    public final int[] getHashes$collection() {
        return this.hashes;
    }

    public final void setHashes$collection(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.hashes = nArray;
    }

    @NotNull
    public final Object[] getArray$collection() {
        return this.array;
    }

    public final void setArray$collection(@NotNull Object[] objectArray) {
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"<set-?>");
        this.array = objectArray;
    }

    public final int get_size$collection() {
        return this._size;
    }

    public final void set_size$collection(int n) {
        this._size = n;
    }

    public int getSize() {
        return this._size;
    }

    public ArraySet(@Nullable ArraySet<? extends E> set) {
        this(0);
        if (set != null) {
            this.addAll(set);
        }
    }

    public ArraySet(@Nullable Collection<? extends E> set) {
        this(0);
        if (set != null) {
            this.addAll(set);
        }
    }

    public ArraySet(@Nullable E[] array2) {
        this(0);
        if (array2 != null) {
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])array2);
            while (iterator2.hasNext()) {
                Object value = iterator2.next();
                this.add(value);
            }
        }
    }

    @Override
    public void clear() {
        ArraySet $this$clearInternal$iv = this;
        boolean $i$f$clearInternal = false;
        if ($this$clearInternal$iv.get_size$collection() != 0) {
            $this$clearInternal$iv.setHashes$collection(ContainerHelpersKt.EMPTY_INTS);
            $this$clearInternal$iv.setArray$collection(ContainerHelpersKt.EMPTY_OBJECTS);
            $this$clearInternal$iv.set_size$collection(0);
        }
        if ($this$clearInternal$iv.get_size$collection() != 0) {
            throw new ConcurrentModificationException();
        }
    }

    public final void ensureCapacity(int minimumCapacity) {
        ArraySet $this$ensureCapacityInternal$iv = this;
        boolean $i$f$ensureCapacityInternal = false;
        int oSize$iv = $this$ensureCapacityInternal$iv.get_size$collection();
        if ($this$ensureCapacityInternal$iv.getHashes$collection().length < minimumCapacity) {
            int[] ohashes$iv = $this$ensureCapacityInternal$iv.getHashes$collection();
            Object[] oarray$iv = $this$ensureCapacityInternal$iv.getArray$collection();
            ArraySetKt.allocArrays($this$ensureCapacityInternal$iv, minimumCapacity);
            if ($this$ensureCapacityInternal$iv.get_size$collection() > 0) {
                ArraysKt.copyInto$default((int[])ohashes$iv, (int[])$this$ensureCapacityInternal$iv.getHashes$collection(), (int)0, (int)0, (int)$this$ensureCapacityInternal$iv.get_size$collection(), (int)6, null);
                ArraysKt.copyInto$default((Object[])oarray$iv, (Object[])$this$ensureCapacityInternal$iv.getArray$collection(), (int)0, (int)0, (int)$this$ensureCapacityInternal$iv.get_size$collection(), (int)6, null);
            }
        }
        if ($this$ensureCapacityInternal$iv.get_size$collection() != oSize$iv) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean contains(Object element) {
        ArraySet $this$containsInternal$iv = this;
        boolean $i$f$containsInternal = false;
        return $this$containsInternal$iv.indexOf(element) >= 0;
    }

    public final int indexOf(@Nullable Object key) {
        ArraySet $this$indexOfInternal$iv = this;
        boolean $i$f$indexOfInternal = false;
        Object object = key;
        return object == null ? ArraySetKt.indexOfNull($this$indexOfInternal$iv) : ArraySetKt.indexOf($this$indexOfInternal$iv, object, key.hashCode());
    }

    public final E valueAt(int index2) {
        ArraySet $this$valueAtInternal$iv = this;
        boolean $i$f$valueAtInternal = false;
        return (E)$this$valueAtInternal$iv.getArray$collection()[index2];
    }

    @Override
    public boolean isEmpty() {
        ArraySet $this$isEmptyInternal$iv = this;
        boolean $i$f$isEmptyInternal = false;
        return $this$isEmptyInternal$iv.get_size$collection() <= 0;
    }

    @Override
    public boolean add(E element) {
        boolean bl;
        ArraySet $this$addInternal$iv = this;
        boolean $i$f$addInternal = false;
        int oSize$iv = $this$addInternal$iv.get_size$collection();
        int hash$iv = 0;
        int index$iv = 0;
        if (element == null) {
            hash$iv = 0;
            index$iv = ArraySetKt.indexOfNull($this$addInternal$iv);
        } else {
            hash$iv = element.hashCode();
            index$iv = ArraySetKt.indexOf($this$addInternal$iv, element, hash$iv);
        }
        if (index$iv >= 0) {
            bl = false;
        } else {
            index$iv ^= 0xFFFFFFFF;
            if (oSize$iv >= $this$addInternal$iv.getHashes$collection().length) {
                int n$iv = oSize$iv >= 8 ? oSize$iv + (oSize$iv >> 1) : (oSize$iv >= 4 ? 8 : 4);
                int[] ohashes$iv = $this$addInternal$iv.getHashes$collection();
                Object[] oarray$iv = $this$addInternal$iv.getArray$collection();
                ArraySetKt.allocArrays($this$addInternal$iv, n$iv);
                if (oSize$iv != $this$addInternal$iv.get_size$collection()) {
                    throw new ConcurrentModificationException();
                }
                if (!($this$addInternal$iv.getHashes$collection().length == 0)) {
                    ArraysKt.copyInto$default((int[])ohashes$iv, (int[])$this$addInternal$iv.getHashes$collection(), (int)0, (int)0, (int)ohashes$iv.length, (int)6, null);
                    ArraysKt.copyInto$default((Object[])oarray$iv, (Object[])$this$addInternal$iv.getArray$collection(), (int)0, (int)0, (int)oarray$iv.length, (int)6, null);
                }
            }
            if (index$iv < oSize$iv) {
                ArraysKt.copyInto((int[])$this$addInternal$iv.getHashes$collection(), (int[])$this$addInternal$iv.getHashes$collection(), (int)(index$iv + 1), (int)index$iv, (int)oSize$iv);
                ArraysKt.copyInto((Object[])$this$addInternal$iv.getArray$collection(), (Object[])$this$addInternal$iv.getArray$collection(), (int)(index$iv + 1), (int)index$iv, (int)oSize$iv);
            }
            if (oSize$iv != $this$addInternal$iv.get_size$collection() || index$iv >= $this$addInternal$iv.getHashes$collection().length) {
                throw new ConcurrentModificationException();
            }
            $this$addInternal$iv.getHashes$collection()[index$iv] = hash$iv;
            $this$addInternal$iv.getArray$collection()[index$iv] = element;
            int n = $this$addInternal$iv.get_size$collection();
            $this$addInternal$iv.set_size$collection(n + 1);
            bl = true;
        }
        return bl;
    }

    public final void addAll(@NotNull ArraySet<? extends E> array2) {
        Intrinsics.checkNotNullParameter(array2, (String)"array");
        ArraySet $this$addAllInternal$iv = this;
        boolean $i$f$addAllInternal = false;
        int n$iv = array2.get_size$collection();
        $this$addAllInternal$iv.ensureCapacity($this$addAllInternal$iv.get_size$collection() + n$iv);
        if ($this$addAllInternal$iv.get_size$collection() == 0) {
            if (n$iv > 0) {
                ArraysKt.copyInto$default((int[])array2.getHashes$collection(), (int[])$this$addAllInternal$iv.getHashes$collection(), (int)0, (int)0, (int)n$iv, (int)6, null);
                ArraysKt.copyInto$default((Object[])array2.getArray$collection(), (Object[])$this$addAllInternal$iv.getArray$collection(), (int)0, (int)0, (int)n$iv, (int)6, null);
                if ($this$addAllInternal$iv.get_size$collection() != 0) {
                    throw new ConcurrentModificationException();
                }
                $this$addAllInternal$iv.set_size$collection(n$iv);
            }
        } else {
            for (int i$iv = 0; i$iv < n$iv; ++i$iv) {
                $this$addAllInternal$iv.add(array2.valueAt(i$iv));
            }
        }
    }

    @Override
    public boolean remove(Object element) {
        boolean bl;
        ArraySet $this$removeInternal$iv = this;
        boolean $i$f$removeInternal = false;
        int index$iv = $this$removeInternal$iv.indexOf(element);
        if (index$iv >= 0) {
            $this$removeInternal$iv.removeAt(index$iv);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final E removeAt(int index2) {
        ArraySet $this$removeAtInternal$iv = this;
        boolean $i$f$removeAtInternal = false;
        int oSize$iv = $this$removeAtInternal$iv.get_size$collection();
        Object old$iv = $this$removeAtInternal$iv.getArray$collection()[index2];
        if (oSize$iv <= 1) {
            $this$removeAtInternal$iv.clear();
        } else {
            int nSize$iv = oSize$iv - 1;
            if ($this$removeAtInternal$iv.getHashes$collection().length > 8 && $this$removeAtInternal$iv.get_size$collection() < $this$removeAtInternal$iv.getHashes$collection().length / 3) {
                int n$iv = $this$removeAtInternal$iv.get_size$collection() > 8 ? $this$removeAtInternal$iv.get_size$collection() + ($this$removeAtInternal$iv.get_size$collection() >> 1) : 8;
                int[] ohashes$iv = $this$removeAtInternal$iv.getHashes$collection();
                Object[] oarray$iv = $this$removeAtInternal$iv.getArray$collection();
                ArraySetKt.allocArrays($this$removeAtInternal$iv, n$iv);
                if (index2 > 0) {
                    ArraysKt.copyInto$default((int[])ohashes$iv, (int[])$this$removeAtInternal$iv.getHashes$collection(), (int)0, (int)0, (int)index2, (int)6, null);
                    ArraysKt.copyInto$default((Object[])oarray$iv, (Object[])$this$removeAtInternal$iv.getArray$collection(), (int)0, (int)0, (int)index2, (int)6, null);
                }
                if (index2 < nSize$iv) {
                    ArraysKt.copyInto((int[])ohashes$iv, (int[])$this$removeAtInternal$iv.getHashes$collection(), (int)index2, (int)(index2 + 1), (int)(nSize$iv + 1));
                    ArraysKt.copyInto((Object[])oarray$iv, (Object[])$this$removeAtInternal$iv.getArray$collection(), (int)index2, (int)(index2 + 1), (int)(nSize$iv + 1));
                }
            } else {
                if (index2 < nSize$iv) {
                    ArraysKt.copyInto((int[])$this$removeAtInternal$iv.getHashes$collection(), (int[])$this$removeAtInternal$iv.getHashes$collection(), (int)index2, (int)(index2 + 1), (int)(nSize$iv + 1));
                    ArraysKt.copyInto((Object[])$this$removeAtInternal$iv.getArray$collection(), (Object[])$this$removeAtInternal$iv.getArray$collection(), (int)index2, (int)(index2 + 1), (int)(nSize$iv + 1));
                }
                $this$removeAtInternal$iv.getArray$collection()[nSize$iv] = null;
            }
            if (oSize$iv != $this$removeAtInternal$iv.get_size$collection()) {
                throw new ConcurrentModificationException();
            }
            $this$removeAtInternal$iv.set_size$collection(nSize$iv);
        }
        return (E)old$iv;
    }

    @Override
    public final boolean removeAll(@NotNull ArraySet<? extends E> array2) {
        Intrinsics.checkNotNullParameter(array2, (String)"array");
        ArraySet $this$removeAllInternal$iv = this;
        boolean $i$f$removeAllInternal = false;
        int n$iv = array2.get_size$collection();
        int originalSize$iv = $this$removeAllInternal$iv.get_size$collection();
        for (int i$iv = 0; i$iv < n$iv; ++i$iv) {
            $this$removeAllInternal$iv.remove(array2.valueAt(i$iv));
        }
        return originalSize$iv != $this$removeAllInternal$iv.get_size$collection();
    }

    @Override
    @NotNull
    public final Object[] toArray() {
        Object[] objectArray = this.array;
        int n = 0;
        int n2 = this._size;
        return ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2);
    }

    @Override
    @NotNull
    public final <T> T[] toArray(@NotNull T[] array2) {
        Intrinsics.checkNotNullParameter(array2, (String)"array");
        Object[] result2 = ArraySetJvmUtil.resizeForToArray(array2, this._size);
        ArraysKt.copyInto((Object[])this.array, (Object[])result2, (int)0, (int)0, (int)this._size);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        boolean bl;
        block10: {
            ArraySet $this$equalsInternal$iv = this;
            boolean $i$f$equalsInternal = false;
            if ($this$equalsInternal$iv == other) {
                bl = true;
            } else if (other instanceof Set) {
                if ($this$equalsInternal$iv.size() != ((Set)other).size()) {
                    bl = false;
                } else {
                    try {
                        int n = $this$equalsInternal$iv.get_size$collection();
                        for (int i$iv = 0; i$iv < n; ++i$iv) {
                            E mine$iv = $this$equalsInternal$iv.valueAt(i$iv);
                            if (((Set)other).contains(mine$iv)) continue;
                            bl = false;
                            break block10;
                        }
                    }
                    catch (NullPointerException ignored$iv) {
                        bl = false;
                        break block10;
                    }
                    catch (ClassCastException ignored$iv) {
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public int hashCode() {
        ArraySet $this$hashCodeInternal$iv = this;
        boolean $i$f$hashCodeInternal = false;
        int[] hashes$iv = $this$hashCodeInternal$iv.getHashes$collection();
        int s$iv = $this$hashCodeInternal$iv.get_size$collection();
        int result$iv = 0;
        for (int i$iv = 0; i$iv < s$iv; ++i$iv) {
            result$iv += hashes$iv[i$iv];
        }
        return result$iv;
    }

    @NotNull
    public String toString() {
        String string2;
        ArraySet $this$toStringInternal$iv = this;
        boolean $i$f$toStringInternal = false;
        if ($this$toStringInternal$iv.isEmpty()) {
            string2 = "{}";
        } else {
            StringBuilder stringBuilder;
            int n = $this$toStringInternal$iv.get_size$collection() * 14;
            StringBuilder $this$toStringInternal_u24lambda_u240$iv = stringBuilder = new StringBuilder(n);
            boolean bl = false;
            $this$toStringInternal_u24lambda_u240$iv.append('{');
            int n2 = $this$toStringInternal$iv.get_size$collection();
            for (int i$iv = 0; i$iv < n2; ++i$iv) {
                E value$iv;
                if (i$iv > 0) {
                    $this$toStringInternal_u24lambda_u240$iv.append(", ");
                }
                if ((value$iv = $this$toStringInternal$iv.valueAt(i$iv)) != $this$toStringInternal$iv) {
                    $this$toStringInternal_u24lambda_u240$iv.append(value$iv);
                    continue;
                }
                $this$toStringInternal_u24lambda_u240$iv.append("(this Set)");
            }
            $this$toStringInternal_u24lambda_u240$iv.append('}');
            String string3 = stringBuilder.toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        }
        return string2;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new ElementIterator();
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            ArraySet $this$containsAllInternal$iv = this;
            boolean $i$f$containsAllInternal = false;
            for (Object object : elements) {
                if ($this$containsAllInternal$iv.contains(object)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ArraySet $this$addAllInternal$iv = this;
        boolean $i$f$addAllInternal = false;
        $this$addAllInternal$iv.ensureCapacity($this$addAllInternal$iv.get_size$collection() + elements.size());
        boolean added$iv = false;
        for (E value$iv : elements) {
            added$iv = $this$addAllInternal$iv.add(value$iv) | added$iv;
        }
        return added$iv;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ArraySet $this$removeAllInternal$iv = this;
        boolean $i$f$removeAllInternal = false;
        boolean removed$iv = false;
        for (Object object : elements) {
            removed$iv |= $this$removeAllInternal$iv.remove(object);
        }
        return removed$iv;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ArraySet $this$retainAllInternal$iv = this;
        boolean $i$f$retainAllInternal = false;
        boolean removed$iv = false;
        for (int i$iv = $this$retainAllInternal$iv.get_size$collection() - 1; -1 < i$iv; --i$iv) {
            if (CollectionsKt.contains((Iterable)elements, (Object)$this$retainAllInternal$iv.getArray$collection()[i$iv])) continue;
            $this$retainAllInternal$iv.removeAt(i$iv);
            removed$iv = true;
        }
        return removed$iv;
    }

    @JvmOverloads
    public ArraySet() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\t"}, d2={"Landroidx/collection/ArraySet$ElementIterator;", "Landroidx/collection/IndexBasedArrayIterator;", "(Landroidx/collection/ArraySet;)V", "elementAt", "index", "", "(I)Ljava/lang/Object;", "removeAt", "", "collection"})
    private final class ElementIterator
    extends IndexBasedArrayIterator<E> {
        public ElementIterator() {
            super(ArraySet.this.get_size$collection());
        }

        @Override
        protected E elementAt(int index2) {
            return ArraySet.this.valueAt(index2);
        }

        @Override
        protected void removeAt(int index2) {
            ArraySet.this.removeAt(index2);
        }
    }
}

