/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.legacy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.loomchild.segment.srx.LanguageRule;
import net.loomchild.segment.srx.Rule;
import net.loomchild.segment.util.Util;

public class MergedPattern {
    private int maxLookbehindConstructLength;
    private Pattern breakingPattern;
    private List<Pattern> nonBreakingPatternList;
    private List<Integer> breakingRuleIndexList;

    public MergedPattern(List<LanguageRule> languageRuleList, int maxLookbehindConstructLength) {
        this.maxLookbehindConstructLength = maxLookbehindConstructLength;
        StringBuilder breakingPatternBuilder = new StringBuilder();
        this.nonBreakingPatternList = new ArrayList<Pattern>();
        this.breakingRuleIndexList = new ArrayList<Integer>();
        int breakingRuleIndex = 0;
        List<Rule> ruleList = this.extractRules(languageRuleList);
        List<List<Rule>> ruleGroupList = this.groupRules(ruleList);
        for (List<Rule> ruleGroup : ruleGroupList) {
            if (ruleGroup.get(0).isBreak()) {
                if (breakingPatternBuilder.length() > 0) {
                    breakingPatternBuilder.append('|');
                }
                String breakingGroupPattern = this.createBreakingPattern(ruleGroup);
                breakingPatternBuilder.append(breakingGroupPattern);
                breakingRuleIndex += ruleGroup.size();
                continue;
            }
            Pattern nonBreakingGroupPattern = Pattern.compile(this.createNonBreakingPattern(ruleGroup));
            this.nonBreakingPatternList.add(nonBreakingGroupPattern);
            this.breakingRuleIndexList.add(breakingRuleIndex);
        }
        this.breakingPattern = breakingPatternBuilder.length() > 0 ? Pattern.compile(breakingPatternBuilder.toString()) : null;
    }

    public Pattern getBreakingPattern() {
        return this.breakingPattern;
    }

    public List<Pattern> getNonBreakingPatternList(int breakingRuleIndex) {
        int currentBreakingRuleIndex;
        ArrayList<Pattern> result2 = new ArrayList<Pattern>();
        Iterator<Pattern> patternIterator = this.nonBreakingPatternList.iterator();
        Iterator<Integer> iterator = this.breakingRuleIndexList.iterator();
        while (iterator.hasNext() && (currentBreakingRuleIndex = iterator.next().intValue()) < breakingRuleIndex) {
            result2.add(patternIterator.next());
        }
        return result2;
    }

    private List<Rule> extractRules(List<LanguageRule> languageRuleList) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        for (LanguageRule languageRule : languageRuleList) {
            ruleList.addAll(languageRule.getRuleList());
        }
        return ruleList;
    }

    private List<List<Rule>> groupRules(List<Rule> ruleList) {
        ArrayList<List<Rule>> ruleGroupList = new ArrayList<List<Rule>>();
        ArrayList<Rule> ruleGroup = null;
        Rule previousRule = null;
        for (Rule rule : ruleList) {
            if (previousRule == null || rule.isBreak() != previousRule.isBreak()) {
                ruleGroup = new ArrayList<Rule>();
                ruleGroupList.add(ruleGroup);
            }
            ruleGroup.add(rule);
            previousRule = rule;
        }
        return ruleGroupList;
    }

    private String createBreakingPattern(List<Rule> ruleList) {
        StringBuilder patternBuilder = new StringBuilder();
        for (Rule rule : ruleList) {
            if (patternBuilder.length() > 0) {
                patternBuilder.append('|');
            }
            String beforePattern = Util.removeCapturingGroups(rule.getBeforePattern());
            String afterPattern = Util.removeCapturingGroups(rule.getAfterPattern());
            patternBuilder.append("(?=");
            patternBuilder.append(beforePattern);
            patternBuilder.append("()");
            patternBuilder.append(afterPattern);
            patternBuilder.append(")");
        }
        return patternBuilder.toString();
    }

    private String createNonBreakingPattern(List<Rule> ruleList) {
        StringBuilder patternBuilder = new StringBuilder();
        for (Rule rule : ruleList) {
            if (patternBuilder.length() > 0) {
                patternBuilder.append('|');
            }
            String beforePattern = Util.finitize(rule.getBeforePattern(), this.maxLookbehindConstructLength);
            String afterPattern = rule.getAfterPattern();
            patternBuilder.append("(?:");
            if (beforePattern.length() > 0) {
                patternBuilder.append("(?<=" + beforePattern + ")");
            }
            if (afterPattern.length() > 0) {
                patternBuilder.append("(?=" + afterPattern + ")");
            }
            patternBuilder.append(")");
        }
        return patternBuilder.toString();
    }
}

