/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.ide.startup.importSettings.models.FeatureInfo;
import com.intellij.ide.startup.importSettings.models.Keymap;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.models.UnknownFeature;
import com.intellij.ide.startup.importSettings.providers.vscode.mappings.KeymapPluginsMappings;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.mappings.PluginMappings;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.JsonKt;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.PluginParserKt;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/PluginParser;", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "<init>", "(Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "process", "", "directory", "Ljava/io/File;", "processPluginsDirectory", "processPluginConfigFile", "file", "addedPluginIds", "", "Lcom/intellij/ide/startup/importSettings/models/FeatureInfo;", "processPluginId", "root", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nPluginParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/PluginParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,81:1\n1#2:82\n13409#3,2:83\n*S KotlinDebug\n*F\n+ 1 PluginParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/PluginParser\n*L\n39#1:83,2\n*E\n"})
public final class PluginParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private final Set<FeatureInfo> addedPluginIds;
    @NotNull
    private static final String PUBLISHER = "publisher";
    @NotNull
    private static final String NAME = "name";
    @NotNull
    private static final String CONFIG_FILE = "package.json";

    public PluginParser(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.addedPluginIds = new LinkedHashSet();
    }

    public final void process(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        try {
            PluginParserKt.access$getLogger$p().info("Processing a directory: " + directory);
            if (!directory.isDirectory()) {
                boolean bl = false;
                String string = "It is not a directory: " + directory;
                throw new IllegalStateException(string.toString());
            }
            this.processPluginsDirectory(directory);
        }
        catch (Throwable t) {
            PluginParserKt.access$getLogger$p().warn(t);
        }
    }

    private final void processPluginsDirectory(File directory) {
        File[] content;
        File[] fileArray = directory.listFiles();
        if (fileArray == null) {
            throw new IllegalStateException(("Invalid directory path: " + directory).toString());
        }
        File[] $this$forEach$iv = content = fileArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            try {
                File file;
                File file2 = it;
                if (file2 == null) continue;
                File it2 = file = file2;
                boolean bl2 = false;
                file2 = it2.isDirectory() ? file : null;
                if (file2 == null) {
                    continue;
                }
                File pluginDirectory = file2;
                File configFile = new File(pluginDirectory.getPath() + "/package.json");
                this.processPluginConfigFile(configFile);
                continue;
            }
            catch (Throwable t) {
                PluginParserKt.access$getLogger$p().warn(t);
            }
        }
    }

    private final void processPluginConfigFile(File file) {
        PluginParserKt.access$getLogger$p().debug("Processing a config file: " + file);
        try {
            JsonNode jsonNode = JsonKt.getVsCodeJsonMapper().readTree(file);
            ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
            if (objectNode == null) {
                throw new IllegalStateException(("Unexpected JSON data; expected: " + JsonNodeType.OBJECT).toString());
            }
            ObjectNode root = objectNode;
            this.processPluginId(root);
        }
        catch (Throwable t) {
            PluginParserKt.access$getLogger$p().warn(t);
        }
    }

    private final void processPluginId(ObjectNode root) {
        FeatureInfo featureInfo;
        FeatureInfo featureInfo2;
        Object object = root.get(PUBLISHER);
        if (object == null || (object = object.textValue()) == null) {
            return;
        }
        Object publisher = object;
        Object object2 = root.get(NAME);
        if (object2 == null || (object2 = object2.textValue()) == null) {
            return;
        }
        Object name = object2;
        String string = ((String)publisher + "." + (String)name).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String foreignPluginId = string;
        Keymap keymapPlugin = KeymapPluginsMappings.INSTANCE.map(foreignPluginId);
        if (keymapPlugin != null) {
            this.settings.setKeymap(keymapPlugin);
        }
        if ((featureInfo2 = PluginMappings.INSTANCE.pluginIdMap(foreignPluginId)) == null) {
            featureInfo2 = UnknownFeature.INSTANCE;
        }
        if (!this.addedPluginIds.contains(featureInfo = featureInfo2) || Intrinsics.areEqual((Object)featureInfo, (Object)UnknownFeature.INSTANCE)) {
            this.settings.getPlugins().put(foreignPluginId, featureInfo);
            this.addedPluginIds.add(featureInfo);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vscode/parsers/PluginParser$Companion;", "", "<init>", "()V", "PUBLISHER", "", "NAME", "CONFIG_FILE", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

