/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.package.version;

import java.lang.module.ModuleDescriptor;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.version.SingleVersion;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u001a\f\u0010\f\u001a\u00020\u0005*\u00020\u0005H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\r"}, d2={"minimalVersion", "Ljava/lang/module/ModuleDescriptor$Version;", "getMinimalVersion", "()Ljava/lang/module/ModuleDescriptor$Version;", "replaceIfNotContains", "", "original", "replace", "replaceWith", "compareAsVersion", "", "other", "normalizeVersion", "model"})
public final class SingleVersionKt {
    @NotNull
    private static final ModuleDescriptor.Version minimalVersion;

    public static final int compareAsVersion(@NotNull String $this$compareAsVersion, @Nullable String other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$compareAsVersion, (String)"<this>");
        if (StringsKt.isBlank((CharSequence)$this$compareAsVersion)) {
            return -1;
        }
        CharSequence charSequence = other;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return 1;
        }
        try {
            SingleVersion myVersion = new SingleVersion($this$compareAsVersion, true);
            SingleVersion otherVersion = new SingleVersion(other, true);
            n = myVersion.compareTo(otherVersion);
        }
        catch (Exception e) {
            String string = e.getMessage();
            n = (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)$this$compareAsVersion, (boolean)false, (int)2, null) : false) ? -1 : 1;
        }
        return n;
    }

    private static final String normalizeVersion(String $this$normalizeVersion) {
        String string = $this$normalizeVersion.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String normalized = string;
        if (StringsKt.startsWith$default((String)normalized, (String)"v", (boolean)false, (int)2, null)) {
            normalized = StringsKt.substringAfter$default((String)normalized, (String)"v", null, (int)2, null);
        }
        if (StringsKt.contains$default((CharSequence)normalized, (CharSequence)"+", (boolean)false, (int)2, null)) {
            normalized = StringsKt.substringBefore$default((String)normalized, (String)"+", null, (int)2, null);
        }
        return SingleVersionKt.replaceIfNotContains(normalized, "rc", "-rc");
    }

    private static final String replaceIfNotContains(String original, String replace, String replaceWith) {
        if (StringsKt.contains$default((CharSequence)original, (CharSequence)replace, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)original, (CharSequence)replaceWith, (boolean)false, (int)2, null)) {
            return StringsKt.replace$default((String)original, (String)replace, (String)replaceWith, (boolean)false, (int)4, null);
        }
        return original;
    }

    @NotNull
    public static final ModuleDescriptor.Version getMinimalVersion() {
        return minimalVersion;
    }

    public static final /* synthetic */ String access$normalizeVersion(String $receiver) {
        return SingleVersionKt.normalizeVersion($receiver);
    }

    static {
        ModuleDescriptor.Version version = ModuleDescriptor.Version.parse("0.0.0");
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"parse(...)");
        minimalVersion = version;
    }
}

