/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.welcome.components;

import com.intellij.ide.ui.laf.darcula.DarculaNewUIUtil;
import com.intellij.llmInstaller.ui.welcome.components.DisclosureButton;
import com.intellij.llmInstaller.ui.welcome.components.DisclosureButtonBorder;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u001c\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J&\u0010\r\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J0\u0010\u0010\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u0016\u001a\u00020\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0018H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/components/DisclosureButtonUI;", "Ljavax/swing/plaf/basic/BasicButtonUI;", "<init>", "()V", "installDefaults", "", "b", "Ljavax/swing/AbstractButton;", "paint", "g", "Ljava/awt/Graphics;", "c", "Ljavax/swing/JComponent;", "paintIcon", "iconRect", "Ljava/awt/Rectangle;", "paintText", "textRect", "text", "", "getPreferredSize", "Ljava/awt/Dimension;", "getMinimumSize", "paintBackground", "Lcom/intellij/llmInstaller/ui/welcome/components/DisclosureButton;", "getExtraIconsSize", "Companion", "intellij.llmInstaller"})
@ApiStatus.Experimental
public final class DisclosureButtonUI
extends BasicButtonUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JBValue.UIInteger ARC = new JBValue.UIInteger("DisclosureButton.arc", 16);
    @NotNull
    private static final JBValue.UIInteger TEXT_RIGHT_ICON_GAP = new JBValue.UIInteger("DisclosureButton.textRightIconGap", 8);
    @NotNull
    private static final JBColor DEFAULT_BACKGROUND;
    @NotNull
    private static final JBColor HOVER_BACKGROUND;
    @NotNull
    private static final JBColor PRESSED_BACKGROUND;
    private static int LEFT_MARGIN;
    private static int RIGHT_MARGIN;

    @Override
    protected void installDefaults(@Nullable AbstractButton b) {
        block0: {
            super.installDefaults(b);
            AbstractButton abstractButton = b;
            if (abstractButton == null) break block0;
            abstractButton.setBorder(new DisclosureButtonBorder());
        }
    }

    @Override
    public void paint(@Nullable Graphics g, @Nullable JComponent c) {
        block1: {
            if (!(c instanceof DisclosureButton) || g == null) {
                super.paint(g, c);
                return;
            }
            this.paintBackground(g, (DisclosureButton)c);
            super.paint(g, c);
            Icon icon = ((DisclosureButton)c).getArrowIcon();
            if (icon == null) break block1;
            Icon it = icon;
            boolean bl = false;
            Insets insets = ((DisclosureButton)c).getInsets();
            Component component2 = c;
            int n = ((DisclosureButton)c).getWidth() - insets.right - JBUIScale.scale((int)RIGHT_MARGIN) - it.getIconWidth();
            int n2 = insets.top;
            int n3 = ((DisclosureButton)c).getHeight();
            Intrinsics.checkNotNull((Object)insets);
            it.paintIcon(component2, g, n, n2 + (n3 - UiSizeUtilKt.getHeight((Insets)insets) - it.getIconHeight()) / 2);
        }
    }

    @Override
    protected void paintIcon(@Nullable Graphics g, @Nullable JComponent c, @Nullable Rectangle iconRect) {
        Rectangle rectangle = iconRect;
        if (rectangle != null) {
            Rectangle it = rectangle;
            boolean bl = false;
            it.x += JBUIScale.scale((int)LEFT_MARGIN);
        }
        super.paintIcon(g, c, iconRect);
    }

    @Override
    protected void paintText(@Nullable Graphics g, @Nullable JComponent c, @Nullable Rectangle textRect, @Nullable String text) {
        block2: {
            if (g == null || textRect == null) {
                return;
            }
            if (!(c instanceof DisclosureButton)) {
                super.paintText(g, c, textRect, text);
                return;
            }
            textRect.x += JBUIScale.scale((int)LEFT_MARGIN);
            textRect.width = ((DisclosureButton)c).getWidth() - textRect.x - this.getExtraIconsSize((DisclosureButton)((DisclosureButton)c)).width - JBUIScale.scale((int)RIGHT_MARGIN);
            FontMetrics fm = ((DisclosureButton)c).getFontMetrics(((DisclosureButton)c).getFont());
            String clippedText = UIUtilities.clipStringIfNecessary((JComponent)c, (FontMetrics)fm, (String)text, (int)textRect.width);
            super.paintText(g, c, textRect, clippedText);
            Icon icon = ((DisclosureButton)c).getRightIcon();
            if (icon == null) break block2;
            Icon it = icon;
            boolean bl = false;
            int textWidth = fm.stringWidth(clippedText);
            int x = textRect.x + Math.min(textRect.width, textWidth) + TEXT_RIGHT_ICON_GAP.get();
            Insets insets = ((DisclosureButton)c).getInsets();
            Component component2 = c;
            int n = insets.top;
            int n2 = ((DisclosureButton)c).getHeight();
            Intrinsics.checkNotNull((Object)insets);
            it.paintIcon(component2, g, x, n + (n2 - UiSizeUtilKt.getHeight((Insets)insets) - it.getIconHeight()) / 2);
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@Nullable JComponent c) {
        Dimension result2 = super.getPreferredSize(c);
        if (c instanceof DisclosureButton) {
            Insets insets = ((DisclosureButton)c).getInsets();
            Dimension minimumSize = this.getMinimumSize(c);
            Dimension extraSize = this.getExtraIconsSize((DisclosureButton)c);
            result2.width += extraSize.width;
            result2.height = Math.max(result2.height, extraSize.height);
            int n = Math.max(result2.width + JBUIScale.scale((int)LEFT_MARGIN) + JBUIScale.scale((int)RIGHT_MARGIN), minimumSize.width);
            Intrinsics.checkNotNull((Object)insets);
            result2.width = n + UiSizeUtilKt.getWidth((Insets)insets);
            result2.height = Math.max(result2.height, minimumSize.height) + UiSizeUtilKt.getHeight((Insets)insets);
        }
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize(@Nullable JComponent c) {
        return (Dimension)new JBDimension(72, 34);
    }

    private final void paintBackground(Graphics g, DisclosureButton c) {
        JBColor jBColor;
        Rectangle r = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        JBInsets.removeFrom((Rectangle)r, (Insets)c.getInsets());
        Color color = c.getButtonBackground();
        if (color == null) {
            color = (Color)DEFAULT_BACKGROUND;
        }
        DarculaNewUIUtil.INSTANCE.fillRoundedRectangle(g, r, color, ARC.getFloat());
        ButtonModel model = c.getModel();
        if (model.isArmed() && model.isPressed()) {
            jBColor = PRESSED_BACKGROUND;
        } else if (model.isRollover()) {
            jBColor = HOVER_BACKGROUND;
        } else {
            return;
        }
        JBColor overlay = jBColor;
        DarculaNewUIUtil.INSTANCE.fillRoundedRectangle(g, r, (Color)overlay, ARC.getFloat());
    }

    private final Dimension getExtraIconsSize(DisclosureButton b) {
        Dimension result2;
        block1: {
            Icon it;
            result2 = new Dimension();
            Icon icon = b.getRightIcon();
            if (icon != null) {
                it = icon;
                boolean bl = false;
                result2.width += TEXT_RIGHT_ICON_GAP.get() + it.getIconWidth();
                result2.height = Math.max(result2.height, it.getIconHeight());
            }
            Icon icon2 = b.getArrowIcon();
            if (icon2 == null) break block1;
            it = icon2;
            boolean bl = false;
            result2.width += b.getIconTextGap() + it.getIconWidth();
            result2.height = Math.max(result2.height, it.getIconHeight());
        }
        return result2;
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"DisclosureButton.defaultBackground");
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        DEFAULT_BACKGROUND = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"DisclosureButton.hoverOverlay");
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        HOVER_BACKGROUND = jBColor2;
        JBColor jBColor3 = JBColor.namedColor((String)"DisclosureButton.pressedOverlay");
        Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"namedColor(...)");
        PRESSED_BACKGROUND = jBColor3;
        LEFT_MARGIN = 14;
        RIGHT_MARGIN = 12;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0019\u0010\u0011\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/components/DisclosureButtonUI$Companion;", "", "<init>", "()V", "ARC", "Lcom/intellij/util/ui/JBValue$UIInteger;", "getARC$intellij_llmInstaller", "()Lcom/intellij/util/ui/JBValue$UIInteger;", "TEXT_RIGHT_ICON_GAP", "getTEXT_RIGHT_ICON_GAP$intellij_llmInstaller", "DEFAULT_BACKGROUND", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "getDEFAULT_BACKGROUND$intellij_llmInstaller", "()Lcom/intellij/ui/JBColor;", "HOVER_BACKGROUND", "getHOVER_BACKGROUND$intellij_llmInstaller", "PRESSED_BACKGROUND", "getPRESSED_BACKGROUND$intellij_llmInstaller", "LEFT_MARGIN", "", "RIGHT_MARGIN", "intellij.llmInstaller"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JBValue.UIInteger getARC$intellij_llmInstaller() {
            return ARC;
        }

        @NotNull
        public final JBValue.UIInteger getTEXT_RIGHT_ICON_GAP$intellij_llmInstaller() {
            return TEXT_RIGHT_ICON_GAP;
        }

        @NotNull
        public final JBColor getDEFAULT_BACKGROUND$intellij_llmInstaller() {
            return DEFAULT_BACKGROUND;
        }

        @NotNull
        public final JBColor getHOVER_BACKGROUND$intellij_llmInstaller() {
            return HOVER_BACKGROUND;
        }

        @NotNull
        public final JBColor getPRESSED_BACKGROUND$intellij_llmInstaller() {
            return PRESSED_BACKGROUND;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

