/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.google.common.collect.Maps;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyConcurrencyEvent;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyIo;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.debugger.PyUserTypeRenderer;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.AbstractThreadCommand;
import com.jetbrains.python.debugger.pydev.ChangeVariableCommand;
import com.jetbrains.python.debugger.pydev.ConsoleExecCommand;
import com.jetbrains.python.debugger.pydev.EvaluateCommand;
import com.jetbrains.python.debugger.pydev.ExceptionBreakpointCommandFactory;
import com.jetbrains.python.debugger.pydev.GetArrayCommand;
import com.jetbrains.python.debugger.pydev.GetCompletionsCommand;
import com.jetbrains.python.debugger.pydev.GetDescriptionCommand;
import com.jetbrains.python.debugger.pydev.GetFrameCommand;
import com.jetbrains.python.debugger.pydev.GetReferrersCommand;
import com.jetbrains.python.debugger.pydev.GetSmartStepIntoVariantsCommand;
import com.jetbrains.python.debugger.pydev.GetVariableCommand;
import com.jetbrains.python.debugger.pydev.InterruptDebugConsoleCommand;
import com.jetbrains.python.debugger.pydev.LoadFullValueCommand;
import com.jetbrains.python.debugger.pydev.LoadSourceCommand;
import com.jetbrains.python.debugger.pydev.ProcessCreatedCommand;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.ProtocolFrame;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebuggerCloseListener;
import com.jetbrains.python.debugger.pydev.RemoveBreakpointCommand;
import com.jetbrains.python.debugger.pydev.ResumeOrStepCommand;
import com.jetbrains.python.debugger.pydev.RunCommand;
import com.jetbrains.python.debugger.pydev.SetBreakpointCommand;
import com.jetbrains.python.debugger.pydev.SetNextStatementCommand;
import com.jetbrains.python.debugger.pydev.SetUnitTestDebuggingMode;
import com.jetbrains.python.debugger.pydev.SetUserTypeRenderersCommand;
import com.jetbrains.python.debugger.pydev.ShowReturnValuesCommand;
import com.jetbrains.python.debugger.pydev.SmartStepIntoCommand;
import com.jetbrains.python.debugger.pydev.SuspendCommand;
import com.jetbrains.python.debugger.pydev.TableCommand;
import com.jetbrains.python.debugger.pydev.VersionCommand;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommand;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandBuilder;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandResult;
import com.jetbrains.python.debugger.pydev.transport.BaseDebuggerTransport;
import com.jetbrains.python.debugger.pydev.transport.ClientModeDebuggerTransport;
import com.jetbrains.python.debugger.pydev.transport.DebuggerTransport;
import com.jetbrains.python.debugger.pydev.transport.ServerModeDebuggerTransport;
import com.jetbrains.python.tables.TableCommandParameters;
import com.jetbrains.python.tables.TableCommandType;
import java.net.ServerSocket;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDebugger
implements ProcessDebugger {
    static final int RESPONSE_TIMEOUT = 60000;
    static final int SHORT_TIMEOUT = 2000;
    private static final long CLIENT_MODE_HANDSHAKE_TIMEOUT_IN_MILLIS = 5000L;
    private static final Logger LOG = Logger.getInstance(RemoteDebugger.class);
    private static final String LOCAL_VERSION = "0.1";
    public static final String TEMP_VAR_PREFIX = "__py_debug_temp_var_";
    private static final SecureRandom ourRandom = new SecureRandom();
    private final IPyDebugProcess myDebugProcess;
    private int mySequence;
    private final Object mySequenceObject;
    private final Map<String, PyThreadInfo> myThreads;
    private final Map<Integer, ProtocolFrame> myResponseQueue;
    private final TempVarsHolder myTempVars;
    private final Map<Pair<String, Integer>, String> myTempBreakpoints;
    private final List<RemoteDebuggerCloseListener> myCloseListeners;
    @NotNull
    private final DebuggerTransport myDebuggerTransport;
    private final long myHandshakeTimeout;

    public RemoteDebugger(@NotNull IPyDebugProcess debugProcess, @NotNull String host, int port) {
        if (debugProcess == null) {
            RemoteDebugger.$$$reportNull$$$0(0);
        }
        if (host == null) {
            RemoteDebugger.$$$reportNull$$$0(1);
        }
        this.mySequence = -1;
        this.mySequenceObject = new Object();
        this.myThreads = new ConcurrentHashMap<String, PyThreadInfo>();
        this.myResponseQueue = new HashMap<Integer, ProtocolFrame>();
        this.myTempVars = new TempVarsHolder();
        this.myTempBreakpoints = Maps.newHashMap();
        this.myCloseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        int connectRetryTimeout = Registry.intValue((String)"python.debugger.remote.connect.retry.timeout.ms", (int)1000);
        int connectMaxAttempts = Registry.intValue((String)"python.debugger.remote.connect.max.attempts", (int)30);
        this.myDebugProcess = debugProcess;
        this.myDebuggerTransport = new ClientModeDebuggerTransport(this, host, port, Duration.ofMillis(connectRetryTimeout), connectMaxAttempts);
        this.myHandshakeTimeout = 5000L;
    }

    public RemoteDebugger(@NotNull IPyDebugProcess debugProcess, @NotNull ServerSocket socket, int timeout) {
        if (debugProcess == null) {
            RemoteDebugger.$$$reportNull$$$0(2);
        }
        if (socket == null) {
            RemoteDebugger.$$$reportNull$$$0(3);
        }
        this.mySequence = -1;
        this.mySequenceObject = new Object();
        this.myThreads = new ConcurrentHashMap<String, PyThreadInfo>();
        this.myResponseQueue = new HashMap<Integer, ProtocolFrame>();
        this.myTempVars = new TempVarsHolder();
        this.myTempBreakpoints = Maps.newHashMap();
        this.myCloseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDebugProcess = debugProcess;
        this.myDebuggerTransport = new ServerModeDebuggerTransport(this, socket, timeout);
        this.myHandshakeTimeout = 60000L;
    }

    protected RemoteDebugger(@NotNull IPyDebugProcess debugProcess, @NotNull DebuggerTransport debuggerTransport) {
        if (debugProcess == null) {
            RemoteDebugger.$$$reportNull$$$0(4);
        }
        if (debuggerTransport == null) {
            RemoteDebugger.$$$reportNull$$$0(5);
        }
        this.mySequence = -1;
        this.mySequenceObject = new Object();
        this.myThreads = new ConcurrentHashMap<String, PyThreadInfo>();
        this.myResponseQueue = new HashMap<Integer, ProtocolFrame>();
        this.myTempVars = new TempVarsHolder();
        this.myTempBreakpoints = Maps.newHashMap();
        this.myCloseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDebugProcess = debugProcess;
        this.myDebuggerTransport = debuggerTransport;
        this.myHandshakeTimeout = 60000L;
    }

    public IPyDebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    @Override
    public boolean isConnected() {
        return this.myDebuggerTransport.isConnected();
    }

    @Override
    public void waitForConnect() throws Exception {
        this.myDebuggerTransport.waitForConnect();
    }

    private void writeToConsole(PyIo io) {
        ConsoleViewContentType contentType = io.getCtx() == 2 ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT;
        this.myDebugProcess.printToConsole(io.getText(), contentType);
    }

    @Override
    public String handshake() throws PyDebuggerException {
        VersionCommand command = new VersionCommand(this, LOCAL_VERSION, SystemInfo.isUnix ? "UNIX" : "WIN", this.myHandshakeTimeout);
        command.execute();
        String version2 = command.getRemoteVersion();
        if (version2 != null) {
            version2 = version2.trim();
        }
        return version2;
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute2) throws PyDebuggerException {
        return this.evaluate(threadId, frameId, expression, execute2, true);
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute2, boolean trimResult) throws PyDebuggerException {
        return this.executeCommand(new EvaluateCommand(this, threadId, frameId, expression, execute2, trimResult)).getValue();
    }

    @Override
    public void consoleExec(String threadId, String frameId, String expression, PyDebugCallback<String> callback) {
        ConsoleExecCommand command = new ConsoleExecCommand(this, threadId, frameId, expression);
        command.execute(callback);
    }

    @Override
    @Nullable
    public String execTableCommand(String threadId, String frameId, String command, TableCommandType commandType, TableCommandParameters tableCommandParameters) throws PyDebuggerException {
        TableCommand tableCommand = new TableCommand(this, threadId, frameId, command, commandType, tableCommandParameters);
        tableCommand.execute();
        return tableCommand.getCommandResult();
    }

    @Override
    public XValueChildrenList loadFrame(String threadId, String frameId, ProcessDebugger.GROUP_TYPE groupType) throws PyDebuggerException {
        return this.executeCommand(new GetFrameCommand(this, threadId, frameId, groupType)).getVariables();
    }

    @Override
    public List<Pair<String, Boolean>> getSmartStepIntoVariants(String threadId, String frameId, int startContextLine, int endContextLine) throws PyDebuggerException {
        return this.executeCommand(new GetSmartStepIntoVariantsCommand(this, threadId, frameId, startContextLine, endContextLine)).getVariants();
    }

    @Override
    public XValueChildrenList loadVariable(String threadId, String frameId, PyDebugValue var) throws PyDebuggerException {
        this.setTempVariable(threadId, frameId, var);
        return this.executeCommand(new GetVariableCommand(this, threadId, frameId, var)).getVariables();
    }

    @Override
    public ArrayChunk loadArrayItems(String threadId, String frameId, PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        return this.executeCommand(new GetArrayCommand(this, threadId, frameId, var, rowOffset, colOffset, rows, cols, format)).getArray();
    }

    @Override
    @NotNull
    public DataViewerCommandResult executeDataViewerCommand(@NotNull DataViewerCommandBuilder builder) throws PyDebuggerException {
        if (builder == null) {
            RemoteDebugger.$$$reportNull$$$0(6);
        }
        builder.setDebugger(this);
        DataViewerCommand command = builder.build();
        command.execute();
        DataViewerCommandResult dataViewerCommandResult = command.getResult();
        if (dataViewerCommandResult == null) {
            RemoteDebugger.$$$reportNull$$$0(7);
        }
        return dataViewerCommandResult;
    }

    @Override
    public void loadReferrers(String threadId, String frameId, PyReferringObjectsValue var, final PyDebugCallback<? super XValueChildrenList> callback) {
        GetReferrersCommand cmd = new GetReferrersCommand(this, threadId, frameId, var);
        cmd.execute(new PyDebugCallback<List<PyDebugValue>>(){

            @Override
            public void ok(List<PyDebugValue> value) {
                XValueChildrenList list = new XValueChildrenList();
                for (PyDebugValue v : value) {
                    list.add((XNamedValue)v);
                }
                callback.ok(list);
            }

            @Override
            public void error(PyDebuggerException exception) {
                callback.error(exception);
            }
        });
    }

    @Override
    public PyDebugValue changeVariable(String threadId, String frameId, PyDebugValue var, String value) throws PyDebuggerException {
        this.setTempVariable(threadId, frameId, var);
        return this.doChangeVariable(threadId, frameId, var.getEvaluationExpression(), value);
    }

    private PyDebugValue doChangeVariable(String threadId, String frameId, String varName, String value) throws PyDebuggerException {
        return this.executeCommand(new ChangeVariableCommand(this, threadId, frameId, varName, value)).getNewValue();
    }

    @Override
    public void loadFullVariableValues(@NotNull String threadId, @NotNull String frameId, @NotNull List<PyFrameAccessor.PyAsyncValue<String>> vars) throws PyDebuggerException {
        if (threadId == null) {
            RemoteDebugger.$$$reportNull$$$0(8);
        }
        if (frameId == null) {
            RemoteDebugger.$$$reportNull$$$0(9);
        }
        if (vars == null) {
            RemoteDebugger.$$$reportNull$$$0(10);
        }
        this.executeCommand(new LoadFullValueCommand(this, threadId, frameId, vars));
    }

    @Override
    @Nullable
    public String loadSource(String path2) {
        try {
            return this.executeCommand(new LoadSourceCommand(this, path2)).getContent();
        }
        catch (PyDebuggerException e) {
            return "#Couldn't load source of file " + path2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        this.myThreads.clear();
        this.myResponseQueue.clear();
        Object object = this.mySequenceObject;
        synchronized (object) {
            this.mySequence = -1;
        }
        this.myTempVars.clear();
    }

    private void setTempVariable(String threadId, String frameId, PyDebugValue var) {
        PyDebugValue topVar = var.getTopParent();
        if (topVar == null) {
            LOG.error("Top parent is null");
            return;
        }
        String tempName = topVar.getTempName();
        if (tempName != null) {
            return;
        }
        if (!this.myDebugProcess.canSaveToTemp(topVar.getName())) {
            return;
        }
        if (this.myTempVars.contains(threadId, frameId, tempName)) {
            return;
        }
        topVar.setTempName(RemoteDebugger.generateTempName());
        try {
            this.doChangeVariable(threadId, frameId, topVar.getTempName(), topVar.getName());
            this.myTempVars.put(threadId, frameId, topVar.getTempName());
        }
        catch (PyDebuggerException e) {
            LOG.error((Throwable)e);
            topVar.setTempName(null);
        }
    }

    public String generateSaveTempName(String threadId, String frameId) {
        String tempName = RemoteDebugger.generateTempName();
        this.myTempVars.put(threadId, frameId, tempName);
        return tempName;
    }

    private void clearTempVariables(String threadId) {
        Map<String, Set<String>> threadVars = this.myTempVars.get(threadId);
        if (threadVars == null || threadVars.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Set<String>> entry : threadVars.entrySet()) {
            Set<String> frameVars = entry.getValue();
            if (frameVars == null || frameVars.isEmpty()) continue;
            String expression = "del " + StringUtil.join(frameVars, (String)",");
            String wrappedExpression = String.format("try:\n    %s\nexcept:\n    pass", expression);
            try {
                this.evaluate(threadId, entry.getKey(), wrappedExpression, true);
            }
            catch (PyDebuggerException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myTempVars.clear(threadId);
    }

    private static String generateTempName() {
        return TEMP_VAR_PREFIX + ourRandom.nextInt(Integer.MAX_VALUE);
    }

    @Override
    public Collection<PyThreadInfo> getThreads() {
        return Collections.unmodifiableCollection(new ArrayList<PyThreadInfo>(this.myThreads.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNextSequence() {
        Object object = this.mySequenceObject;
        synchronized (object) {
            this.mySequence += 2;
            return this.mySequence;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void placeResponse(int sequence, ProtocolFrame response) {
        Map<Integer, ProtocolFrame> map2 = this.myResponseQueue;
        synchronized (map2) {
            if (response == null || this.myResponseQueue.containsKey(sequence)) {
                this.myResponseQueue.put(sequence, response);
            }
            if (response != null) {
                this.myResponseQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ProtocolFrame waitForResponse(int sequence, long timeout) {
        ProtocolFrame response;
        long until = System.currentTimeMillis() + timeout;
        Map<Integer, ProtocolFrame> map2 = this.myResponseQueue;
        synchronized (map2) {
            boolean interrupted = false;
            do {
                try {
                    this.myResponseQueue.wait(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    interrupted = true;
                }
            } while ((response = this.myResponseQueue.get(sequence)) == null && this.shouldWaitForResponse() && !interrupted && System.currentTimeMillis() < until);
            this.myResponseQueue.remove(sequence);
        }
        return response;
    }

    private boolean shouldWaitForResponse() {
        return this.myDebuggerTransport.isConnecting() || this.myDebuggerTransport.isConnected();
    }

    @Override
    public void execute(@NotNull AbstractCommand command) {
        if (command == null) {
            RemoteDebugger.$$$reportNull$$$0(11);
        }
        CountDownLatch myLatch = new CountDownLatch(1);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (command instanceof ResumeOrStepCommand) {
                String threadId = ((ResumeOrStepCommand)command).getThreadId();
                this.clearTempVariables(threadId);
            }
            try {
                command.execute();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                myLatch.countDown();
            }
        });
        if (command.isResponseExpected()) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            try {
                myLatch.await(command.getResponseTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error((Throwable)e);
            }
        }
    }

    boolean sendFrame(ProtocolFrame frame) {
        return this.myDebuggerTransport.sendFrame(frame);
    }

    @Override
    public void suspendAllThreads() {
        for (PyThreadInfo thread : this.getThreads()) {
            this.suspendThread(thread.getId());
        }
    }

    @Override
    public void suspendThread(String threadId) {
        SuspendCommand command = new SuspendCommand(this, threadId);
        this.execute(command);
    }

    @Override
    public void close() {
        this.myDebuggerTransport.close();
        this.fireCloseEvent();
    }

    @Override
    public void disconnect() {
        this.myDebuggerTransport.disconnect();
        this.cleanUp();
    }

    @Override
    public void run() throws PyDebuggerException {
        this.executeCommand(new RunCommand(this));
    }

    @Override
    public void smartStepInto(String threadId, String frameId, String functionName, int callOrder, int contextStartLine, int contextEndLine) {
        SmartStepIntoCommand command = new SmartStepIntoCommand(this, threadId, frameId, functionName, callOrder, contextStartLine, contextEndLine);
        this.execute(command);
    }

    @Override
    public void resumeOrStep(String threadId, ResumeOrStepCommand.Mode mode) {
        ResumeOrStepCommand command = new ResumeOrStepCommand(this, threadId, mode);
        this.execute(command);
    }

    @Override
    public void setNextStatement(@NotNull String threadId, @NotNull XSourcePosition sourcePosition, @Nullable String functionName, @NotNull PyDebugCallback<Pair<Boolean, String>> callback) {
        if (threadId == null) {
            RemoteDebugger.$$$reportNull$$$0(12);
        }
        if (sourcePosition == null) {
            RemoteDebugger.$$$reportNull$$$0(13);
        }
        if (callback == null) {
            RemoteDebugger.$$$reportNull$$$0(14);
        }
        this.executeCommandSafely(new SetNextStatementCommand(this, threadId, sourcePosition, functionName, callback));
    }

    @Override
    public void setTempBreakpoint(@NotNull String type2, @NotNull String file, int line) {
        if (type2 == null) {
            RemoteDebugger.$$$reportNull$$$0(15);
        }
        if (file == null) {
            RemoteDebugger.$$$reportNull$$$0(16);
        }
        this.executeCommandSafely(new SetBreakpointCommand(this, type2, file, line));
        this.myTempBreakpoints.put((Pair<String, Integer>)Pair.create((Object)file, (Object)line), type2);
    }

    @Override
    public void removeTempBreakpoint(@NotNull String file, int line) {
        String type2;
        if (file == null) {
            RemoteDebugger.$$$reportNull$$$0(17);
        }
        if ((type2 = this.myTempBreakpoints.remove(Pair.create((Object)file, (Object)line))) != null) {
            RemoveBreakpointCommand command = new RemoveBreakpointCommand(this, type2, file, line);
            this.execute(command);
        } else {
            LOG.warn("Temp breakpoint not found for " + file + ":" + line);
        }
    }

    @Override
    public void setBreakpoint(@NotNull String typeId, @NotNull String file, int line, @Nullable String condition, @Nullable String logExpression, @Nullable String funcName, @NotNull SuspendPolicy policy) {
        if (typeId == null) {
            RemoteDebugger.$$$reportNull$$$0(18);
        }
        if (file == null) {
            RemoteDebugger.$$$reportNull$$$0(19);
        }
        if (policy == null) {
            RemoteDebugger.$$$reportNull$$$0(20);
        }
        SetBreakpointCommand command = new SetBreakpointCommand(this, typeId, file, line, condition, logExpression, funcName, policy);
        this.execute(command);
    }

    @Override
    public void removeBreakpoint(@NotNull String typeId, @NotNull String file, int line) {
        if (typeId == null) {
            RemoteDebugger.$$$reportNull$$$0(21);
        }
        if (file == null) {
            RemoteDebugger.$$$reportNull$$$0(22);
        }
        RemoveBreakpointCommand command = new RemoveBreakpointCommand(this, typeId, file, line);
        this.execute(command);
    }

    @Override
    public void setUserTypeRenderers(@NotNull @NotNull List<@NotNull PyUserTypeRenderer> renderers) {
        if (renderers == null) {
            RemoteDebugger.$$$reportNull$$$0(23);
        }
        SetUserTypeRenderersCommand command = new SetUserTypeRenderersCommand(this, renderers);
        this.execute(command);
    }

    @Override
    public void setShowReturnValues(boolean isShowReturnValues) {
        ShowReturnValuesCommand command = new ShowReturnValuesCommand(this, isShowReturnValues);
        this.execute(command);
    }

    @Override
    public void setUnitTestDebuggingMode() {
        SetUnitTestDebuggingMode command = new SetUnitTestDebuggingMode(this);
        this.execute(command);
    }

    public void processResponse(@NotNull String line) {
        if (line == null) {
            RemoteDebugger.$$$reportNull$$$0(24);
        }
        try {
            ProtocolFrame frame = new ProtocolFrame(line);
            BaseDebuggerTransport.logFrame(frame, false);
            if (AbstractThreadCommand.isThreadCommand(frame.getCommand())) {
                this.processThreadEvent(frame);
            } else if (AbstractCommand.isWriteToConsole(frame.getCommand())) {
                this.writeToConsole(ProtocolParser.parseIo(frame.getPayload()));
            } else if (AbstractCommand.isExitEvent(frame.getCommand())) {
                this.fireCommunicationError();
            } else if (AbstractCommand.isCallSignatureTrace(frame.getCommand())) {
                this.recordCallSignature(ProtocolParser.parseCallSignature(frame.getPayload()));
            } else if (AbstractCommand.isConcurrencyEvent(frame.getCommand())) {
                this.recordConcurrencyEvent(ProtocolParser.parseConcurrencyEvent(frame.getPayload(), this.myDebugProcess.getPositionConverter()));
            } else if (AbstractCommand.isInputRequested(frame.getCommand())) {
                this.myDebugProcess.consoleInputRequested(ProtocolParser.parseInputCommand(frame.getPayload()));
            } else if (ProcessCreatedCommand.isProcessCreatedCommand(frame.getCommand())) {
                this.onProcessCreatedEvent(frame.getSequence());
            } else if (AbstractCommand.isShowWarningCommand(frame.getCommand())) {
                String warningId = ProtocolParser.parseWarning(frame.getPayload());
                this.myDebugProcess.showWarning(warningId);
            } else {
                this.placeResponse(frame.getSequence(), frame);
            }
        }
        catch (Throwable t) {
            LOG.error(t);
        }
    }

    private void recordCallSignature(PySignature signature) {
        this.myDebugProcess.recordSignature(signature);
    }

    private void recordConcurrencyEvent(PyConcurrencyEvent event) {
        this.myDebugProcess.recordLogEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processThreadEvent(ProtocolFrame frame) throws PyDebuggerException {
        XDebugSession xDebugSession = this.myDebugProcess.getSession();
        synchronized (xDebugSession) {
            switch (frame.getCommand()) {
                case 103: {
                    PyThreadInfo thread = this.parseThreadEvent(frame);
                    if (thread.isPydevThread()) break;
                    this.myThreads.put(thread.getId(), thread);
                    if (!this.myDebugProcess.getSession().isSuspended() || !this.myDebugProcess.isSuspendedOnAllThreadsPolicy()) break;
                    this.suspendThread(thread.getId());
                    break;
                }
                case 105: {
                    PyThreadInfo event = this.parseThreadEvent(frame);
                    PyThreadInfo thread = this.myThreads.get(event.getId());
                    if (thread == null) {
                        LOG.error("Trying to stop on non-existent thread: " + event.getId() + ", " + event.getStopReason() + ", " + event.getMessage());
                        this.myThreads.put(event.getId(), event);
                        thread = event;
                    }
                    thread.updateState(PyThreadInfo.State.SUSPENDED, event.getFrames());
                    thread.setStopReason(event.getStopReason());
                    thread.setMessage(event.getMessage());
                    boolean updateSourcePosition = true;
                    if (event.getStopReason() == 105 || event.getStopReason() == 111) {
                        updateSourcePosition = !this.myDebugProcess.getSession().isSuspended();
                    }
                    this.myDebugProcess.threadSuspended(thread, updateSourcePosition);
                    break;
                }
                case 106: {
                    String id = ProtocolParser.getThreadId(frame.getPayload());
                    PyThreadInfo thread = this.myThreads.get(id);
                    if (thread == null) break;
                    thread.updateState(PyThreadInfo.State.RUNNING, null);
                    this.myDebugProcess.threadResumed(thread);
                    break;
                }
                case 104: {
                    String id = frame.getPayload();
                    PyThreadInfo thread = this.myThreads.get(id);
                    if (thread != null) {
                        thread.updateState(PyThreadInfo.State.KILLED, null);
                        this.myThreads.remove(id);
                    }
                    if (this.myDebugProcess.getSession().getCurrentPosition() != null) break;
                    for (PyThreadInfo threadInfo : this.myThreads.values()) {
                        if (threadInfo == null || threadInfo.getState() != PyThreadInfo.State.SUSPENDED) continue;
                        this.myDebugProcess.threadResumed(threadInfo);
                        this.myDebugProcess.threadSuspended(threadInfo, true);
                    }
                    break;
                }
                case 142: {
                    PyThreadInfo event = this.parseThreadEvent(frame);
                    PyThreadInfo thread = this.myThreads.get(event.getId());
                    if (thread == null) {
                        this.myThreads.put(event.getId(), event);
                        thread = event;
                    }
                    thread.updateState(PyThreadInfo.State.SUSPENDED, event.getFrames());
                    thread.setStopReason(event.getStopReason());
                    thread.setMessage(event.getMessage());
                    this.myDebugProcess.showConsole(thread);
                }
            }
        }
    }

    private PyThreadInfo parseThreadEvent(ProtocolFrame frame) throws PyDebuggerException {
        return ProtocolParser.parseThread(frame.getPayload(), this.myDebugProcess.getPositionConverter());
    }

    @Override
    public void addCloseListener(RemoteDebuggerCloseListener listener2) {
        this.myCloseListeners.add(listener2);
    }

    public void removeCloseListener(RemoteDebuggerCloseListener listener2) {
        this.myCloseListeners.remove(listener2);
    }

    @Override
    public List<PydevCompletionVariant> getCompletions(String threadId, String frameId, String prefix) {
        GetCompletionsCommand command = new GetCompletionsCommand(this, threadId, frameId, prefix);
        this.execute(command);
        return command.getCompletions();
    }

    @Override
    public String getDescription(String threadId, String frameId, String cmd) {
        GetDescriptionCommand command = new GetDescriptionCommand(this, threadId, frameId, cmd);
        this.execute(command);
        return command.getResult();
    }

    @Override
    public void addExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        this.execute(factory.createAddCommand(this));
    }

    @Override
    public void removeExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        this.execute(factory.createRemoveCommand(this));
    }

    @Override
    public void suspendOtherThreads(PyThreadInfo thread) {
        if (!this.myThreads.containsKey(thread.getId())) {
            for (PyThreadInfo otherThread : this.getThreads()) {
                if (otherThread.getId().equals(thread.getId())) continue;
                this.suspendThread(otherThread.getId());
            }
        }
    }

    protected void onProcessCreatedEvent(int commandSequence) {
    }

    protected void fireCloseEvent() {
        for (RemoteDebuggerCloseListener listener2 : this.myCloseListeners) {
            listener2.closed();
        }
    }

    public void fireCommunicationError() {
        for (RemoteDebuggerCloseListener listener2 : this.myCloseListeners) {
            listener2.communicationError();
        }
    }

    public void fireExitEvent() {
        for (RemoteDebuggerCloseListener listener2 : this.myCloseListeners) {
            listener2.detached();
        }
    }

    private <T extends AbstractCommand<?>> T executeCommand(@NotNull T command) throws PyDebuggerException {
        block3: {
            if (command == null) {
                RemoteDebugger.$$$reportNull$$$0(25);
            }
            try {
                command.execute();
            }
            catch (PyDebuggerException e) {
                if (!this.isConnected()) break block3;
                throw e;
            }
        }
        return command;
    }

    private <T extends AbstractCommand<?>> void executeCommandSafely(@NotNull T command) {
        block3: {
            if (command == null) {
                RemoteDebugger.$$$reportNull$$$0(26);
            }
            try {
                command.execute();
            }
            catch (PyDebuggerException e) {
                if (!this.isConnected()) break block3;
                LOG.error("Command " + command + " failed", (Throwable)e);
            }
        }
    }

    @Override
    public void interruptDebugConsole() {
        InterruptDebugConsoleCommand interruptCommand = new InterruptDebugConsoleCommand(this);
        try {
            interruptCommand.execute();
        }
        catch (PyDebuggerException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerTransport";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/RemoteDebugger";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 11: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderers";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/RemoteDebugger";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "executeDataViewerCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeDataViewerCommand";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadFullVariableValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setNextStatement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setTempBreakpoint";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeTempBreakpoint";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setBreakpoint";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoint";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setUserTypeRenderers";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processResponse";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "executeCommandSafely";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private static class TempVarsHolder {
        private final Map<String, Map<String, Set<String>>> myData = new HashMap<String, Map<String, Set<String>>>();

        private TempVarsHolder() {
        }

        public boolean contains(String threadId, String frameId, String name2) {
            Map<String, Set<String>> threadVars = this.myData.get(threadId);
            if (threadVars == null) {
                return false;
            }
            Set<String> frameVars = threadVars.get(frameId);
            if (frameVars == null) {
                return false;
            }
            return frameVars.contains(name2);
        }

        protected void put(String threadId, String frameId, String name2) {
            Set<String> frameVars;
            Map<String, Set<String>> threadVars = this.myData.get(threadId);
            if (threadVars == null) {
                threadVars = new HashMap<String, Set<String>>();
                this.myData.put(threadId, threadVars);
            }
            if ((frameVars = threadVars.get(frameId)) == null) {
                frameVars = new HashSet<String>();
                threadVars.put(frameId, frameVars);
            }
            frameVars.add(name2);
        }

        protected Map<String, Set<String>> get(String threadId) {
            return this.myData.get(threadId);
        }

        protected void clear() {
            this.myData.clear();
        }

        protected void clear(String threadId) {
            Map<String, Set<String>> threadVars = this.myData.get(threadId);
            if (threadVars != null) {
                threadVars.clear();
            }
        }
    }
}

