/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyRequirement;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0007J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/codeInsight/typing/PyBundledStubs;", "", "<init>", "()V", "BUNDLED_STUBS_PATH", "", "BUNDLED_STUB_ROOT", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBUNDLED_STUB_ROOT", "()Lcom/intellij/openapi/vfs/VirtualFile;", "BUNDLED_STUB_ROOT$delegate", "Lkotlin/Lazy;", "maySearchForStubInRoot", "", "name", "Lcom/intellij/psi/util/QualifiedName;", "root", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isBundledStubsDirectory", "file", "getRoots", "", "intellij.python.psi.impl"})
public final class PyBundledStubs {
    @NotNull
    public static final PyBundledStubs INSTANCE = new PyBundledStubs();
    @NotNull
    private static final String BUNDLED_STUBS_PATH = "bundled_stubs";
    @NotNull
    private static final Lazy BUNDLED_STUB_ROOT$delegate = LazyKt.lazy(PyBundledStubs::BUNDLED_STUB_ROOT_delegate$lambda$0);

    private PyBundledStubs() {
    }

    private final VirtualFile getBUNDLED_STUB_ROOT() {
        Lazy lazy = BUNDLED_STUB_ROOT$delegate;
        return (VirtualFile)lazy.getValue();
    }

    public final boolean maySearchForStubInRoot(@NotNull QualifiedName name2, @NotNull VirtualFile root, @NotNull Sdk sdk2) {
        List<PyPackage> list;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        String string = name2.getFirstComponent();
        if (string == null) {
            return false;
        }
        String possiblePackage = string;
        String alternativePossiblePackage = PyPsiPackageUtil.INSTANCE.moduleToPackageName(possiblePackage, "");
        PyPackageManager pyPackageManager = PyPackageManagers.getInstance().forSdk(sdk2);
        Intrinsics.checkNotNullExpressionValue((Object)pyPackageManager, (String)"forSdk(...)");
        PyPackageManager packageManager = pyPackageManager;
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !PlatformUtils.isFleetBackend()) {
            list = packageManager.refreshAndGetPackages(false);
        } else {
            list = packageManager.getPackages();
            if (list == null) {
                return true;
            }
        }
        List<PyPackage> list2 = list;
        Intrinsics.checkNotNull(list2);
        List<PyPackage> installedPackages = list2;
        PyRequirement pyRequirement = packageManager.parseRequirement(possiblePackage);
        return (pyRequirement != null ? pyRequirement.match((Collection<? extends PyPackage>)installedPackages) : null) != null || PyPsiPackageUtil.findPackage(installedPackages, alternativePossiblePackage) != null;
    }

    public final boolean isBundledStubsDirectory(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file, (Object)this.getBUNDLED_STUB_ROOT());
    }

    @NotNull
    public final Iterable<VirtualFile> getRoots() {
        return CollectionsKt.listOfNotNull((Object)this.getBUNDLED_STUB_ROOT());
    }

    private static final VirtualFile BUNDLED_STUB_ROOT_delegate$lambda$0() {
        String helpersPath = PythonHelpersLocator.Companion.findPathStringInHelpers(BUNDLED_STUBS_PATH);
        if (((CharSequence)helpersPath).length() == 0) {
            return null;
        }
        return StandardFileSystems.local().findFileByPath(helpersPath);
    }
}

