/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesList;
import com.intellij.lang.properties.psi.PropertiesListStub;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.lang.properties.psi.PropertyKeyValueFormat;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesFileImpl
extends PsiFileBase
implements PropertiesFile {
    private static final Logger LOG = Logger.getInstance(PropertiesFileImpl.class);
    private static final TokenSet PROPERTIES_LIST_SET = TokenSet.create((IElementType[])new IElementType[]{PropertiesElementTypes.PROPERTIES_LIST});

    public PropertiesFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, (Language)PropertiesLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = PropertiesFileType.INSTANCE;
        if (languageFileType == null) {
            PropertiesFileImpl.$$$reportNull$$$0(0);
        }
        return languageFileType;
    }

    @NonNls
    public String toString() {
        return "Properties file:" + this.getName();
    }

    @Override
    @NotNull
    public List<IProperty> getProperties() {
        PropertiesList propertiesList = (PropertiesList)this.withGreenStubOrAst(stub -> {
            PropertiesListStub propertiesListStub = (PropertiesListStub)stub.findChildStubByType((IStubElementType)PropertiesElementTypes.PROPERTIES_LIST);
            return propertiesListStub == null ? null : (PropertiesList)propertiesListStub.getPsi();
        }, ast -> (PropertiesList)PsiTreeUtil.findChildOfType((PsiElement)this, PropertiesList.class));
        List<IProperty> list = Collections.unmodifiableList(PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)propertiesList, Property.class));
        if (list == null) {
            PropertiesFileImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    private ASTNode getPropertiesList() {
        return (ASTNode)ArrayUtil.getFirstElement((Object[])this.getNode().getChildren(PROPERTIES_LIST_SET));
    }

    @Override
    @Nullable
    public IProperty findPropertyByKey(@NotNull String key) {
        if (key == null) {
            PropertiesFileImpl.$$$reportNull$$$0(2);
        }
        return this.propertiesByKey(key).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public List<IProperty> findPropertiesByKey(@NotNull String key) {
        if (key == null) {
            PropertiesFileImpl.$$$reportNull$$$0(3);
        }
        List<IProperty> list = this.propertiesByKey(key).collect(Collectors.toList());
        if (list == null) {
            PropertiesFileImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = PropertiesImplUtil.getResourceBundle(this);
        if (resourceBundle == null) {
            PropertiesFileImpl.$$$reportNull$$$0(5);
        }
        return resourceBundle;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        Locale locale = PropertiesUtil.getLocale(this);
        if (locale == null) {
            PropertiesFileImpl.$$$reportNull$$$0(6);
        }
        return locale;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PropertiesFileImpl.$$$reportNull$$$0(7);
        }
        if (element instanceof Property) {
            throw new IncorrectOperationException("Use addProperty() instead");
        }
        return super.add(element);
    }

    @Override
    @NotNull
    public PsiElement addProperty(@NotNull IProperty property) throws IncorrectOperationException {
        if (property == null) {
            PropertiesFileImpl.$$$reportNull$$$0(8);
        }
        IProperty position = this.findInsertionPosition(property);
        PsiElement psiElement = this.addPropertyAfter(property, position);
        if (psiElement == null) {
            PropertiesFileImpl.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement addPropertyAfter(@NotNull IProperty property, @Nullable IProperty anchor) throws IncorrectOperationException {
        ASTNode anchorBefore;
        if (property == null) {
            PropertiesFileImpl.$$$reportNull$$$0(10);
        }
        TreeElement copy = ChangeUtil.copyToElement((PsiElement)property.getPsiElement());
        List<IProperty> properties = this.getProperties();
        ASTNode aSTNode = anchor == null ? (properties.isEmpty() ? null : properties.get(0).getPsiElement().getNode()) : (anchorBefore = anchor.getPsiElement().getNode().getTreeNext());
        if (anchorBefore != null && anchorBefore.getElementType() == TokenType.WHITE_SPACE) {
            anchorBefore = anchorBefore.getTreeNext();
        }
        if (anchorBefore == null && this.haveToAddNewLine()) {
            this.insertLineBreakBefore(null);
        }
        this.getPropertiesList().addChild((ASTNode)copy, anchorBefore);
        if (anchorBefore != null) {
            this.insertLineBreakBefore(anchorBefore);
        }
        PsiElement psiElement = copy.getPsi();
        if (psiElement == null) {
            PropertiesFileImpl.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public IProperty addProperty(@NotNull String key, @NotNull String value, @NotNull PropertyKeyValueFormat format) {
        if (key == null) {
            PropertiesFileImpl.$$$reportNull$$$0(12);
        }
        if (value == null) {
            PropertiesFileImpl.$$$reportNull$$$0(13);
        }
        if (format == null) {
            PropertiesFileImpl.$$$reportNull$$$0(14);
        }
        IProperty iProperty = (IProperty)this.addProperty(PropertiesElementFactory.createProperty(this.getProject(), key, value, null, format));
        if (iProperty == null) {
            PropertiesFileImpl.$$$reportNull$$$0(15);
        }
        return iProperty;
    }

    @Override
    @NotNull
    public IProperty addPropertyAfter(@NotNull String key, @NotNull String value, @Nullable IProperty anchor) {
        if (key == null) {
            PropertiesFileImpl.$$$reportNull$$$0(16);
        }
        if (value == null) {
            PropertiesFileImpl.$$$reportNull$$$0(17);
        }
        IProperty iProperty = (IProperty)this.addPropertyAfter(PropertiesElementFactory.createProperty(this.getProject(), key, value, null), anchor);
        if (iProperty == null) {
            PropertiesFileImpl.$$$reportNull$$$0(18);
        }
        return iProperty;
    }

    private void insertLineBreakBefore(ASTNode anchorBefore) {
        ASTNode propertiesList = this.getPropertiesList();
        if (anchorBefore == null && propertiesList.getFirstChildNode() == null) {
            this.getNode().addChild((ASTNode)ASTFactory.whitespace((CharSequence)"\n"), propertiesList);
        } else {
            propertiesList.addChild((ASTNode)ASTFactory.whitespace((CharSequence)"\n"), anchorBefore);
        }
    }

    private boolean haveToAddNewLine() {
        ASTNode propertiesList = this.getPropertiesList();
        ASTNode lastChild = propertiesList.getLastChildNode();
        if (lastChild != null) {
            return !lastChild.getText().endsWith("\n");
        }
        ASTNode prev = propertiesList.getTreePrev();
        return prev == null || !PropertiesTokenTypes.WHITESPACES.contains(prev.getElementType());
    }

    @Override
    @NotNull
    public Map<String, String> getNamesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (IProperty property : this.getProperties()) {
            result.put(property.getUnescapedKey(), property.getValue());
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            PropertiesFileImpl.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    @Override
    public boolean isAlphaSorted() {
        return PropertiesImplUtil.isAlphaSorted(this.getProperties());
    }

    private IProperty findInsertionPosition(@NotNull IProperty property) {
        List<IProperty> properties;
        if (property == null) {
            PropertiesFileImpl.$$$reportNull$$$0(20);
        }
        if ((properties = this.getProperties()).isEmpty()) {
            return null;
        }
        if (PropertiesImplUtil.isAlphaSorted(properties)) {
            int insertIndex = Collections.binarySearch(this.getProperties(), property, (p1, p2) -> {
                String k1 = p1.getKey();
                String k2 = p2.getKey();
                LOG.assertTrue(k1 != null && k2 != null);
                return String.CASE_INSENSITIVE_ORDER.compare(k1, k2);
            });
            return insertIndex == -1 ? null : this.getProperties().get(insertIndex < 0 ? -insertIndex - 2 : insertIndex);
        }
        return (IProperty)ContainerUtil.getLastItem(properties);
    }

    @NotNull
    private Stream<? extends IProperty> propertiesByKey(@NotNull String key) {
        if (key == null) {
            PropertiesFileImpl.$$$reportNull$$$0(21);
        }
        if (this.shouldReadIndex()) {
            Stream<Property> stream = PropertyKeyIndex.getInstance().getProperties(key, this.getProject(), GlobalSearchScope.fileScope((PsiFile)this)).stream();
            if (stream == null) {
                PropertiesFileImpl.$$$reportNull$$$0(22);
            }
            return stream;
        }
        Stream<IProperty> stream = this.getProperties().stream().filter(p -> key.equals(p.getUnescapedKey()));
        if (stream == null) {
            PropertiesFileImpl.$$$reportNull$$$0(23);
        }
        return stream;
    }

    private boolean shouldReadIndex() {
        Project project = this.getProject();
        if (DumbService.isDumb((Project)project)) {
            return false;
        }
        VirtualFile file = this.getVirtualFile();
        return file != null && ProjectFileIndex.getInstance((Project)project).isInContent(file) && !InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(this.getContainingFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 7, 8, 10, 12, 13, 14, 16, 17, 20, 21 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/psi/impl/PropertiesFileImpl";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/psi/impl/PropertiesFileImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findPropertiesByKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
            case 9: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addProperty";
                break;
            }
            case 11: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "addPropertyAfter";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamesMap";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "propertiesByKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyByKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPropertiesByKey";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addProperty";
                break;
            }
            case 10: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyAfter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findInsertionPosition";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "propertiesByKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 7, 8, 10, 12, 13, 14, 16, 17, 20, 21 -> new IllegalArgumentException(string);
        };
    }
}

