/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.tree;

import com.intellij.openapi.project.Project;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.ui.tree.TreeUtil;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.popup.GitBranchesTreePopupFilterByAction;
import git4idea.ui.branch.popup.GitBranchesTreePopupFilterByRepository;
import git4idea.ui.branch.tree.GitBranchesTreeModel;
import git4idea.ui.branch.tree.GitBranchesTreeMultiRepoFilteringModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ'\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0002\b\u0015J'\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0002\b\u0017J\u0014\u0010\u0018\u001a\u00020\f*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0019\u001a\u00020\f*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u001a\u001a\u00020\f*\u00020\u0006H\u0002J\u0012\u0010\u001b\u001a\u00020\f*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u001c\u001a\u00020\f*\u00020\u0006H\u0002J\u0012\u0010\u001d\u001a\u00020\f*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u001e\u001a\u00020\f*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u001f\u001a\u00020\f*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010 \u001a\u00020\f*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\f2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0002J \u0010$\u001a\u0004\u0018\u00010#*\u00020%2\b\u0010&\u001a\u0004\u0018\u00010#2\u0006\u0010!\u001a\u00020\fH\u0002J*\u0010'\u001a\u0004\u0018\u00010#*\u00020%2\u0006\u0010(\u001a\u00020#2\u0006\u0010!\u001a\u00020\f2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010#H\u0002J\u001e\u0010*\u001a\u0004\u0018\u00010#*\u00020%2\u0006\u0010&\u001a\u00020#2\u0006\u0010!\u001a\u00020\fH\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010#*\u00020%H\u0002J\u000e\u0010,\u001a\u0004\u0018\u00010#*\u00020%H\u0002R\u0014\u0010\r\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006-"}, d2={"Lgit4idea/ui/branch/tree/GitBranchesTreeUtil;", "", "<init>", "()V", "overrideBuiltInAction", "", "Ljavax/swing/JTree;", "actionKey", "", "override", "Lkotlin/Function1;", "Ljava/awt/event/ActionEvent;", "", "cycleScrolling", "getCycleScrolling", "()Z", "canHighlight", "project", "Lcom/intellij/openapi/project/Project;", "tree", "node", "canHighlight$intellij_vcs_git", "canSelect", "canSelect$intellij_vcs_git", "selectFirstRow", "selectNext", "selectNextLeaf", "selectPrev", "selectPrevLeaf", "selectFirst", "selectLast", "selectLastRow", "selectRow", "forward", "curSelection", "Ljavax/swing/tree/TreePath;", "findNextLeaf", "Ljavax/swing/tree/TreeModel;", "start", "findChildLeaf", "parentPath", "startChild", "findNextSiblingLeaf", "findFirstLeaf", "findLastLeaf", "intellij.vcs.git"})
public final class GitBranchesTreeUtil {
    @NotNull
    public static final GitBranchesTreeUtil INSTANCE = new GitBranchesTreeUtil();

    private GitBranchesTreeUtil() {
    }

    public final void overrideBuiltInAction(@NotNull JTree $this$overrideBuiltInAction, @NotNull String actionKey, @NotNull Function1<? super ActionEvent, Boolean> override) {
        Intrinsics.checkNotNullParameter((Object)$this$overrideBuiltInAction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actionKey, (String)"actionKey");
        Intrinsics.checkNotNullParameter(override, (String)"override");
        Action originalAction = $this$overrideBuiltInAction.getActionMap().get(actionKey);
        $this$overrideBuiltInAction.getActionMap().put(actionKey, new AbstractAction(override, originalAction){
            final /* synthetic */ Function1<ActionEvent, Boolean> $override;
            final /* synthetic */ Action $originalAction;
            {
                this.$override = $override;
                this.$originalAction = $originalAction;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (((Boolean)this.$override.invoke((Object)e)).booleanValue()) {
                    return;
                }
                this.$originalAction.actionPerformed(e);
            }
        });
    }

    private final boolean getCycleScrolling() {
        return TreeUtil.isCyclicScrollingAllowed();
    }

    public final boolean canHighlight$intellij_vcs_git(@NotNull Project project, @NotNull JTree tree, @Nullable Object node) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        return node instanceof GitBranchesTreeModel.BranchesPrefixGroup || this.canSelect$intellij_vcs_git(project, tree, node);
    }

    public final boolean canSelect$intellij_vcs_git(@NotNull Project project, @NotNull JTree tree, @Nullable Object node) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        TreeModel model = tree.getModel();
        if (node instanceof GitRepository && model instanceof GitBranchesTreeMultiRepoFilteringModel) {
            return ((GitBranchesTreeMultiRepoFilteringModel)((Object)model)).isLeaf(node);
        }
        Object object = node;
        return object instanceof PopupFactoryImpl.ActionItem ? GitBranchesTreePopupFilterByAction.Companion.isSelected(project) : (object instanceof GitRepository ? GitBranchesTreePopupFilterByRepository.Companion.isSelected(project) : (object instanceof GitBranchesTreeModel.TopLevelRepository ? GitBranchesTreePopupFilterByRepository.Companion.isSelected(project) : model.isLeaf(node)));
    }

    private final boolean selectFirstRow(JTree $this$selectFirstRow, Project project) {
        TreePath treePath = $this$selectFirstRow.getPathForRow(0);
        if (treePath == null) {
            return false;
        }
        TreePath path = treePath;
        if (!this.canSelect$intellij_vcs_git(project, $this$selectFirstRow, path.getLastPathComponent())) {
            return false;
        }
        $this$selectFirstRow.scrollPathToVisible(path);
        $this$selectFirstRow.setSelectionPath(path);
        return true;
    }

    public final boolean selectNext(@NotNull JTree $this$selectNext, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$selectNext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (GitBranchesTreeUtil.selectRow$default(this, $this$selectNext, project, true, null, 4, null)) {
            return true;
        }
        return this.selectNextLeaf($this$selectNext);
    }

    private final boolean selectNextLeaf(JTree $this$selectNextLeaf) {
        TreeModel treeModel = $this$selectNextLeaf.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"getModel(...)");
        TreePath nextLeaf = this.findNextLeaf(treeModel, $this$selectNextLeaf.getSelectionPath(), true);
        TreePath treePath = nextLeaf;
        if (treePath == null) {
            if (this.getCycleScrolling()) {
                TreeModel treeModel2 = $this$selectNextLeaf.getModel();
                Intrinsics.checkNotNullExpressionValue((Object)treeModel2, (String)"getModel(...)");
                treePath = this.findFirstLeaf(treeModel2);
            } else {
                return false;
            }
        }
        TreePath toSelect = treePath;
        $this$selectNextLeaf.scrollPathToVisible(toSelect);
        $this$selectNextLeaf.setSelectionPath(toSelect);
        return true;
    }

    public final boolean selectPrev(@NotNull JTree $this$selectPrev, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$selectPrev, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (GitBranchesTreeUtil.selectRow$default(this, $this$selectPrev, project, false, null, 4, null)) {
            return true;
        }
        return this.selectPrevLeaf($this$selectPrev);
    }

    private final boolean selectPrevLeaf(JTree $this$selectPrevLeaf) {
        TreeModel treeModel = $this$selectPrevLeaf.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"getModel(...)");
        TreePath prevLeaf = this.findNextLeaf(treeModel, $this$selectPrevLeaf.getSelectionPath(), false);
        TreePath treePath = prevLeaf;
        if (treePath == null) {
            if (this.getCycleScrolling()) {
                TreeModel treeModel2 = $this$selectPrevLeaf.getModel();
                Intrinsics.checkNotNullExpressionValue((Object)treeModel2, (String)"getModel(...)");
                treePath = this.findLastLeaf(treeModel2);
            } else {
                return false;
            }
        }
        TreePath toSelect = treePath;
        $this$selectPrevLeaf.scrollPathToVisible(toSelect);
        $this$selectPrevLeaf.setSelectionPath(toSelect);
        return true;
    }

    public final boolean selectFirst(@NotNull JTree $this$selectFirst, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$selectFirst, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.selectFirstRow($this$selectFirst, project)) {
            return true;
        }
        TreeModel treeModel = $this$selectFirst.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"getModel(...)");
        TreePath treePath = this.findFirstLeaf(treeModel);
        if (treePath == null) {
            return false;
        }
        TreePath toSelect = treePath;
        $this$selectFirst.scrollPathToVisible(toSelect);
        $this$selectFirst.setSelectionPath(toSelect);
        return true;
    }

    public final boolean selectLast(@NotNull JTree $this$selectLast, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$selectLast, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.selectLastRow($this$selectLast, project)) {
            return true;
        }
        TreeModel treeModel = $this$selectLast.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"getModel(...)");
        TreePath treePath = this.findLastLeaf(treeModel);
        if (treePath == null) {
            return false;
        }
        TreePath toSelect = treePath;
        $this$selectLast.scrollPathToVisible(toSelect);
        $this$selectLast.setSelectionPath(toSelect);
        return true;
    }

    private final boolean selectLastRow(JTree $this$selectLastRow, Project project) {
        TreePath treePath = $this$selectLastRow.getPathForRow($this$selectLastRow.getRowCount() - 1);
        if (treePath == null) {
            return false;
        }
        TreePath path = treePath;
        if (!this.canSelect$intellij_vcs_git(project, $this$selectLastRow, path.getLastPathComponent())) {
            return false;
        }
        $this$selectLastRow.scrollPathToVisible(path);
        $this$selectLastRow.setSelectionPath(path);
        return true;
    }

    private final boolean selectRow(JTree $this$selectRow, Project project, boolean forward, TreePath curSelection) {
        int rowToSelect = $this$selectRow.getRowForPath(curSelection) + (forward ? 1 : -1);
        if (!(0 <= rowToSelect ? rowToSelect < $this$selectRow.getRowCount() : false) && this.getCycleScrolling()) {
            rowToSelect = forward ? 0 : $this$selectRow.getRowCount() - 1;
        }
        TreePath treePath = $this$selectRow.getPathForRow(rowToSelect);
        if (treePath == null) {
            return false;
        }
        TreePath pathToSelect = treePath;
        Object nodeToSelect = pathToSelect.getLastPathComponent();
        if (nodeToSelect instanceof SeparatorWithText) {
            return this.selectRow($this$selectRow, project, forward, pathToSelect);
        }
        if (!this.canSelect$intellij_vcs_git(project, $this$selectRow, nodeToSelect)) {
            TreeModel treeModel = $this$selectRow.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"getModel(...)");
            if (this.findNextLeaf(treeModel, pathToSelect, forward) != null) {
                return forward ? this.selectNextLeaf($this$selectRow) : this.selectPrevLeaf($this$selectRow);
            }
            return this.selectRow($this$selectRow, project, forward, pathToSelect);
        }
        $this$selectRow.scrollPathToVisible(pathToSelect);
        $this$selectRow.setSelectionPath(pathToSelect);
        return true;
    }

    static /* synthetic */ boolean selectRow$default(GitBranchesTreeUtil gitBranchesTreeUtil, JTree jTree, Project project, boolean bl, TreePath treePath, int n, Object object) {
        if ((n & 4) != 0) {
            treePath = jTree.getSelectionPath();
        }
        return gitBranchesTreeUtil.selectRow(jTree, project, bl, treePath);
    }

    private final TreePath findNextLeaf(TreeModel $this$findNextLeaf, TreePath start, boolean forward) {
        if (start == null) {
            return null;
        }
        if (start.getParentPath() == null) {
            return null;
        }
        TreePath treePath = GitBranchesTreeUtil.findChildLeaf$default(this, $this$findNextLeaf, start, forward, null, 4, null);
        if (treePath == null) {
            treePath = this.findNextSiblingLeaf($this$findNextLeaf, start, forward);
        }
        return treePath;
    }

    private final TreePath findChildLeaf(TreeModel $this$findChildLeaf, TreePath parentPath, boolean forward, TreePath startChild) {
        int startIndex;
        Object parent = parentPath.getLastPathComponent();
        int childCount = $this$findChildLeaf.getChildCount(parent);
        if (childCount <= 0) {
            return null;
        }
        if (startChild == null) {
            v0 = forward ? 0 : childCount - 1;
        } else {
            int startChildIndex = $this$findChildLeaf.getIndexOfChild(parentPath.getLastPathComponent(), startChild.getLastPathComponent());
            v0 = startIndex = forward ? startChildIndex + 1 : startChildIndex - 1;
        }
        if (startIndex < 0 || startIndex >= childCount) {
            return null;
        }
        IntProgression indices = forward ? (IntProgression)RangesKt.until((int)startIndex, (int)childCount) : RangesKt.downTo((int)startIndex, (int)0);
        int i = indices.getFirst();
        int n = indices.getLast();
        int n2 = indices.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                Object child;
                Intrinsics.checkNotNull((Object)$this$findChildLeaf.getChild(parent, i));
                TreePath childPath = parentPath.pathByAddingChild(child);
                if ($this$findChildLeaf.isLeaf(child)) {
                    return childPath;
                }
                Intrinsics.checkNotNull((Object)childPath);
                TreePath childOfChild = GitBranchesTreeUtil.findChildLeaf$default(this, $this$findChildLeaf, childPath, forward, null, 4, null);
                if (childOfChild != null) {
                    return childOfChild;
                }
                if (i == n) break;
                i += n2;
            }
        }
        return null;
    }

    static /* synthetic */ TreePath findChildLeaf$default(GitBranchesTreeUtil gitBranchesTreeUtil, TreeModel treeModel, TreePath treePath, boolean bl, TreePath treePath2, int n, Object object) {
        if ((n & 4) != 0) {
            treePath2 = null;
        }
        return gitBranchesTreeUtil.findChildLeaf(treeModel, treePath, bl, treePath2);
    }

    private final TreePath findNextSiblingLeaf(TreeModel $this$findNextSiblingLeaf, TreePath start, boolean forward) {
        TreePath parent = start.getParentPath();
        if (parent == null) {
            return null;
        }
        TreePath treePath = this.findChildLeaf($this$findNextSiblingLeaf, parent, forward, start);
        if (treePath == null) {
            TreePath treePath2 = start.getParentPath();
            Intrinsics.checkNotNullExpressionValue((Object)treePath2, (String)"getParentPath(...)");
            treePath = this.findNextSiblingLeaf($this$findNextSiblingLeaf, treePath2, forward);
        }
        return treePath;
    }

    private final TreePath findFirstLeaf(TreeModel $this$findFirstLeaf) {
        TreePath rootPath = new TreePath($this$findFirstLeaf.getRoot());
        return GitBranchesTreeUtil.findChildLeaf$default(this, $this$findFirstLeaf, rootPath, true, null, 4, null);
    }

    private final TreePath findLastLeaf(TreeModel $this$findLastLeaf) {
        TreePath rootPath = new TreePath($this$findLastLeaf.getRoot());
        return GitBranchesTreeUtil.findChildLeaf$default(this, $this$findLastLeaf, rootPath, false, null, 4, null);
    }
}

