/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.tooltips;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendAsyncTooltipHighlightInfo;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendSynchronousTooltipProvider;
import com.jetbrains.rdclient.document.DocumentExKt;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\u0005*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendLazyTooltipHighlightInfoRequester;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "<init>", "()V", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "startTooltipPrecalculation", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "range", "Lcom/intellij/openapi/util/TextRange;", "selectRangeForTooltipPrecalculation", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "getTargetOffset", "event", "intellij.rd.client"})
public final class FrontendLazyTooltipHighlightInfoRequester
implements EditorMouseMotionListener {
    public void mouseMoved(@NotNull EditorMouseEvent e) {
        block4: {
            MarkupModelEx model;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (Registry.Companion.is("ide.disable.editor.tooltips")) {
                return;
            }
            int offset = this.getTargetOffset(e);
            if (offset == -1) {
                return;
            }
            Editor editor = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            if (DocumentExKt.getTextControlId(editor) == null) {
                return;
            }
            Document document = e.getEditor().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document2, (Project)e.getEditor().getProject(), (boolean)false);
            MarkupModelEx markupModelEx = model = markupModel instanceof MarkupModelEx ? (MarkupModelEx)markupModel : null;
            if (markupModelEx != null) {
                this.startTooltipPrecalculation(markupModelEx, new TextRange(offset, offset));
            }
            Editor editor2 = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            TextRange range = this.selectRangeForTooltipPrecalculation(editor2, offset);
            MarkupModelEx markupModelEx2 = model;
            if (markupModelEx2 == null) break block4;
            this.startTooltipPrecalculation(markupModelEx2, range);
        }
    }

    private final void startTooltipPrecalculation(MarkupModelEx $this$startTooltipPrecalculation, TextRange range) {
        $this$startTooltipPrecalculation.processRangeHighlightersOverlappingWith(range.getStartOffset(), range.getEndOffset(), arg_0 -> FrontendLazyTooltipHighlightInfoRequester.startTooltipPrecalculation$lambda$1(FrontendLazyTooltipHighlightInfoRequester::startTooltipPrecalculation$lambda$0, arg_0));
    }

    private final TextRange selectRangeForTooltipPrecalculation(Editor editor, int offset) {
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(offset);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        LogicalPosition cursorLogicalPosition = logicalPosition;
        int firstLineToPrecalculate = Math.max(cursorLogicalPosition.line - 1, 0);
        int lastLineToPrecalculate = cursorLogicalPosition.line + 2;
        LogicalPosition startPosition = new LogicalPosition(firstLineToPrecalculate, 0);
        LogicalPosition endPosition = new LogicalPosition(lastLineToPrecalculate, 0);
        int startOffset = editor.logicalPositionToOffset(startPosition);
        int endOffset = editor.logicalPositionToOffset(endPosition);
        return new TextRange(startOffset, endOffset);
    }

    private final int getTargetOffset(EditorMouseEvent event) {
        Editor editor = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        Point point = event.getMouseEvent().getPoint();
        if (editor2 instanceof EditorEx && editor2.getProject() != null && event.getArea() == EditorMouseEventArea.EDITING_AREA && event.getMouseEvent().getModifiers() == 0 && EditorUtil.isPointOverText((Editor)editor2, (Point)point) && ((EditorEx)editor2).getFoldingModel().getFoldingPlaceholderAt(point) == null) {
            LogicalPosition logicalPosition = editor2.xyToLogicalPosition(point);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
            LogicalPosition logicalPosition2 = logicalPosition;
            return editor2.logicalPositionToOffset(logicalPosition2);
        }
        return -1;
    }

    private static final boolean startTooltipPrecalculation$lambda$0(RangeHighlighterEx marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        ProgressManager.checkCanceled();
        Object info2 = marker.getErrorStripeTooltip();
        if (info2 instanceof FrontendAsyncTooltipHighlightInfo && !(((FrontendAsyncTooltipHighlightInfo)((Object)info2)).getTooltipProvider() instanceof FrontendSynchronousTooltipProvider)) {
            ((FrontendAsyncTooltipHighlightInfo)((Object)info2)).calculateTooltip();
        }
        return true;
    }

    private static final boolean startTooltipPrecalculation$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

