/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.URLUtil;
import com.jetbrains.qodana.sarif.model.PropertyBag;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.VersionControlDetails;
import git4idea.GitCommit;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.EnvKt;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.sarif.GitReportContributorKt;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifReportContributor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/GitReportContributor;", "Lorg/jetbrains/qodana/staticAnalysis/sarif/SarifReportContributor;", "<init>", "()V", "contribute", "", "run", "Lcom/jetbrains/qodana/sarif/model/Run;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "getRemoteUrl", "Ljava/net/URI;", "name", "", "repository", "Lgit4idea/repo/GitRepository;", "convertScp", "url", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nGitReportContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitReportContributor.kt\norg/jetbrains/qodana/staticAnalysis/sarif/GitReportContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class GitReportContributor
implements SarifReportContributor {
    @Override
    public void contribute(@NotNull Run run2, @NotNull Project project, @NotNull QodanaConfig config) {
        String string;
        String string2;
        Map map2;
        PropertyBag it;
        PropertyBag propertyBag;
        String revision;
        URI remoteUrl;
        String branch;
        VirtualFile projectDir;
        block19: {
            String string3;
            block18: {
                String string4;
                String string5;
                Intrinsics.checkNotNullParameter((Object)run2, (String)"run");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
                if (virtualFile == null) {
                    return;
                }
                projectDir = virtualFile;
                GitRepository repository = (GitRepository)GitRepositoryManager.getInstance((Project)project).getRepositoryForFileQuick(projectDir);
                if (repository != null) {
                    GitReportContributorKt.access$getLOG$p().debug("Found git repository: " + repository);
                }
                if ((string5 = EnvKt.qodanaEnv().getQODANA_BRANCH().getValue()) == null) {
                    GitRepository gitRepository = repository;
                    string5 = gitRepository != null && (gitRepository = gitRepository.getCurrentBranch()) != null ? gitRepository.getName() : null;
                }
                if ((branch = string5) == null) {
                    GitReportContributorKt.access$getLOG$p().warn("Unable to find the branch name, please set the environment variable " + EnvKt.qodanaEnv().getQODANA_BRANCH().getKey());
                }
                GitReportContributorKt.access$getLOG$p().debug("Found git branch: " + branch);
                remoteUrl = this.getRemoteUrl(branch, repository);
                if (remoteUrl == null) {
                    GitReportContributorKt.access$getLOG$p().warn("Unable to find the remote url, please set the environment variable " + EnvKt.qodanaEnv().getQODANA_REMOTE_URL().getKey());
                }
                GitReportContributorKt.access$getLOG$p().debug("Found git remote url: " + remoteUrl);
                String string6 = EnvKt.qodanaEnv().getQODANA_REVISION().getValue();
                if (string6 == null) {
                    GitRepository gitRepository = repository;
                    string6 = gitRepository != null ? gitRepository.getCurrentRevision() : null;
                }
                if ((revision = string6) == null) {
                    GitReportContributorKt.access$getLOG$p().warn("Unable to find the revision, please set the environment variable " + EnvKt.qodanaEnv().getQODANA_REVISION().getKey());
                }
                GitReportContributorKt.access$getLOG$p().debug("Found git revision: " + revision);
                it = propertyBag = new PropertyBag();
                boolean bl = false;
                ((Map)it).put("vcsType", "Git");
                it = propertyBag;
                boolean bl2 = false;
                map2 = it;
                string2 = "repoUrl";
                string = EnvKt.qodanaEnv().getQODANA_REPO_URL().getValue();
                if (string == null) break block18;
                String url = string4 = string;
                boolean bl3 = false;
                string = StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null) ? string4 : null;
                if (string != null) break block19;
            }
            URI uRI = remoteUrl;
            String url = string3 = uRI != null ? uRI.toString() : null;
            boolean bl = false;
            string = url != null && StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null) ? string3 : null;
            if (string == null) {
                string = "";
            }
        }
        String string7 = string;
        map2.put(string2, string7);
        if (Intrinsics.areEqual((Object)it.get("repoUrl"), (Object)"")) {
            GitReportContributorKt.access$getLOG$p().warn("Unable to parse the repository url, please set the environment variable " + EnvKt.qodanaEnv().getQODANA_REPO_URL().getKey() + ", should start with https://");
        }
        PropertyBag properties = propertyBag;
        VersionControlDetails vcsDetails = new VersionControlDetails().withRepositoryUri(remoteUrl).withBranch(branch).withRevisionId(revision).withProperties(properties);
        try {
            if (revision != null) {
                String[] stringArray = GitHistoryUtils.formHashParameters((Project)project, (Collection)SetsKt.setOf((Object)revision));
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"formHashParameters(...)");
                String[] hashParameters = stringArray;
                List list2 = GitHistoryUtils.history((Project)project, (VirtualFile)projectDir, (String[])Arrays.copyOf(hashParameters, hashParameters.length));
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"history(...)");
                List gitCommits = list2;
                if (gitCommits.size() > 0) {
                    GitCommit commit = (GitCommit)gitCommits.get(0);
                    ((Map)properties).put("lastAuthorName", commit.getAuthor().getName());
                    ((Map)properties).put("lastAuthorEmail", commit.getAuthor().getEmail());
                }
            }
        }
        catch (Exception e) {
            GitReportContributorKt.access$getLOG$p().warn("Unable to obtain the author from VCS", (Throwable)e);
        }
        run2.setVersionControlProvenance(SetsKt.setOf((Object)vcsDetails));
    }

    private final URI getRemoteUrl(String name, GitRepository repository) {
        String url = EnvKt.qodanaEnv().getQODANA_REMOTE_URL().getValue();
        if (url == null) {
            if (name == null) {
                return null;
            }
            GitRepository gitRepository = repository;
            if (gitRepository == null || (gitRepository = gitRepository.getBranchTrackInfo(name)) == null) {
                return null;
            }
            GitRepository branchTrackInfo = gitRepository;
            String string = branchTrackInfo.getRemote().getFirstUrl();
            if (string == null) {
                return null;
            }
            url = string;
        }
        try {
            return URLUtil.containsScheme((String)url) ? new URI(url) : this.convertScp(url);
        }
        catch (URISyntaxException e) {
            GitReportContributorKt.access$getLOG$p().warn("Unable to create a URI from the extracted remote URL: " + url, (Throwable)e);
            return null;
        }
    }

    private final URI convertScp(String url) {
        URI uri = new URI("ssh://" + url);
        String string = uri.getAuthority();
        if (string == null) {
            return null;
        }
        String authority = string;
        String[] stringArray = new String[]{":"};
        List fields = StringsKt.split$default((CharSequence)authority, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (fields.size() != 2) {
            GitReportContributorKt.access$getLOG$p().warn("Can't parse authority in git origin uri '" + url + "'");
            return null;
        }
        String authAndHost = (String)fields.get(0);
        Object e = fields.get(1);
        String string2 = uri.getPath();
        if (string2 == null) {
            string2 = "";
        }
        String path = e + string2;
        return new URI("ssh://" + authAndHost + "/" + path);
    }
}

