/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.inspectionKts.api;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.inspectionKts.api.LocalInspection;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J3\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/qodana/inspectionKts/api/LocalInspectionImpl;", "Lorg/jetbrains/qodana/inspectionKts/api/LocalInspection;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "currentFile", "Lcom/intellij/psi/PsiFile;", "getCurrentFile", "()Lcom/intellij/psi/PsiFile;", "registerProblem", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "message", "", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "intellij.qodana"})
public final class LocalInspectionImpl
implements LocalInspection {
    @NotNull
    private final ProblemsHolder problemsHolder;

    public LocalInspectionImpl(@NotNull ProblemsHolder problemsHolder) {
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        this.problemsHolder = problemsHolder;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.problemsHolder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @Override
    @NotNull
    public PsiFile getCurrentFile() {
        PsiFile psiFile2 = this.problemsHolder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
        return psiFile2;
    }

    @Override
    public void registerProblem(@Nullable PsiElement psiElement, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PsiElement psiElement2 = psiElement;
        if (psiElement2 == null) {
            psiElement2 = (PsiElement)this.getCurrentFile();
        }
        this.problemsHolder.registerProblem(psiElement2, message, new LocalQuickFix[0]);
    }

    @Override
    public void registerProblem(@Nullable PsiElement psiElement, @NotNull String message, LocalQuickFix ... fixes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
        PsiElement psiElement2 = psiElement;
        if (psiElement2 == null) {
            psiElement2 = (PsiElement)this.getCurrentFile();
        }
        this.problemsHolder.registerProblem(psiElement2, message, Arrays.copyOf(fixes, fixes.length));
    }
}

