/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.CSSPrimitiveValue;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.parser.property.Conversions;
import com.openhtmltopdf.css.parser.property.PrimitivePropertyBuilders;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.List;

public class BorderPropertyBuilders {

    public static class Border
    extends BorderSidePropertyBuilder {
        @Override
        protected CSSName[][] getProperties() {
            return new CSSName[][]{{CSSName.BORDER_TOP_WIDTH, CSSName.BORDER_RIGHT_WIDTH, CSSName.BORDER_BOTTOM_WIDTH, CSSName.BORDER_LEFT_WIDTH}, {CSSName.BORDER_TOP_STYLE, CSSName.BORDER_RIGHT_STYLE, CSSName.BORDER_BOTTOM_STYLE, CSSName.BORDER_LEFT_STYLE}, {CSSName.BORDER_TOP_COLOR, CSSName.BORDER_RIGHT_COLOR, CSSName.BORDER_BOTTOM_COLOR, CSSName.BORDER_LEFT_COLOR}};
        }
    }

    public static class BorderLeft
    extends BorderSidePropertyBuilder {
        @Override
        protected CSSName[][] getProperties() {
            return new CSSName[][]{{CSSName.BORDER_LEFT_WIDTH}, {CSSName.BORDER_LEFT_STYLE}, {CSSName.BORDER_LEFT_COLOR}};
        }
    }

    public static class BorderBottom
    extends BorderSidePropertyBuilder {
        @Override
        protected CSSName[][] getProperties() {
            return new CSSName[][]{{CSSName.BORDER_BOTTOM_WIDTH}, {CSSName.BORDER_BOTTOM_STYLE}, {CSSName.BORDER_BOTTOM_COLOR}};
        }
    }

    public static class BorderRight
    extends BorderSidePropertyBuilder {
        @Override
        protected CSSName[][] getProperties() {
            return new CSSName[][]{{CSSName.BORDER_RIGHT_WIDTH}, {CSSName.BORDER_RIGHT_STYLE}, {CSSName.BORDER_RIGHT_COLOR}};
        }
    }

    public static class BorderTop
    extends BorderSidePropertyBuilder {
        @Override
        protected CSSName[][] getProperties() {
            return new CSSName[][]{{CSSName.BORDER_TOP_WIDTH}, {CSSName.BORDER_TOP_STYLE}, {CSSName.BORDER_TOP_COLOR}};
        }
    }

    private static abstract class BorderSidePropertyBuilder
    extends AbstractPropertyBuilder {
        private BorderSidePropertyBuilder() {
        }

        protected abstract CSSName[][] getProperties();

        private void addAll(List<PropertyDeclaration> result2, CSSName[] properties, CSSPrimitiveValue value2, int origin, boolean important) {
            for (int i = 0; i < properties.length; ++i) {
                result2.add(new PropertyDeclaration(properties[i], value2, important, origin));
            }
        }

        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            CSSName[][] props = this.getProperties();
            ArrayList<PropertyDeclaration> result2 = new ArrayList<PropertyDeclaration>(3);
            if (values.size() == 1 && ((CSSPrimitiveValue)values.get(0)).getCssValueType() == 0) {
                CSSPrimitiveValue value2 = values.get(0);
                this.addAll(result2, props[0], value2, origin, important);
                this.addAll(result2, props[1], value2, origin, important);
                this.addAll(result2, props[2], value2, origin, important);
                return result2;
            }
            this.checkValueCount(cssName, 1, 3, values.size());
            boolean haveBorderStyle = false;
            boolean haveBorderColor = false;
            boolean haveBorderWidth = false;
            for (CSSPrimitiveValue cSSPrimitiveValue : values) {
                CSSPrimitiveValue borderColor;
                this.checkInheritAllowed(cSSPrimitiveValue, false);
                boolean matched = false;
                CSSPrimitiveValue borderWidth = this.convertToBorderWidth(cSSPrimitiveValue);
                if (borderWidth != null) {
                    if (haveBorderWidth) {
                        throw new CSSParseException("A border width cannot be set twice", -1);
                    }
                    haveBorderWidth = true;
                    matched = true;
                    this.addAll(result2, props[0], borderWidth, origin, important);
                }
                if (this.isBorderStyle(cSSPrimitiveValue)) {
                    if (haveBorderStyle) {
                        throw new CSSParseException("A border style cannot be set twice", -1);
                    }
                    haveBorderStyle = true;
                    matched = true;
                    this.addAll(result2, props[1], cSSPrimitiveValue, origin, important);
                }
                if ((borderColor = this.convertToBorderColor(cSSPrimitiveValue)) != null) {
                    if (haveBorderColor) {
                        throw new CSSParseException("A border color cannot be set twice", -1);
                    }
                    haveBorderColor = true;
                    matched = true;
                    this.addAll(result2, props[2], borderColor, origin, important);
                }
                if (matched) continue;
                throw new CSSParseException(cSSPrimitiveValue.getCssText() + " is not a border width, style, or color", -1);
            }
            if (!haveBorderWidth) {
                this.addAll(result2, props[0], new PropertyValue(IdentValue.FS_INITIAL_VALUE), origin, important);
            }
            if (!haveBorderStyle) {
                this.addAll(result2, props[1], new PropertyValue(IdentValue.FS_INITIAL_VALUE), origin, important);
            }
            if (!haveBorderColor) {
                this.addAll(result2, props[2], new PropertyValue(IdentValue.FS_INITIAL_VALUE), origin, important);
            }
            return result2;
        }

        private boolean isBorderStyle(CSSPrimitiveValue value2) {
            if (value2.getPrimitiveType() != 21) {
                return false;
            }
            IdentValue ident = IdentValue.valueOf(value2.getCssText());
            if (ident == null) {
                return false;
            }
            return PrimitivePropertyBuilders.BORDER_STYLES.get(ident.FS_ID);
        }

        private CSSPrimitiveValue convertToBorderWidth(CSSPrimitiveValue value2) {
            short type2 = value2.getPrimitiveType();
            if (type2 != 21 && !this.isLength(value2)) {
                return null;
            }
            if (this.isLength(value2)) {
                return value2;
            }
            IdentValue ident = IdentValue.valueOf(value2.getStringValue());
            if (ident == null) {
                return null;
            }
            if (PrimitivePropertyBuilders.BORDER_WIDTHS.get(ident.FS_ID)) {
                return Conversions.getBorderWidth(ident.toString());
            }
            return null;
        }

        private CSSPrimitiveValue convertToBorderColor(CSSPrimitiveValue value2) {
            short type2 = value2.getPrimitiveType();
            if (type2 != 21 && type2 != 25) {
                return null;
            }
            if (type2 == 25) {
                return value2;
            }
            FSRGBColor color = Conversions.getColor(value2.getStringValue());
            if (color != null) {
                return new PropertyValue(color);
            }
            IdentValue ident = IdentValue.valueOf(value2.getCssText());
            if (ident == null || ident != IdentValue.TRANSPARENT) {
                return null;
            }
            return value2;
        }
    }
}

