/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.api.graphql;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.collaboration.api.graphql.GraphQLFileNotFoundException;
import com.intellij.collaboration.api.graphql.GraphQLQueryLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBr\u0012#\u0010\u0002\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J*\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002R+\u0010\u0002\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/collaboration/api/graphql/CachingGraphQLQueryLoader;", "Lcom/intellij/collaboration/api/graphql/GraphQLQueryLoader;", "getFileStream", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "relativePath", "Ljava/io/InputStream;", "fragmentsCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/collaboration/api/graphql/CachingGraphQLQueryLoader$Companion$Block;", "queriesCache", "fragmentsDirectories", "", "fragmentsFileExtension", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/ConcurrentMap;Ljava/util/concurrent/ConcurrentMap;Ljava/util/List;Ljava/lang/String;)V", "fragmentDefinitionRegex", "Lkotlin/text/Regex;", "loadQuery", "queryPath", "readFragmentsInto", "", "names", "", "into", "", "readBlock", "filePath", "Companion", "intellij.platform.collaborationTools"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCachingGraphQLQueryLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingGraphQLQueryLoader.kt\ncom/intellij/collaboration/api/graphql/CachingGraphQLQueryLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n774#2:96\n865#2,2:97\n*S KotlinDebug\n*F\n+ 1 CachingGraphQLQueryLoader.kt\ncom/intellij/collaboration/api/graphql/CachingGraphQLQueryLoader\n*L\n50#1:96\n50#1:97,2\n*E\n"})
public final class CachingGraphQLQueryLoader
implements GraphQLQueryLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, InputStream> getFileStream;
    @NotNull
    private final ConcurrentMap<String, Companion.Block> fragmentsCache;
    @NotNull
    private final ConcurrentMap<String, String> queriesCache;
    @NotNull
    private final List<String> fragmentsDirectories;
    @NotNull
    private final String fragmentsFileExtension;
    @NotNull
    private final Regex fragmentDefinitionRegex;

    public CachingGraphQLQueryLoader(@NotNull Function1<? super String, ? extends InputStream> getFileStream, @NotNull ConcurrentMap<String, Companion.Block> fragmentsCache, @NotNull ConcurrentMap<String, String> queriesCache, @NotNull List<String> fragmentsDirectories, @NotNull String fragmentsFileExtension) {
        Intrinsics.checkNotNullParameter(getFileStream, (String)"getFileStream");
        Intrinsics.checkNotNullParameter(fragmentsCache, (String)"fragmentsCache");
        Intrinsics.checkNotNullParameter(queriesCache, (String)"queriesCache");
        Intrinsics.checkNotNullParameter(fragmentsDirectories, (String)"fragmentsDirectories");
        Intrinsics.checkNotNullParameter((Object)fragmentsFileExtension, (String)"fragmentsFileExtension");
        this.getFileStream = getFileStream;
        this.fragmentsCache = fragmentsCache;
        this.queriesCache = queriesCache;
        this.fragmentsDirectories = fragmentsDirectories;
        this.fragmentsFileExtension = fragmentsFileExtension;
        this.fragmentDefinitionRegex = new Regex("fragment (.*) on .*\\{");
    }

    public /* synthetic */ CachingGraphQLQueryLoader(Function1 function1, ConcurrentMap concurrentMap, ConcurrentMap concurrentMap2, List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            concurrentMap = Companion.createFragmentCache();
        }
        if ((n & 4) != 0) {
            concurrentMap2 = Companion.createQueryCache();
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.listOf((Object)"graphql/fragment");
        }
        if ((n & 0x10) != 0) {
            string = "graphql";
        }
        this((Function1<? super String, ? extends InputStream>)function1, concurrentMap, concurrentMap2, list, string);
    }

    @Override
    @NotNull
    public String loadQuery(@NotNull String queryPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)queryPath, (String)"queryPath");
        String string = this.queriesCache.computeIfAbsent(queryPath, arg_0 -> CachingGraphQLQueryLoader.loadQuery$lambda$1(arg_0 -> CachingGraphQLQueryLoader.loadQuery$lambda$0(this, queryPath, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"computeIfAbsent(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void readFragmentsInto(Set<String> names, Map<String, Companion.Block> into) {
        for (String fragmentName : names) {
            void $this$filterTo$iv$iv;
            Object object;
            Object it2;
            block4: {
                for (Object it2 : (Iterable)this.fragmentsDirectories) {
                    boolean bl = false;
                    String path = (String)it2 + "/" + fragmentName + "." + this.fragmentsFileExtension;
                    if ((it2 = this.fragmentsCache.computeIfAbsent(path, arg_0 -> CachingGraphQLQueryLoader.readFragmentsInto$lambda$3$lambda$2((Function1)new Function1<String, Companion.Block>((Object)this){

                        public final Companion.Block invoke(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return CachingGraphQLQueryLoader.access$readBlock((CachingGraphQLQueryLoader)this.receiver, p0);
                        }
                    }, arg_0))) == null) continue;
                    object = it2;
                    break block4;
                }
                object = null;
            }
            if (object == null) {
                throw new GraphQLFileNotFoundException("Couldn't find file for fragment " + fragmentName);
            }
            Companion.Block fragment2 = object;
            into.put(fragmentName, fragment2);
            Iterable $this$filter$iv = fragment2.getDependencies();
            boolean $i$f$filter = false;
            it2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it3 = (String)element$iv$iv;
                boolean bl = false;
                if (!(!into.containsKey(it3))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set nonProcessedDependencies = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            this.readFragmentsInto(nonProcessedDependencies, into);
        }
    }

    private final Companion.Block readBlock(String filePath) {
        InputStream stream;
        StringBuilder bodyBuilder = new StringBuilder();
        Set fragments = new LinkedHashSet();
        Set innerFragments = new LinkedHashSet();
        InputStream inputStream = (InputStream)this.getFileStream.invoke((Object)filePath);
        if (inputStream == null) {
            return null;
        }
        InputStream inputStream2 = stream = inputStream;
        Charset charset = Charsets.UTF_8;
        TextStreamsKt.forEachLine((Reader)new InputStreamReader(inputStream2, charset), arg_0 -> CachingGraphQLQueryLoader.readBlock$lambda$5(bodyBuilder, this, innerFragments, fragments, arg_0));
        fragments.removeAll(innerFragments);
        String string = bodyBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new Companion.Block(StringsKt.removeSuffix((String)string, (CharSequence)"\n"), fragments);
    }

    private static final String loadQuery$lambda$0(CachingGraphQLQueryLoader this$0, String $queryPath, String path) {
        Intrinsics.checkNotNull((Object)path);
        Companion.Block block = this$0.readBlock(path);
        if (block == null) {
            throw new GraphQLFileNotFoundException("Couldn't find query file at " + $queryPath);
        }
        Companion.Block block2 = block;
        String body = block2.component1();
        Set<String> fragmentNames = block2.component2();
        StringBuilder builder = new StringBuilder();
        LinkedHashMap fragments = new LinkedHashMap();
        this$0.readFragmentsInto(fragmentNames, fragments);
        Collection collection = fragments.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        for (Object e : CollectionsKt.reversed((Iterable)collection)) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Companion.Block fragment2 = (Companion.Block)e;
            builder.append(fragment2.getBody()).append("\n");
        }
        builder.append(body);
        return builder.toString();
    }

    private static final String loadQuery$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Companion.Block readFragmentsInto$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        return (Companion.Block)$tmp0.invoke(p0);
    }

    private static final Unit readBlock$lambda$5(StringBuilder $bodyBuilder, CachingGraphQLQueryLoader this$0, Set $innerFragments, Set $fragments, String it) {
        String fragmentName;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String line = ((Object)StringsKt.trim((CharSequence)it)).toString();
        $bodyBuilder.append(line).append("\n");
        if (StringsKt.startsWith$default((String)line, (String)"fragment", (boolean)false, (int)2, null)) {
            Object object = this$0.fragmentDefinitionRegex.matchEntire((CharSequence)line);
            String string = object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : (fragmentName = null);
            if (fragmentName != null) {
                $innerFragments.add(fragmentName);
            }
        }
        if (StringsKt.startsWith$default((String)line, (String)"...", (boolean)false, (int)2, null) && line.length() > 3 && !CharsKt.isWhitespace((char)line.charAt(3))) {
            String string = line.substring(3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            fragmentName = string;
            $fragments.add(fragmentName);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Companion.Block access$readBlock(CachingGraphQLQueryLoader $this, String filePath) {
        return $this.readBlock(filePath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\tB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\n"}, d2={"Lcom/intellij/collaboration/api/graphql/CachingGraphQLQueryLoader$Companion;", "", "<init>", "()V", "createFragmentCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/intellij/collaboration/api/graphql/CachingGraphQLQueryLoader$Companion$Block;", "createQueryCache", "Block", "intellij.platform.collaborationTools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConcurrentMap<String, Block> createFragmentCache() {
            ConcurrentMap concurrentMap = Caffeine.newBuilder().expireAfterAccess(Duration.of(2L, ChronoUnit.MINUTES)).build().asMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"asMap(...)");
            return concurrentMap;
        }

        @NotNull
        public final ConcurrentMap<String, String> createQueryCache() {
            ConcurrentMap concurrentMap = Caffeine.newBuilder().expireAfterAccess(Duration.of(1L, ChronoUnit.MINUTES)).build().asMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"asMap(...)");
            return concurrentMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/collaboration/api/graphql/CachingGraphQLQueryLoader$Companion$Block;", "", "body", "", "dependencies", "", "<init>", "(Ljava/lang/String;Ljava/util/Set;)V", "getBody", "()Ljava/lang/String;", "getDependencies", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.collaborationTools"})
        public static final class Block {
            @NotNull
            private final String body;
            @NotNull
            private final Set<String> dependencies;

            public Block(@NotNull String body, @NotNull Set<String> dependencies) {
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
                this.body = body;
                this.dependencies = dependencies;
            }

            @NotNull
            public final String getBody() {
                return this.body;
            }

            @NotNull
            public final Set<String> getDependencies() {
                return this.dependencies;
            }

            @NotNull
            public final String component1() {
                return this.body;
            }

            @NotNull
            public final Set<String> component2() {
                return this.dependencies;
            }

            @NotNull
            public final Block copy(@NotNull String body, @NotNull Set<String> dependencies) {
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
                return new Block(body, dependencies);
            }

            public static /* synthetic */ Block copy$default(Block block, String string, Set set, int n, Object object) {
                if ((n & 1) != 0) {
                    string = block.body;
                }
                if ((n & 2) != 0) {
                    set = block.dependencies;
                }
                return block.copy(string, set);
            }

            @NotNull
            public String toString() {
                return "Block(body=" + this.body + ", dependencies=" + this.dependencies + ")";
            }

            public int hashCode() {
                int result = this.body.hashCode();
                result = result * 31 + ((Object)this.dependencies).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Block)) {
                    return false;
                }
                Block block = (Block)other;
                if (!Intrinsics.areEqual((Object)this.body, (Object)block.body)) {
                    return false;
                }
                return Intrinsics.areEqual(this.dependencies, block.dependencies);
            }
        }
    }
}

