/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.ui.BlockSeparatorRenderer;
import org.jetbrains.plugins.terminal.block.ui.GradientTextureCache;
import org.jetbrains.plugins.terminal.block.ui.TerminalBlockBackgroundRendererKt;
import org.jetbrains.plugins.terminal.block.ui.TerminalUi;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B3\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000bB'\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\fJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/terminal/block/ui/TerminalBlockCornersRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "backgroundKey", "Lcom/intellij/openapi/editor/colors/ColorKey;", "gradientCache", "Lorg/jetbrains/plugins/terminal/block/ui/GradientTextureCache;", "strokeBackgroundKey", "strokeWidth", "", "<init>", "(Lcom/intellij/openapi/editor/colors/ColorKey;Lorg/jetbrains/plugins/terminal/block/ui/GradientTextureCache;Lcom/intellij/openapi/editor/colors/ColorKey;I)V", "(Lcom/intellij/openapi/editor/colors/ColorKey;Lcom/intellij/openapi/editor/colors/ColorKey;I)V", "(Lorg/jetbrains/plugins/terminal/block/ui/GradientTextureCache;Lcom/intellij/openapi/editor/colors/ColorKey;I)V", "separatorRenderer", "Lorg/jetbrains/plugins/terminal/block/ui/BlockSeparatorRenderer;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalBlockCornersRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalBlockCornersRenderer.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalBlockCornersRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public final class TerminalBlockCornersRenderer
implements CustomHighlighterRenderer {
    @Nullable
    private final ColorKey backgroundKey;
    @Nullable
    private final GradientTextureCache gradientCache;
    @Nullable
    private final ColorKey strokeBackgroundKey;
    private final int strokeWidth;
    @NotNull
    private final BlockSeparatorRenderer separatorRenderer;

    private TerminalBlockCornersRenderer(ColorKey backgroundKey, GradientTextureCache gradientCache, ColorKey strokeBackgroundKey, int strokeWidth) {
        this.backgroundKey = backgroundKey;
        this.gradientCache = gradientCache;
        this.strokeBackgroundKey = strokeBackgroundKey;
        this.strokeWidth = strokeWidth;
        this.separatorRenderer = new BlockSeparatorRenderer();
    }

    /* synthetic */ TerminalBlockCornersRenderer(ColorKey colorKey, GradientTextureCache gradientTextureCache, ColorKey colorKey2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            colorKey2 = null;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(colorKey, gradientTextureCache, colorKey2, n);
    }

    public TerminalBlockCornersRenderer(@NotNull ColorKey backgroundKey, @Nullable ColorKey strokeBackgroundKey, int strokeWidth) {
        Intrinsics.checkNotNullParameter((Object)backgroundKey, (String)"backgroundKey");
        this(backgroundKey, null, strokeBackgroundKey, strokeWidth);
    }

    public /* synthetic */ TerminalBlockCornersRenderer(ColorKey colorKey, ColorKey colorKey2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            colorKey2 = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(colorKey, colorKey2, n);
    }

    public TerminalBlockCornersRenderer(@NotNull GradientTextureCache gradientCache, @Nullable ColorKey strokeBackgroundKey, int strokeWidth) {
        Intrinsics.checkNotNullParameter((Object)gradientCache, (String)"gradientCache");
        this(null, gradientCache, strokeBackgroundKey, strokeWidth);
    }

    public /* synthetic */ TerminalBlockCornersRenderer(GradientTextureCache gradientTextureCache, ColorKey colorKey, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            colorKey = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(gradientTextureCache, colorKey, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        Path2D.Float float_;
        Color strokeBackground;
        Path2D.Float float_2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        float topIns = TerminalUiUtils.INSTANCE.toFloatAndScale(6);
        float bottomIns = TerminalUiUtils.INSTANCE.toFloatAndScale(6);
        float cornerToBlock = JBUI.scale((int)10);
        float gap = TerminalUiUtils.INSTANCE.toFloatAndScale(0);
        float arc = TerminalUiUtils.INSTANCE.toFloatAndScale(8);
        int selectionGap = JBUI.scale((int)1);
        Rectangle rectangle = editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        float width = (float)visibleArea.width - cornerToBlock;
        float topY = (float)editor.offsetToXY((int)highlighter.getStartOffset()).y - topIns + (float)selectionGap;
        float bottomY = (float)(editor.offsetToXY((int)highlighter.getEndOffset()).y + editor.getLineHeight()) + bottomIns - (float)selectionGap;
        Rectangle2D.Float topRect = new Rectangle2D.Float(0.0f, topY, width, topIns);
        Rectangle2D.Float bottomRect = new Rectangle2D.Float(0.0f, bottomY - bottomIns, width, bottomIns + gap);
        Path2D.Float $this$paint_u24lambda_u240 = float_2 = new Path2D.Float(0);
        boolean bl = false;
        $this$paint_u24lambda_u240.moveTo(0.0f, topY);
        $this$paint_u24lambda_u240.lineTo(width - arc, topY);
        $this$paint_u24lambda_u240.quadTo(width, topY, width, topY + arc);
        $this$paint_u24lambda_u240.lineTo(width, topY + topIns);
        $this$paint_u24lambda_u240.lineTo(0.0f, topY + topIns);
        $this$paint_u24lambda_u240.lineTo(0.0f, topY);
        $this$paint_u24lambda_u240.closePath();
        Path2D.Float topCornerPath = float_2;
        Path2D.Float $this$paint_u24lambda_u241 = $this$paint_u24lambda_u240 = new Path2D.Float(0);
        boolean bl2 = false;
        $this$paint_u24lambda_u241.moveTo(0.0f, bottomY - bottomIns);
        $this$paint_u24lambda_u241.lineTo(width, bottomY - bottomIns);
        $this$paint_u24lambda_u241.lineTo(width, bottomY - arc);
        $this$paint_u24lambda_u241.quadTo(width, bottomY, width - arc, bottomY);
        $this$paint_u24lambda_u241.lineTo(0.0f, bottomY);
        $this$paint_u24lambda_u241.lineTo(0.0f, bottomY - bottomIns);
        $this$paint_u24lambda_u241.closePath();
        Path2D.Float bottomCornerPath = $this$paint_u24lambda_u240;
        ColorKey it = bl2 = this.strokeBackgroundKey;
        boolean bl3 = false;
        Object object = this.strokeWidth > 0 ? bl2 : null;
        if (object != null) {
            it = object;
            boolean bl4 = false;
            v2 = editor.getColorsScheme().getColor(it);
        } else {
            v2 = strokeBackground = null;
        }
        if (strokeBackground != null) {
            Path2D.Float bl4;
            float stroke = TerminalUiUtils.INSTANCE.toFloatAndScale(this.strokeWidth);
            Path2D.Float $this$paint_u24lambda_u244 = bl4 = new Path2D.Float(0);
            boolean bl5 = false;
            $this$paint_u24lambda_u244.moveTo(0.0f, topY);
            $this$paint_u24lambda_u244.lineTo(width - arc, topY);
            $this$paint_u24lambda_u244.quadTo(width, topY, width, topY + arc);
            $this$paint_u24lambda_u244.lineTo(width, bottomY - arc);
            $this$paint_u24lambda_u244.quadTo(width, bottomY, width - arc, bottomY);
            $this$paint_u24lambda_u244.lineTo(0.0f, bottomY);
            Path2D.Float outerPath = bl4;
            Path2D.Float $this$paint_u24lambda_u245 = $this$paint_u24lambda_u244 = new Path2D.Float(0);
            boolean bl6 = false;
            $this$paint_u24lambda_u245.moveTo(0.0f, topY + stroke);
            $this$paint_u24lambda_u245.lineTo(width - arc, topY + stroke);
            $this$paint_u24lambda_u245.quadTo(width - stroke, topY + stroke, width - stroke, topY + arc);
            $this$paint_u24lambda_u245.lineTo(width - stroke, bottomY - arc);
            $this$paint_u24lambda_u245.quadTo(width - stroke, bottomY - stroke, width - arc, bottomY - stroke);
            $this$paint_u24lambda_u245.lineTo(0.0f, bottomY - stroke);
            Path2D.Float innerPath = $this$paint_u24lambda_u244;
            Path2D.Float $this$paint_u24lambda_u246 = $this$paint_u24lambda_u244 = new Path2D.Float(0);
            boolean bl7 = false;
            $this$paint_u24lambda_u246.append(outerPath, false);
            $this$paint_u24lambda_u246.append(innerPath, false);
            $this$paint_u24lambda_u246.moveTo(0.0f, topY);
            $this$paint_u24lambda_u246.lineTo(0.0f, topY + stroke);
            $this$paint_u24lambda_u246.moveTo(0.0f, bottomY - stroke);
            $this$paint_u24lambda_u246.lineTo(0.0f, bottomY);
            $this$paint_u24lambda_u246.closePath();
            float_ = $this$paint_u24lambda_u244;
        } else {
            float_ = null;
        }
        Path2D.Float strokePath = float_;
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        try {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor((Color)TerminalUi.INSTANCE.defaultBackground(editor));
            g2d.fill(topRect);
            g2d.fill(bottomRect);
            Paint paint = TerminalBlockBackgroundRendererKt.getBlockBackgroundPaint(editor, g2d, (int)width, this.gradientCache, this.backgroundKey);
            if (paint != null) {
                Paint it2 = paint;
                boolean bl8 = false;
                g2d.setPaint(it2);
                g2d.fill(topCornerPath);
                g2d.fill(bottomCornerPath);
            }
            if (strokePath != null) {
                g2d.setPaint(strokeBackground);
                g2d.fill(strokePath);
            }
        }
        finally {
            g2d.dispose();
        }
        this.separatorRenderer.paint(editor, highlighter, g);
    }
}

