/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.tasks.js;

import com.google.protobuf.ProtocolStringList;
import io.bazel.kotlin.builder.tasks.js.Kotlin2JsTaskExecutor;
import io.bazel.kotlin.builder.toolchain.CompilationException;
import io.bazel.kotlin.builder.toolchain.CompilationTaskContext;
import io.bazel.kotlin.builder.toolchain.KotlinToolchain;
import io.bazel.kotlin.builder.utils.MiscUtilsKt;
import io.bazel.kotlin.builder.utils.jars.JarCreator;
import io.bazel.kotlin.builder.utils.jars.SourceJarCreator;
import io.bazel.kotlin.model.JsCompilationTask;
import java.io.Closeable;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u000e*\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000f\u001a\u00020\b*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\f\u0010\u0011\u001a\u00020\b*\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/bazel/kotlin/builder/tasks/js/Kotlin2JsTaskExecutor;", "", "invoker", "Lio/bazel/kotlin/builder/toolchain/KotlinToolchain$K2JSCompilerInvoker;", "(Lio/bazel/kotlin/builder/toolchain/KotlinToolchain$K2JSCompilerInvoker;)V", "fileSystem", "Ljava/nio/file/FileSystem;", "execute", "", "context", "Lio/bazel/kotlin/builder/toolchain/CompilationTaskContext;", "task", "Lio/bazel/kotlin/model/JsCompilationTask;", "compile", "Ljava/nio/file/Path;", "createJar", "jsDirectoryPath", "createSourceJar", "src_main_kotlin_io_bazel_kotlin_builder_tasks-tasks"})
public final class Kotlin2JsTaskExecutor {
    @NotNull
    private final KotlinToolchain.K2JSCompilerInvoker invoker;
    @NotNull
    private final FileSystem fileSystem;

    @Inject
    public Kotlin2JsTaskExecutor(@NotNull KotlinToolchain.K2JSCompilerInvoker invoker) {
        Intrinsics.checkNotNullParameter(invoker, "invoker");
        this.invoker = invoker;
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkNotNullExpressionValue(fileSystem, "getDefault()");
        this.fileSystem = fileSystem;
    }

    public final void execute(@NotNull CompilationTaskContext context, @NotNull JsCompilationTask task) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(task, "task");
        Path outputDirectory = this.compile(task, context);
        this.createJar(task, outputDirectory);
        this.createSourceJar(task);
    }

    /*
     * WARNING - void declaration
     */
    private final Path compile(JsCompilationTask $this$compile, CompilationTaskContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection<String> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        List list;
        Path jsOut = this.fileSystem.getPath($this$compile.getOutputs().getJs(), new String[0]);
        Path outputDirectory = jsOut.getParent();
        Path path = jsOut.getFileName();
        Intrinsics.checkNotNullExpressionValue(path, "jsOut.fileName");
        String baseName = PathsKt.getNameWithoutExtension(path);
        Path mapOut = outputDirectory.resolve(baseName + ".js.map");
        Path workingDirectory = this.fileSystem.getPath($this$compile.getDirectories().getTemp(), new String[0]);
        Path path2 = this.fileSystem.getPath(".", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "fileSystem.getPath(\".\")");
        Path path3 = path2.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(path3, "toAbsolutePath()");
        Path execRoot = path3;
        List $this$compile_u24lambda_u242 = list = (List)new ArrayList();
        boolean bl = false;
        ProtocolStringList protocolStringList = $this$compile.getPassThroughFlagsList();
        Intrinsics.checkNotNullExpressionValue(protocolStringList, "passThroughFlagsList");
        $this$compile_u24lambda_u242.addAll(protocolStringList);
        $this$compile_u24lambda_u242.add("-Xdisable-default-scripting-plugin");
        $this$compile_u24lambda_u242.add("-Xir-produce-js");
        $this$compile_u24lambda_u242.add("-progressive");
        $this$compile_u24lambda_u242.add("-Xoptimize-generated-js=false");
        Collection collection2 = $this$compile_u24lambda_u242;
        Object object = new String[2];
        object[0] = "-libraries";
        ProtocolStringList protocolStringList2 = $this$compile.getInputs().getLibrariesList();
        Intrinsics.checkNotNullExpressionValue(protocolStringList2, "inputs.librariesList");
        Iterable iterable = protocolStringList2;
        int n = 1;
        Object object2 = object;
        Collection collection3 = collection2;
        boolean $i$f$map22 = false;
        void var19_20 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl2 = false;
            Path path4 = execRoot.resolve((String)it);
            Intrinsics.checkNotNullExpressionValue(path4, "execRoot\n               \u2026  it,\n                  )");
            collection.add(((Object)path4.toAbsolutePath()).toString());
        }
        collection = (List)destination$iv$iv;
        object2[n] = CollectionsKt.joinToString$default(collection, ":", null, null, 0, null, null, 62, null);
        MiscUtilsKt.addAll(collection3, object);
        object = new String[]{"-ir-output-name", baseName};
        MiscUtilsKt.addAll((Collection)$this$compile_u24lambda_u242, object);
        object = new String[]{"-ir-output-dir", ((Object)workingDirectory).toString()};
        MiscUtilsKt.addAll((Collection)$this$compile_u24lambda_u242, object);
        object = new String[]{"-Xir-module-name=" + $this$compile.getInfo().getModuleName()};
        MiscUtilsKt.addAll((Collection)$this$compile_u24lambda_u242, object);
        ProtocolStringList protocolStringList3 = $this$compile.getInputs().getKotlinSourcesList();
        Intrinsics.checkNotNullExpressionValue(protocolStringList3, "inputs.kotlinSourcesList");
        object = protocolStringList3;
        collection3 = $this$compile_u24lambda_u242;
        boolean $i$f$map = false;
        void $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (String)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl3 = false;
            Path path5 = execRoot.resolve((String)it);
            Intrinsics.checkNotNullExpressionValue(path5, "execRoot.resolve(it)");
            object2.add(((Object)path5.toAbsolutePath()).toString());
        }
        collection3.addAll((List)destination$iv$iv2);
        List args2 = list;
        context.whenTracing((Function1)new Function1<CompilationTaskContext, Unit>((List<String>)args2){
            final /* synthetic */ List<String> $args;
            {
                this.$args = $args;
                super(1);
            }

            public final void invoke(@NotNull CompilationTaskContext $this$whenTracing) {
                Intrinsics.checkNotNullParameter($this$whenTracing, "$this$whenTracing");
                CompilationTaskContext.printLines$default($this$whenTracing, "js compile args", this.$args, null, false, 12, null);
            }
        });
        CompilationTaskContext.executeCompilerTask$default(context, args2, new Function2<String[], PrintStream, Integer>((Object)this.invoker){

            @NotNull
            public final Integer invoke(@NotNull String[] p0, @NotNull PrintStream p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                return ((KotlinToolchain.K2JSCompilerInvoker)this.receiver).compile(p0, p1);
            }
        }, false, false, 12, null);
        context.whenTracing((Function1)new Function1<CompilationTaskContext, Unit>(outputDirectory){
            final /* synthetic */ Path $outputDirectory;
            {
                this.$outputDirectory = $outputDirectory;
                super(1);
            }

            public final void invoke(@NotNull CompilationTaskContext $this$whenTracing) {
                Intrinsics.checkNotNullParameter($this$whenTracing, "$this$whenTracing");
                List<T> list = Files.walk(this.$outputDirectory, new FileVisitOption[0]).map((Function)compile.1.INSTANCE).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list, "walk(outputDirectory).ma\u2026lect(Collectors.toList())");
                CompilationTaskContext.printLines$default($this$whenTracing, "outputs", list, null, false, 12, null);
            }
        });
        Files.copy(workingDirectory.resolve(jsOut.getFileName()), jsOut, new CopyOption[0]);
        Files.copy(workingDirectory.resolve(mapOut.getFileName()), mapOut, new CopyOption[0]);
        Intrinsics.checkNotNullExpressionValue(workingDirectory, "workingDirectory");
        return workingDirectory;
    }

    /*
     * WARNING - void declaration
     */
    private final void createSourceJar(JsCompilationTask $this$createSourceJar) {
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            SourceJarCreator sourceJarCreator;
            Path path = this.fileSystem.getPath($this$createSourceJar.getOutputs().getSrcjar(), new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "fileSystem.getPath(outputs.srcjar)");
            SourceJarCreator creator = sourceJarCreator = new SourceJarCreator(path, false);
            boolean bl = false;
            ProtocolStringList protocolStringList = $this$createSourceJar.getInputs().getKotlinSourcesList();
            Intrinsics.checkNotNullExpressionValue(protocolStringList, "inputs.kotlinSourcesList");
            Iterable iterable = protocolStringList;
            SourceJarCreator sourceJarCreator2 = creator;
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.fileSystem.getPath((String)it, new String[0]));
            }
            Stream<Path> stream = ((List)destination$iv$iv).stream();
            Intrinsics.checkNotNullExpressionValue(stream, "inputs.kotlinSourcesList\u2026em.getPath(it) }.stream()");
            sourceJarCreator2.addSources(stream);
            sourceJarCreator.execute();
        }
        catch (Throwable ex) {
            throw new CompilationException("could not create source jar", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createJar(JsCompilationTask $this$createJar, Path jsDirectoryPath) {
        try {
            Path path = this.fileSystem.getPath($this$createJar.getOutputs().getJar(), new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "fileSystem.getPath(outputs.jar)");
            Closeable closeable = new JarCreator(path, false, false, 6, null);
            Throwable throwable = null;
            try {
                JarCreator creator = (JarCreator)closeable;
                boolean bl = false;
                creator.addDirectory(jsDirectoryPath);
                creator.execute();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Throwable ex) {
            throw new CompilationException("error creating js jar", ex);
        }
    }
}

