/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.comments;

import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.comments.LineComment;
import java.util.LinkedList;
import java.util.List;

public class CommentsCollection {
    private List<LineComment> lineComments = new LinkedList<LineComment>();
    private List<BlockComment> blockComments = new LinkedList<BlockComment>();
    private List<JavadocComment> javadocComments = new LinkedList<JavadocComment>();

    public List<LineComment> getLineComments() {
        return this.lineComments;
    }

    public List<BlockComment> getBlockComments() {
        return this.blockComments;
    }

    public List<JavadocComment> getJavadocComments() {
        return this.javadocComments;
    }

    public void addComment(LineComment lineComment) {
        this.lineComments.add(lineComment);
    }

    public void addComment(BlockComment blockComment) {
        this.blockComments.add(blockComment);
    }

    public void addComment(JavadocComment javadocComment) {
        this.javadocComments.add(javadocComment);
    }

    public boolean contains(Comment comment) {
        for (Comment c : this.getAll()) {
            if (c.getBegin().line != comment.getBegin().line || c.getBegin().column != comment.getBegin().column || c.getEnd().line != comment.getEnd().line || Math.abs(c.getEnd().column - comment.getEnd().column) >= 2) continue;
            return true;
        }
        return false;
    }

    public List<Comment> getAll() {
        LinkedList<Comment> comments = new LinkedList<Comment>();
        comments.addAll(this.lineComments);
        comments.addAll(this.blockComments);
        comments.addAll(this.javadocComments);
        return comments;
    }

    public int size() {
        return this.lineComments.size() + this.blockComments.size() + this.javadocComments.size();
    }

    public CommentsCollection minus(CommentsCollection other) {
        CommentsCollection result = new CommentsCollection();
        for (LineComment lineComment : this.lineComments) {
            if (other.contains(lineComment)) continue;
            result.lineComments.add(lineComment);
        }
        for (BlockComment blockComment : this.blockComments) {
            if (other.contains(blockComment)) continue;
            result.blockComments.add(blockComment);
        }
        for (JavadocComment javadocComment : this.javadocComments) {
            if (other.contains(javadocComment)) continue;
            result.javadocComments.add(javadocComment);
        }
        return result;
    }
}

