/*
 * Decompiled with CFR 0.152.
 */
package io.spring.githubchangeloggenerator;

import io.spring.githubchangeloggenerator.ApplicationProperties;
import io.spring.githubchangeloggenerator.ChangelogSection;
import io.spring.githubchangeloggenerator.github.payload.Issue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
class ChangelogSections {
    private static final List<ChangelogSection> DEFAULT_SECTIONS;
    private final List<ChangelogSection> sections;

    private static void add(List<ChangelogSection> sections, String title, String ... labels) {
        sections.add(new ChangelogSection(title, null, null, labels));
    }

    ChangelogSections(ApplicationProperties properties) {
        this.sections = this.adapt(properties.getSections());
    }

    private List<ChangelogSection> adapt(List<ApplicationProperties.Section> propertySections) {
        if (CollectionUtils.isEmpty(propertySections)) {
            return DEFAULT_SECTIONS;
        }
        return propertySections.stream().map(arg_0 -> this.adapt(arg_0)).collect(Collectors.toList());
    }

    private ChangelogSection adapt(ApplicationProperties.Section propertySection) {
        return new ChangelogSection(propertySection.getTitle(), propertySection.getGroup(), propertySection.getSort(), propertySection.getLabels());
    }

    Map<ChangelogSection, List<Issue>> collate(List<Issue> issues) {
        return this.collate(issues, false);
    }

    Map<ChangelogSection, List<Issue>> collate(List<Issue> issues, boolean includeWildcardSection) {
        TreeMap<ChangelogSection, List<Issue>> collated = new TreeMap<ChangelogSection, List<Issue>>(Comparator.comparing(this.sections::indexOf));
        for (Issue issue : issues) {
            List sections = this.getSections(issue, includeWildcardSection);
            for (ChangelogSection section : sections) {
                collated.computeIfAbsent(section, key -> new ArrayList());
                ((List)collated.get(section)).add(issue);
            }
        }
        return collated;
    }

    private List<ChangelogSection> getSections(Issue issue) {
        return this.getSections(issue, false);
    }

    private List<ChangelogSection> getSections(Issue issue, boolean includeWildcardSection) {
        ArrayList<ChangelogSection> result = new ArrayList<ChangelogSection>();
        HashSet<String> groupClaimes = new HashSet<String>();
        for (ChangelogSection section : this.sections) {
            if (!section.isMatchFor(issue, includeWildcardSection) || !groupClaimes.add(section.getGroup())) continue;
            result.add(section);
        }
        return result;
    }

    static {
        ArrayList sections = new ArrayList();
        ChangelogSections.add(sections, (String)":star: New Features", (String[])new String[]{"enhancement"});
        ChangelogSections.add(sections, (String)":beetle: Bug Fixes", (String[])new String[]{"bug", "regression"});
        ChangelogSections.add(sections, (String)":notebook_with_decorative_cover: Documentation", (String[])new String[]{"documentation"});
        ChangelogSections.add(sections, (String)":hammer: Dependency Upgrades", (String[])new String[]{"dependency-upgrade"});
        DEFAULT_SECTIONS = Collections.unmodifiableList(sections);
    }
}

