/*
 * Decompiled with CFR 0.152.
 */
package io.spring.githubchangeloggenerator;

import io.spring.githubchangeloggenerator.ApplicationProperties;
import io.spring.githubchangeloggenerator.MilestoneReference;
import io.spring.githubchangeloggenerator.github.service.Repository;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.bind.DefaultValue;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="changelog")
@ConstructorBinding
public class ApplicationProperties {
    private final Repository repository;
    private final MilestoneReference milestoneReference;
    private final String defaultTitlePrefix;
    private final String bulletStyle;
    private final List<Section> sections;
    private final boolean includeWildcardSection;
    private final Issues issues;
    private final Contributors contributors;
    private final List<ExternalLink> externalLinks;
    private final boolean wrapIssueLinkInBrackets;
    private final boolean includeIssueOrPrPrefix;
    private final boolean includePrAuthor;
    private final boolean excludeIssues;
    private final boolean excludePullRequests;

    public ApplicationProperties(Repository repository, @DefaultValue(value={"title"}) MilestoneReference milestoneReference, @DefaultValue(value={"## "}) String defaultTitlePrefix, @DefaultValue(value={"- "}) String bulletStyle, Boolean excludeIssues, Boolean excludePullRequests, Boolean wrapIssueLinkInBrackets, Boolean includeIssueOrPrPrefix, Boolean includePrAuthor, List<Section> sections, Boolean includeWildcardSection, Issues issues, Contributors contributors, List<ExternalLink> externalLinks) {
        Assert.notNull((Object)repository, (String)"Repository must not be null");
        this.repository = repository;
        this.milestoneReference = milestoneReference;
        this.defaultTitlePrefix = defaultTitlePrefix;
        this.bulletStyle = bulletStyle;
        this.wrapIssueLinkInBrackets = wrapIssueLinkInBrackets != null ? wrapIssueLinkInBrackets : false;
        this.includeIssueOrPrPrefix = includeIssueOrPrPrefix != null ? includeIssueOrPrPrefix : false;
        this.includePrAuthor = includePrAuthor != null ? includePrAuthor : false;
        this.excludeIssues = excludeIssues != null ? excludeIssues : false;
        this.excludePullRequests = excludePullRequests != null ? excludePullRequests : false;
        this.sections = sections != null ? sections : Collections.emptyList();
        this.includeWildcardSection = includeWildcardSection != null ? includeWildcardSection : false;
        this.issues = issues != null ? issues : new Issues(null, null, null);
        this.contributors = contributors != null ? contributors : new Contributors(null, null, null);
        this.externalLinks = externalLinks != null ? externalLinks : Collections.emptyList();
    }

    public Repository getRepository() {
        return this.repository;
    }

    public MilestoneReference getMilestoneReference() {
        return this.milestoneReference;
    }

    public String getDefaultTitlePrefix() {
        return this.defaultTitlePrefix;
    }

    public String getBulletStyle() {
        return this.bulletStyle;
    }

    public boolean getWrapIssueLinkInBrackets() {
        return this.wrapIssueLinkInBrackets;
    }

    public boolean getIncludeIssueOrPrPrefix() {
        return this.includeIssueOrPrPrefix;
    }

    public boolean getIncludePrAuthor() {
        return this.includePrAuthor;
    }

    public boolean getExcludeIssues() {
        return this.excludeIssues;
    }

    public boolean getExcludePullRequests() {
        return this.excludePullRequests;
    }

    public boolean getIncludeWildcardSection() {
        return this.includeWildcardSection;
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public Issues getIssues() {
        return this.issues;
    }

    public Contributors getContributors() {
        return this.contributors;
    }

    public List<ExternalLink> getExternalLinks() {
        return this.externalLinks;
    }
}

