# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_pkgcruft_global_optspecs
	string join \n v/verbose q/quiet color= h/help V/version
end

function __fish_pkgcruft_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_pkgcruft_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_pkgcruft_using_subcommand
	set -l cmd (__fish_pkgcruft_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c pkgcruft -n "__fish_pkgcruft_needs_command" -l color -d 'enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pkgcruft -n "__fish_pkgcruft_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_needs_command" -s h -l help -d 'Print help'
complete -c pkgcruft -n "__fish_pkgcruft_needs_command" -s V -l version -d 'Print version'
complete -c pkgcruft -n "__fish_pkgcruft_needs_command" -f -a "completion" -d 'Generate shell completion'
complete -c pkgcruft -n "__fish_pkgcruft_needs_command" -f -a "diff" -d 'Compare reports'
complete -c pkgcruft -n "__fish_pkgcruft_needs_command" -f -a "ignore" -d 'Show ignore information'
complete -c pkgcruft -n "__fish_pkgcruft_needs_command" -f -a "replay" -d 'Replay reports'
complete -c pkgcruft -n "__fish_pkgcruft_needs_command" -f -a "scan" -d 'Scan for QA issues'
complete -c pkgcruft -n "__fish_pkgcruft_needs_command" -f -a "show" -d 'Show various information'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand completion" -s d -l dir -d 'Target directory for completion files' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand completion" -l color -d 'enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand completion" -s v -l verbose -d 'Increase logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand completion" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand completion" -s h -l help -d 'Print help'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand diff" -s r -l reports -d 'Restrict by report target' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand diff" -s p -l pkgs -d 'Package restrictions' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand diff" -l color -d 'enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand diff" -s s -l sort -d 'Sort reports'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand diff" -s v -l verbose -d 'Increase logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand diff" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand diff" -s h -l help -d 'Print help'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand ignore" -l repo -d 'Target repo' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand ignore" -l color -d 'enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand ignore" -s v -l verbose -d 'Increase logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand ignore" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand ignore" -s h -l help -d 'Print help'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand replay" -s r -l reports -d 'Restrict by report target' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand replay" -s p -l pkgs -d 'Package restrictions' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand replay" -s S -l scopes -d 'Restrict by scope' -r -f -a "version\t''
package\t''
category\t''
repo\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand replay" -s R -l reporter -d 'Reporter to use' -r -f -a "count\t''
fancy\t''
format\t''
json\t''
null\t''
simple\t''
stats\t''
time\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand replay" -l format -d 'Format string for the format reporter' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand replay" -l stats -d 'Sorting variant for the stats reporter' -r -f -a "name\t''
count\t''
level\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand replay" -l color -d 'enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand replay" -s s -l sort -d 'Sort reports'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand replay" -s v -l verbose -d 'Increase logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand replay" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand replay" -s h -l help -d 'Print help'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -s f -l filters -d 'Enable package filtering' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -s j -l jobs -d 'Parallel jobs to run' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -l exit -d 'Exit status triggers' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -l repo -d 'Target repo' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -s R -l reporter -d 'Reporter to use' -r -f -a "count\t''
fancy\t''
format\t''
json\t''
null\t''
simple\t''
stats\t''
time\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -l format -d 'Format string for the format reporter' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -l stats -d 'Sorting variant for the stats reporter' -r -f -a "name\t''
count\t''
level\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -s r -l reports -d 'Restrict by report target' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -l color -d 'enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -s F -l force -d 'Disregard ignore settings'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -s s -l sort -d 'Output reports in sorted order'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -s v -l verbose -d 'Increase logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand scan" -s h -l help -d 'Print help'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and not __fish_seen_subcommand_from checks reports" -l color -d 'enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and not __fish_seen_subcommand_from checks reports" -s v -l verbose -d 'Increase logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and not __fish_seen_subcommand_from checks reports" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and not __fish_seen_subcommand_from checks reports" -s h -l help -d 'Print help'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and not __fish_seen_subcommand_from checks reports" -f -a "checks" -d 'Show checks'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and not __fish_seen_subcommand_from checks reports" -f -a "reports" -d 'Show reports'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and __fish_seen_subcommand_from checks" -l repo -d 'Target repo' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and __fish_seen_subcommand_from checks" -l color -d 'enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and __fish_seen_subcommand_from checks" -s i -l info -d 'Output extended information'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and __fish_seen_subcommand_from checks" -s v -l verbose -d 'Increase logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and __fish_seen_subcommand_from checks" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and __fish_seen_subcommand_from checks" -s h -l help -d 'Print help'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and __fish_seen_subcommand_from reports" -l repo -d 'Target repo' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and __fish_seen_subcommand_from reports" -s r -l reports -d 'Restrict by report target' -r
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and __fish_seen_subcommand_from reports" -l color -d 'enable/disable color support' -r -f -a "true\t''
false\t''"
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and __fish_seen_subcommand_from reports" -s v -l verbose -d 'Increase logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and __fish_seen_subcommand_from reports" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pkgcruft -n "__fish_pkgcruft_using_subcommand show; and __fish_seen_subcommand_from reports" -s h -l help -d 'Print help'
