// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mgn

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opChangeServerLifeCycleState = "ChangeServerLifeCycleState"

// ChangeServerLifeCycleStateRequest generates a "aws/request.Request" representing the
// client's request for the ChangeServerLifeCycleState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ChangeServerLifeCycleState for more information on using the ChangeServerLifeCycleState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ChangeServerLifeCycleStateRequest method.
//    req, resp := client.ChangeServerLifeCycleStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ChangeServerLifeCycleState
func (c *Mgn) ChangeServerLifeCycleStateRequest(input *ChangeServerLifeCycleStateInput) (req *request.Request, output *ChangeServerLifeCycleStateOutput) {
	op := &request.Operation{
		Name:       opChangeServerLifeCycleState,
		HTTPMethod: "POST",
		HTTPPath:   "/ChangeServerLifeCycleState",
	}

	if input == nil {
		input = &ChangeServerLifeCycleStateInput{}
	}

	output = &ChangeServerLifeCycleStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ChangeServerLifeCycleState API operation for Application Migration Service.
//
// Allows the user to set the SourceServer.LifeCycle.state property for specific
// Source Server IDs to one of the following: READY_FOR_TEST or READY_FOR_CUTOVER.
// This command only works if the Source Server is already launchable (dataReplicationInfo.lagDuration
// is not null.)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation ChangeServerLifeCycleState for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ValidationException
//   Validate exception.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ChangeServerLifeCycleState
func (c *Mgn) ChangeServerLifeCycleState(input *ChangeServerLifeCycleStateInput) (*ChangeServerLifeCycleStateOutput, error) {
	req, out := c.ChangeServerLifeCycleStateRequest(input)
	return out, req.Send()
}

// ChangeServerLifeCycleStateWithContext is the same as ChangeServerLifeCycleState with the addition of
// the ability to pass a context and additional request options.
//
// See ChangeServerLifeCycleState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) ChangeServerLifeCycleStateWithContext(ctx aws.Context, input *ChangeServerLifeCycleStateInput, opts ...request.Option) (*ChangeServerLifeCycleStateOutput, error) {
	req, out := c.ChangeServerLifeCycleStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationConfigurationTemplate = "CreateReplicationConfigurationTemplate"

// CreateReplicationConfigurationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationConfigurationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationConfigurationTemplate for more information on using the CreateReplicationConfigurationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateReplicationConfigurationTemplateRequest method.
//    req, resp := client.CreateReplicationConfigurationTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateReplicationConfigurationTemplate
func (c *Mgn) CreateReplicationConfigurationTemplateRequest(input *CreateReplicationConfigurationTemplateInput) (req *request.Request, output *CreateReplicationConfigurationTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateReplicationConfigurationTemplate",
	}

	if input == nil {
		input = &CreateReplicationConfigurationTemplateInput{}
	}

	output = &CreateReplicationConfigurationTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationConfigurationTemplate API operation for Application Migration Service.
//
// Creates a new ReplicationConfigurationTemplate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation CreateReplicationConfigurationTemplate for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ValidationException
//   Validate exception.
//
//   * AccessDeniedException
//   Operating denied due to a file permission or access check error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateReplicationConfigurationTemplate
func (c *Mgn) CreateReplicationConfigurationTemplate(input *CreateReplicationConfigurationTemplateInput) (*CreateReplicationConfigurationTemplateOutput, error) {
	req, out := c.CreateReplicationConfigurationTemplateRequest(input)
	return out, req.Send()
}

// CreateReplicationConfigurationTemplateWithContext is the same as CreateReplicationConfigurationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationConfigurationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) CreateReplicationConfigurationTemplateWithContext(ctx aws.Context, input *CreateReplicationConfigurationTemplateInput, opts ...request.Option) (*CreateReplicationConfigurationTemplateOutput, error) {
	req, out := c.CreateReplicationConfigurationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJob = "DeleteJob"

// DeleteJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJob for more information on using the DeleteJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJobRequest method.
//    req, resp := client.DeleteJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteJob
func (c *Mgn) DeleteJobRequest(input *DeleteJobInput) (req *request.Request, output *DeleteJobOutput) {
	op := &request.Operation{
		Name:       opDeleteJob,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteJob",
	}

	if input == nil {
		input = &DeleteJobInput{}
	}

	output = &DeleteJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteJob API operation for Application Migration Service.
//
// Deletes a single Job by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation DeleteJob for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteJob
func (c *Mgn) DeleteJob(input *DeleteJobInput) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	return out, req.Send()
}

// DeleteJobWithContext is the same as DeleteJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DeleteJobWithContext(ctx aws.Context, input *DeleteJobInput, opts ...request.Option) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationConfigurationTemplate = "DeleteReplicationConfigurationTemplate"

// DeleteReplicationConfigurationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationConfigurationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationConfigurationTemplate for more information on using the DeleteReplicationConfigurationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReplicationConfigurationTemplateRequest method.
//    req, resp := client.DeleteReplicationConfigurationTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteReplicationConfigurationTemplate
func (c *Mgn) DeleteReplicationConfigurationTemplateRequest(input *DeleteReplicationConfigurationTemplateInput) (req *request.Request, output *DeleteReplicationConfigurationTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteReplicationConfigurationTemplate",
	}

	if input == nil {
		input = &DeleteReplicationConfigurationTemplateInput{}
	}

	output = &DeleteReplicationConfigurationTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReplicationConfigurationTemplate API operation for Application Migration Service.
//
// Deletes a single Replication Configuration Template by ID
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation DeleteReplicationConfigurationTemplate for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteReplicationConfigurationTemplate
func (c *Mgn) DeleteReplicationConfigurationTemplate(input *DeleteReplicationConfigurationTemplateInput) (*DeleteReplicationConfigurationTemplateOutput, error) {
	req, out := c.DeleteReplicationConfigurationTemplateRequest(input)
	return out, req.Send()
}

// DeleteReplicationConfigurationTemplateWithContext is the same as DeleteReplicationConfigurationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationConfigurationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DeleteReplicationConfigurationTemplateWithContext(ctx aws.Context, input *DeleteReplicationConfigurationTemplateInput, opts ...request.Option) (*DeleteReplicationConfigurationTemplateOutput, error) {
	req, out := c.DeleteReplicationConfigurationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSourceServer = "DeleteSourceServer"

// DeleteSourceServerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSourceServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSourceServer for more information on using the DeleteSourceServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSourceServerRequest method.
//    req, resp := client.DeleteSourceServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteSourceServer
func (c *Mgn) DeleteSourceServerRequest(input *DeleteSourceServerInput) (req *request.Request, output *DeleteSourceServerOutput) {
	op := &request.Operation{
		Name:       opDeleteSourceServer,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteSourceServer",
	}

	if input == nil {
		input = &DeleteSourceServerInput{}
	}

	output = &DeleteSourceServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSourceServer API operation for Application Migration Service.
//
// Deletes a single source server by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation DeleteSourceServer for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteSourceServer
func (c *Mgn) DeleteSourceServer(input *DeleteSourceServerInput) (*DeleteSourceServerOutput, error) {
	req, out := c.DeleteSourceServerRequest(input)
	return out, req.Send()
}

// DeleteSourceServerWithContext is the same as DeleteSourceServer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSourceServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DeleteSourceServerWithContext(ctx aws.Context, input *DeleteSourceServerInput, opts ...request.Option) (*DeleteSourceServerOutput, error) {
	req, out := c.DeleteSourceServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVcenterClient = "DeleteVcenterClient"

// DeleteVcenterClientRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVcenterClient operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVcenterClient for more information on using the DeleteVcenterClient
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVcenterClientRequest method.
//    req, resp := client.DeleteVcenterClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteVcenterClient
func (c *Mgn) DeleteVcenterClientRequest(input *DeleteVcenterClientInput) (req *request.Request, output *DeleteVcenterClientOutput) {
	op := &request.Operation{
		Name:       opDeleteVcenterClient,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteVcenterClient",
	}

	if input == nil {
		input = &DeleteVcenterClientInput{}
	}

	output = &DeleteVcenterClientOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVcenterClient API operation for Application Migration Service.
//
// Deletes a given vCenter client by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation DeleteVcenterClient for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ValidationException
//   Validate exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteVcenterClient
func (c *Mgn) DeleteVcenterClient(input *DeleteVcenterClientInput) (*DeleteVcenterClientOutput, error) {
	req, out := c.DeleteVcenterClientRequest(input)
	return out, req.Send()
}

// DeleteVcenterClientWithContext is the same as DeleteVcenterClient with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVcenterClient for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DeleteVcenterClientWithContext(ctx aws.Context, input *DeleteVcenterClientInput, opts ...request.Option) (*DeleteVcenterClientOutput, error) {
	req, out := c.DeleteVcenterClientRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJobLogItems = "DescribeJobLogItems"

// DescribeJobLogItemsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobLogItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobLogItems for more information on using the DescribeJobLogItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobLogItemsRequest method.
//    req, resp := client.DescribeJobLogItemsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems
func (c *Mgn) DescribeJobLogItemsRequest(input *DescribeJobLogItemsInput) (req *request.Request, output *DescribeJobLogItemsOutput) {
	op := &request.Operation{
		Name:       opDescribeJobLogItems,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeJobLogItems",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeJobLogItemsInput{}
	}

	output = &DescribeJobLogItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobLogItems API operation for Application Migration Service.
//
// Retrieves detailed job log items with paging.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation DescribeJobLogItems for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ValidationException
//   Validate exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems
func (c *Mgn) DescribeJobLogItems(input *DescribeJobLogItemsInput) (*DescribeJobLogItemsOutput, error) {
	req, out := c.DescribeJobLogItemsRequest(input)
	return out, req.Send()
}

// DescribeJobLogItemsWithContext is the same as DescribeJobLogItems with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobLogItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DescribeJobLogItemsWithContext(ctx aws.Context, input *DescribeJobLogItemsInput, opts ...request.Option) (*DescribeJobLogItemsOutput, error) {
	req, out := c.DescribeJobLogItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeJobLogItemsPages iterates over the pages of a DescribeJobLogItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeJobLogItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeJobLogItems operation.
//    pageNum := 0
//    err := client.DescribeJobLogItemsPages(params,
//        func(page *mgn.DescribeJobLogItemsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Mgn) DescribeJobLogItemsPages(input *DescribeJobLogItemsInput, fn func(*DescribeJobLogItemsOutput, bool) bool) error {
	return c.DescribeJobLogItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeJobLogItemsPagesWithContext same as DescribeJobLogItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DescribeJobLogItemsPagesWithContext(ctx aws.Context, input *DescribeJobLogItemsInput, fn func(*DescribeJobLogItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeJobLogItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeJobLogItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeJobLogItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeJobs = "DescribeJobs"

// DescribeJobsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobs for more information on using the DescribeJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobsRequest method.
//    req, resp := client.DescribeJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs
func (c *Mgn) DescribeJobsRequest(input *DescribeJobsInput) (req *request.Request, output *DescribeJobsOutput) {
	op := &request.Operation{
		Name:       opDescribeJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeJobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeJobsInput{}
	}

	output = &DescribeJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobs API operation for Application Migration Service.
//
// Returns a list of Jobs. Use the JobsID and fromDate and toData filters to
// limit which jobs are returned. The response is sorted by creationDataTime
// - latest date first. Jobs are normally created by the StartTest, StartCutover,
// and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch
// and TerminateDiagnosticInstances, which are APIs available only to *Support*
// and only used in response to relevant support tickets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation DescribeJobs for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ValidationException
//   Validate exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs
func (c *Mgn) DescribeJobs(input *DescribeJobsInput) (*DescribeJobsOutput, error) {
	req, out := c.DescribeJobsRequest(input)
	return out, req.Send()
}

// DescribeJobsWithContext is the same as DescribeJobs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DescribeJobsWithContext(ctx aws.Context, input *DescribeJobsInput, opts ...request.Option) (*DescribeJobsOutput, error) {
	req, out := c.DescribeJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeJobsPages iterates over the pages of a DescribeJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeJobs operation.
//    pageNum := 0
//    err := client.DescribeJobsPages(params,
//        func(page *mgn.DescribeJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Mgn) DescribeJobsPages(input *DescribeJobsInput, fn func(*DescribeJobsOutput, bool) bool) error {
	return c.DescribeJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeJobsPagesWithContext same as DescribeJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DescribeJobsPagesWithContext(ctx aws.Context, input *DescribeJobsInput, fn func(*DescribeJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationConfigurationTemplates = "DescribeReplicationConfigurationTemplates"

// DescribeReplicationConfigurationTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationConfigurationTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationConfigurationTemplates for more information on using the DescribeReplicationConfigurationTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationConfigurationTemplatesRequest method.
//    req, resp := client.DescribeReplicationConfigurationTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates
func (c *Mgn) DescribeReplicationConfigurationTemplatesRequest(input *DescribeReplicationConfigurationTemplatesInput) (req *request.Request, output *DescribeReplicationConfigurationTemplatesOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationConfigurationTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeReplicationConfigurationTemplates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationConfigurationTemplatesInput{}
	}

	output = &DescribeReplicationConfigurationTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationConfigurationTemplates API operation for Application Migration Service.
//
// Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation DescribeReplicationConfigurationTemplates for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ValidationException
//   Validate exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates
func (c *Mgn) DescribeReplicationConfigurationTemplates(input *DescribeReplicationConfigurationTemplatesInput) (*DescribeReplicationConfigurationTemplatesOutput, error) {
	req, out := c.DescribeReplicationConfigurationTemplatesRequest(input)
	return out, req.Send()
}

// DescribeReplicationConfigurationTemplatesWithContext is the same as DescribeReplicationConfigurationTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationConfigurationTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DescribeReplicationConfigurationTemplatesWithContext(ctx aws.Context, input *DescribeReplicationConfigurationTemplatesInput, opts ...request.Option) (*DescribeReplicationConfigurationTemplatesOutput, error) {
	req, out := c.DescribeReplicationConfigurationTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationConfigurationTemplatesPages iterates over the pages of a DescribeReplicationConfigurationTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationConfigurationTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationConfigurationTemplates operation.
//    pageNum := 0
//    err := client.DescribeReplicationConfigurationTemplatesPages(params,
//        func(page *mgn.DescribeReplicationConfigurationTemplatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Mgn) DescribeReplicationConfigurationTemplatesPages(input *DescribeReplicationConfigurationTemplatesInput, fn func(*DescribeReplicationConfigurationTemplatesOutput, bool) bool) error {
	return c.DescribeReplicationConfigurationTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationConfigurationTemplatesPagesWithContext same as DescribeReplicationConfigurationTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DescribeReplicationConfigurationTemplatesPagesWithContext(ctx aws.Context, input *DescribeReplicationConfigurationTemplatesInput, fn func(*DescribeReplicationConfigurationTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationConfigurationTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationConfigurationTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationConfigurationTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSourceServers = "DescribeSourceServers"

// DescribeSourceServersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSourceServers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSourceServers for more information on using the DescribeSourceServers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSourceServersRequest method.
//    req, resp := client.DescribeSourceServersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers
func (c *Mgn) DescribeSourceServersRequest(input *DescribeSourceServersInput) (req *request.Request, output *DescribeSourceServersOutput) {
	op := &request.Operation{
		Name:       opDescribeSourceServers,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeSourceServers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSourceServersInput{}
	}

	output = &DescribeSourceServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSourceServers API operation for Application Migration Service.
//
// Retrieves all SourceServers or multiple SourceServers by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation DescribeSourceServers for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ValidationException
//   Validate exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers
func (c *Mgn) DescribeSourceServers(input *DescribeSourceServersInput) (*DescribeSourceServersOutput, error) {
	req, out := c.DescribeSourceServersRequest(input)
	return out, req.Send()
}

// DescribeSourceServersWithContext is the same as DescribeSourceServers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSourceServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DescribeSourceServersWithContext(ctx aws.Context, input *DescribeSourceServersInput, opts ...request.Option) (*DescribeSourceServersOutput, error) {
	req, out := c.DescribeSourceServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSourceServersPages iterates over the pages of a DescribeSourceServers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSourceServers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSourceServers operation.
//    pageNum := 0
//    err := client.DescribeSourceServersPages(params,
//        func(page *mgn.DescribeSourceServersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Mgn) DescribeSourceServersPages(input *DescribeSourceServersInput, fn func(*DescribeSourceServersOutput, bool) bool) error {
	return c.DescribeSourceServersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSourceServersPagesWithContext same as DescribeSourceServersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DescribeSourceServersPagesWithContext(ctx aws.Context, input *DescribeSourceServersInput, fn func(*DescribeSourceServersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSourceServersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSourceServersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSourceServersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeVcenterClients = "DescribeVcenterClients"

// DescribeVcenterClientsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVcenterClients operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVcenterClients for more information on using the DescribeVcenterClients
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVcenterClientsRequest method.
//    req, resp := client.DescribeVcenterClientsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients
func (c *Mgn) DescribeVcenterClientsRequest(input *DescribeVcenterClientsInput) (req *request.Request, output *DescribeVcenterClientsOutput) {
	op := &request.Operation{
		Name:       opDescribeVcenterClients,
		HTTPMethod: "GET",
		HTTPPath:   "/DescribeVcenterClients",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeVcenterClientsInput{}
	}

	output = &DescribeVcenterClientsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVcenterClients API operation for Application Migration Service.
//
// Returns a list of the installed vCenter clients.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation DescribeVcenterClients for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ValidationException
//   Validate exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients
func (c *Mgn) DescribeVcenterClients(input *DescribeVcenterClientsInput) (*DescribeVcenterClientsOutput, error) {
	req, out := c.DescribeVcenterClientsRequest(input)
	return out, req.Send()
}

// DescribeVcenterClientsWithContext is the same as DescribeVcenterClients with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVcenterClients for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DescribeVcenterClientsWithContext(ctx aws.Context, input *DescribeVcenterClientsInput, opts ...request.Option) (*DescribeVcenterClientsOutput, error) {
	req, out := c.DescribeVcenterClientsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeVcenterClientsPages iterates over the pages of a DescribeVcenterClients operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeVcenterClients method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeVcenterClients operation.
//    pageNum := 0
//    err := client.DescribeVcenterClientsPages(params,
//        func(page *mgn.DescribeVcenterClientsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Mgn) DescribeVcenterClientsPages(input *DescribeVcenterClientsInput, fn func(*DescribeVcenterClientsOutput, bool) bool) error {
	return c.DescribeVcenterClientsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeVcenterClientsPagesWithContext same as DescribeVcenterClientsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DescribeVcenterClientsPagesWithContext(ctx aws.Context, input *DescribeVcenterClientsInput, fn func(*DescribeVcenterClientsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeVcenterClientsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeVcenterClientsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeVcenterClientsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDisconnectFromService = "DisconnectFromService"

// DisconnectFromServiceRequest generates a "aws/request.Request" representing the
// client's request for the DisconnectFromService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisconnectFromService for more information on using the DisconnectFromService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisconnectFromServiceRequest method.
//    req, resp := client.DisconnectFromServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisconnectFromService
func (c *Mgn) DisconnectFromServiceRequest(input *DisconnectFromServiceInput) (req *request.Request, output *DisconnectFromServiceOutput) {
	op := &request.Operation{
		Name:       opDisconnectFromService,
		HTTPMethod: "POST",
		HTTPPath:   "/DisconnectFromService",
	}

	if input == nil {
		input = &DisconnectFromServiceInput{}
	}

	output = &DisconnectFromServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisconnectFromService API operation for Application Migration Service.
//
// Disconnects specific Source Servers from Application Migration Service. Data
// replication is stopped immediately. All AWS resources created by Application
// Migration Service for enabling the replication of these source servers will
// be terminated / deleted within 90 minutes. Launched Test or Cutover instances
// will NOT be terminated. If the agent on the source server has not been prevented
// from communicating with the Application Migration Service service, then it
// will receive a command to uninstall itself (within approximately 10 minutes).
// The following properties of the SourceServer will be changed immediately:
// dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The
// totalStorageBytes property for each of dataReplicationInfo.replicatedDisks
// will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration
// will be nullified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation DisconnectFromService for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisconnectFromService
func (c *Mgn) DisconnectFromService(input *DisconnectFromServiceInput) (*DisconnectFromServiceOutput, error) {
	req, out := c.DisconnectFromServiceRequest(input)
	return out, req.Send()
}

// DisconnectFromServiceWithContext is the same as DisconnectFromService with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectFromService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) DisconnectFromServiceWithContext(ctx aws.Context, input *DisconnectFromServiceInput, opts ...request.Option) (*DisconnectFromServiceOutput, error) {
	req, out := c.DisconnectFromServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opFinalizeCutover = "FinalizeCutover"

// FinalizeCutoverRequest generates a "aws/request.Request" representing the
// client's request for the FinalizeCutover operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See FinalizeCutover for more information on using the FinalizeCutover
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the FinalizeCutoverRequest method.
//    req, resp := client.FinalizeCutoverRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/FinalizeCutover
func (c *Mgn) FinalizeCutoverRequest(input *FinalizeCutoverInput) (req *request.Request, output *FinalizeCutoverOutput) {
	op := &request.Operation{
		Name:       opFinalizeCutover,
		HTTPMethod: "POST",
		HTTPPath:   "/FinalizeCutover",
	}

	if input == nil {
		input = &FinalizeCutoverInput{}
	}

	output = &FinalizeCutoverOutput{}
	req = c.newRequest(op, input, output)
	return
}

// FinalizeCutover API operation for Application Migration Service.
//
// Finalizes the cutover immediately for specific Source Servers. All AWS resources
// created by Application Migration Service for enabling the replication of
// these source servers will be terminated / deleted within 90 minutes. Launched
// Test or Cutover instances will NOT be terminated. The AWS Replication Agent
// will receive a command to uninstall itself (within 10 minutes). The following
// properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState
// will be changed to DISCONNECTED; The SourceServer.lifeCycle.state will be
// changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks
// will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration
// will be nullified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation FinalizeCutover for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ValidationException
//   Validate exception.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/FinalizeCutover
func (c *Mgn) FinalizeCutover(input *FinalizeCutoverInput) (*FinalizeCutoverOutput, error) {
	req, out := c.FinalizeCutoverRequest(input)
	return out, req.Send()
}

// FinalizeCutoverWithContext is the same as FinalizeCutover with the addition of
// the ability to pass a context and additional request options.
//
// See FinalizeCutover for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) FinalizeCutoverWithContext(ctx aws.Context, input *FinalizeCutoverInput, opts ...request.Option) (*FinalizeCutoverOutput, error) {
	req, out := c.FinalizeCutoverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLaunchConfiguration = "GetLaunchConfiguration"

// GetLaunchConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetLaunchConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLaunchConfiguration for more information on using the GetLaunchConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLaunchConfigurationRequest method.
//    req, resp := client.GetLaunchConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetLaunchConfiguration
func (c *Mgn) GetLaunchConfigurationRequest(input *GetLaunchConfigurationInput) (req *request.Request, output *GetLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/GetLaunchConfiguration",
	}

	if input == nil {
		input = &GetLaunchConfigurationInput{}
	}

	output = &GetLaunchConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLaunchConfiguration API operation for Application Migration Service.
//
// Lists all LaunchConfigurations available, filtered by Source Server IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation GetLaunchConfiguration for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetLaunchConfiguration
func (c *Mgn) GetLaunchConfiguration(input *GetLaunchConfigurationInput) (*GetLaunchConfigurationOutput, error) {
	req, out := c.GetLaunchConfigurationRequest(input)
	return out, req.Send()
}

// GetLaunchConfigurationWithContext is the same as GetLaunchConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetLaunchConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) GetLaunchConfigurationWithContext(ctx aws.Context, input *GetLaunchConfigurationInput, opts ...request.Option) (*GetLaunchConfigurationOutput, error) {
	req, out := c.GetLaunchConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetReplicationConfiguration = "GetReplicationConfiguration"

// GetReplicationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetReplicationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetReplicationConfiguration for more information on using the GetReplicationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetReplicationConfigurationRequest method.
//    req, resp := client.GetReplicationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetReplicationConfiguration
func (c *Mgn) GetReplicationConfigurationRequest(input *GetReplicationConfigurationInput) (req *request.Request, output *GetReplicationConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetReplicationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/GetReplicationConfiguration",
	}

	if input == nil {
		input = &GetReplicationConfigurationInput{}
	}

	output = &GetReplicationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetReplicationConfiguration API operation for Application Migration Service.
//
// Lists all ReplicationConfigurations, filtered by Source Server ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation GetReplicationConfiguration for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetReplicationConfiguration
func (c *Mgn) GetReplicationConfiguration(input *GetReplicationConfigurationInput) (*GetReplicationConfigurationOutput, error) {
	req, out := c.GetReplicationConfigurationRequest(input)
	return out, req.Send()
}

// GetReplicationConfigurationWithContext is the same as GetReplicationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetReplicationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) GetReplicationConfigurationWithContext(ctx aws.Context, input *GetReplicationConfigurationInput, opts ...request.Option) (*GetReplicationConfigurationOutput, error) {
	req, out := c.GetReplicationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInitializeService = "InitializeService"

// InitializeServiceRequest generates a "aws/request.Request" representing the
// client's request for the InitializeService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InitializeService for more information on using the InitializeService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InitializeServiceRequest method.
//    req, resp := client.InitializeServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/InitializeService
func (c *Mgn) InitializeServiceRequest(input *InitializeServiceInput) (req *request.Request, output *InitializeServiceOutput) {
	op := &request.Operation{
		Name:       opInitializeService,
		HTTPMethod: "POST",
		HTTPPath:   "/InitializeService",
	}

	if input == nil {
		input = &InitializeServiceInput{}
	}

	output = &InitializeServiceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// InitializeService API operation for Application Migration Service.
//
// Initialize Application Migration Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation InitializeService for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Validate exception.
//
//   * AccessDeniedException
//   Operating denied due to a file permission or access check error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/InitializeService
func (c *Mgn) InitializeService(input *InitializeServiceInput) (*InitializeServiceOutput, error) {
	req, out := c.InitializeServiceRequest(input)
	return out, req.Send()
}

// InitializeServiceWithContext is the same as InitializeService with the addition of
// the ability to pass a context and additional request options.
//
// See InitializeService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) InitializeServiceWithContext(ctx aws.Context, input *InitializeServiceInput, opts ...request.Option) (*InitializeServiceOutput, error) {
	req, out := c.InitializeServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTagsForResource
func (c *Mgn) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Application Migration Service.
//
// List all tags for your Application Migration Service resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ThrottlingException
//   Reached throttling quota exception.
//
//   * ValidationException
//   Validate exception.
//
//   * AccessDeniedException
//   Operating denied due to a file permission or access check error.
//
//   * InternalServerException
//   The server encountered an unexpected condition that prevented it from fulfilling
//   the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTagsForResource
func (c *Mgn) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opMarkAsArchived = "MarkAsArchived"

// MarkAsArchivedRequest generates a "aws/request.Request" representing the
// client's request for the MarkAsArchived operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See MarkAsArchived for more information on using the MarkAsArchived
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the MarkAsArchivedRequest method.
//    req, resp := client.MarkAsArchivedRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/MarkAsArchived
func (c *Mgn) MarkAsArchivedRequest(input *MarkAsArchivedInput) (req *request.Request, output *MarkAsArchivedOutput) {
	op := &request.Operation{
		Name:       opMarkAsArchived,
		HTTPMethod: "POST",
		HTTPPath:   "/MarkAsArchived",
	}

	if input == nil {
		input = &MarkAsArchivedInput{}
	}

	output = &MarkAsArchivedOutput{}
	req = c.newRequest(op, input, output)
	return
}

// MarkAsArchived API operation for Application Migration Service.
//
// Archives specific Source Servers by setting the SourceServer.isArchived property
// to true for specified SourceServers by ID. This command only works for SourceServers
// with a lifecycle. state which equals DISCONNECTED or CUTOVER.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation MarkAsArchived for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/MarkAsArchived
func (c *Mgn) MarkAsArchived(input *MarkAsArchivedInput) (*MarkAsArchivedOutput, error) {
	req, out := c.MarkAsArchivedRequest(input)
	return out, req.Send()
}

// MarkAsArchivedWithContext is the same as MarkAsArchived with the addition of
// the ability to pass a context and additional request options.
//
// See MarkAsArchived for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) MarkAsArchivedWithContext(ctx aws.Context, input *MarkAsArchivedInput, opts ...request.Option) (*MarkAsArchivedOutput, error) {
	req, out := c.MarkAsArchivedRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRetryDataReplication = "RetryDataReplication"

// RetryDataReplicationRequest generates a "aws/request.Request" representing the
// client's request for the RetryDataReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RetryDataReplication for more information on using the RetryDataReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RetryDataReplicationRequest method.
//    req, resp := client.RetryDataReplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RetryDataReplication
func (c *Mgn) RetryDataReplicationRequest(input *RetryDataReplicationInput) (req *request.Request, output *RetryDataReplicationOutput) {
	op := &request.Operation{
		Name:       opRetryDataReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/RetryDataReplication",
	}

	if input == nil {
		input = &RetryDataReplicationInput{}
	}

	output = &RetryDataReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RetryDataReplication API operation for Application Migration Service.
//
// Causes the data replication initiation sequence to begin immediately upon
// next Handshake for specified SourceServer IDs, regardless of when the previous
// initiation started. This command will not work if the SourceServer is not
// stalled or is in a DISCONNECTED or STOPPED state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation RetryDataReplication for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ValidationException
//   Validate exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RetryDataReplication
func (c *Mgn) RetryDataReplication(input *RetryDataReplicationInput) (*RetryDataReplicationOutput, error) {
	req, out := c.RetryDataReplicationRequest(input)
	return out, req.Send()
}

// RetryDataReplicationWithContext is the same as RetryDataReplication with the addition of
// the ability to pass a context and additional request options.
//
// See RetryDataReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) RetryDataReplicationWithContext(ctx aws.Context, input *RetryDataReplicationInput, opts ...request.Option) (*RetryDataReplicationOutput, error) {
	req, out := c.RetryDataReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartCutover = "StartCutover"

// StartCutoverRequest generates a "aws/request.Request" representing the
// client's request for the StartCutover operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCutover for more information on using the StartCutover
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartCutoverRequest method.
//    req, resp := client.StartCutoverRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartCutover
func (c *Mgn) StartCutoverRequest(input *StartCutoverInput) (req *request.Request, output *StartCutoverOutput) {
	op := &request.Operation{
		Name:       opStartCutover,
		HTTPMethod: "POST",
		HTTPPath:   "/StartCutover",
	}

	if input == nil {
		input = &StartCutoverInput{}
	}

	output = &StartCutoverOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartCutover API operation for Application Migration Service.
//
// Launches a Cutover Instance for specific Source Servers. This command starts
// a LAUNCH job whose initiatedBy property is StartCutover and changes the SourceServer.lifeCycle.state
// property to CUTTING_OVER.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation StartCutover for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ValidationException
//   Validate exception.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartCutover
func (c *Mgn) StartCutover(input *StartCutoverInput) (*StartCutoverOutput, error) {
	req, out := c.StartCutoverRequest(input)
	return out, req.Send()
}

// StartCutoverWithContext is the same as StartCutover with the addition of
// the ability to pass a context and additional request options.
//
// See StartCutover for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) StartCutoverWithContext(ctx aws.Context, input *StartCutoverInput, opts ...request.Option) (*StartCutoverOutput, error) {
	req, out := c.StartCutoverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReplication = "StartReplication"

// StartReplicationRequest generates a "aws/request.Request" representing the
// client's request for the StartReplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReplication for more information on using the StartReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartReplicationRequest method.
//    req, resp := client.StartReplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartReplication
func (c *Mgn) StartReplicationRequest(input *StartReplicationInput) (req *request.Request, output *StartReplicationOutput) {
	op := &request.Operation{
		Name:       opStartReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/StartReplication",
	}

	if input == nil {
		input = &StartReplicationInput{}
	}

	output = &StartReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReplication API operation for Application Migration Service.
//
// Starts replication for SNAPSHOT_SHIPPING agents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation StartReplication for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ValidationException
//   Validate exception.
//
//   * ServiceQuotaExceededException
//   The request could not be completed because its exceeded the service quota.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartReplication
func (c *Mgn) StartReplication(input *StartReplicationInput) (*StartReplicationOutput, error) {
	req, out := c.StartReplicationRequest(input)
	return out, req.Send()
}

// StartReplicationWithContext is the same as StartReplication with the addition of
// the ability to pass a context and additional request options.
//
// See StartReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) StartReplicationWithContext(ctx aws.Context, input *StartReplicationInput, opts ...request.Option) (*StartReplicationOutput, error) {
	req, out := c.StartReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTest = "StartTest"

// StartTestRequest generates a "aws/request.Request" representing the
// client's request for the StartTest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTest for more information on using the StartTest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTestRequest method.
//    req, resp := client.StartTestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartTest
func (c *Mgn) StartTestRequest(input *StartTestInput) (req *request.Request, output *StartTestOutput) {
	op := &request.Operation{
		Name:       opStartTest,
		HTTPMethod: "POST",
		HTTPPath:   "/StartTest",
	}

	if input == nil {
		input = &StartTestInput{}
	}

	output = &StartTestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTest API operation for Application Migration Service.
//
// Launches a Test Instance for specific Source Servers. This command starts
// a LAUNCH job whose initiatedBy property is StartTest and changes the SourceServer.lifeCycle.state
// property to TESTING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation StartTest for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ValidationException
//   Validate exception.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartTest
func (c *Mgn) StartTest(input *StartTestInput) (*StartTestOutput, error) {
	req, out := c.StartTestRequest(input)
	return out, req.Send()
}

// StartTestWithContext is the same as StartTest with the addition of
// the ability to pass a context and additional request options.
//
// See StartTest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) StartTestWithContext(ctx aws.Context, input *StartTestInput, opts ...request.Option) (*StartTestOutput, error) {
	req, out := c.StartTestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TagResource
func (c *Mgn) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Application Migration Service.
//
// Adds or overwrites only the specified tags for the specified Application
// Migration Service resource or resources. When you specify an existing tag
// key, the value is overwritten with the new value. Each resource can have
// a maximum of 50 tags. Each tag consists of a key and optional value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ThrottlingException
//   Reached throttling quota exception.
//
//   * ValidationException
//   Validate exception.
//
//   * AccessDeniedException
//   Operating denied due to a file permission or access check error.
//
//   * InternalServerException
//   The server encountered an unexpected condition that prevented it from fulfilling
//   the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TagResource
func (c *Mgn) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateTargetInstances = "TerminateTargetInstances"

// TerminateTargetInstancesRequest generates a "aws/request.Request" representing the
// client's request for the TerminateTargetInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateTargetInstances for more information on using the TerminateTargetInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TerminateTargetInstancesRequest method.
//    req, resp := client.TerminateTargetInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TerminateTargetInstances
func (c *Mgn) TerminateTargetInstancesRequest(input *TerminateTargetInstancesInput) (req *request.Request, output *TerminateTargetInstancesOutput) {
	op := &request.Operation{
		Name:       opTerminateTargetInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/TerminateTargetInstances",
	}

	if input == nil {
		input = &TerminateTargetInstancesInput{}
	}

	output = &TerminateTargetInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateTargetInstances API operation for Application Migration Service.
//
// Starts a job that terminates specific launched EC2 Test and Cutover instances.
// This command will not work for any Source Server with a lifecycle.state of
// TESTING, CUTTING_OVER, or CUTOVER.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation TerminateTargetInstances for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ValidationException
//   Validate exception.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TerminateTargetInstances
func (c *Mgn) TerminateTargetInstances(input *TerminateTargetInstancesInput) (*TerminateTargetInstancesOutput, error) {
	req, out := c.TerminateTargetInstancesRequest(input)
	return out, req.Send()
}

// TerminateTargetInstancesWithContext is the same as TerminateTargetInstances with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateTargetInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) TerminateTargetInstancesWithContext(ctx aws.Context, input *TerminateTargetInstancesInput, opts ...request.Option) (*TerminateTargetInstancesOutput, error) {
	req, out := c.TerminateTargetInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UntagResource
func (c *Mgn) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Application Migration Service.
//
// Deletes the specified set of tags from the specified set of Application Migration
// Service resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ThrottlingException
//   Reached throttling quota exception.
//
//   * ValidationException
//   Validate exception.
//
//   * AccessDeniedException
//   Operating denied due to a file permission or access check error.
//
//   * InternalServerException
//   The server encountered an unexpected condition that prevented it from fulfilling
//   the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UntagResource
func (c *Mgn) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLaunchConfiguration = "UpdateLaunchConfiguration"

// UpdateLaunchConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLaunchConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLaunchConfiguration for more information on using the UpdateLaunchConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLaunchConfigurationRequest method.
//    req, resp := client.UpdateLaunchConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfiguration
func (c *Mgn) UpdateLaunchConfigurationRequest(input *UpdateLaunchConfigurationInput) (req *request.Request, output *UpdateLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateLaunchConfiguration",
	}

	if input == nil {
		input = &UpdateLaunchConfigurationInput{}
	}

	output = &UpdateLaunchConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLaunchConfiguration API operation for Application Migration Service.
//
// Updates multiple LaunchConfigurations by Source Server ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation UpdateLaunchConfiguration for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ValidationException
//   Validate exception.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfiguration
func (c *Mgn) UpdateLaunchConfiguration(input *UpdateLaunchConfigurationInput) (*UpdateLaunchConfigurationOutput, error) {
	req, out := c.UpdateLaunchConfigurationRequest(input)
	return out, req.Send()
}

// UpdateLaunchConfigurationWithContext is the same as UpdateLaunchConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLaunchConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) UpdateLaunchConfigurationWithContext(ctx aws.Context, input *UpdateLaunchConfigurationInput, opts ...request.Option) (*UpdateLaunchConfigurationOutput, error) {
	req, out := c.UpdateLaunchConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReplicationConfiguration = "UpdateReplicationConfiguration"

// UpdateReplicationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReplicationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReplicationConfiguration for more information on using the UpdateReplicationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateReplicationConfigurationRequest method.
//    req, resp := client.UpdateReplicationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfiguration
func (c *Mgn) UpdateReplicationConfigurationRequest(input *UpdateReplicationConfigurationInput) (req *request.Request, output *UpdateReplicationConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateReplicationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateReplicationConfiguration",
	}

	if input == nil {
		input = &UpdateReplicationConfigurationInput{}
	}

	output = &UpdateReplicationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReplicationConfiguration API operation for Application Migration Service.
//
// Allows you to update multiple ReplicationConfigurations by Source Server
// ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation UpdateReplicationConfiguration for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ValidationException
//   Validate exception.
//
//   * AccessDeniedException
//   Operating denied due to a file permission or access check error.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfiguration
func (c *Mgn) UpdateReplicationConfiguration(input *UpdateReplicationConfigurationInput) (*UpdateReplicationConfigurationOutput, error) {
	req, out := c.UpdateReplicationConfigurationRequest(input)
	return out, req.Send()
}

// UpdateReplicationConfigurationWithContext is the same as UpdateReplicationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReplicationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) UpdateReplicationConfigurationWithContext(ctx aws.Context, input *UpdateReplicationConfigurationInput, opts ...request.Option) (*UpdateReplicationConfigurationOutput, error) {
	req, out := c.UpdateReplicationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReplicationConfigurationTemplate = "UpdateReplicationConfigurationTemplate"

// UpdateReplicationConfigurationTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReplicationConfigurationTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReplicationConfigurationTemplate for more information on using the UpdateReplicationConfigurationTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateReplicationConfigurationTemplateRequest method.
//    req, resp := client.UpdateReplicationConfigurationTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfigurationTemplate
func (c *Mgn) UpdateReplicationConfigurationTemplateRequest(input *UpdateReplicationConfigurationTemplateInput) (req *request.Request, output *UpdateReplicationConfigurationTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateReplicationConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateReplicationConfigurationTemplate",
	}

	if input == nil {
		input = &UpdateReplicationConfigurationTemplateInput{}
	}

	output = &UpdateReplicationConfigurationTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReplicationConfigurationTemplate API operation for Application Migration Service.
//
// Updates multiple ReplicationConfigurationTemplates by ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation UpdateReplicationConfigurationTemplate for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ValidationException
//   Validate exception.
//
//   * AccessDeniedException
//   Operating denied due to a file permission or access check error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfigurationTemplate
func (c *Mgn) UpdateReplicationConfigurationTemplate(input *UpdateReplicationConfigurationTemplateInput) (*UpdateReplicationConfigurationTemplateOutput, error) {
	req, out := c.UpdateReplicationConfigurationTemplateRequest(input)
	return out, req.Send()
}

// UpdateReplicationConfigurationTemplateWithContext is the same as UpdateReplicationConfigurationTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReplicationConfigurationTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) UpdateReplicationConfigurationTemplateWithContext(ctx aws.Context, input *UpdateReplicationConfigurationTemplateInput, opts ...request.Option) (*UpdateReplicationConfigurationTemplateOutput, error) {
	req, out := c.UpdateReplicationConfigurationTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSourceServerReplicationType = "UpdateSourceServerReplicationType"

// UpdateSourceServerReplicationTypeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSourceServerReplicationType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSourceServerReplicationType for more information on using the UpdateSourceServerReplicationType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSourceServerReplicationTypeRequest method.
//    req, resp := client.UpdateSourceServerReplicationTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateSourceServerReplicationType
func (c *Mgn) UpdateSourceServerReplicationTypeRequest(input *UpdateSourceServerReplicationTypeInput) (req *request.Request, output *UpdateSourceServerReplicationTypeOutput) {
	op := &request.Operation{
		Name:       opUpdateSourceServerReplicationType,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateSourceServerReplicationType",
	}

	if input == nil {
		input = &UpdateSourceServerReplicationTypeInput{}
	}

	output = &UpdateSourceServerReplicationTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSourceServerReplicationType API operation for Application Migration Service.
//
// Allows you to change between the AGENT_BASED replication type and the SNAPSHOT_SHIPPING
// replication type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Application Migration Service's
// API operation UpdateSourceServerReplicationType for usage and error information.
//
// Returned Error Types:
//   * UninitializedAccountException
//   Uninitialized account exception.
//
//   * ResourceNotFoundException
//   Resource not found exception.
//
//   * ValidationException
//   Validate exception.
//
//   * ConflictException
//   The request could not be completed due to a conflict with the current state
//   of the target resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateSourceServerReplicationType
func (c *Mgn) UpdateSourceServerReplicationType(input *UpdateSourceServerReplicationTypeInput) (*UpdateSourceServerReplicationTypeOutput, error) {
	req, out := c.UpdateSourceServerReplicationTypeRequest(input)
	return out, req.Send()
}

// UpdateSourceServerReplicationTypeWithContext is the same as UpdateSourceServerReplicationType with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSourceServerReplicationType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Mgn) UpdateSourceServerReplicationTypeWithContext(ctx aws.Context, input *UpdateSourceServerReplicationTypeInput, opts ...request.Option) (*UpdateSourceServerReplicationTypeOutput, error) {
	req, out := c.UpdateSourceServerReplicationTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Operating denied due to a file permission or access check error.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Source server CPU information.
type CPU struct {
	_ struct{} `type:"structure"`

	// The number of CPU cores on the source server.
	Cores *int64 `locationName:"cores" type:"long"`

	// The source server's CPU model name.
	ModelName *string `locationName:"modelName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CPU) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CPU) GoString() string {
	return s.String()
}

// SetCores sets the Cores field's value.
func (s *CPU) SetCores(v int64) *CPU {
	s.Cores = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CPU) SetModelName(v string) *CPU {
	s.ModelName = &v
	return s
}

type ChangeServerLifeCycleStateInput struct {
	_ struct{} `type:"structure"`

	// The request to change the source server migration lifecycle state.
	//
	// LifeCycle is a required field
	LifeCycle *ChangeServerLifeCycleStateSourceServerLifecycle `locationName:"lifeCycle" type:"structure" required:"true"`

	// The request to change the source server migration lifecycle state by source
	// server ID.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeServerLifeCycleStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeServerLifeCycleStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangeServerLifeCycleStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangeServerLifeCycleStateInput"}
	if s.LifeCycle == nil {
		invalidParams.Add(request.NewErrParamRequired("LifeCycle"))
	}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}
	if s.LifeCycle != nil {
		if err := s.LifeCycle.Validate(); err != nil {
			invalidParams.AddNested("LifeCycle", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *ChangeServerLifeCycleStateInput) SetLifeCycle(v *ChangeServerLifeCycleStateSourceServerLifecycle) *ChangeServerLifeCycleStateInput {
	s.LifeCycle = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *ChangeServerLifeCycleStateInput) SetSourceServerID(v string) *ChangeServerLifeCycleStateInput {
	s.SourceServerID = &v
	return s
}

type ChangeServerLifeCycleStateOutput struct {
	_ struct{} `type:"structure"`

	// Source server ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Source server data replication info.
	DataReplicationInfo *DataReplicationInfo `locationName:"dataReplicationInfo" type:"structure"`

	// Source server archived status.
	IsArchived *bool `locationName:"isArchived" type:"boolean"`

	// Source server launched instance.
	LaunchedInstance *LaunchedInstance `locationName:"launchedInstance" type:"structure"`

	// Source server lifecycle state.
	LifeCycle *LifeCycle `locationName:"lifeCycle" type:"structure"`

	// Source server replication type.
	ReplicationType *string `locationName:"replicationType" type:"string" enum:"ReplicationType"`

	// Source server properties.
	SourceProperties *SourceProperties `locationName:"sourceProperties" type:"structure"`

	// Source server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Source server Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ChangeServerLifeCycleStateOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Source server vCenter client id.
	VcenterClientID *string `locationName:"vcenterClientID" min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeServerLifeCycleStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeServerLifeCycleStateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ChangeServerLifeCycleStateOutput) SetArn(v string) *ChangeServerLifeCycleStateOutput {
	s.Arn = &v
	return s
}

// SetDataReplicationInfo sets the DataReplicationInfo field's value.
func (s *ChangeServerLifeCycleStateOutput) SetDataReplicationInfo(v *DataReplicationInfo) *ChangeServerLifeCycleStateOutput {
	s.DataReplicationInfo = v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *ChangeServerLifeCycleStateOutput) SetIsArchived(v bool) *ChangeServerLifeCycleStateOutput {
	s.IsArchived = &v
	return s
}

// SetLaunchedInstance sets the LaunchedInstance field's value.
func (s *ChangeServerLifeCycleStateOutput) SetLaunchedInstance(v *LaunchedInstance) *ChangeServerLifeCycleStateOutput {
	s.LaunchedInstance = v
	return s
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *ChangeServerLifeCycleStateOutput) SetLifeCycle(v *LifeCycle) *ChangeServerLifeCycleStateOutput {
	s.LifeCycle = v
	return s
}

// SetReplicationType sets the ReplicationType field's value.
func (s *ChangeServerLifeCycleStateOutput) SetReplicationType(v string) *ChangeServerLifeCycleStateOutput {
	s.ReplicationType = &v
	return s
}

// SetSourceProperties sets the SourceProperties field's value.
func (s *ChangeServerLifeCycleStateOutput) SetSourceProperties(v *SourceProperties) *ChangeServerLifeCycleStateOutput {
	s.SourceProperties = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *ChangeServerLifeCycleStateOutput) SetSourceServerID(v string) *ChangeServerLifeCycleStateOutput {
	s.SourceServerID = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ChangeServerLifeCycleStateOutput) SetTags(v map[string]*string) *ChangeServerLifeCycleStateOutput {
	s.Tags = v
	return s
}

// SetVcenterClientID sets the VcenterClientID field's value.
func (s *ChangeServerLifeCycleStateOutput) SetVcenterClientID(v string) *ChangeServerLifeCycleStateOutput {
	s.VcenterClientID = &v
	return s
}

// The request to change the source server migration lifecycle state.
type ChangeServerLifeCycleStateSourceServerLifecycle struct {
	_ struct{} `type:"structure"`

	// The request to change the source server migration lifecycle state.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"ChangeServerLifeCycleStateSourceServerLifecycleState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeServerLifeCycleStateSourceServerLifecycle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChangeServerLifeCycleStateSourceServerLifecycle) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangeServerLifeCycleStateSourceServerLifecycle) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangeServerLifeCycleStateSourceServerLifecycle"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetState sets the State field's value.
func (s *ChangeServerLifeCycleStateSourceServerLifecycle) SetState(v string) *ChangeServerLifeCycleStateSourceServerLifecycle {
	s.State = &v
	return s
}

// The request could not be completed due to a conflict with the current state
// of the target resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// A conflict occurred when prompting for the Resource ID.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// A conflict occurred when prompting for resource type.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateReplicationConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// Request to associate the default Application Migration Service Security group
	// with the Replication Settings template.
	//
	// AssociateDefaultSecurityGroup is a required field
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean" required:"true"`

	// Request to configure bandwidth throttling during Replication Settings template
	// creation.
	//
	// BandwidthThrottling is a required field
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long" required:"true"`

	// Request to create Public IP during Replication Settings template creation.
	//
	// CreatePublicIP is a required field
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean" required:"true"`

	// Request to configure data plane routing during Replication Settings template
	// creation.
	//
	// DataPlaneRouting is a required field
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" required:"true" enum:"ReplicationConfigurationDataPlaneRouting"`

	// Request to configure the default large staging disk EBS volume type during
	// Replication Settings template creation.
	//
	// DefaultLargeStagingDiskType is a required field
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" required:"true" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// Request to configure EBS encryption during Replication Settings template
	// creation.
	//
	// EbsEncryption is a required field
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" required:"true" enum:"ReplicationConfigurationEbsEncryption"`

	// Request to configure an EBS encryption key during Replication Settings template
	// creation.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// Request to configure the Replication Server instance type during Replication
	// Settings template creation.
	//
	// ReplicationServerInstanceType is a required field
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string" required:"true"`

	// Request to configure the Replication Server Security group ID during Replication
	// Settings template creation.
	//
	// ReplicationServersSecurityGroupsIDs is a required field
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list" required:"true"`

	// Request to configure the Staging Area subnet ID during Replication Settings
	// template creation.
	//
	// StagingAreaSubnetId is a required field
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string" required:"true"`

	// Request to configure Staging Area tags during Replication Settings template
	// creation.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateReplicationConfigurationTemplateInput's
	// String and GoString methods.
	//
	// StagingAreaTags is a required field
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" required:"true" sensitive:"true"`

	// Request to configure tags during Replication Settings template creation.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateReplicationConfigurationTemplateInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Request to use Dedicated Replication Servers during Replication Settings
	// template creation.
	//
	// UseDedicatedReplicationServer is a required field
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigurationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationConfigurationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationConfigurationTemplateInput"}
	if s.AssociateDefaultSecurityGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociateDefaultSecurityGroup"))
	}
	if s.BandwidthThrottling == nil {
		invalidParams.Add(request.NewErrParamRequired("BandwidthThrottling"))
	}
	if s.CreatePublicIP == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatePublicIP"))
	}
	if s.DataPlaneRouting == nil {
		invalidParams.Add(request.NewErrParamRequired("DataPlaneRouting"))
	}
	if s.DefaultLargeStagingDiskType == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultLargeStagingDiskType"))
	}
	if s.EbsEncryption == nil {
		invalidParams.Add(request.NewErrParamRequired("EbsEncryption"))
	}
	if s.EbsEncryptionKeyArn != nil && len(*s.EbsEncryptionKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EbsEncryptionKeyArn", 20))
	}
	if s.ReplicationServerInstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationServerInstanceType"))
	}
	if s.ReplicationServersSecurityGroupsIDs == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationServersSecurityGroupsIDs"))
	}
	if s.StagingAreaSubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("StagingAreaSubnetId"))
	}
	if s.StagingAreaTags == nil {
		invalidParams.Add(request.NewErrParamRequired("StagingAreaTags"))
	}
	if s.UseDedicatedReplicationServer == nil {
		invalidParams.Add(request.NewErrParamRequired("UseDedicatedReplicationServer"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetAssociateDefaultSecurityGroup(v bool) *CreateReplicationConfigurationTemplateInput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetBandwidthThrottling(v int64) *CreateReplicationConfigurationTemplateInput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetCreatePublicIP(v bool) *CreateReplicationConfigurationTemplateInput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetDataPlaneRouting(v string) *CreateReplicationConfigurationTemplateInput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetDefaultLargeStagingDiskType(v string) *CreateReplicationConfigurationTemplateInput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetEbsEncryption(v string) *CreateReplicationConfigurationTemplateInput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetEbsEncryptionKeyArn(v string) *CreateReplicationConfigurationTemplateInput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetReplicationServerInstanceType(v string) *CreateReplicationConfigurationTemplateInput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetReplicationServersSecurityGroupsIDs(v []*string) *CreateReplicationConfigurationTemplateInput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetStagingAreaSubnetId(v string) *CreateReplicationConfigurationTemplateInput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetStagingAreaTags(v map[string]*string) *CreateReplicationConfigurationTemplateInput {
	s.StagingAreaTags = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetTags(v map[string]*string) *CreateReplicationConfigurationTemplateInput {
	s.Tags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *CreateReplicationConfigurationTemplateInput) SetUseDedicatedReplicationServer(v bool) *CreateReplicationConfigurationTemplateInput {
	s.UseDedicatedReplicationServer = &v
	return s
}

type CreateReplicationConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Replication Configuration template ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Replication Configuration template associate default Application Migration
	// Service Security group.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Replication Configuration template bandwidth throttling.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Replication Configuration template create Public IP.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// Replication Configuration template data plane routing.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// Replication Configuration template use default large Staging Disk type.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// Replication Configuration template EBS encryption.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// Replication Configuration template EBS encryption key ARN.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// Replication Configuration template ID.
	//
	// ReplicationConfigurationTemplateID is a required field
	ReplicationConfigurationTemplateID *string `locationName:"replicationConfigurationTemplateID" min:"21" type:"string" required:"true"`

	// Replication Configuration template server instance type.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// Replication Configuration template server Security Groups IDs.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// Replication Configuration template Staging Area subnet ID.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// Replication Configuration template Staging Area Tags.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateReplicationConfigurationTemplateOutput's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// Replication Configuration template Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateReplicationConfigurationTemplateOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Replication Configuration template use Dedicated Replication Server.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigurationTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetArn(v string) *CreateReplicationConfigurationTemplateOutput {
	s.Arn = &v
	return s
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetAssociateDefaultSecurityGroup(v bool) *CreateReplicationConfigurationTemplateOutput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetBandwidthThrottling(v int64) *CreateReplicationConfigurationTemplateOutput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetCreatePublicIP(v bool) *CreateReplicationConfigurationTemplateOutput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetDataPlaneRouting(v string) *CreateReplicationConfigurationTemplateOutput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetDefaultLargeStagingDiskType(v string) *CreateReplicationConfigurationTemplateOutput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetEbsEncryption(v string) *CreateReplicationConfigurationTemplateOutput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetEbsEncryptionKeyArn(v string) *CreateReplicationConfigurationTemplateOutput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetReplicationConfigurationTemplateID sets the ReplicationConfigurationTemplateID field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetReplicationConfigurationTemplateID(v string) *CreateReplicationConfigurationTemplateOutput {
	s.ReplicationConfigurationTemplateID = &v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetReplicationServerInstanceType(v string) *CreateReplicationConfigurationTemplateOutput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetReplicationServersSecurityGroupsIDs(v []*string) *CreateReplicationConfigurationTemplateOutput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetStagingAreaSubnetId(v string) *CreateReplicationConfigurationTemplateOutput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetStagingAreaTags(v map[string]*string) *CreateReplicationConfigurationTemplateOutput {
	s.StagingAreaTags = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetTags(v map[string]*string) *CreateReplicationConfigurationTemplateOutput {
	s.Tags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *CreateReplicationConfigurationTemplateOutput) SetUseDedicatedReplicationServer(v bool) *CreateReplicationConfigurationTemplateOutput {
	s.UseDedicatedReplicationServer = &v
	return s
}

// Error in data replication.
type DataReplicationError struct {
	_ struct{} `type:"structure"`

	// Error in data replication.
	Error *string `locationName:"error" type:"string" enum:"DataReplicationErrorString"`

	// Error in data replication.
	RawError *string `locationName:"rawError" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationError) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *DataReplicationError) SetError(v string) *DataReplicationError {
	s.Error = &v
	return s
}

// SetRawError sets the RawError field's value.
func (s *DataReplicationError) SetRawError(v string) *DataReplicationError {
	s.RawError = &v
	return s
}

// Request data replication info.
type DataReplicationInfo struct {
	_ struct{} `type:"structure"`

	// Error in obtaining data replication info.
	DataReplicationError *DataReplicationError `locationName:"dataReplicationError" type:"structure"`

	// Request to query whether data replication has been initiated.
	DataReplicationInitiation *DataReplicationInitiation `locationName:"dataReplicationInitiation" type:"structure"`

	// Request to query the data replication state.
	DataReplicationState *string `locationName:"dataReplicationState" type:"string" enum:"DataReplicationState"`

	// Request to query the time when data replication will be complete.
	EtaDateTime *string `locationName:"etaDateTime" min:"19" type:"string"`

	// Request to query data replication lag duration.
	LagDuration *string `locationName:"lagDuration" min:"19" type:"string"`

	// Request to query data replication last snapshot time.
	LastSnapshotDateTime *string `locationName:"lastSnapshotDateTime" min:"19" type:"string"`

	// Request to query disks replicated.
	ReplicatedDisks []*DataReplicationInfoReplicatedDisk `locationName:"replicatedDisks" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInfo) GoString() string {
	return s.String()
}

// SetDataReplicationError sets the DataReplicationError field's value.
func (s *DataReplicationInfo) SetDataReplicationError(v *DataReplicationError) *DataReplicationInfo {
	s.DataReplicationError = v
	return s
}

// SetDataReplicationInitiation sets the DataReplicationInitiation field's value.
func (s *DataReplicationInfo) SetDataReplicationInitiation(v *DataReplicationInitiation) *DataReplicationInfo {
	s.DataReplicationInitiation = v
	return s
}

// SetDataReplicationState sets the DataReplicationState field's value.
func (s *DataReplicationInfo) SetDataReplicationState(v string) *DataReplicationInfo {
	s.DataReplicationState = &v
	return s
}

// SetEtaDateTime sets the EtaDateTime field's value.
func (s *DataReplicationInfo) SetEtaDateTime(v string) *DataReplicationInfo {
	s.EtaDateTime = &v
	return s
}

// SetLagDuration sets the LagDuration field's value.
func (s *DataReplicationInfo) SetLagDuration(v string) *DataReplicationInfo {
	s.LagDuration = &v
	return s
}

// SetLastSnapshotDateTime sets the LastSnapshotDateTime field's value.
func (s *DataReplicationInfo) SetLastSnapshotDateTime(v string) *DataReplicationInfo {
	s.LastSnapshotDateTime = &v
	return s
}

// SetReplicatedDisks sets the ReplicatedDisks field's value.
func (s *DataReplicationInfo) SetReplicatedDisks(v []*DataReplicationInfoReplicatedDisk) *DataReplicationInfo {
	s.ReplicatedDisks = v
	return s
}

// Request to query disks replicated.
type DataReplicationInfoReplicatedDisk struct {
	_ struct{} `type:"structure"`

	// Request to query data replication backlog size in bytes.
	BackloggedStorageBytes *int64 `locationName:"backloggedStorageBytes" type:"long"`

	// Request to query device name.
	DeviceName *string `locationName:"deviceName" type:"string"`

	// Request to query amount of data replicated in bytes.
	ReplicatedStorageBytes *int64 `locationName:"replicatedStorageBytes" type:"long"`

	// Request to query amount of data rescanned in bytes.
	RescannedStorageBytes *int64 `locationName:"rescannedStorageBytes" type:"long"`

	// Request to query total amount of data replicated in bytes.
	TotalStorageBytes *int64 `locationName:"totalStorageBytes" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInfoReplicatedDisk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInfoReplicatedDisk) GoString() string {
	return s.String()
}

// SetBackloggedStorageBytes sets the BackloggedStorageBytes field's value.
func (s *DataReplicationInfoReplicatedDisk) SetBackloggedStorageBytes(v int64) *DataReplicationInfoReplicatedDisk {
	s.BackloggedStorageBytes = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *DataReplicationInfoReplicatedDisk) SetDeviceName(v string) *DataReplicationInfoReplicatedDisk {
	s.DeviceName = &v
	return s
}

// SetReplicatedStorageBytes sets the ReplicatedStorageBytes field's value.
func (s *DataReplicationInfoReplicatedDisk) SetReplicatedStorageBytes(v int64) *DataReplicationInfoReplicatedDisk {
	s.ReplicatedStorageBytes = &v
	return s
}

// SetRescannedStorageBytes sets the RescannedStorageBytes field's value.
func (s *DataReplicationInfoReplicatedDisk) SetRescannedStorageBytes(v int64) *DataReplicationInfoReplicatedDisk {
	s.RescannedStorageBytes = &v
	return s
}

// SetTotalStorageBytes sets the TotalStorageBytes field's value.
func (s *DataReplicationInfoReplicatedDisk) SetTotalStorageBytes(v int64) *DataReplicationInfoReplicatedDisk {
	s.TotalStorageBytes = &v
	return s
}

// Data replication initiation.
type DataReplicationInitiation struct {
	_ struct{} `type:"structure"`

	// Request to query next data initiation date and time.
	NextAttemptDateTime *string `locationName:"nextAttemptDateTime" min:"19" type:"string"`

	// Request to query data initiation start date and time.
	StartDateTime *string `locationName:"startDateTime" min:"19" type:"string"`

	// Request to query data initiation steps.
	Steps []*DataReplicationInitiationStep `locationName:"steps" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInitiation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInitiation) GoString() string {
	return s.String()
}

// SetNextAttemptDateTime sets the NextAttemptDateTime field's value.
func (s *DataReplicationInitiation) SetNextAttemptDateTime(v string) *DataReplicationInitiation {
	s.NextAttemptDateTime = &v
	return s
}

// SetStartDateTime sets the StartDateTime field's value.
func (s *DataReplicationInitiation) SetStartDateTime(v string) *DataReplicationInitiation {
	s.StartDateTime = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *DataReplicationInitiation) SetSteps(v []*DataReplicationInitiationStep) *DataReplicationInitiation {
	s.Steps = v
	return s
}

// Data replication initiation step.
type DataReplicationInitiationStep struct {
	_ struct{} `type:"structure"`

	// Request to query data initiation step name.
	Name *string `locationName:"name" type:"string" enum:"DataReplicationInitiationStepName"`

	// Request to query data initiation status.
	Status *string `locationName:"status" type:"string" enum:"DataReplicationInitiationStepStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInitiationStep) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataReplicationInitiationStep) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DataReplicationInitiationStep) SetName(v string) *DataReplicationInitiationStep {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataReplicationInitiationStep) SetStatus(v string) *DataReplicationInitiationStep {
	s.Status = &v
	return s
}

type DeleteJobInput struct {
	_ struct{} `type:"structure"`

	// Request to delete Job from service by Job ID.
	//
	// JobID is a required field
	JobID *string `locationName:"jobID" min:"24" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobInput"}
	if s.JobID == nil {
		invalidParams.Add(request.NewErrParamRequired("JobID"))
	}
	if s.JobID != nil && len(*s.JobID) < 24 {
		invalidParams.Add(request.NewErrParamMinLen("JobID", 24))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobID sets the JobID field's value.
func (s *DeleteJobInput) SetJobID(v string) *DeleteJobInput {
	s.JobID = &v
	return s
}

type DeleteJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteJobOutput) GoString() string {
	return s.String()
}

type DeleteReplicationConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// Request to delete Replication Configuration Template from service by Replication
	// Configuration Template ID.
	//
	// ReplicationConfigurationTemplateID is a required field
	ReplicationConfigurationTemplateID *string `locationName:"replicationConfigurationTemplateID" min:"21" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigurationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationConfigurationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationConfigurationTemplateInput"}
	if s.ReplicationConfigurationTemplateID == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationConfigurationTemplateID"))
	}
	if s.ReplicationConfigurationTemplateID != nil && len(*s.ReplicationConfigurationTemplateID) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("ReplicationConfigurationTemplateID", 21))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationConfigurationTemplateID sets the ReplicationConfigurationTemplateID field's value.
func (s *DeleteReplicationConfigurationTemplateInput) SetReplicationConfigurationTemplateID(v string) *DeleteReplicationConfigurationTemplateInput {
	s.ReplicationConfigurationTemplateID = &v
	return s
}

type DeleteReplicationConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigurationTemplateOutput) GoString() string {
	return s.String()
}

type DeleteSourceServerInput struct {
	_ struct{} `type:"structure"`

	// Request to delete Source Server from service by Server ID.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSourceServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSourceServerInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *DeleteSourceServerInput) SetSourceServerID(v string) *DeleteSourceServerInput {
	s.SourceServerID = &v
	return s
}

type DeleteSourceServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSourceServerOutput) GoString() string {
	return s.String()
}

type DeleteVcenterClientInput struct {
	_ struct{} `type:"structure"`

	// ID of resource to be deleted.
	//
	// VcenterClientID is a required field
	VcenterClientID *string `locationName:"vcenterClientID" min:"21" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVcenterClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVcenterClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVcenterClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVcenterClientInput"}
	if s.VcenterClientID == nil {
		invalidParams.Add(request.NewErrParamRequired("VcenterClientID"))
	}
	if s.VcenterClientID != nil && len(*s.VcenterClientID) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("VcenterClientID", 21))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVcenterClientID sets the VcenterClientID field's value.
func (s *DeleteVcenterClientInput) SetVcenterClientID(v string) *DeleteVcenterClientInput {
	s.VcenterClientID = &v
	return s
}

type DeleteVcenterClientOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVcenterClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVcenterClientOutput) GoString() string {
	return s.String()
}

type DescribeJobLogItemsInput struct {
	_ struct{} `type:"structure"`

	// Request to describe Job log job ID.
	//
	// JobID is a required field
	JobID *string `locationName:"jobID" min:"24" type:"string" required:"true"`

	// Request to describe Job log item maximum results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Request to describe Job log next token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobLogItemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobLogItemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobLogItemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobLogItemsInput"}
	if s.JobID == nil {
		invalidParams.Add(request.NewErrParamRequired("JobID"))
	}
	if s.JobID != nil && len(*s.JobID) < 24 {
		invalidParams.Add(request.NewErrParamMinLen("JobID", 24))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobID sets the JobID field's value.
func (s *DescribeJobLogItemsInput) SetJobID(v string) *DescribeJobLogItemsInput {
	s.JobID = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeJobLogItemsInput) SetMaxResults(v int64) *DescribeJobLogItemsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobLogItemsInput) SetNextToken(v string) *DescribeJobLogItemsInput {
	s.NextToken = &v
	return s
}

type DescribeJobLogItemsOutput struct {
	_ struct{} `type:"structure"`

	// Request to describe Job log response items.
	Items []*JobLog `locationName:"items" type:"list"`

	// Request to describe Job log response next token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobLogItemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobLogItemsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeJobLogItemsOutput) SetItems(v []*JobLog) *DescribeJobLogItemsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobLogItemsOutput) SetNextToken(v string) *DescribeJobLogItemsOutput {
	s.NextToken = &v
	return s
}

type DescribeJobsInput struct {
	_ struct{} `type:"structure"`

	// Request to describe Job log filters.
	Filters *DescribeJobsRequestFilters `locationName:"filters" type:"structure"`

	// Request to describe job log items by max results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Request to describe job log items by next token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeJobsInput) SetFilters(v *DescribeJobsRequestFilters) *DescribeJobsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeJobsInput) SetMaxResults(v int64) *DescribeJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobsInput) SetNextToken(v string) *DescribeJobsInput {
	s.NextToken = &v
	return s
}

type DescribeJobsOutput struct {
	_ struct{} `type:"structure"`

	// Request to describe Job log items.
	Items []*Job `locationName:"items" type:"list"`

	// Request to describe Job response by next token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeJobsOutput) SetItems(v []*Job) *DescribeJobsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobsOutput) SetNextToken(v string) *DescribeJobsOutput {
	s.NextToken = &v
	return s
}

// Request to describe Job log filters.
type DescribeJobsRequestFilters struct {
	_ struct{} `type:"structure"`

	// Request to describe Job log filters by date.
	FromDate *string `locationName:"fromDate" min:"19" type:"string"`

	// Request to describe Job log filters by job ID.
	JobIDs []*string `locationName:"jobIDs" type:"list"`

	// Request to describe job log items by last date.
	ToDate *string `locationName:"toDate" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsRequestFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeJobsRequestFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobsRequestFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobsRequestFilters"}
	if s.FromDate != nil && len(*s.FromDate) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("FromDate", 19))
	}
	if s.ToDate != nil && len(*s.ToDate) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("ToDate", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromDate sets the FromDate field's value.
func (s *DescribeJobsRequestFilters) SetFromDate(v string) *DescribeJobsRequestFilters {
	s.FromDate = &v
	return s
}

// SetJobIDs sets the JobIDs field's value.
func (s *DescribeJobsRequestFilters) SetJobIDs(v []*string) *DescribeJobsRequestFilters {
	s.JobIDs = v
	return s
}

// SetToDate sets the ToDate field's value.
func (s *DescribeJobsRequestFilters) SetToDate(v string) *DescribeJobsRequestFilters {
	s.ToDate = &v
	return s
}

type DescribeReplicationConfigurationTemplatesInput struct {
	_ struct{} `type:"structure"`

	// Request to describe Replication Configuration template by max results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Request to describe Replication Configuration template by next token.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Request to describe Replication Configuration template by template IDs.
	ReplicationConfigurationTemplateIDs []*string `locationName:"replicationConfigurationTemplateIDs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigurationTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigurationTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationConfigurationTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationConfigurationTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReplicationConfigurationTemplatesInput) SetMaxResults(v int64) *DescribeReplicationConfigurationTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReplicationConfigurationTemplatesInput) SetNextToken(v string) *DescribeReplicationConfigurationTemplatesInput {
	s.NextToken = &v
	return s
}

// SetReplicationConfigurationTemplateIDs sets the ReplicationConfigurationTemplateIDs field's value.
func (s *DescribeReplicationConfigurationTemplatesInput) SetReplicationConfigurationTemplateIDs(v []*string) *DescribeReplicationConfigurationTemplatesInput {
	s.ReplicationConfigurationTemplateIDs = v
	return s
}

type DescribeReplicationConfigurationTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// Request to describe Replication Configuration template by items.
	Items []*ReplicationConfigurationTemplate `locationName:"items" type:"list"`

	// Request to describe Replication Configuration template by next token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigurationTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigurationTemplatesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeReplicationConfigurationTemplatesOutput) SetItems(v []*ReplicationConfigurationTemplate) *DescribeReplicationConfigurationTemplatesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReplicationConfigurationTemplatesOutput) SetNextToken(v string) *DescribeReplicationConfigurationTemplatesOutput {
	s.NextToken = &v
	return s
}

type DescribeSourceServersInput struct {
	_ struct{} `type:"structure"`

	// Request to filter Source Servers list.
	Filters *DescribeSourceServersRequestFilters `locationName:"filters" type:"structure"`

	// Request to filter Source Servers list by maximum results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// Request to filter Source Servers list by next token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceServersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceServersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSourceServersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSourceServersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeSourceServersInput) SetFilters(v *DescribeSourceServersRequestFilters) *DescribeSourceServersInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSourceServersInput) SetMaxResults(v int64) *DescribeSourceServersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSourceServersInput) SetNextToken(v string) *DescribeSourceServersInput {
	s.NextToken = &v
	return s
}

type DescribeSourceServersOutput struct {
	_ struct{} `type:"structure"`

	// Request to filter Source Servers list by item.
	Items []*SourceServer `locationName:"items" type:"list"`

	// Request to filter Source Servers next token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceServersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceServersOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeSourceServersOutput) SetItems(v []*SourceServer) *DescribeSourceServersOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSourceServersOutput) SetNextToken(v string) *DescribeSourceServersOutput {
	s.NextToken = &v
	return s
}

// Request to filter Source Servers list.
type DescribeSourceServersRequestFilters struct {
	_ struct{} `type:"structure"`

	// Request to filter Source Servers list by archived.
	IsArchived *bool `locationName:"isArchived" type:"boolean"`

	// Request to filter Source Servers list by life cycle states.
	LifeCycleStates []*string `locationName:"lifeCycleStates" type:"list" enum:"LifeCycleState"`

	// Request to filter Source Servers list by replication type.
	ReplicationTypes []*string `locationName:"replicationTypes" type:"list" enum:"ReplicationType"`

	// Request to filter Source Servers list by Source Server ID.
	SourceServerIDs []*string `locationName:"sourceServerIDs" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceServersRequestFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSourceServersRequestFilters) GoString() string {
	return s.String()
}

// SetIsArchived sets the IsArchived field's value.
func (s *DescribeSourceServersRequestFilters) SetIsArchived(v bool) *DescribeSourceServersRequestFilters {
	s.IsArchived = &v
	return s
}

// SetLifeCycleStates sets the LifeCycleStates field's value.
func (s *DescribeSourceServersRequestFilters) SetLifeCycleStates(v []*string) *DescribeSourceServersRequestFilters {
	s.LifeCycleStates = v
	return s
}

// SetReplicationTypes sets the ReplicationTypes field's value.
func (s *DescribeSourceServersRequestFilters) SetReplicationTypes(v []*string) *DescribeSourceServersRequestFilters {
	s.ReplicationTypes = v
	return s
}

// SetSourceServerIDs sets the SourceServerIDs field's value.
func (s *DescribeSourceServersRequestFilters) SetSourceServerIDs(v []*string) *DescribeSourceServersRequestFilters {
	s.SourceServerIDs = v
	return s
}

type DescribeVcenterClientsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Maximum results to be returned in DescribeVcenterClients.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Next pagination token to be provided for DescribeVcenterClients.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVcenterClientsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVcenterClientsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVcenterClientsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVcenterClientsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeVcenterClientsInput) SetMaxResults(v int64) *DescribeVcenterClientsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeVcenterClientsInput) SetNextToken(v string) *DescribeVcenterClientsInput {
	s.NextToken = &v
	return s
}

type DescribeVcenterClientsOutput struct {
	_ struct{} `type:"structure"`

	// List of items returned by DescribeVcenterClients.
	Items []*VcenterClient `locationName:"items" type:"list"`

	// Next pagination token returned from DescribeVcenterClients.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVcenterClientsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVcenterClientsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *DescribeVcenterClientsOutput) SetItems(v []*VcenterClient) *DescribeVcenterClientsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeVcenterClientsOutput) SetNextToken(v string) *DescribeVcenterClientsOutput {
	s.NextToken = &v
	return s
}

type DisconnectFromServiceInput struct {
	_ struct{} `type:"structure"`

	// Request to disconnect Source Server from service by Server ID.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectFromServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectFromServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectFromServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisconnectFromServiceInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *DisconnectFromServiceInput) SetSourceServerID(v string) *DisconnectFromServiceInput {
	s.SourceServerID = &v
	return s
}

type DisconnectFromServiceOutput struct {
	_ struct{} `type:"structure"`

	// Source server ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Source server data replication info.
	DataReplicationInfo *DataReplicationInfo `locationName:"dataReplicationInfo" type:"structure"`

	// Source server archived status.
	IsArchived *bool `locationName:"isArchived" type:"boolean"`

	// Source server launched instance.
	LaunchedInstance *LaunchedInstance `locationName:"launchedInstance" type:"structure"`

	// Source server lifecycle state.
	LifeCycle *LifeCycle `locationName:"lifeCycle" type:"structure"`

	// Source server replication type.
	ReplicationType *string `locationName:"replicationType" type:"string" enum:"ReplicationType"`

	// Source server properties.
	SourceProperties *SourceProperties `locationName:"sourceProperties" type:"structure"`

	// Source server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Source server Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DisconnectFromServiceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Source server vCenter client id.
	VcenterClientID *string `locationName:"vcenterClientID" min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectFromServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectFromServiceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DisconnectFromServiceOutput) SetArn(v string) *DisconnectFromServiceOutput {
	s.Arn = &v
	return s
}

// SetDataReplicationInfo sets the DataReplicationInfo field's value.
func (s *DisconnectFromServiceOutput) SetDataReplicationInfo(v *DataReplicationInfo) *DisconnectFromServiceOutput {
	s.DataReplicationInfo = v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *DisconnectFromServiceOutput) SetIsArchived(v bool) *DisconnectFromServiceOutput {
	s.IsArchived = &v
	return s
}

// SetLaunchedInstance sets the LaunchedInstance field's value.
func (s *DisconnectFromServiceOutput) SetLaunchedInstance(v *LaunchedInstance) *DisconnectFromServiceOutput {
	s.LaunchedInstance = v
	return s
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *DisconnectFromServiceOutput) SetLifeCycle(v *LifeCycle) *DisconnectFromServiceOutput {
	s.LifeCycle = v
	return s
}

// SetReplicationType sets the ReplicationType field's value.
func (s *DisconnectFromServiceOutput) SetReplicationType(v string) *DisconnectFromServiceOutput {
	s.ReplicationType = &v
	return s
}

// SetSourceProperties sets the SourceProperties field's value.
func (s *DisconnectFromServiceOutput) SetSourceProperties(v *SourceProperties) *DisconnectFromServiceOutput {
	s.SourceProperties = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *DisconnectFromServiceOutput) SetSourceServerID(v string) *DisconnectFromServiceOutput {
	s.SourceServerID = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DisconnectFromServiceOutput) SetTags(v map[string]*string) *DisconnectFromServiceOutput {
	s.Tags = v
	return s
}

// SetVcenterClientID sets the VcenterClientID field's value.
func (s *DisconnectFromServiceOutput) SetVcenterClientID(v string) *DisconnectFromServiceOutput {
	s.VcenterClientID = &v
	return s
}

// The disk identifier.
type Disk struct {
	_ struct{} `type:"structure"`

	// The amount of storage on the disk in bytes.
	Bytes *int64 `locationName:"bytes" type:"long"`

	// The disk or device name.
	DeviceName *string `locationName:"deviceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Disk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Disk) GoString() string {
	return s.String()
}

// SetBytes sets the Bytes field's value.
func (s *Disk) SetBytes(v int64) *Disk {
	s.Bytes = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *Disk) SetDeviceName(v string) *Disk {
	s.DeviceName = &v
	return s
}

type FinalizeCutoverInput struct {
	_ struct{} `type:"structure"`

	// Request to finalize Cutover by Source Server ID.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FinalizeCutoverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FinalizeCutoverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FinalizeCutoverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FinalizeCutoverInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *FinalizeCutoverInput) SetSourceServerID(v string) *FinalizeCutoverInput {
	s.SourceServerID = &v
	return s
}

type FinalizeCutoverOutput struct {
	_ struct{} `type:"structure"`

	// Source server ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Source server data replication info.
	DataReplicationInfo *DataReplicationInfo `locationName:"dataReplicationInfo" type:"structure"`

	// Source server archived status.
	IsArchived *bool `locationName:"isArchived" type:"boolean"`

	// Source server launched instance.
	LaunchedInstance *LaunchedInstance `locationName:"launchedInstance" type:"structure"`

	// Source server lifecycle state.
	LifeCycle *LifeCycle `locationName:"lifeCycle" type:"structure"`

	// Source server replication type.
	ReplicationType *string `locationName:"replicationType" type:"string" enum:"ReplicationType"`

	// Source server properties.
	SourceProperties *SourceProperties `locationName:"sourceProperties" type:"structure"`

	// Source server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Source server Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FinalizeCutoverOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Source server vCenter client id.
	VcenterClientID *string `locationName:"vcenterClientID" min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FinalizeCutoverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FinalizeCutoverOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FinalizeCutoverOutput) SetArn(v string) *FinalizeCutoverOutput {
	s.Arn = &v
	return s
}

// SetDataReplicationInfo sets the DataReplicationInfo field's value.
func (s *FinalizeCutoverOutput) SetDataReplicationInfo(v *DataReplicationInfo) *FinalizeCutoverOutput {
	s.DataReplicationInfo = v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *FinalizeCutoverOutput) SetIsArchived(v bool) *FinalizeCutoverOutput {
	s.IsArchived = &v
	return s
}

// SetLaunchedInstance sets the LaunchedInstance field's value.
func (s *FinalizeCutoverOutput) SetLaunchedInstance(v *LaunchedInstance) *FinalizeCutoverOutput {
	s.LaunchedInstance = v
	return s
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *FinalizeCutoverOutput) SetLifeCycle(v *LifeCycle) *FinalizeCutoverOutput {
	s.LifeCycle = v
	return s
}

// SetReplicationType sets the ReplicationType field's value.
func (s *FinalizeCutoverOutput) SetReplicationType(v string) *FinalizeCutoverOutput {
	s.ReplicationType = &v
	return s
}

// SetSourceProperties sets the SourceProperties field's value.
func (s *FinalizeCutoverOutput) SetSourceProperties(v *SourceProperties) *FinalizeCutoverOutput {
	s.SourceProperties = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *FinalizeCutoverOutput) SetSourceServerID(v string) *FinalizeCutoverOutput {
	s.SourceServerID = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *FinalizeCutoverOutput) SetTags(v map[string]*string) *FinalizeCutoverOutput {
	s.Tags = v
	return s
}

// SetVcenterClientID sets the VcenterClientID field's value.
func (s *FinalizeCutoverOutput) SetVcenterClientID(v string) *FinalizeCutoverOutput {
	s.VcenterClientID = &v
	return s
}

type GetLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Request to get Launch Configuration information by Source Server ID.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLaunchConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLaunchConfigurationInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *GetLaunchConfigurationInput) SetSourceServerID(v string) *GetLaunchConfigurationInput {
	s.SourceServerID = &v
	return s
}

type GetLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Launch configuration boot mode.
	BootMode *string `locationName:"bootMode" type:"string" enum:"BootMode"`

	// Copy Private IP during Launch Configuration.
	CopyPrivateIp *bool `locationName:"copyPrivateIp" type:"boolean"`

	// Copy Tags during Launch Configuration.
	CopyTags *bool `locationName:"copyTags" type:"boolean"`

	// Launch configuration EC2 Launch template ID.
	Ec2LaunchTemplateID *string `locationName:"ec2LaunchTemplateID" type:"string"`

	// Launch disposition for launch configuration.
	LaunchDisposition *string `locationName:"launchDisposition" type:"string" enum:"LaunchDisposition"`

	// Launch configuration OS licensing.
	Licensing *Licensing `locationName:"licensing" type:"structure"`

	// Launch configuration name.
	Name *string `locationName:"name" type:"string"`

	// Launch configuration Source Server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Launch configuration Target instance type right sizing method.
	TargetInstanceTypeRightSizingMethod *string `locationName:"targetInstanceTypeRightSizingMethod" type:"string" enum:"TargetInstanceTypeRightSizingMethod"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLaunchConfigurationOutput) GoString() string {
	return s.String()
}

// SetBootMode sets the BootMode field's value.
func (s *GetLaunchConfigurationOutput) SetBootMode(v string) *GetLaunchConfigurationOutput {
	s.BootMode = &v
	return s
}

// SetCopyPrivateIp sets the CopyPrivateIp field's value.
func (s *GetLaunchConfigurationOutput) SetCopyPrivateIp(v bool) *GetLaunchConfigurationOutput {
	s.CopyPrivateIp = &v
	return s
}

// SetCopyTags sets the CopyTags field's value.
func (s *GetLaunchConfigurationOutput) SetCopyTags(v bool) *GetLaunchConfigurationOutput {
	s.CopyTags = &v
	return s
}

// SetEc2LaunchTemplateID sets the Ec2LaunchTemplateID field's value.
func (s *GetLaunchConfigurationOutput) SetEc2LaunchTemplateID(v string) *GetLaunchConfigurationOutput {
	s.Ec2LaunchTemplateID = &v
	return s
}

// SetLaunchDisposition sets the LaunchDisposition field's value.
func (s *GetLaunchConfigurationOutput) SetLaunchDisposition(v string) *GetLaunchConfigurationOutput {
	s.LaunchDisposition = &v
	return s
}

// SetLicensing sets the Licensing field's value.
func (s *GetLaunchConfigurationOutput) SetLicensing(v *Licensing) *GetLaunchConfigurationOutput {
	s.Licensing = v
	return s
}

// SetName sets the Name field's value.
func (s *GetLaunchConfigurationOutput) SetName(v string) *GetLaunchConfigurationOutput {
	s.Name = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *GetLaunchConfigurationOutput) SetSourceServerID(v string) *GetLaunchConfigurationOutput {
	s.SourceServerID = &v
	return s
}

// SetTargetInstanceTypeRightSizingMethod sets the TargetInstanceTypeRightSizingMethod field's value.
func (s *GetLaunchConfigurationOutput) SetTargetInstanceTypeRightSizingMethod(v string) *GetLaunchConfigurationOutput {
	s.TargetInstanceTypeRightSizingMethod = &v
	return s
}

type GetReplicationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Request to get Replication Configuration by Source Server ID.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReplicationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReplicationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetReplicationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetReplicationConfigurationInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *GetReplicationConfigurationInput) SetSourceServerID(v string) *GetReplicationConfigurationInput {
	s.SourceServerID = &v
	return s
}

type GetReplicationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Replication Configuration associate default Application Migration Service
	// Security Group.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Replication Configuration set bandwidth throttling.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Replication Configuration create Public IP.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// Replication Configuration data plane routing.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// Replication Configuration use default large Staging Disks.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// Replication Configuration EBS encryption.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// Replication Configuration EBS encryption key ARN.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// Replication Configuration name.
	Name *string `locationName:"name" type:"string"`

	// Replication Configuration replicated disks.
	ReplicatedDisks []*ReplicationConfigurationReplicatedDisk `locationName:"replicatedDisks" type:"list"`

	// Replication Configuration Replication Server instance type.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// Replication Configuration Replication Server Security Group IDs.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// Replication Configuration Source Server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Replication Configuration Staging Area subnet ID.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// Replication Configuration Staging Area tags.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetReplicationConfigurationOutput's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// Replication Configuration use Dedicated Replication Server.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReplicationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetReplicationConfigurationOutput) GoString() string {
	return s.String()
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *GetReplicationConfigurationOutput) SetAssociateDefaultSecurityGroup(v bool) *GetReplicationConfigurationOutput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *GetReplicationConfigurationOutput) SetBandwidthThrottling(v int64) *GetReplicationConfigurationOutput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *GetReplicationConfigurationOutput) SetCreatePublicIP(v bool) *GetReplicationConfigurationOutput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *GetReplicationConfigurationOutput) SetDataPlaneRouting(v string) *GetReplicationConfigurationOutput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *GetReplicationConfigurationOutput) SetDefaultLargeStagingDiskType(v string) *GetReplicationConfigurationOutput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *GetReplicationConfigurationOutput) SetEbsEncryption(v string) *GetReplicationConfigurationOutput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *GetReplicationConfigurationOutput) SetEbsEncryptionKeyArn(v string) *GetReplicationConfigurationOutput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetReplicationConfigurationOutput) SetName(v string) *GetReplicationConfigurationOutput {
	s.Name = &v
	return s
}

// SetReplicatedDisks sets the ReplicatedDisks field's value.
func (s *GetReplicationConfigurationOutput) SetReplicatedDisks(v []*ReplicationConfigurationReplicatedDisk) *GetReplicationConfigurationOutput {
	s.ReplicatedDisks = v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *GetReplicationConfigurationOutput) SetReplicationServerInstanceType(v string) *GetReplicationConfigurationOutput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *GetReplicationConfigurationOutput) SetReplicationServersSecurityGroupsIDs(v []*string) *GetReplicationConfigurationOutput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *GetReplicationConfigurationOutput) SetSourceServerID(v string) *GetReplicationConfigurationOutput {
	s.SourceServerID = &v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *GetReplicationConfigurationOutput) SetStagingAreaSubnetId(v string) *GetReplicationConfigurationOutput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *GetReplicationConfigurationOutput) SetStagingAreaTags(v map[string]*string) *GetReplicationConfigurationOutput {
	s.StagingAreaTags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *GetReplicationConfigurationOutput) SetUseDedicatedReplicationServer(v bool) *GetReplicationConfigurationOutput {
	s.UseDedicatedReplicationServer = &v
	return s
}

// Identification hints.
type IdentificationHints struct {
	_ struct{} `type:"structure"`

	// AWS Instance ID identification hint.
	AwsInstanceID *string `locationName:"awsInstanceID" type:"string"`

	// FQDN address identification hint.
	Fqdn *string `locationName:"fqdn" type:"string"`

	// Hostname identification hint.
	Hostname *string `locationName:"hostname" type:"string"`

	// vCenter VM path identification hint.
	VmPath *string `locationName:"vmPath" type:"string"`

	// vmWare UUID identification hint.
	VmWareUuid *string `locationName:"vmWareUuid" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentificationHints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentificationHints) GoString() string {
	return s.String()
}

// SetAwsInstanceID sets the AwsInstanceID field's value.
func (s *IdentificationHints) SetAwsInstanceID(v string) *IdentificationHints {
	s.AwsInstanceID = &v
	return s
}

// SetFqdn sets the Fqdn field's value.
func (s *IdentificationHints) SetFqdn(v string) *IdentificationHints {
	s.Fqdn = &v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *IdentificationHints) SetHostname(v string) *IdentificationHints {
	s.Hostname = &v
	return s
}

// SetVmPath sets the VmPath field's value.
func (s *IdentificationHints) SetVmPath(v string) *IdentificationHints {
	s.VmPath = &v
	return s
}

// SetVmWareUuid sets the VmWareUuid field's value.
func (s *IdentificationHints) SetVmWareUuid(v string) *IdentificationHints {
	s.VmWareUuid = &v
	return s
}

type InitializeServiceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitializeServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitializeServiceInput) GoString() string {
	return s.String()
}

type InitializeServiceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitializeServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InitializeServiceOutput) GoString() string {
	return s.String()
}

// The server encountered an unexpected condition that prevented it from fulfilling
// the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The server encountered an unexpected condition that prevented it from fulfilling
	// the request. The request will be retried again after x seconds.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Job.
type Job struct {
	_ struct{} `type:"structure"`

	// the ARN of the specific Job.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Job creation time.
	CreationDateTime *string `locationName:"creationDateTime" min:"19" type:"string"`

	// Job end time.
	EndDateTime *string `locationName:"endDateTime" min:"19" type:"string"`

	// Job initiated by field.
	InitiatedBy *string `locationName:"initiatedBy" type:"string" enum:"InitiatedBy"`

	// Job ID.
	//
	// JobID is a required field
	JobID *string `locationName:"jobID" min:"24" type:"string" required:"true"`

	// Servers participating in a specific Job.
	ParticipatingServers []*ParticipatingServer `locationName:"participatingServers" type:"list"`

	// Job status.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`

	// Tags associated with specific Job.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Job's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Job type.
	Type *string `locationName:"type" type:"string" enum:"JobType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Job) SetArn(v string) *Job {
	s.Arn = &v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *Job) SetCreationDateTime(v string) *Job {
	s.CreationDateTime = &v
	return s
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *Job) SetEndDateTime(v string) *Job {
	s.EndDateTime = &v
	return s
}

// SetInitiatedBy sets the InitiatedBy field's value.
func (s *Job) SetInitiatedBy(v string) *Job {
	s.InitiatedBy = &v
	return s
}

// SetJobID sets the JobID field's value.
func (s *Job) SetJobID(v string) *Job {
	s.JobID = &v
	return s
}

// SetParticipatingServers sets the ParticipatingServers field's value.
func (s *Job) SetParticipatingServers(v []*ParticipatingServer) *Job {
	s.ParticipatingServers = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Job) SetStatus(v string) *Job {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Job) SetTags(v map[string]*string) *Job {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Job) SetType(v string) *Job {
	s.Type = &v
	return s
}

// Job log.
type JobLog struct {
	_ struct{} `type:"structure"`

	// Job log event.
	Event *string `locationName:"event" type:"string" enum:"JobLogEvent"`

	// Job event data
	EventData *JobLogEventData `locationName:"eventData" type:"structure"`

	// Job log event date and time.
	LogDateTime *string `locationName:"logDateTime" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobLog) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *JobLog) SetEvent(v string) *JobLog {
	s.Event = &v
	return s
}

// SetEventData sets the EventData field's value.
func (s *JobLog) SetEventData(v *JobLogEventData) *JobLog {
	s.EventData = v
	return s
}

// SetLogDateTime sets the LogDateTime field's value.
func (s *JobLog) SetLogDateTime(v string) *JobLog {
	s.LogDateTime = &v
	return s
}

// Job log data
type JobLogEventData struct {
	_ struct{} `type:"structure"`

	// Job Event conversion Server ID.
	ConversionServerID *string `locationName:"conversionServerID" type:"string"`

	// Job error.
	RawError *string `locationName:"rawError" type:"string"`

	// Job Event Source Server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Job Event Target instance ID.
	TargetInstanceID *string `locationName:"targetInstanceID" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobLogEventData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobLogEventData) GoString() string {
	return s.String()
}

// SetConversionServerID sets the ConversionServerID field's value.
func (s *JobLogEventData) SetConversionServerID(v string) *JobLogEventData {
	s.ConversionServerID = &v
	return s
}

// SetRawError sets the RawError field's value.
func (s *JobLogEventData) SetRawError(v string) *JobLogEventData {
	s.RawError = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *JobLogEventData) SetSourceServerID(v string) *JobLogEventData {
	s.SourceServerID = &v
	return s
}

// SetTargetInstanceID sets the TargetInstanceID field's value.
func (s *JobLogEventData) SetTargetInstanceID(v string) *JobLogEventData {
	s.TargetInstanceID = &v
	return s
}

// Launched instance.
type LaunchedInstance struct {
	_ struct{} `type:"structure"`

	// Launched instance EC2 ID.
	Ec2InstanceID *string `locationName:"ec2InstanceID" type:"string"`

	// Launched instance first boot.
	FirstBoot *string `locationName:"firstBoot" type:"string" enum:"FirstBoot"`

	// Launched instance Job ID.
	JobID *string `locationName:"jobID" min:"24" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchedInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchedInstance) GoString() string {
	return s.String()
}

// SetEc2InstanceID sets the Ec2InstanceID field's value.
func (s *LaunchedInstance) SetEc2InstanceID(v string) *LaunchedInstance {
	s.Ec2InstanceID = &v
	return s
}

// SetFirstBoot sets the FirstBoot field's value.
func (s *LaunchedInstance) SetFirstBoot(v string) *LaunchedInstance {
	s.FirstBoot = &v
	return s
}

// SetJobID sets the JobID field's value.
func (s *LaunchedInstance) SetJobID(v string) *LaunchedInstance {
	s.JobID = &v
	return s
}

// Configure Licensing.
type Licensing struct {
	_ struct{} `type:"structure"`

	// Configure BYOL OS licensing.
	OsByol *bool `locationName:"osByol" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Licensing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Licensing) GoString() string {
	return s.String()
}

// SetOsByol sets the OsByol field's value.
func (s *Licensing) SetOsByol(v bool) *Licensing {
	s.OsByol = &v
	return s
}

// Lifecycle.
type LifeCycle struct {
	_ struct{} `type:"structure"`

	// Lifecycle added to service data and time.
	AddedToServiceDateTime *string `locationName:"addedToServiceDateTime" min:"19" type:"string"`

	// Lifecycle elapsed time and duration.
	ElapsedReplicationDuration *string `locationName:"elapsedReplicationDuration" min:"19" type:"string"`

	// Lifecycle replication initiation date and time.
	FirstByteDateTime *string `locationName:"firstByteDateTime" min:"19" type:"string"`

	// Lifecycle last Cutover.
	LastCutover *LifeCycleLastCutover `locationName:"lastCutover" type:"structure"`

	// Lifecycle last seen date and time.
	LastSeenByServiceDateTime *string `locationName:"lastSeenByServiceDateTime" min:"19" type:"string"`

	// Lifecycle last Test.
	LastTest *LifeCycleLastTest `locationName:"lastTest" type:"structure"`

	// Lifecycle state.
	State *string `locationName:"state" type:"string" enum:"LifeCycleState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycle) GoString() string {
	return s.String()
}

// SetAddedToServiceDateTime sets the AddedToServiceDateTime field's value.
func (s *LifeCycle) SetAddedToServiceDateTime(v string) *LifeCycle {
	s.AddedToServiceDateTime = &v
	return s
}

// SetElapsedReplicationDuration sets the ElapsedReplicationDuration field's value.
func (s *LifeCycle) SetElapsedReplicationDuration(v string) *LifeCycle {
	s.ElapsedReplicationDuration = &v
	return s
}

// SetFirstByteDateTime sets the FirstByteDateTime field's value.
func (s *LifeCycle) SetFirstByteDateTime(v string) *LifeCycle {
	s.FirstByteDateTime = &v
	return s
}

// SetLastCutover sets the LastCutover field's value.
func (s *LifeCycle) SetLastCutover(v *LifeCycleLastCutover) *LifeCycle {
	s.LastCutover = v
	return s
}

// SetLastSeenByServiceDateTime sets the LastSeenByServiceDateTime field's value.
func (s *LifeCycle) SetLastSeenByServiceDateTime(v string) *LifeCycle {
	s.LastSeenByServiceDateTime = &v
	return s
}

// SetLastTest sets the LastTest field's value.
func (s *LifeCycle) SetLastTest(v *LifeCycleLastTest) *LifeCycle {
	s.LastTest = v
	return s
}

// SetState sets the State field's value.
func (s *LifeCycle) SetState(v string) *LifeCycle {
	s.State = &v
	return s
}

// Lifecycle last Cutover .
type LifeCycleLastCutover struct {
	_ struct{} `type:"structure"`

	// Lifecycle Cutover finalized date and time.
	Finalized *LifeCycleLastCutoverFinalized `locationName:"finalized" type:"structure"`

	// Lifecycle last Cutover initiated.
	Initiated *LifeCycleLastCutoverInitiated `locationName:"initiated" type:"structure"`

	// Lifecycle last Cutover reverted.
	Reverted *LifeCycleLastCutoverReverted `locationName:"reverted" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastCutover) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastCutover) GoString() string {
	return s.String()
}

// SetFinalized sets the Finalized field's value.
func (s *LifeCycleLastCutover) SetFinalized(v *LifeCycleLastCutoverFinalized) *LifeCycleLastCutover {
	s.Finalized = v
	return s
}

// SetInitiated sets the Initiated field's value.
func (s *LifeCycleLastCutover) SetInitiated(v *LifeCycleLastCutoverInitiated) *LifeCycleLastCutover {
	s.Initiated = v
	return s
}

// SetReverted sets the Reverted field's value.
func (s *LifeCycleLastCutover) SetReverted(v *LifeCycleLastCutoverReverted) *LifeCycleLastCutover {
	s.Reverted = v
	return s
}

// Lifecycle Cutover finalized
type LifeCycleLastCutoverFinalized struct {
	_ struct{} `type:"structure"`

	// Lifecycle Cutover finalized date and time.
	ApiCallDateTime *string `locationName:"apiCallDateTime" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastCutoverFinalized) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastCutoverFinalized) GoString() string {
	return s.String()
}

// SetApiCallDateTime sets the ApiCallDateTime field's value.
func (s *LifeCycleLastCutoverFinalized) SetApiCallDateTime(v string) *LifeCycleLastCutoverFinalized {
	s.ApiCallDateTime = &v
	return s
}

// Lifecycle last Cutover initiated.
type LifeCycleLastCutoverInitiated struct {
	_ struct{} `type:"structure"`

	ApiCallDateTime *string `locationName:"apiCallDateTime" min:"19" type:"string"`

	// Lifecycle last Cutover initiated by Job ID.
	JobID *string `locationName:"jobID" min:"24" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastCutoverInitiated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastCutoverInitiated) GoString() string {
	return s.String()
}

// SetApiCallDateTime sets the ApiCallDateTime field's value.
func (s *LifeCycleLastCutoverInitiated) SetApiCallDateTime(v string) *LifeCycleLastCutoverInitiated {
	s.ApiCallDateTime = &v
	return s
}

// SetJobID sets the JobID field's value.
func (s *LifeCycleLastCutoverInitiated) SetJobID(v string) *LifeCycleLastCutoverInitiated {
	s.JobID = &v
	return s
}

// Lifecycle last Cutover reverted.
type LifeCycleLastCutoverReverted struct {
	_ struct{} `type:"structure"`

	// Lifecycle last Cutover reverted API call date time.
	ApiCallDateTime *string `locationName:"apiCallDateTime" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastCutoverReverted) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastCutoverReverted) GoString() string {
	return s.String()
}

// SetApiCallDateTime sets the ApiCallDateTime field's value.
func (s *LifeCycleLastCutoverReverted) SetApiCallDateTime(v string) *LifeCycleLastCutoverReverted {
	s.ApiCallDateTime = &v
	return s
}

// Lifecycle last Test.
type LifeCycleLastTest struct {
	_ struct{} `type:"structure"`

	// Lifecycle last Test finalized.
	Finalized *LifeCycleLastTestFinalized `locationName:"finalized" type:"structure"`

	// Lifecycle last Test initiated.
	Initiated *LifeCycleLastTestInitiated `locationName:"initiated" type:"structure"`

	// Lifecycle last Test reverted.
	Reverted *LifeCycleLastTestReverted `locationName:"reverted" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastTest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastTest) GoString() string {
	return s.String()
}

// SetFinalized sets the Finalized field's value.
func (s *LifeCycleLastTest) SetFinalized(v *LifeCycleLastTestFinalized) *LifeCycleLastTest {
	s.Finalized = v
	return s
}

// SetInitiated sets the Initiated field's value.
func (s *LifeCycleLastTest) SetInitiated(v *LifeCycleLastTestInitiated) *LifeCycleLastTest {
	s.Initiated = v
	return s
}

// SetReverted sets the Reverted field's value.
func (s *LifeCycleLastTest) SetReverted(v *LifeCycleLastTestReverted) *LifeCycleLastTest {
	s.Reverted = v
	return s
}

// Lifecycle last Test finalized.
type LifeCycleLastTestFinalized struct {
	_ struct{} `type:"structure"`

	// Lifecycle Test failed API call date and time.
	ApiCallDateTime *string `locationName:"apiCallDateTime" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastTestFinalized) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastTestFinalized) GoString() string {
	return s.String()
}

// SetApiCallDateTime sets the ApiCallDateTime field's value.
func (s *LifeCycleLastTestFinalized) SetApiCallDateTime(v string) *LifeCycleLastTestFinalized {
	s.ApiCallDateTime = &v
	return s
}

// Lifecycle last Test initiated.
type LifeCycleLastTestInitiated struct {
	_ struct{} `type:"structure"`

	// Lifecycle last Test initiated API call date and time.
	ApiCallDateTime *string `locationName:"apiCallDateTime" min:"19" type:"string"`

	// Lifecycle last Test initiated Job ID.
	JobID *string `locationName:"jobID" min:"24" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastTestInitiated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastTestInitiated) GoString() string {
	return s.String()
}

// SetApiCallDateTime sets the ApiCallDateTime field's value.
func (s *LifeCycleLastTestInitiated) SetApiCallDateTime(v string) *LifeCycleLastTestInitiated {
	s.ApiCallDateTime = &v
	return s
}

// SetJobID sets the JobID field's value.
func (s *LifeCycleLastTestInitiated) SetJobID(v string) *LifeCycleLastTestInitiated {
	s.JobID = &v
	return s
}

// Lifecycle last Test reverted.
type LifeCycleLastTestReverted struct {
	_ struct{} `type:"structure"`

	// Lifecycle last Test reverted API call date and time.
	ApiCallDateTime *string `locationName:"apiCallDateTime" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastTestReverted) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifeCycleLastTestReverted) GoString() string {
	return s.String()
}

// SetApiCallDateTime sets the ApiCallDateTime field's value.
func (s *LifeCycleLastTestReverted) SetApiCallDateTime(v string) *LifeCycleLastTestReverted {
	s.ApiCallDateTime = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// List tags for resource request by ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// List tags for resource response.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListTagsForResourceOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type MarkAsArchivedInput struct {
	_ struct{} `type:"structure"`

	// Mark as archived by Source Server ID.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MarkAsArchivedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MarkAsArchivedInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MarkAsArchivedInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MarkAsArchivedInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *MarkAsArchivedInput) SetSourceServerID(v string) *MarkAsArchivedInput {
	s.SourceServerID = &v
	return s
}

type MarkAsArchivedOutput struct {
	_ struct{} `type:"structure"`

	// Source server ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Source server data replication info.
	DataReplicationInfo *DataReplicationInfo `locationName:"dataReplicationInfo" type:"structure"`

	// Source server archived status.
	IsArchived *bool `locationName:"isArchived" type:"boolean"`

	// Source server launched instance.
	LaunchedInstance *LaunchedInstance `locationName:"launchedInstance" type:"structure"`

	// Source server lifecycle state.
	LifeCycle *LifeCycle `locationName:"lifeCycle" type:"structure"`

	// Source server replication type.
	ReplicationType *string `locationName:"replicationType" type:"string" enum:"ReplicationType"`

	// Source server properties.
	SourceProperties *SourceProperties `locationName:"sourceProperties" type:"structure"`

	// Source server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Source server Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MarkAsArchivedOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Source server vCenter client id.
	VcenterClientID *string `locationName:"vcenterClientID" min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MarkAsArchivedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MarkAsArchivedOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *MarkAsArchivedOutput) SetArn(v string) *MarkAsArchivedOutput {
	s.Arn = &v
	return s
}

// SetDataReplicationInfo sets the DataReplicationInfo field's value.
func (s *MarkAsArchivedOutput) SetDataReplicationInfo(v *DataReplicationInfo) *MarkAsArchivedOutput {
	s.DataReplicationInfo = v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *MarkAsArchivedOutput) SetIsArchived(v bool) *MarkAsArchivedOutput {
	s.IsArchived = &v
	return s
}

// SetLaunchedInstance sets the LaunchedInstance field's value.
func (s *MarkAsArchivedOutput) SetLaunchedInstance(v *LaunchedInstance) *MarkAsArchivedOutput {
	s.LaunchedInstance = v
	return s
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *MarkAsArchivedOutput) SetLifeCycle(v *LifeCycle) *MarkAsArchivedOutput {
	s.LifeCycle = v
	return s
}

// SetReplicationType sets the ReplicationType field's value.
func (s *MarkAsArchivedOutput) SetReplicationType(v string) *MarkAsArchivedOutput {
	s.ReplicationType = &v
	return s
}

// SetSourceProperties sets the SourceProperties field's value.
func (s *MarkAsArchivedOutput) SetSourceProperties(v *SourceProperties) *MarkAsArchivedOutput {
	s.SourceProperties = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *MarkAsArchivedOutput) SetSourceServerID(v string) *MarkAsArchivedOutput {
	s.SourceServerID = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *MarkAsArchivedOutput) SetTags(v map[string]*string) *MarkAsArchivedOutput {
	s.Tags = v
	return s
}

// SetVcenterClientID sets the VcenterClientID field's value.
func (s *MarkAsArchivedOutput) SetVcenterClientID(v string) *MarkAsArchivedOutput {
	s.VcenterClientID = &v
	return s
}

// Network interface.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// Network interface IPs.
	Ips []*string `locationName:"ips" type:"list"`

	// Network interface primary IP.
	IsPrimary *bool `locationName:"isPrimary" type:"boolean"`

	// Network interface Mac address.
	MacAddress *string `locationName:"macAddress" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetIps sets the Ips field's value.
func (s *NetworkInterface) SetIps(v []*string) *NetworkInterface {
	s.Ips = v
	return s
}

// SetIsPrimary sets the IsPrimary field's value.
func (s *NetworkInterface) SetIsPrimary(v bool) *NetworkInterface {
	s.IsPrimary = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *NetworkInterface) SetMacAddress(v string) *NetworkInterface {
	s.MacAddress = &v
	return s
}

// Operating System.
type OS struct {
	_ struct{} `type:"structure"`

	// OS full string.
	FullString *string `locationName:"fullString" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OS) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OS) GoString() string {
	return s.String()
}

// SetFullString sets the FullString field's value.
func (s *OS) SetFullString(v string) *OS {
	s.FullString = &v
	return s
}

// Server participating in Job.
type ParticipatingServer struct {
	_ struct{} `type:"structure"`

	// Participating server launch status.
	LaunchStatus *string `locationName:"launchStatus" type:"string" enum:"LaunchStatus"`

	// Participating server Source Server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipatingServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipatingServer) GoString() string {
	return s.String()
}

// SetLaunchStatus sets the LaunchStatus field's value.
func (s *ParticipatingServer) SetLaunchStatus(v string) *ParticipatingServer {
	s.LaunchStatus = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *ParticipatingServer) SetSourceServerID(v string) *ParticipatingServer {
	s.SourceServerID = &v
	return s
}

// Replication Configuration replicated disk.
type ReplicationConfigurationReplicatedDisk struct {
	_ struct{} `type:"structure"`

	// Replication Configuration replicated disk device name.
	DeviceName *string `locationName:"deviceName" type:"string"`

	// Replication Configuration replicated disk IOPs.
	Iops *int64 `locationName:"iops" type:"long"`

	// Replication Configuration replicated disk boot disk.
	IsBootDisk *bool `locationName:"isBootDisk" type:"boolean"`

	// Replication Configuration replicated disk staging disk type.
	StagingDiskType *string `locationName:"stagingDiskType" type:"string" enum:"ReplicationConfigurationReplicatedDiskStagingDiskType"`

	// Replication Configuration replicated disk throughput.
	Throughput *int64 `locationName:"throughput" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationConfigurationReplicatedDisk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationConfigurationReplicatedDisk) GoString() string {
	return s.String()
}

// SetDeviceName sets the DeviceName field's value.
func (s *ReplicationConfigurationReplicatedDisk) SetDeviceName(v string) *ReplicationConfigurationReplicatedDisk {
	s.DeviceName = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *ReplicationConfigurationReplicatedDisk) SetIops(v int64) *ReplicationConfigurationReplicatedDisk {
	s.Iops = &v
	return s
}

// SetIsBootDisk sets the IsBootDisk field's value.
func (s *ReplicationConfigurationReplicatedDisk) SetIsBootDisk(v bool) *ReplicationConfigurationReplicatedDisk {
	s.IsBootDisk = &v
	return s
}

// SetStagingDiskType sets the StagingDiskType field's value.
func (s *ReplicationConfigurationReplicatedDisk) SetStagingDiskType(v string) *ReplicationConfigurationReplicatedDisk {
	s.StagingDiskType = &v
	return s
}

// SetThroughput sets the Throughput field's value.
func (s *ReplicationConfigurationReplicatedDisk) SetThroughput(v int64) *ReplicationConfigurationReplicatedDisk {
	s.Throughput = &v
	return s
}

type ReplicationConfigurationTemplate struct {
	_ struct{} `type:"structure"`

	// Replication Configuration template ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Replication Configuration template associate default Application Migration
	// Service Security group.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Replication Configuration template bandwidth throttling.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Replication Configuration template create Public IP.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// Replication Configuration template data plane routing.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// Replication Configuration template use default large Staging Disk type.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// Replication Configuration template EBS encryption.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// Replication Configuration template EBS encryption key ARN.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// Replication Configuration template ID.
	//
	// ReplicationConfigurationTemplateID is a required field
	ReplicationConfigurationTemplateID *string `locationName:"replicationConfigurationTemplateID" min:"21" type:"string" required:"true"`

	// Replication Configuration template server instance type.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// Replication Configuration template server Security Groups IDs.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// Replication Configuration template Staging Area subnet ID.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// Replication Configuration template Staging Area Tags.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ReplicationConfigurationTemplate's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// Replication Configuration template Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ReplicationConfigurationTemplate's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Replication Configuration template use Dedicated Replication Server.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationConfigurationTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationConfigurationTemplate) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ReplicationConfigurationTemplate) SetArn(v string) *ReplicationConfigurationTemplate {
	s.Arn = &v
	return s
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *ReplicationConfigurationTemplate) SetAssociateDefaultSecurityGroup(v bool) *ReplicationConfigurationTemplate {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *ReplicationConfigurationTemplate) SetBandwidthThrottling(v int64) *ReplicationConfigurationTemplate {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *ReplicationConfigurationTemplate) SetCreatePublicIP(v bool) *ReplicationConfigurationTemplate {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *ReplicationConfigurationTemplate) SetDataPlaneRouting(v string) *ReplicationConfigurationTemplate {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *ReplicationConfigurationTemplate) SetDefaultLargeStagingDiskType(v string) *ReplicationConfigurationTemplate {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *ReplicationConfigurationTemplate) SetEbsEncryption(v string) *ReplicationConfigurationTemplate {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *ReplicationConfigurationTemplate) SetEbsEncryptionKeyArn(v string) *ReplicationConfigurationTemplate {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetReplicationConfigurationTemplateID sets the ReplicationConfigurationTemplateID field's value.
func (s *ReplicationConfigurationTemplate) SetReplicationConfigurationTemplateID(v string) *ReplicationConfigurationTemplate {
	s.ReplicationConfigurationTemplateID = &v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *ReplicationConfigurationTemplate) SetReplicationServerInstanceType(v string) *ReplicationConfigurationTemplate {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *ReplicationConfigurationTemplate) SetReplicationServersSecurityGroupsIDs(v []*string) *ReplicationConfigurationTemplate {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *ReplicationConfigurationTemplate) SetStagingAreaSubnetId(v string) *ReplicationConfigurationTemplate {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *ReplicationConfigurationTemplate) SetStagingAreaTags(v map[string]*string) *ReplicationConfigurationTemplate {
	s.StagingAreaTags = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ReplicationConfigurationTemplate) SetTags(v map[string]*string) *ReplicationConfigurationTemplate {
	s.Tags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *ReplicationConfigurationTemplate) SetUseDedicatedReplicationServer(v bool) *ReplicationConfigurationTemplate {
	s.UseDedicatedReplicationServer = &v
	return s
}

// Resource not found exception.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// Resource ID not found error.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// Resource type not found error.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RetryDataReplicationInput struct {
	_ struct{} `type:"structure"`

	// Retry data replication for Source Server ID.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryDataReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryDataReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetryDataReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetryDataReplicationInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *RetryDataReplicationInput) SetSourceServerID(v string) *RetryDataReplicationInput {
	s.SourceServerID = &v
	return s
}

type RetryDataReplicationOutput struct {
	_ struct{} `type:"structure"`

	// Source server ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Source server data replication info.
	DataReplicationInfo *DataReplicationInfo `locationName:"dataReplicationInfo" type:"structure"`

	// Source server archived status.
	IsArchived *bool `locationName:"isArchived" type:"boolean"`

	// Source server launched instance.
	LaunchedInstance *LaunchedInstance `locationName:"launchedInstance" type:"structure"`

	// Source server lifecycle state.
	LifeCycle *LifeCycle `locationName:"lifeCycle" type:"structure"`

	// Source server replication type.
	ReplicationType *string `locationName:"replicationType" type:"string" enum:"ReplicationType"`

	// Source server properties.
	SourceProperties *SourceProperties `locationName:"sourceProperties" type:"structure"`

	// Source server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Source server Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RetryDataReplicationOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Source server vCenter client id.
	VcenterClientID *string `locationName:"vcenterClientID" min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryDataReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryDataReplicationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RetryDataReplicationOutput) SetArn(v string) *RetryDataReplicationOutput {
	s.Arn = &v
	return s
}

// SetDataReplicationInfo sets the DataReplicationInfo field's value.
func (s *RetryDataReplicationOutput) SetDataReplicationInfo(v *DataReplicationInfo) *RetryDataReplicationOutput {
	s.DataReplicationInfo = v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *RetryDataReplicationOutput) SetIsArchived(v bool) *RetryDataReplicationOutput {
	s.IsArchived = &v
	return s
}

// SetLaunchedInstance sets the LaunchedInstance field's value.
func (s *RetryDataReplicationOutput) SetLaunchedInstance(v *LaunchedInstance) *RetryDataReplicationOutput {
	s.LaunchedInstance = v
	return s
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *RetryDataReplicationOutput) SetLifeCycle(v *LifeCycle) *RetryDataReplicationOutput {
	s.LifeCycle = v
	return s
}

// SetReplicationType sets the ReplicationType field's value.
func (s *RetryDataReplicationOutput) SetReplicationType(v string) *RetryDataReplicationOutput {
	s.ReplicationType = &v
	return s
}

// SetSourceProperties sets the SourceProperties field's value.
func (s *RetryDataReplicationOutput) SetSourceProperties(v *SourceProperties) *RetryDataReplicationOutput {
	s.SourceProperties = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *RetryDataReplicationOutput) SetSourceServerID(v string) *RetryDataReplicationOutput {
	s.SourceServerID = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RetryDataReplicationOutput) SetTags(v map[string]*string) *RetryDataReplicationOutput {
	s.Tags = v
	return s
}

// SetVcenterClientID sets the VcenterClientID field's value.
func (s *RetryDataReplicationOutput) SetVcenterClientID(v string) *RetryDataReplicationOutput {
	s.VcenterClientID = &v
	return s
}

// The request could not be completed because its exceeded the service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// Exceeded the service quota code.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// Exceeded the service quota value.
	QuotaValue *int64 `locationName:"quotaValue" min:"1" type:"integer"`

	// Exceeded the service quota resource ID.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// Exceeded the service quota resource type.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// Exceeded the service quota service code.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Source server properties.
type SourceProperties struct {
	_ struct{} `type:"structure"`

	// Source Server CPUs.
	Cpus []*CPU `locationName:"cpus" type:"list"`

	// Source Server disks.
	Disks []*Disk `locationName:"disks" type:"list"`

	// Source server identification hints.
	IdentificationHints *IdentificationHints `locationName:"identificationHints" type:"structure"`

	// Source server last update date and time.
	LastUpdatedDateTime *string `locationName:"lastUpdatedDateTime" min:"19" type:"string"`

	// Source server network interfaces.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// Source server OS.
	Os *OS `locationName:"os" type:"structure"`

	// Source server RAM in bytes.
	RamBytes *int64 `locationName:"ramBytes" type:"long"`

	// Source server recommended instance type.
	RecommendedInstanceType *string `locationName:"recommendedInstanceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceProperties) GoString() string {
	return s.String()
}

// SetCpus sets the Cpus field's value.
func (s *SourceProperties) SetCpus(v []*CPU) *SourceProperties {
	s.Cpus = v
	return s
}

// SetDisks sets the Disks field's value.
func (s *SourceProperties) SetDisks(v []*Disk) *SourceProperties {
	s.Disks = v
	return s
}

// SetIdentificationHints sets the IdentificationHints field's value.
func (s *SourceProperties) SetIdentificationHints(v *IdentificationHints) *SourceProperties {
	s.IdentificationHints = v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *SourceProperties) SetLastUpdatedDateTime(v string) *SourceProperties {
	s.LastUpdatedDateTime = &v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *SourceProperties) SetNetworkInterfaces(v []*NetworkInterface) *SourceProperties {
	s.NetworkInterfaces = v
	return s
}

// SetOs sets the Os field's value.
func (s *SourceProperties) SetOs(v *OS) *SourceProperties {
	s.Os = v
	return s
}

// SetRamBytes sets the RamBytes field's value.
func (s *SourceProperties) SetRamBytes(v int64) *SourceProperties {
	s.RamBytes = &v
	return s
}

// SetRecommendedInstanceType sets the RecommendedInstanceType field's value.
func (s *SourceProperties) SetRecommendedInstanceType(v string) *SourceProperties {
	s.RecommendedInstanceType = &v
	return s
}

type SourceServer struct {
	_ struct{} `type:"structure"`

	// Source server ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Source server data replication info.
	DataReplicationInfo *DataReplicationInfo `locationName:"dataReplicationInfo" type:"structure"`

	// Source server archived status.
	IsArchived *bool `locationName:"isArchived" type:"boolean"`

	// Source server launched instance.
	LaunchedInstance *LaunchedInstance `locationName:"launchedInstance" type:"structure"`

	// Source server lifecycle state.
	LifeCycle *LifeCycle `locationName:"lifeCycle" type:"structure"`

	// Source server replication type.
	ReplicationType *string `locationName:"replicationType" type:"string" enum:"ReplicationType"`

	// Source server properties.
	SourceProperties *SourceProperties `locationName:"sourceProperties" type:"structure"`

	// Source server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Source server Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SourceServer's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Source server vCenter client id.
	VcenterClientID *string `locationName:"vcenterClientID" min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceServer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SourceServer) SetArn(v string) *SourceServer {
	s.Arn = &v
	return s
}

// SetDataReplicationInfo sets the DataReplicationInfo field's value.
func (s *SourceServer) SetDataReplicationInfo(v *DataReplicationInfo) *SourceServer {
	s.DataReplicationInfo = v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *SourceServer) SetIsArchived(v bool) *SourceServer {
	s.IsArchived = &v
	return s
}

// SetLaunchedInstance sets the LaunchedInstance field's value.
func (s *SourceServer) SetLaunchedInstance(v *LaunchedInstance) *SourceServer {
	s.LaunchedInstance = v
	return s
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *SourceServer) SetLifeCycle(v *LifeCycle) *SourceServer {
	s.LifeCycle = v
	return s
}

// SetReplicationType sets the ReplicationType field's value.
func (s *SourceServer) SetReplicationType(v string) *SourceServer {
	s.ReplicationType = &v
	return s
}

// SetSourceProperties sets the SourceProperties field's value.
func (s *SourceServer) SetSourceProperties(v *SourceProperties) *SourceServer {
	s.SourceProperties = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *SourceServer) SetSourceServerID(v string) *SourceServer {
	s.SourceServerID = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SourceServer) SetTags(v map[string]*string) *SourceServer {
	s.Tags = v
	return s
}

// SetVcenterClientID sets the VcenterClientID field's value.
func (s *SourceServer) SetVcenterClientID(v string) *SourceServer {
	s.VcenterClientID = &v
	return s
}

type StartCutoverInput struct {
	_ struct{} `type:"structure"`

	// Start Cutover by Source Server IDs.
	//
	// SourceServerIDs is a required field
	SourceServerIDs []*string `locationName:"sourceServerIDs" min:"1" type:"list" required:"true"`

	// Start Cutover by Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartCutoverInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCutoverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCutoverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCutoverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCutoverInput"}
	if s.SourceServerIDs == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerIDs"))
	}
	if s.SourceServerIDs != nil && len(s.SourceServerIDs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerIDs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerIDs sets the SourceServerIDs field's value.
func (s *StartCutoverInput) SetSourceServerIDs(v []*string) *StartCutoverInput {
	s.SourceServerIDs = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartCutoverInput) SetTags(v map[string]*string) *StartCutoverInput {
	s.Tags = v
	return s
}

type StartCutoverOutput struct {
	_ struct{} `type:"structure"`

	// Start Cutover Job response.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCutoverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCutoverOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *StartCutoverOutput) SetJob(v *Job) *StartCutoverOutput {
	s.Job = v
	return s
}

type StartReplicationInput struct {
	_ struct{} `type:"structure"`

	// ID of source server on which to start replication.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReplicationInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *StartReplicationInput) SetSourceServerID(v string) *StartReplicationInput {
	s.SourceServerID = &v
	return s
}

type StartReplicationOutput struct {
	_ struct{} `type:"structure"`

	// Source server ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Source server data replication info.
	DataReplicationInfo *DataReplicationInfo `locationName:"dataReplicationInfo" type:"structure"`

	// Source server archived status.
	IsArchived *bool `locationName:"isArchived" type:"boolean"`

	// Source server launched instance.
	LaunchedInstance *LaunchedInstance `locationName:"launchedInstance" type:"structure"`

	// Source server lifecycle state.
	LifeCycle *LifeCycle `locationName:"lifeCycle" type:"structure"`

	// Source server replication type.
	ReplicationType *string `locationName:"replicationType" type:"string" enum:"ReplicationType"`

	// Source server properties.
	SourceProperties *SourceProperties `locationName:"sourceProperties" type:"structure"`

	// Source server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Source server Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartReplicationOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Source server vCenter client id.
	VcenterClientID *string `locationName:"vcenterClientID" min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReplicationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartReplicationOutput) SetArn(v string) *StartReplicationOutput {
	s.Arn = &v
	return s
}

// SetDataReplicationInfo sets the DataReplicationInfo field's value.
func (s *StartReplicationOutput) SetDataReplicationInfo(v *DataReplicationInfo) *StartReplicationOutput {
	s.DataReplicationInfo = v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *StartReplicationOutput) SetIsArchived(v bool) *StartReplicationOutput {
	s.IsArchived = &v
	return s
}

// SetLaunchedInstance sets the LaunchedInstance field's value.
func (s *StartReplicationOutput) SetLaunchedInstance(v *LaunchedInstance) *StartReplicationOutput {
	s.LaunchedInstance = v
	return s
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *StartReplicationOutput) SetLifeCycle(v *LifeCycle) *StartReplicationOutput {
	s.LifeCycle = v
	return s
}

// SetReplicationType sets the ReplicationType field's value.
func (s *StartReplicationOutput) SetReplicationType(v string) *StartReplicationOutput {
	s.ReplicationType = &v
	return s
}

// SetSourceProperties sets the SourceProperties field's value.
func (s *StartReplicationOutput) SetSourceProperties(v *SourceProperties) *StartReplicationOutput {
	s.SourceProperties = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *StartReplicationOutput) SetSourceServerID(v string) *StartReplicationOutput {
	s.SourceServerID = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartReplicationOutput) SetTags(v map[string]*string) *StartReplicationOutput {
	s.Tags = v
	return s
}

// SetVcenterClientID sets the VcenterClientID field's value.
func (s *StartReplicationOutput) SetVcenterClientID(v string) *StartReplicationOutput {
	s.VcenterClientID = &v
	return s
}

type StartTestInput struct {
	_ struct{} `type:"structure"`

	// Start Test for Source Server IDs.
	//
	// SourceServerIDs is a required field
	SourceServerIDs []*string `locationName:"sourceServerIDs" min:"1" type:"list" required:"true"`

	// Start Test by Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartTestInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTestInput"}
	if s.SourceServerIDs == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerIDs"))
	}
	if s.SourceServerIDs != nil && len(s.SourceServerIDs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerIDs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerIDs sets the SourceServerIDs field's value.
func (s *StartTestInput) SetSourceServerIDs(v []*string) *StartTestInput {
	s.SourceServerIDs = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartTestInput) SetTags(v map[string]*string) *StartTestInput {
	s.Tags = v
	return s
}

type StartTestOutput struct {
	_ struct{} `type:"structure"`

	// Start Test Job response.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTestOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *StartTestOutput) SetJob(v *Job) *StartTestOutput {
	s.Job = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Tag resource by ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// Tag resource by Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TagResourceInput's
	// String and GoString methods.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TerminateTargetInstancesInput struct {
	_ struct{} `type:"structure"`

	// Terminate Target instance by Source Server IDs.
	//
	// SourceServerIDs is a required field
	SourceServerIDs []*string `locationName:"sourceServerIDs" min:"1" type:"list" required:"true"`

	// Terminate Target instance by Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TerminateTargetInstancesInput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateTargetInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateTargetInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateTargetInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateTargetInstancesInput"}
	if s.SourceServerIDs == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerIDs"))
	}
	if s.SourceServerIDs != nil && len(s.SourceServerIDs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerIDs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceServerIDs sets the SourceServerIDs field's value.
func (s *TerminateTargetInstancesInput) SetSourceServerIDs(v []*string) *TerminateTargetInstancesInput {
	s.SourceServerIDs = v
	return s
}

// SetTags sets the Tags field's value.
func (s *TerminateTargetInstancesInput) SetTags(v map[string]*string) *TerminateTargetInstancesInput {
	s.Tags = v
	return s
}

type TerminateTargetInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Terminate Target instance Job response.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateTargetInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateTargetInstancesOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *TerminateTargetInstancesOutput) SetJob(v *Job) *TerminateTargetInstancesOutput {
	s.Job = v
	return s
}

// Reached throttling quota exception.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// Reached throttling quota exception.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// Reached throttling quota exception will retry after x seconds.
	RetryAfterSeconds *string `location:"header" locationName:"Retry-After" type:"string"`

	// Reached throttling quota exception service code.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Uninitialized account exception.
type UninitializedAccountException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UninitializedAccountException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UninitializedAccountException) GoString() string {
	return s.String()
}

func newErrorUninitializedAccountException(v protocol.ResponseMetadata) error {
	return &UninitializedAccountException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UninitializedAccountException) Code() string {
	return "UninitializedAccountException"
}

// Message returns the exception's message.
func (s *UninitializedAccountException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UninitializedAccountException) OrigErr() error {
	return nil
}

func (s *UninitializedAccountException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UninitializedAccountException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UninitializedAccountException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Untag resource by ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// Untag resource by Keys.
	//
	// TagKeys is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UntagResourceInput's
	// String and GoString methods.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Update Launch configuration boot mode request.
	BootMode *string `locationName:"bootMode" type:"string" enum:"BootMode"`

	// Update Launch configuration copy Private IP request.
	CopyPrivateIp *bool `locationName:"copyPrivateIp" type:"boolean"`

	// Update Launch configuration copy Tags request.
	CopyTags *bool `locationName:"copyTags" type:"boolean"`

	// Update Launch configuration launch disposition request.
	LaunchDisposition *string `locationName:"launchDisposition" type:"string" enum:"LaunchDisposition"`

	// Update Launch configuration licensing request.
	Licensing *Licensing `locationName:"licensing" type:"structure"`

	// Update Launch configuration name request.
	Name *string `locationName:"name" type:"string"`

	// Update Launch configuration by Source Server ID request.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`

	// Update Launch configuration Target instance right sizing request.
	TargetInstanceTypeRightSizingMethod *string `locationName:"targetInstanceTypeRightSizingMethod" type:"string" enum:"TargetInstanceTypeRightSizingMethod"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLaunchConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLaunchConfigurationInput"}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBootMode sets the BootMode field's value.
func (s *UpdateLaunchConfigurationInput) SetBootMode(v string) *UpdateLaunchConfigurationInput {
	s.BootMode = &v
	return s
}

// SetCopyPrivateIp sets the CopyPrivateIp field's value.
func (s *UpdateLaunchConfigurationInput) SetCopyPrivateIp(v bool) *UpdateLaunchConfigurationInput {
	s.CopyPrivateIp = &v
	return s
}

// SetCopyTags sets the CopyTags field's value.
func (s *UpdateLaunchConfigurationInput) SetCopyTags(v bool) *UpdateLaunchConfigurationInput {
	s.CopyTags = &v
	return s
}

// SetLaunchDisposition sets the LaunchDisposition field's value.
func (s *UpdateLaunchConfigurationInput) SetLaunchDisposition(v string) *UpdateLaunchConfigurationInput {
	s.LaunchDisposition = &v
	return s
}

// SetLicensing sets the Licensing field's value.
func (s *UpdateLaunchConfigurationInput) SetLicensing(v *Licensing) *UpdateLaunchConfigurationInput {
	s.Licensing = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLaunchConfigurationInput) SetName(v string) *UpdateLaunchConfigurationInput {
	s.Name = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *UpdateLaunchConfigurationInput) SetSourceServerID(v string) *UpdateLaunchConfigurationInput {
	s.SourceServerID = &v
	return s
}

// SetTargetInstanceTypeRightSizingMethod sets the TargetInstanceTypeRightSizingMethod field's value.
func (s *UpdateLaunchConfigurationInput) SetTargetInstanceTypeRightSizingMethod(v string) *UpdateLaunchConfigurationInput {
	s.TargetInstanceTypeRightSizingMethod = &v
	return s
}

type UpdateLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Launch configuration boot mode.
	BootMode *string `locationName:"bootMode" type:"string" enum:"BootMode"`

	// Copy Private IP during Launch Configuration.
	CopyPrivateIp *bool `locationName:"copyPrivateIp" type:"boolean"`

	// Copy Tags during Launch Configuration.
	CopyTags *bool `locationName:"copyTags" type:"boolean"`

	// Launch configuration EC2 Launch template ID.
	Ec2LaunchTemplateID *string `locationName:"ec2LaunchTemplateID" type:"string"`

	// Launch disposition for launch configuration.
	LaunchDisposition *string `locationName:"launchDisposition" type:"string" enum:"LaunchDisposition"`

	// Launch configuration OS licensing.
	Licensing *Licensing `locationName:"licensing" type:"structure"`

	// Launch configuration name.
	Name *string `locationName:"name" type:"string"`

	// Launch configuration Source Server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Launch configuration Target instance type right sizing method.
	TargetInstanceTypeRightSizingMethod *string `locationName:"targetInstanceTypeRightSizingMethod" type:"string" enum:"TargetInstanceTypeRightSizingMethod"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLaunchConfigurationOutput) GoString() string {
	return s.String()
}

// SetBootMode sets the BootMode field's value.
func (s *UpdateLaunchConfigurationOutput) SetBootMode(v string) *UpdateLaunchConfigurationOutput {
	s.BootMode = &v
	return s
}

// SetCopyPrivateIp sets the CopyPrivateIp field's value.
func (s *UpdateLaunchConfigurationOutput) SetCopyPrivateIp(v bool) *UpdateLaunchConfigurationOutput {
	s.CopyPrivateIp = &v
	return s
}

// SetCopyTags sets the CopyTags field's value.
func (s *UpdateLaunchConfigurationOutput) SetCopyTags(v bool) *UpdateLaunchConfigurationOutput {
	s.CopyTags = &v
	return s
}

// SetEc2LaunchTemplateID sets the Ec2LaunchTemplateID field's value.
func (s *UpdateLaunchConfigurationOutput) SetEc2LaunchTemplateID(v string) *UpdateLaunchConfigurationOutput {
	s.Ec2LaunchTemplateID = &v
	return s
}

// SetLaunchDisposition sets the LaunchDisposition field's value.
func (s *UpdateLaunchConfigurationOutput) SetLaunchDisposition(v string) *UpdateLaunchConfigurationOutput {
	s.LaunchDisposition = &v
	return s
}

// SetLicensing sets the Licensing field's value.
func (s *UpdateLaunchConfigurationOutput) SetLicensing(v *Licensing) *UpdateLaunchConfigurationOutput {
	s.Licensing = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLaunchConfigurationOutput) SetName(v string) *UpdateLaunchConfigurationOutput {
	s.Name = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *UpdateLaunchConfigurationOutput) SetSourceServerID(v string) *UpdateLaunchConfigurationOutput {
	s.SourceServerID = &v
	return s
}

// SetTargetInstanceTypeRightSizingMethod sets the TargetInstanceTypeRightSizingMethod field's value.
func (s *UpdateLaunchConfigurationOutput) SetTargetInstanceTypeRightSizingMethod(v string) *UpdateLaunchConfigurationOutput {
	s.TargetInstanceTypeRightSizingMethod = &v
	return s
}

type UpdateReplicationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Update replication configuration associate default Application Migration
	// Service Security group request.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Update replication configuration bandwidth throttling request.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Update replication configuration create Public IP request.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// Update replication configuration data plane routing request.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// Update replication configuration use default large Staging Disk type request.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// Update replication configuration EBS encryption request.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// Update replication configuration EBS encryption key ARN request.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// Update replication configuration name request.
	Name *string `locationName:"name" type:"string"`

	// Update replication configuration replicated disks request.
	ReplicatedDisks []*ReplicationConfigurationReplicatedDisk `locationName:"replicatedDisks" type:"list"`

	// Update replication configuration Replication Server instance type request.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// Update replication configuration Replication Server Security Groups IDs request.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// Update replication configuration Source Server ID request.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`

	// Update replication configuration Staging Area subnet request.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// Update replication configuration Staging Area Tags request.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateReplicationConfigurationInput's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// Update replication configuration use dedicated Replication Server request.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReplicationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReplicationConfigurationInput"}
	if s.EbsEncryptionKeyArn != nil && len(*s.EbsEncryptionKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EbsEncryptionKeyArn", 20))
	}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *UpdateReplicationConfigurationInput) SetAssociateDefaultSecurityGroup(v bool) *UpdateReplicationConfigurationInput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *UpdateReplicationConfigurationInput) SetBandwidthThrottling(v int64) *UpdateReplicationConfigurationInput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *UpdateReplicationConfigurationInput) SetCreatePublicIP(v bool) *UpdateReplicationConfigurationInput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *UpdateReplicationConfigurationInput) SetDataPlaneRouting(v string) *UpdateReplicationConfigurationInput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *UpdateReplicationConfigurationInput) SetDefaultLargeStagingDiskType(v string) *UpdateReplicationConfigurationInput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *UpdateReplicationConfigurationInput) SetEbsEncryption(v string) *UpdateReplicationConfigurationInput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *UpdateReplicationConfigurationInput) SetEbsEncryptionKeyArn(v string) *UpdateReplicationConfigurationInput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateReplicationConfigurationInput) SetName(v string) *UpdateReplicationConfigurationInput {
	s.Name = &v
	return s
}

// SetReplicatedDisks sets the ReplicatedDisks field's value.
func (s *UpdateReplicationConfigurationInput) SetReplicatedDisks(v []*ReplicationConfigurationReplicatedDisk) *UpdateReplicationConfigurationInput {
	s.ReplicatedDisks = v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *UpdateReplicationConfigurationInput) SetReplicationServerInstanceType(v string) *UpdateReplicationConfigurationInput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *UpdateReplicationConfigurationInput) SetReplicationServersSecurityGroupsIDs(v []*string) *UpdateReplicationConfigurationInput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *UpdateReplicationConfigurationInput) SetSourceServerID(v string) *UpdateReplicationConfigurationInput {
	s.SourceServerID = &v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *UpdateReplicationConfigurationInput) SetStagingAreaSubnetId(v string) *UpdateReplicationConfigurationInput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *UpdateReplicationConfigurationInput) SetStagingAreaTags(v map[string]*string) *UpdateReplicationConfigurationInput {
	s.StagingAreaTags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *UpdateReplicationConfigurationInput) SetUseDedicatedReplicationServer(v bool) *UpdateReplicationConfigurationInput {
	s.UseDedicatedReplicationServer = &v
	return s
}

type UpdateReplicationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Replication Configuration associate default Application Migration Service
	// Security Group.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Replication Configuration set bandwidth throttling.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Replication Configuration create Public IP.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// Replication Configuration data plane routing.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// Replication Configuration use default large Staging Disks.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// Replication Configuration EBS encryption.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// Replication Configuration EBS encryption key ARN.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// Replication Configuration name.
	Name *string `locationName:"name" type:"string"`

	// Replication Configuration replicated disks.
	ReplicatedDisks []*ReplicationConfigurationReplicatedDisk `locationName:"replicatedDisks" type:"list"`

	// Replication Configuration Replication Server instance type.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// Replication Configuration Replication Server Security Group IDs.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// Replication Configuration Source Server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Replication Configuration Staging Area subnet ID.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// Replication Configuration Staging Area tags.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateReplicationConfigurationOutput's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// Replication Configuration use Dedicated Replication Server.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationOutput) GoString() string {
	return s.String()
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *UpdateReplicationConfigurationOutput) SetAssociateDefaultSecurityGroup(v bool) *UpdateReplicationConfigurationOutput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *UpdateReplicationConfigurationOutput) SetBandwidthThrottling(v int64) *UpdateReplicationConfigurationOutput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *UpdateReplicationConfigurationOutput) SetCreatePublicIP(v bool) *UpdateReplicationConfigurationOutput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *UpdateReplicationConfigurationOutput) SetDataPlaneRouting(v string) *UpdateReplicationConfigurationOutput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *UpdateReplicationConfigurationOutput) SetDefaultLargeStagingDiskType(v string) *UpdateReplicationConfigurationOutput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *UpdateReplicationConfigurationOutput) SetEbsEncryption(v string) *UpdateReplicationConfigurationOutput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *UpdateReplicationConfigurationOutput) SetEbsEncryptionKeyArn(v string) *UpdateReplicationConfigurationOutput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateReplicationConfigurationOutput) SetName(v string) *UpdateReplicationConfigurationOutput {
	s.Name = &v
	return s
}

// SetReplicatedDisks sets the ReplicatedDisks field's value.
func (s *UpdateReplicationConfigurationOutput) SetReplicatedDisks(v []*ReplicationConfigurationReplicatedDisk) *UpdateReplicationConfigurationOutput {
	s.ReplicatedDisks = v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *UpdateReplicationConfigurationOutput) SetReplicationServerInstanceType(v string) *UpdateReplicationConfigurationOutput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *UpdateReplicationConfigurationOutput) SetReplicationServersSecurityGroupsIDs(v []*string) *UpdateReplicationConfigurationOutput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *UpdateReplicationConfigurationOutput) SetSourceServerID(v string) *UpdateReplicationConfigurationOutput {
	s.SourceServerID = &v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *UpdateReplicationConfigurationOutput) SetStagingAreaSubnetId(v string) *UpdateReplicationConfigurationOutput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *UpdateReplicationConfigurationOutput) SetStagingAreaTags(v map[string]*string) *UpdateReplicationConfigurationOutput {
	s.StagingAreaTags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *UpdateReplicationConfigurationOutput) SetUseDedicatedReplicationServer(v bool) *UpdateReplicationConfigurationOutput {
	s.UseDedicatedReplicationServer = &v
	return s
}

type UpdateReplicationConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// Update replication configuration template ARN request.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Update replication configuration template associate default Application Migration
	// Service Security group request.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Update replication configuration template bandwidth throttling request.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Update replication configuration template create Public IP request.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// Update replication configuration template data plane routing request.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// Update replication configuration template use default large Staging Disk
	// type request.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// Update replication configuration template EBS encryption request.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// Update replication configuration template EBS encryption key ARN request.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// Update replication configuration template template ID request.
	//
	// ReplicationConfigurationTemplateID is a required field
	ReplicationConfigurationTemplateID *string `locationName:"replicationConfigurationTemplateID" min:"21" type:"string" required:"true"`

	// Update replication configuration template Replication Server instance type
	// request.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// Update replication configuration template Replication Server Security groups
	// IDs request.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// Update replication configuration template Staging Area subnet ID request.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// Update replication configuration template Staging Area Tags request.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateReplicationConfigurationTemplateInput's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// Update replication configuration template use dedicated Replication Server
	// request.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReplicationConfigurationTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReplicationConfigurationTemplateInput"}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.EbsEncryptionKeyArn != nil && len(*s.EbsEncryptionKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EbsEncryptionKeyArn", 20))
	}
	if s.ReplicationConfigurationTemplateID == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationConfigurationTemplateID"))
	}
	if s.ReplicationConfigurationTemplateID != nil && len(*s.ReplicationConfigurationTemplateID) < 21 {
		invalidParams.Add(request.NewErrParamMinLen("ReplicationConfigurationTemplateID", 21))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetArn(v string) *UpdateReplicationConfigurationTemplateInput {
	s.Arn = &v
	return s
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetAssociateDefaultSecurityGroup(v bool) *UpdateReplicationConfigurationTemplateInput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetBandwidthThrottling(v int64) *UpdateReplicationConfigurationTemplateInput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetCreatePublicIP(v bool) *UpdateReplicationConfigurationTemplateInput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetDataPlaneRouting(v string) *UpdateReplicationConfigurationTemplateInput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetDefaultLargeStagingDiskType(v string) *UpdateReplicationConfigurationTemplateInput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetEbsEncryption(v string) *UpdateReplicationConfigurationTemplateInput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetEbsEncryptionKeyArn(v string) *UpdateReplicationConfigurationTemplateInput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetReplicationConfigurationTemplateID sets the ReplicationConfigurationTemplateID field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetReplicationConfigurationTemplateID(v string) *UpdateReplicationConfigurationTemplateInput {
	s.ReplicationConfigurationTemplateID = &v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetReplicationServerInstanceType(v string) *UpdateReplicationConfigurationTemplateInput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetReplicationServersSecurityGroupsIDs(v []*string) *UpdateReplicationConfigurationTemplateInput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetStagingAreaSubnetId(v string) *UpdateReplicationConfigurationTemplateInput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetStagingAreaTags(v map[string]*string) *UpdateReplicationConfigurationTemplateInput {
	s.StagingAreaTags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *UpdateReplicationConfigurationTemplateInput) SetUseDedicatedReplicationServer(v bool) *UpdateReplicationConfigurationTemplateInput {
	s.UseDedicatedReplicationServer = &v
	return s
}

type UpdateReplicationConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Replication Configuration template ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Replication Configuration template associate default Application Migration
	// Service Security group.
	AssociateDefaultSecurityGroup *bool `locationName:"associateDefaultSecurityGroup" type:"boolean"`

	// Replication Configuration template bandwidth throttling.
	BandwidthThrottling *int64 `locationName:"bandwidthThrottling" type:"long"`

	// Replication Configuration template create Public IP.
	CreatePublicIP *bool `locationName:"createPublicIP" type:"boolean"`

	// Replication Configuration template data plane routing.
	DataPlaneRouting *string `locationName:"dataPlaneRouting" type:"string" enum:"ReplicationConfigurationDataPlaneRouting"`

	// Replication Configuration template use default large Staging Disk type.
	DefaultLargeStagingDiskType *string `locationName:"defaultLargeStagingDiskType" type:"string" enum:"ReplicationConfigurationDefaultLargeStagingDiskType"`

	// Replication Configuration template EBS encryption.
	EbsEncryption *string `locationName:"ebsEncryption" type:"string" enum:"ReplicationConfigurationEbsEncryption"`

	// Replication Configuration template EBS encryption key ARN.
	EbsEncryptionKeyArn *string `locationName:"ebsEncryptionKeyArn" min:"20" type:"string"`

	// Replication Configuration template ID.
	//
	// ReplicationConfigurationTemplateID is a required field
	ReplicationConfigurationTemplateID *string `locationName:"replicationConfigurationTemplateID" min:"21" type:"string" required:"true"`

	// Replication Configuration template server instance type.
	ReplicationServerInstanceType *string `locationName:"replicationServerInstanceType" type:"string"`

	// Replication Configuration template server Security Groups IDs.
	ReplicationServersSecurityGroupsIDs []*string `locationName:"replicationServersSecurityGroupsIDs" type:"list"`

	// Replication Configuration template Staging Area subnet ID.
	StagingAreaSubnetId *string `locationName:"stagingAreaSubnetId" type:"string"`

	// Replication Configuration template Staging Area Tags.
	//
	// StagingAreaTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateReplicationConfigurationTemplateOutput's
	// String and GoString methods.
	StagingAreaTags map[string]*string `locationName:"stagingAreaTags" type:"map" sensitive:"true"`

	// Replication Configuration template Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateReplicationConfigurationTemplateOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Replication Configuration template use Dedicated Replication Server.
	UseDedicatedReplicationServer *bool `locationName:"useDedicatedReplicationServer" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateReplicationConfigurationTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetArn(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.Arn = &v
	return s
}

// SetAssociateDefaultSecurityGroup sets the AssociateDefaultSecurityGroup field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetAssociateDefaultSecurityGroup(v bool) *UpdateReplicationConfigurationTemplateOutput {
	s.AssociateDefaultSecurityGroup = &v
	return s
}

// SetBandwidthThrottling sets the BandwidthThrottling field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetBandwidthThrottling(v int64) *UpdateReplicationConfigurationTemplateOutput {
	s.BandwidthThrottling = &v
	return s
}

// SetCreatePublicIP sets the CreatePublicIP field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetCreatePublicIP(v bool) *UpdateReplicationConfigurationTemplateOutput {
	s.CreatePublicIP = &v
	return s
}

// SetDataPlaneRouting sets the DataPlaneRouting field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetDataPlaneRouting(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.DataPlaneRouting = &v
	return s
}

// SetDefaultLargeStagingDiskType sets the DefaultLargeStagingDiskType field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetDefaultLargeStagingDiskType(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.DefaultLargeStagingDiskType = &v
	return s
}

// SetEbsEncryption sets the EbsEncryption field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetEbsEncryption(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.EbsEncryption = &v
	return s
}

// SetEbsEncryptionKeyArn sets the EbsEncryptionKeyArn field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetEbsEncryptionKeyArn(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.EbsEncryptionKeyArn = &v
	return s
}

// SetReplicationConfigurationTemplateID sets the ReplicationConfigurationTemplateID field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetReplicationConfigurationTemplateID(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.ReplicationConfigurationTemplateID = &v
	return s
}

// SetReplicationServerInstanceType sets the ReplicationServerInstanceType field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetReplicationServerInstanceType(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.ReplicationServerInstanceType = &v
	return s
}

// SetReplicationServersSecurityGroupsIDs sets the ReplicationServersSecurityGroupsIDs field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetReplicationServersSecurityGroupsIDs(v []*string) *UpdateReplicationConfigurationTemplateOutput {
	s.ReplicationServersSecurityGroupsIDs = v
	return s
}

// SetStagingAreaSubnetId sets the StagingAreaSubnetId field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetStagingAreaSubnetId(v string) *UpdateReplicationConfigurationTemplateOutput {
	s.StagingAreaSubnetId = &v
	return s
}

// SetStagingAreaTags sets the StagingAreaTags field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetStagingAreaTags(v map[string]*string) *UpdateReplicationConfigurationTemplateOutput {
	s.StagingAreaTags = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetTags(v map[string]*string) *UpdateReplicationConfigurationTemplateOutput {
	s.Tags = v
	return s
}

// SetUseDedicatedReplicationServer sets the UseDedicatedReplicationServer field's value.
func (s *UpdateReplicationConfigurationTemplateOutput) SetUseDedicatedReplicationServer(v bool) *UpdateReplicationConfigurationTemplateOutput {
	s.UseDedicatedReplicationServer = &v
	return s
}

type UpdateSourceServerReplicationTypeInput struct {
	_ struct{} `type:"structure"`

	// Replication type to which to update source server.
	//
	// ReplicationType is a required field
	ReplicationType *string `locationName:"replicationType" type:"string" required:"true" enum:"ReplicationType"`

	// ID of source server on which to update replication type.
	//
	// SourceServerID is a required field
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSourceServerReplicationTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSourceServerReplicationTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSourceServerReplicationTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSourceServerReplicationTypeInput"}
	if s.ReplicationType == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationType"))
	}
	if s.SourceServerID == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceServerID"))
	}
	if s.SourceServerID != nil && len(*s.SourceServerID) < 19 {
		invalidParams.Add(request.NewErrParamMinLen("SourceServerID", 19))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationType sets the ReplicationType field's value.
func (s *UpdateSourceServerReplicationTypeInput) SetReplicationType(v string) *UpdateSourceServerReplicationTypeInput {
	s.ReplicationType = &v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *UpdateSourceServerReplicationTypeInput) SetSourceServerID(v string) *UpdateSourceServerReplicationTypeInput {
	s.SourceServerID = &v
	return s
}

type UpdateSourceServerReplicationTypeOutput struct {
	_ struct{} `type:"structure"`

	// Source server ARN.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Source server data replication info.
	DataReplicationInfo *DataReplicationInfo `locationName:"dataReplicationInfo" type:"structure"`

	// Source server archived status.
	IsArchived *bool `locationName:"isArchived" type:"boolean"`

	// Source server launched instance.
	LaunchedInstance *LaunchedInstance `locationName:"launchedInstance" type:"structure"`

	// Source server lifecycle state.
	LifeCycle *LifeCycle `locationName:"lifeCycle" type:"structure"`

	// Source server replication type.
	ReplicationType *string `locationName:"replicationType" type:"string" enum:"ReplicationType"`

	// Source server properties.
	SourceProperties *SourceProperties `locationName:"sourceProperties" type:"structure"`

	// Source server ID.
	SourceServerID *string `locationName:"sourceServerID" min:"19" type:"string"`

	// Source server Tags.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateSourceServerReplicationTypeOutput's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// Source server vCenter client id.
	VcenterClientID *string `locationName:"vcenterClientID" min:"21" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSourceServerReplicationTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSourceServerReplicationTypeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateSourceServerReplicationTypeOutput) SetArn(v string) *UpdateSourceServerReplicationTypeOutput {
	s.Arn = &v
	return s
}

// SetDataReplicationInfo sets the DataReplicationInfo field's value.
func (s *UpdateSourceServerReplicationTypeOutput) SetDataReplicationInfo(v *DataReplicationInfo) *UpdateSourceServerReplicationTypeOutput {
	s.DataReplicationInfo = v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *UpdateSourceServerReplicationTypeOutput) SetIsArchived(v bool) *UpdateSourceServerReplicationTypeOutput {
	s.IsArchived = &v
	return s
}

// SetLaunchedInstance sets the LaunchedInstance field's value.
func (s *UpdateSourceServerReplicationTypeOutput) SetLaunchedInstance(v *LaunchedInstance) *UpdateSourceServerReplicationTypeOutput {
	s.LaunchedInstance = v
	return s
}

// SetLifeCycle sets the LifeCycle field's value.
func (s *UpdateSourceServerReplicationTypeOutput) SetLifeCycle(v *LifeCycle) *UpdateSourceServerReplicationTypeOutput {
	s.LifeCycle = v
	return s
}

// SetReplicationType sets the ReplicationType field's value.
func (s *UpdateSourceServerReplicationTypeOutput) SetReplicationType(v string) *UpdateSourceServerReplicationTypeOutput {
	s.ReplicationType = &v
	return s
}

// SetSourceProperties sets the SourceProperties field's value.
func (s *UpdateSourceServerReplicationTypeOutput) SetSourceProperties(v *SourceProperties) *UpdateSourceServerReplicationTypeOutput {
	s.SourceProperties = v
	return s
}

// SetSourceServerID sets the SourceServerID field's value.
func (s *UpdateSourceServerReplicationTypeOutput) SetSourceServerID(v string) *UpdateSourceServerReplicationTypeOutput {
	s.SourceServerID = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateSourceServerReplicationTypeOutput) SetTags(v map[string]*string) *UpdateSourceServerReplicationTypeOutput {
	s.Tags = v
	return s
}

// SetVcenterClientID sets the VcenterClientID field's value.
func (s *UpdateSourceServerReplicationTypeOutput) SetVcenterClientID(v string) *UpdateSourceServerReplicationTypeOutput {
	s.VcenterClientID = &v
	return s
}

// Validate exception.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	// Validate exception field list.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`

	// Validate exception reason.
	Reason *string `locationName:"reason" type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Validate exception field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Validate exception field message.
	Message *string `locationName:"message" type:"string"`

	// Validate exception field name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// vCenter client.
type VcenterClient struct {
	_ struct{} `type:"structure"`

	// Arn of vCenter client.
	Arn *string `locationName:"arn" min:"20" type:"string"`

	// Datacenter name of vCenter client.
	DatacenterName *string `locationName:"datacenterName" type:"string"`

	// Hostname of vCenter client .
	Hostname *string `locationName:"hostname" type:"string"`

	// Last seen time of vCenter client.
	LastSeenDatetime *string `locationName:"lastSeenDatetime" min:"19" type:"string"`

	// Tags for Source Server of vCenter client.
	//
	// SourceServerTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by VcenterClient's
	// String and GoString methods.
	SourceServerTags map[string]*string `locationName:"sourceServerTags" type:"map" sensitive:"true"`

	// Tags for vCenter client.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by VcenterClient's
	// String and GoString methods.
	Tags map[string]*string `locationName:"tags" type:"map" sensitive:"true"`

	// ID of vCenter client.
	VcenterClientID *string `locationName:"vcenterClientID" min:"21" type:"string"`

	// Vcenter UUID of vCenter client.
	VcenterUUID *string `locationName:"vcenterUUID" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VcenterClient) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VcenterClient) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *VcenterClient) SetArn(v string) *VcenterClient {
	s.Arn = &v
	return s
}

// SetDatacenterName sets the DatacenterName field's value.
func (s *VcenterClient) SetDatacenterName(v string) *VcenterClient {
	s.DatacenterName = &v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *VcenterClient) SetHostname(v string) *VcenterClient {
	s.Hostname = &v
	return s
}

// SetLastSeenDatetime sets the LastSeenDatetime field's value.
func (s *VcenterClient) SetLastSeenDatetime(v string) *VcenterClient {
	s.LastSeenDatetime = &v
	return s
}

// SetSourceServerTags sets the SourceServerTags field's value.
func (s *VcenterClient) SetSourceServerTags(v map[string]*string) *VcenterClient {
	s.SourceServerTags = v
	return s
}

// SetTags sets the Tags field's value.
func (s *VcenterClient) SetTags(v map[string]*string) *VcenterClient {
	s.Tags = v
	return s
}

// SetVcenterClientID sets the VcenterClientID field's value.
func (s *VcenterClient) SetVcenterClientID(v string) *VcenterClient {
	s.VcenterClientID = &v
	return s
}

// SetVcenterUUID sets the VcenterUUID field's value.
func (s *VcenterClient) SetVcenterUUID(v string) *VcenterClient {
	s.VcenterUUID = &v
	return s
}

const (
	// BootModeLegacyBios is a BootMode enum value
	BootModeLegacyBios = "LEGACY_BIOS"

	// BootModeUefi is a BootMode enum value
	BootModeUefi = "UEFI"
)

// BootMode_Values returns all elements of the BootMode enum
func BootMode_Values() []string {
	return []string{
		BootModeLegacyBios,
		BootModeUefi,
	}
}

const (
	// ChangeServerLifeCycleStateSourceServerLifecycleStateReadyForTest is a ChangeServerLifeCycleStateSourceServerLifecycleState enum value
	ChangeServerLifeCycleStateSourceServerLifecycleStateReadyForTest = "READY_FOR_TEST"

	// ChangeServerLifeCycleStateSourceServerLifecycleStateReadyForCutover is a ChangeServerLifeCycleStateSourceServerLifecycleState enum value
	ChangeServerLifeCycleStateSourceServerLifecycleStateReadyForCutover = "READY_FOR_CUTOVER"

	// ChangeServerLifeCycleStateSourceServerLifecycleStateCutover is a ChangeServerLifeCycleStateSourceServerLifecycleState enum value
	ChangeServerLifeCycleStateSourceServerLifecycleStateCutover = "CUTOVER"
)

// ChangeServerLifeCycleStateSourceServerLifecycleState_Values returns all elements of the ChangeServerLifeCycleStateSourceServerLifecycleState enum
func ChangeServerLifeCycleStateSourceServerLifecycleState_Values() []string {
	return []string{
		ChangeServerLifeCycleStateSourceServerLifecycleStateReadyForTest,
		ChangeServerLifeCycleStateSourceServerLifecycleStateReadyForCutover,
		ChangeServerLifeCycleStateSourceServerLifecycleStateCutover,
	}
}

const (
	// DataReplicationErrorStringAgentNotSeen is a DataReplicationErrorString enum value
	DataReplicationErrorStringAgentNotSeen = "AGENT_NOT_SEEN"

	// DataReplicationErrorStringSnapshotsFailure is a DataReplicationErrorString enum value
	DataReplicationErrorStringSnapshotsFailure = "SNAPSHOTS_FAILURE"

	// DataReplicationErrorStringNotConverging is a DataReplicationErrorString enum value
	DataReplicationErrorStringNotConverging = "NOT_CONVERGING"

	// DataReplicationErrorStringUnstableNetwork is a DataReplicationErrorString enum value
	DataReplicationErrorStringUnstableNetwork = "UNSTABLE_NETWORK"

	// DataReplicationErrorStringFailedToCreateSecurityGroup is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToCreateSecurityGroup = "FAILED_TO_CREATE_SECURITY_GROUP"

	// DataReplicationErrorStringFailedToLaunchReplicationServer is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToLaunchReplicationServer = "FAILED_TO_LAUNCH_REPLICATION_SERVER"

	// DataReplicationErrorStringFailedToBootReplicationServer is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToBootReplicationServer = "FAILED_TO_BOOT_REPLICATION_SERVER"

	// DataReplicationErrorStringFailedToAuthenticateWithService is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToAuthenticateWithService = "FAILED_TO_AUTHENTICATE_WITH_SERVICE"

	// DataReplicationErrorStringFailedToDownloadReplicationSoftware is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToDownloadReplicationSoftware = "FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE"

	// DataReplicationErrorStringFailedToCreateStagingDisks is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToCreateStagingDisks = "FAILED_TO_CREATE_STAGING_DISKS"

	// DataReplicationErrorStringFailedToAttachStagingDisks is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToAttachStagingDisks = "FAILED_TO_ATTACH_STAGING_DISKS"

	// DataReplicationErrorStringFailedToPairReplicationServerWithAgent is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToPairReplicationServerWithAgent = "FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT"

	// DataReplicationErrorStringFailedToConnectAgentToReplicationServer is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToConnectAgentToReplicationServer = "FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER"

	// DataReplicationErrorStringFailedToStartDataTransfer is a DataReplicationErrorString enum value
	DataReplicationErrorStringFailedToStartDataTransfer = "FAILED_TO_START_DATA_TRANSFER"

	// DataReplicationErrorStringUnsupportedVmConfiguration is a DataReplicationErrorString enum value
	DataReplicationErrorStringUnsupportedVmConfiguration = "UNSUPPORTED_VM_CONFIGURATION"

	// DataReplicationErrorStringLastSnapshotJobFailed is a DataReplicationErrorString enum value
	DataReplicationErrorStringLastSnapshotJobFailed = "LAST_SNAPSHOT_JOB_FAILED"
)

// DataReplicationErrorString_Values returns all elements of the DataReplicationErrorString enum
func DataReplicationErrorString_Values() []string {
	return []string{
		DataReplicationErrorStringAgentNotSeen,
		DataReplicationErrorStringSnapshotsFailure,
		DataReplicationErrorStringNotConverging,
		DataReplicationErrorStringUnstableNetwork,
		DataReplicationErrorStringFailedToCreateSecurityGroup,
		DataReplicationErrorStringFailedToLaunchReplicationServer,
		DataReplicationErrorStringFailedToBootReplicationServer,
		DataReplicationErrorStringFailedToAuthenticateWithService,
		DataReplicationErrorStringFailedToDownloadReplicationSoftware,
		DataReplicationErrorStringFailedToCreateStagingDisks,
		DataReplicationErrorStringFailedToAttachStagingDisks,
		DataReplicationErrorStringFailedToPairReplicationServerWithAgent,
		DataReplicationErrorStringFailedToConnectAgentToReplicationServer,
		DataReplicationErrorStringFailedToStartDataTransfer,
		DataReplicationErrorStringUnsupportedVmConfiguration,
		DataReplicationErrorStringLastSnapshotJobFailed,
	}
}

const (
	// DataReplicationInitiationStepNameWait is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameWait = "WAIT"

	// DataReplicationInitiationStepNameCreateSecurityGroup is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameCreateSecurityGroup = "CREATE_SECURITY_GROUP"

	// DataReplicationInitiationStepNameLaunchReplicationServer is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameLaunchReplicationServer = "LAUNCH_REPLICATION_SERVER"

	// DataReplicationInitiationStepNameBootReplicationServer is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameBootReplicationServer = "BOOT_REPLICATION_SERVER"

	// DataReplicationInitiationStepNameAuthenticateWithService is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameAuthenticateWithService = "AUTHENTICATE_WITH_SERVICE"

	// DataReplicationInitiationStepNameDownloadReplicationSoftware is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameDownloadReplicationSoftware = "DOWNLOAD_REPLICATION_SOFTWARE"

	// DataReplicationInitiationStepNameCreateStagingDisks is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameCreateStagingDisks = "CREATE_STAGING_DISKS"

	// DataReplicationInitiationStepNameAttachStagingDisks is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameAttachStagingDisks = "ATTACH_STAGING_DISKS"

	// DataReplicationInitiationStepNamePairReplicationServerWithAgent is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNamePairReplicationServerWithAgent = "PAIR_REPLICATION_SERVER_WITH_AGENT"

	// DataReplicationInitiationStepNameConnectAgentToReplicationServer is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameConnectAgentToReplicationServer = "CONNECT_AGENT_TO_REPLICATION_SERVER"

	// DataReplicationInitiationStepNameStartDataTransfer is a DataReplicationInitiationStepName enum value
	DataReplicationInitiationStepNameStartDataTransfer = "START_DATA_TRANSFER"
)

// DataReplicationInitiationStepName_Values returns all elements of the DataReplicationInitiationStepName enum
func DataReplicationInitiationStepName_Values() []string {
	return []string{
		DataReplicationInitiationStepNameWait,
		DataReplicationInitiationStepNameCreateSecurityGroup,
		DataReplicationInitiationStepNameLaunchReplicationServer,
		DataReplicationInitiationStepNameBootReplicationServer,
		DataReplicationInitiationStepNameAuthenticateWithService,
		DataReplicationInitiationStepNameDownloadReplicationSoftware,
		DataReplicationInitiationStepNameCreateStagingDisks,
		DataReplicationInitiationStepNameAttachStagingDisks,
		DataReplicationInitiationStepNamePairReplicationServerWithAgent,
		DataReplicationInitiationStepNameConnectAgentToReplicationServer,
		DataReplicationInitiationStepNameStartDataTransfer,
	}
}

const (
	// DataReplicationInitiationStepStatusNotStarted is a DataReplicationInitiationStepStatus enum value
	DataReplicationInitiationStepStatusNotStarted = "NOT_STARTED"

	// DataReplicationInitiationStepStatusInProgress is a DataReplicationInitiationStepStatus enum value
	DataReplicationInitiationStepStatusInProgress = "IN_PROGRESS"

	// DataReplicationInitiationStepStatusSucceeded is a DataReplicationInitiationStepStatus enum value
	DataReplicationInitiationStepStatusSucceeded = "SUCCEEDED"

	// DataReplicationInitiationStepStatusFailed is a DataReplicationInitiationStepStatus enum value
	DataReplicationInitiationStepStatusFailed = "FAILED"

	// DataReplicationInitiationStepStatusSkipped is a DataReplicationInitiationStepStatus enum value
	DataReplicationInitiationStepStatusSkipped = "SKIPPED"
)

// DataReplicationInitiationStepStatus_Values returns all elements of the DataReplicationInitiationStepStatus enum
func DataReplicationInitiationStepStatus_Values() []string {
	return []string{
		DataReplicationInitiationStepStatusNotStarted,
		DataReplicationInitiationStepStatusInProgress,
		DataReplicationInitiationStepStatusSucceeded,
		DataReplicationInitiationStepStatusFailed,
		DataReplicationInitiationStepStatusSkipped,
	}
}

const (
	// DataReplicationStateStopped is a DataReplicationState enum value
	DataReplicationStateStopped = "STOPPED"

	// DataReplicationStateInitiating is a DataReplicationState enum value
	DataReplicationStateInitiating = "INITIATING"

	// DataReplicationStateInitialSync is a DataReplicationState enum value
	DataReplicationStateInitialSync = "INITIAL_SYNC"

	// DataReplicationStateBacklog is a DataReplicationState enum value
	DataReplicationStateBacklog = "BACKLOG"

	// DataReplicationStateCreatingSnapshot is a DataReplicationState enum value
	DataReplicationStateCreatingSnapshot = "CREATING_SNAPSHOT"

	// DataReplicationStateContinuous is a DataReplicationState enum value
	DataReplicationStateContinuous = "CONTINUOUS"

	// DataReplicationStatePaused is a DataReplicationState enum value
	DataReplicationStatePaused = "PAUSED"

	// DataReplicationStateRescan is a DataReplicationState enum value
	DataReplicationStateRescan = "RESCAN"

	// DataReplicationStateStalled is a DataReplicationState enum value
	DataReplicationStateStalled = "STALLED"

	// DataReplicationStateDisconnected is a DataReplicationState enum value
	DataReplicationStateDisconnected = "DISCONNECTED"

	// DataReplicationStatePendingSnapshotShipping is a DataReplicationState enum value
	DataReplicationStatePendingSnapshotShipping = "PENDING_SNAPSHOT_SHIPPING"

	// DataReplicationStateShippingSnapshot is a DataReplicationState enum value
	DataReplicationStateShippingSnapshot = "SHIPPING_SNAPSHOT"
)

// DataReplicationState_Values returns all elements of the DataReplicationState enum
func DataReplicationState_Values() []string {
	return []string{
		DataReplicationStateStopped,
		DataReplicationStateInitiating,
		DataReplicationStateInitialSync,
		DataReplicationStateBacklog,
		DataReplicationStateCreatingSnapshot,
		DataReplicationStateContinuous,
		DataReplicationStatePaused,
		DataReplicationStateRescan,
		DataReplicationStateStalled,
		DataReplicationStateDisconnected,
		DataReplicationStatePendingSnapshotShipping,
		DataReplicationStateShippingSnapshot,
	}
}

const (
	// FirstBootWaiting is a FirstBoot enum value
	FirstBootWaiting = "WAITING"

	// FirstBootSucceeded is a FirstBoot enum value
	FirstBootSucceeded = "SUCCEEDED"

	// FirstBootUnknown is a FirstBoot enum value
	FirstBootUnknown = "UNKNOWN"

	// FirstBootStopped is a FirstBoot enum value
	FirstBootStopped = "STOPPED"
)

// FirstBoot_Values returns all elements of the FirstBoot enum
func FirstBoot_Values() []string {
	return []string{
		FirstBootWaiting,
		FirstBootSucceeded,
		FirstBootUnknown,
		FirstBootStopped,
	}
}

const (
	// InitiatedByStartTest is a InitiatedBy enum value
	InitiatedByStartTest = "START_TEST"

	// InitiatedByStartCutover is a InitiatedBy enum value
	InitiatedByStartCutover = "START_CUTOVER"

	// InitiatedByDiagnostic is a InitiatedBy enum value
	InitiatedByDiagnostic = "DIAGNOSTIC"

	// InitiatedByTerminate is a InitiatedBy enum value
	InitiatedByTerminate = "TERMINATE"
)

// InitiatedBy_Values returns all elements of the InitiatedBy enum
func InitiatedBy_Values() []string {
	return []string{
		InitiatedByStartTest,
		InitiatedByStartCutover,
		InitiatedByDiagnostic,
		InitiatedByTerminate,
	}
}

const (
	// JobLogEventJobStart is a JobLogEvent enum value
	JobLogEventJobStart = "JOB_START"

	// JobLogEventServerSkipped is a JobLogEvent enum value
	JobLogEventServerSkipped = "SERVER_SKIPPED"

	// JobLogEventCleanupStart is a JobLogEvent enum value
	JobLogEventCleanupStart = "CLEANUP_START"

	// JobLogEventCleanupEnd is a JobLogEvent enum value
	JobLogEventCleanupEnd = "CLEANUP_END"

	// JobLogEventCleanupFail is a JobLogEvent enum value
	JobLogEventCleanupFail = "CLEANUP_FAIL"

	// JobLogEventSnapshotStart is a JobLogEvent enum value
	JobLogEventSnapshotStart = "SNAPSHOT_START"

	// JobLogEventSnapshotEnd is a JobLogEvent enum value
	JobLogEventSnapshotEnd = "SNAPSHOT_END"

	// JobLogEventSnapshotFail is a JobLogEvent enum value
	JobLogEventSnapshotFail = "SNAPSHOT_FAIL"

	// JobLogEventUsingPreviousSnapshot is a JobLogEvent enum value
	JobLogEventUsingPreviousSnapshot = "USING_PREVIOUS_SNAPSHOT"

	// JobLogEventConversionStart is a JobLogEvent enum value
	JobLogEventConversionStart = "CONVERSION_START"

	// JobLogEventConversionEnd is a JobLogEvent enum value
	JobLogEventConversionEnd = "CONVERSION_END"

	// JobLogEventConversionFail is a JobLogEvent enum value
	JobLogEventConversionFail = "CONVERSION_FAIL"

	// JobLogEventLaunchStart is a JobLogEvent enum value
	JobLogEventLaunchStart = "LAUNCH_START"

	// JobLogEventLaunchFailed is a JobLogEvent enum value
	JobLogEventLaunchFailed = "LAUNCH_FAILED"

	// JobLogEventJobCancel is a JobLogEvent enum value
	JobLogEventJobCancel = "JOB_CANCEL"

	// JobLogEventJobEnd is a JobLogEvent enum value
	JobLogEventJobEnd = "JOB_END"
)

// JobLogEvent_Values returns all elements of the JobLogEvent enum
func JobLogEvent_Values() []string {
	return []string{
		JobLogEventJobStart,
		JobLogEventServerSkipped,
		JobLogEventCleanupStart,
		JobLogEventCleanupEnd,
		JobLogEventCleanupFail,
		JobLogEventSnapshotStart,
		JobLogEventSnapshotEnd,
		JobLogEventSnapshotFail,
		JobLogEventUsingPreviousSnapshot,
		JobLogEventConversionStart,
		JobLogEventConversionEnd,
		JobLogEventConversionFail,
		JobLogEventLaunchStart,
		JobLogEventLaunchFailed,
		JobLogEventJobCancel,
		JobLogEventJobEnd,
	}
}

const (
	// JobStatusPending is a JobStatus enum value
	JobStatusPending = "PENDING"

	// JobStatusStarted is a JobStatus enum value
	JobStatusStarted = "STARTED"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusPending,
		JobStatusStarted,
		JobStatusCompleted,
	}
}

const (
	// JobTypeLaunch is a JobType enum value
	JobTypeLaunch = "LAUNCH"

	// JobTypeTerminate is a JobType enum value
	JobTypeTerminate = "TERMINATE"
)

// JobType_Values returns all elements of the JobType enum
func JobType_Values() []string {
	return []string{
		JobTypeLaunch,
		JobTypeTerminate,
	}
}

const (
	// LaunchDispositionStopped is a LaunchDisposition enum value
	LaunchDispositionStopped = "STOPPED"

	// LaunchDispositionStarted is a LaunchDisposition enum value
	LaunchDispositionStarted = "STARTED"
)

// LaunchDisposition_Values returns all elements of the LaunchDisposition enum
func LaunchDisposition_Values() []string {
	return []string{
		LaunchDispositionStopped,
		LaunchDispositionStarted,
	}
}

const (
	// LaunchStatusPending is a LaunchStatus enum value
	LaunchStatusPending = "PENDING"

	// LaunchStatusInProgress is a LaunchStatus enum value
	LaunchStatusInProgress = "IN_PROGRESS"

	// LaunchStatusLaunched is a LaunchStatus enum value
	LaunchStatusLaunched = "LAUNCHED"

	// LaunchStatusFailed is a LaunchStatus enum value
	LaunchStatusFailed = "FAILED"

	// LaunchStatusTerminated is a LaunchStatus enum value
	LaunchStatusTerminated = "TERMINATED"
)

// LaunchStatus_Values returns all elements of the LaunchStatus enum
func LaunchStatus_Values() []string {
	return []string{
		LaunchStatusPending,
		LaunchStatusInProgress,
		LaunchStatusLaunched,
		LaunchStatusFailed,
		LaunchStatusTerminated,
	}
}

const (
	// LifeCycleStateStopped is a LifeCycleState enum value
	LifeCycleStateStopped = "STOPPED"

	// LifeCycleStateNotReady is a LifeCycleState enum value
	LifeCycleStateNotReady = "NOT_READY"

	// LifeCycleStateReadyForTest is a LifeCycleState enum value
	LifeCycleStateReadyForTest = "READY_FOR_TEST"

	// LifeCycleStateTesting is a LifeCycleState enum value
	LifeCycleStateTesting = "TESTING"

	// LifeCycleStateReadyForCutover is a LifeCycleState enum value
	LifeCycleStateReadyForCutover = "READY_FOR_CUTOVER"

	// LifeCycleStateCuttingOver is a LifeCycleState enum value
	LifeCycleStateCuttingOver = "CUTTING_OVER"

	// LifeCycleStateCutover is a LifeCycleState enum value
	LifeCycleStateCutover = "CUTOVER"

	// LifeCycleStateDisconnected is a LifeCycleState enum value
	LifeCycleStateDisconnected = "DISCONNECTED"

	// LifeCycleStateDiscovered is a LifeCycleState enum value
	LifeCycleStateDiscovered = "DISCOVERED"
)

// LifeCycleState_Values returns all elements of the LifeCycleState enum
func LifeCycleState_Values() []string {
	return []string{
		LifeCycleStateStopped,
		LifeCycleStateNotReady,
		LifeCycleStateReadyForTest,
		LifeCycleStateTesting,
		LifeCycleStateReadyForCutover,
		LifeCycleStateCuttingOver,
		LifeCycleStateCutover,
		LifeCycleStateDisconnected,
		LifeCycleStateDiscovered,
	}
}

const (
	// ReplicationConfigurationDataPlaneRoutingPrivateIp is a ReplicationConfigurationDataPlaneRouting enum value
	ReplicationConfigurationDataPlaneRoutingPrivateIp = "PRIVATE_IP"

	// ReplicationConfigurationDataPlaneRoutingPublicIp is a ReplicationConfigurationDataPlaneRouting enum value
	ReplicationConfigurationDataPlaneRoutingPublicIp = "PUBLIC_IP"
)

// ReplicationConfigurationDataPlaneRouting_Values returns all elements of the ReplicationConfigurationDataPlaneRouting enum
func ReplicationConfigurationDataPlaneRouting_Values() []string {
	return []string{
		ReplicationConfigurationDataPlaneRoutingPrivateIp,
		ReplicationConfigurationDataPlaneRoutingPublicIp,
	}
}

const (
	// ReplicationConfigurationDefaultLargeStagingDiskTypeGp2 is a ReplicationConfigurationDefaultLargeStagingDiskType enum value
	ReplicationConfigurationDefaultLargeStagingDiskTypeGp2 = "GP2"

	// ReplicationConfigurationDefaultLargeStagingDiskTypeSt1 is a ReplicationConfigurationDefaultLargeStagingDiskType enum value
	ReplicationConfigurationDefaultLargeStagingDiskTypeSt1 = "ST1"

	// ReplicationConfigurationDefaultLargeStagingDiskTypeGp3 is a ReplicationConfigurationDefaultLargeStagingDiskType enum value
	ReplicationConfigurationDefaultLargeStagingDiskTypeGp3 = "GP3"
)

// ReplicationConfigurationDefaultLargeStagingDiskType_Values returns all elements of the ReplicationConfigurationDefaultLargeStagingDiskType enum
func ReplicationConfigurationDefaultLargeStagingDiskType_Values() []string {
	return []string{
		ReplicationConfigurationDefaultLargeStagingDiskTypeGp2,
		ReplicationConfigurationDefaultLargeStagingDiskTypeSt1,
		ReplicationConfigurationDefaultLargeStagingDiskTypeGp3,
	}
}

const (
	// ReplicationConfigurationEbsEncryptionDefault is a ReplicationConfigurationEbsEncryption enum value
	ReplicationConfigurationEbsEncryptionDefault = "DEFAULT"

	// ReplicationConfigurationEbsEncryptionCustom is a ReplicationConfigurationEbsEncryption enum value
	ReplicationConfigurationEbsEncryptionCustom = "CUSTOM"
)

// ReplicationConfigurationEbsEncryption_Values returns all elements of the ReplicationConfigurationEbsEncryption enum
func ReplicationConfigurationEbsEncryption_Values() []string {
	return []string{
		ReplicationConfigurationEbsEncryptionDefault,
		ReplicationConfigurationEbsEncryptionCustom,
	}
}

const (
	// ReplicationConfigurationReplicatedDiskStagingDiskTypeAuto is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeAuto = "AUTO"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeGp2 is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeGp2 = "GP2"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeIo1 is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeIo1 = "IO1"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeSc1 is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeSc1 = "SC1"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeSt1 is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeSt1 = "ST1"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeStandard is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeStandard = "STANDARD"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeGp3 is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeGp3 = "GP3"

	// ReplicationConfigurationReplicatedDiskStagingDiskTypeIo2 is a ReplicationConfigurationReplicatedDiskStagingDiskType enum value
	ReplicationConfigurationReplicatedDiskStagingDiskTypeIo2 = "IO2"
)

// ReplicationConfigurationReplicatedDiskStagingDiskType_Values returns all elements of the ReplicationConfigurationReplicatedDiskStagingDiskType enum
func ReplicationConfigurationReplicatedDiskStagingDiskType_Values() []string {
	return []string{
		ReplicationConfigurationReplicatedDiskStagingDiskTypeAuto,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeGp2,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeIo1,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeSc1,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeSt1,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeStandard,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeGp3,
		ReplicationConfigurationReplicatedDiskStagingDiskTypeIo2,
	}
}

const (
	// ReplicationTypeAgentBased is a ReplicationType enum value
	ReplicationTypeAgentBased = "AGENT_BASED"

	// ReplicationTypeSnapshotShipping is a ReplicationType enum value
	ReplicationTypeSnapshotShipping = "SNAPSHOT_SHIPPING"
)

// ReplicationType_Values returns all elements of the ReplicationType enum
func ReplicationType_Values() []string {
	return []string{
		ReplicationTypeAgentBased,
		ReplicationTypeSnapshotShipping,
	}
}

const (
	// TargetInstanceTypeRightSizingMethodNone is a TargetInstanceTypeRightSizingMethod enum value
	TargetInstanceTypeRightSizingMethodNone = "NONE"

	// TargetInstanceTypeRightSizingMethodBasic is a TargetInstanceTypeRightSizingMethod enum value
	TargetInstanceTypeRightSizingMethodBasic = "BASIC"
)

// TargetInstanceTypeRightSizingMethod_Values returns all elements of the TargetInstanceTypeRightSizingMethod enum
func TargetInstanceTypeRightSizingMethod_Values() []string {
	return []string{
		TargetInstanceTypeRightSizingMethodNone,
		TargetInstanceTypeRightSizingMethodBasic,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
