all: egrep fgrep grep grep_sus grep_su3

egrep: alloc.o grep.o grid.o egrep.o plist.o svid3.o
	$(LD) $(LDFLAGS) alloc.o grep.o grid.o egrep.o plist.o svid3.o $(LCOMMON) $(LWCHAR) $(LIBS) -o egrep

fgrep: alloc.o grep.o grid.o fgrep.o plist.o svid3.o ac.o
	$(LD) $(LDFLAGS) alloc.o grep.o grid.o fgrep.o plist.o svid3.o ac.o $(LCOMMON) $(LWCHAR) $(LIBS) -o fgrep

grep: alloc.o grep.o grid.o ggrep.o svid3.o
	$(LD) $(LDFLAGS) alloc.o grep.o grid.o ggrep.o svid3.o $(LCOMMON) $(LWCHAR) $(LIBS) -o grep

grep_sus: alloc.o grep.o grid.o plist.o rcomp.o sus.o ac.o
	$(LD) $(LDFLAGS) alloc.o grep.o grid.o plist.o rcomp.o sus.o ac.o $(LUXRE) $(LCOMMON) $(LWCHAR) $(LIBS) -o grep_sus

grep_su3: alloc.o grep.o grid.o plist.o rcomp.o su3.o ac.o
	$(LD) $(LDFLAGS) alloc.o grep.o grid.o plist.o rcomp.o su3.o ac.o $(LUXRE) $(LCOMMON) $(LWCHAR) $(LIBS) -o grep_su3

alloc.o: alloc.c
	$(CC) $(CFLAGSS) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c alloc.c

grep.o: grep.c
	$(CC) $(CFLAGSS) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c grep.c

grid.o: grid.c
	$(CC) $(CFLAGSS) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c grid.c

ggrep.o: ggrep.c
	$(CC) $(CFLAGSS) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c ggrep.c

plist.o: plist.c
	$(CC) $(CFLAGSS) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c plist.c

rcomp.o: rcomp.c
	$(CC) $(CFLAGS2) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c rcomp.c

egrep.o: egrep.c
	$(CC) $(CFLAGS2) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c egrep.c

fgrep.o: fgrep.c
	$(CC) $(CFLAGSS) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c fgrep.c

ac.o: ac.c
	$(CC) $(CFLAGS2) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c ac.c

svid3.o: svid3.c
	$(CC) $(CFLAGSS) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c svid3.c

sus.o: sus.c
	$(CC) $(CFLAGSS) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -DSUS -c sus.c

su3.o: sus.c
	$(CC) $(CFLAGSS) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -DSU3 -c sus.c -o su3.o

install: all
	$(UCBINST) -c egrep $(ROOT)$(SV3BIN)/egrep
	$(STRIP) $(ROOT)$(SV3BIN)/egrep
	$(UCBINST) -c fgrep $(ROOT)$(SV3BIN)/fgrep
	$(STRIP) $(ROOT)$(SV3BIN)/fgrep
	$(UCBINST) -c grep $(ROOT)$(SV3BIN)/grep
	$(STRIP) $(ROOT)$(SV3BIN)/grep
	$(UCBINST) -c grep_sus $(ROOT)$(SUSBIN)/grep
	$(STRIP) $(ROOT)$(SUSBIN)/grep
	rm -f $(ROOT)$(SUSBIN)/egrep $(ROOT)$(SUSBIN)/fgrep
	$(LNS) grep $(ROOT)$(SUSBIN)/egrep
	$(LNS) grep $(ROOT)$(SUSBIN)/fgrep
	$(UCBINST) -c grep_su3 $(ROOT)$(SU3BIN)/grep
	$(STRIP) $(ROOT)$(SU3BIN)/grep
	rm -f $(ROOT)$(SU3BIN)/egrep $(ROOT)$(SU3BIN)/fgrep
	$(LNS) grep $(ROOT)$(SU3BIN)/egrep
	$(LNS) grep $(ROOT)$(SU3BIN)/fgrep
	$(MANINST) -c -m 644 egrep.1 $(ROOT)$(MANDIR)/man1/egrep.1
	$(MANINST) -c -m 644 fgrep.1 $(ROOT)$(MANDIR)/man1/fgrep.1
	$(MANINST) -c -m 644 grep.1 $(ROOT)$(MANDIR)/man1/grep.1

clean:
	rm -f config.h fgrep egrep grep grep_sus grep_su3 ac.o alloc.o egrep.o fgrep.o ggrep.o grep.o grid.o plist.o rcomp.o sus.o su3.o svid3.o egrep.c core log *~

config.h:
	-echo '/*	Auto-generated by make. Do not edit!	*/' >config.h
	-echo '#include	<wchar.h>' >___build$$$$.c ; \
	$(CC) $(CFLAGS2) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c ___build$$$$.c >/dev/null 2>&1 ; \
	if test $$? = 0 && test -f ___build$$$$.o ; \
	then	echo '#include	<wchar.h>' >>config.h ; \
	fi ; \
	rm -f ___build$$$$.o ___build$$$$.c
	-echo '#include	<wctype.h>' >___build$$$$.c ; \
	$(CC) $(CFLAGS2) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c ___build$$$$.c >/dev/null 2>&1 ; \
	if test $$? = 0 && test -f ___build$$$$.o ; \
	then	echo '#include	<wctype.h>' >>config.h ; \
	fi ; \
	rm -f ___build$$$$.o ___build$$$$.c
	-echo 'long long foo;' >___build$$$$.c ; \
	$(CC) $(CFLAGS2) $(CPPFLAGS) $(IWCHAR) $(ICOMMON) $(IUXRE) $(LARGEF) -c ___build$$$$.c >/dev/null 2>&1 ; \
	if test $$? = 0 && test -f ___build$$$$.o ; \
	then	echo '#define	LONGLONG' >>config.h ; \
	fi ; \
	rm -f ___build$$$$.o ___build$$$$.c

grep.o: grep.h config.h alloc.h
egrep.o: grep.h config.h alloc.h
fgrep.o: grep.h config.h
ggrep.o: grep.h config.h
plist.o: grep.h config.h alloc.h
svid3.o: grep.h config.h
sus.o: grep.h config.h alloc.h
su3.o: grep.h config.h alloc.h
ac.o: alloc.h grep.h
rcomp.o: grep.h config.h alloc.h
