/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpOid;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpIndex
implements Serializable {
    private static final long serialVersionUID = 8712159739982192146L;
    private Vector<SnmpOid> oids = new Vector();
    private int size = 0;

    public SnmpIndex(SnmpOid[] snmpOidArray) {
        this.size = snmpOidArray.length;
        for (int i = 0; i < this.size; ++i) {
            this.oids.addElement(snmpOidArray[i]);
        }
    }

    public SnmpIndex(SnmpOid snmpOid) {
        this.oids.addElement(snmpOid);
        this.size = 1;
    }

    public int getNbComponents() {
        return this.size;
    }

    public Vector<SnmpOid> getComponents() {
        return this.oids;
    }

    public boolean equals(SnmpIndex snmpIndex) {
        if (this.size != snmpIndex.getNbComponents()) {
            return false;
        }
        Vector<SnmpOid> vector = snmpIndex.getComponents();
        for (int i = 0; i < this.size; ++i) {
            SnmpOid snmpOid;
            SnmpOid snmpOid2 = this.oids.elementAt(i);
            if (snmpOid2.equals(snmpOid = vector.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public int compareTo(SnmpIndex snmpIndex) {
        int n = snmpIndex.getNbComponents();
        Vector<SnmpOid> vector = snmpIndex.getComponents();
        for (int i = 0; i < this.size; ++i) {
            SnmpOid snmpOid;
            if (i > n) {
                return 1;
            }
            SnmpOid snmpOid2 = this.oids.elementAt(i);
            int n2 = snmpOid2.compareTo(snmpOid = vector.elementAt(i));
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<SnmpOid> enumeration = this.oids.elements();
        while (enumeration.hasMoreElements()) {
            SnmpOid snmpOid = enumeration.nextElement();
            stringBuilder.append("//").append(snmpOid.toString());
        }
        return stringBuilder.toString();
    }
}

