/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

abstract class NotificationEmitterSupport
implements NotificationEmitter {
    private Object listenerLock = new Object();
    private List<ListenerInfo> listenerList = Collections.emptyList();

    protected NotificationEmitterSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        Object object2 = this.listenerLock;
        synchronized (object2) {
            ArrayList<ListenerInfo> arrayList = new ArrayList<ListenerInfo>(this.listenerList.size() + 1);
            arrayList.addAll(this.listenerList);
            arrayList.add(new ListenerInfo(notificationListener, notificationFilter, object));
            this.listenerList = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<ListenerInfo> arrayList = new ArrayList<ListenerInfo>(this.listenerList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ListenerInfo listenerInfo = (ListenerInfo)arrayList.get(i);
                if (listenerInfo.listener != notificationListener) continue;
                arrayList.remove(i);
            }
            if (arrayList.size() == this.listenerList.size()) {
                throw new ListenerNotFoundException("Listener not registered");
            }
            this.listenerList = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        boolean bl = false;
        Object object2 = this.listenerLock;
        synchronized (object2) {
            ArrayList<ListenerInfo> arrayList = new ArrayList<ListenerInfo>(this.listenerList);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ListenerInfo listenerInfo = (ListenerInfo)arrayList.get(i);
                if (listenerInfo.listener != notificationListener) continue;
                bl = true;
                if (listenerInfo.filter != notificationFilter || listenerInfo.handback != object) continue;
                arrayList.remove(i);
                this.listenerList = arrayList;
                return;
            }
        }
        if (bl) {
            throw new ListenerNotFoundException("Listener not registered with this filter and handback");
        }
        throw new ListenerNotFoundException("Listener not registered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotification(Notification notification) {
        List<ListenerInfo> list;
        if (notification == null) {
            return;
        }
        Object object = this.listenerLock;
        synchronized (object) {
            list = this.listenerList;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ListenerInfo listenerInfo = list.get(i);
            if (listenerInfo.filter != null && !listenerInfo.filter.isNotificationEnabled(notification)) continue;
            try {
                listenerInfo.listener.handleNotification(notification, listenerInfo.handback);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new AssertionError((Object)"Error in invoking listener");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasListeners() {
        Object object = this.listenerLock;
        synchronized (object) {
            return !this.listenerList.isEmpty();
        }
    }

    @Override
    public abstract MBeanNotificationInfo[] getNotificationInfo();

    private class ListenerInfo {
        public NotificationListener listener;
        NotificationFilter filter;
        Object handback;

        public ListenerInfo(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
            this.listener = notificationListener;
            this.filter = notificationFilter;
            this.handback = object;
        }
    }
}

