/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.domain;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public final class FileSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final long size;
    private final long lastAccessMillis;
    private final long lastModifiedMillis;

    public FileSnapshot(Path path, BasicFileAttributes attrs) {
        this(path.getFileName().toString(), attrs.size(), attrs.lastAccessTime().toMillis(), attrs.lastModifiedTime().toMillis());
    }

    public FileSnapshot(String name, long size, long lastAccessMillis, long lastModifiedMillis) {
        this.name = name;
        this.size = size;
        this.lastAccessMillis = lastAccessMillis;
        this.lastModifiedMillis = lastModifiedMillis;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastAccessMillis() {
        return this.lastAccessMillis;
    }

    public long getLastModifiedMillis() {
        return this.lastModifiedMillis;
    }

    public long getLastUsedMillis() {
        return Math.max(this.lastAccessMillis, this.lastModifiedMillis);
    }
}

