/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.internal.JSDLCoreStyleChecker;
import com.jgoodies.dialogs.core.pane.AbstractStyledPaneVisualConfiguration;
import com.jgoodies.dialogs.core.pane.StyledPane;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;

public final class TabbedStyledPane
extends StyledPane {
    private static final String UI_CLASS_ID = "JSDL.TabbedStyledPaneUI";

    public TabbedStyledPane() {
        this(MessageType.PLAIN, (JComponent)null, CommandValue.OK);
    }

    public TabbedStyledPane(Object ... commitObjects) {
        this(MessageType.PLAIN, (JComponent)null, commitObjects);
    }

    public TabbedStyledPane(JComponent header, Object ... commitObjects) {
        this(MessageType.PLAIN, header, commitObjects);
    }

    public TabbedStyledPane(MessageType messageType, Object ... commitObjects) {
        this(messageType, null, commitObjects);
    }

    public TabbedStyledPane(MessageType messageType, JComponent header, Object ... commitObjects) {
        super(messageType, header, JGComponentFactory.getCurrent().createTabbedPane(), commitObjects);
        this.setBackground(UIManager.getColor("TabbedPropertyPane.background"));
        ((AbstractStyledPaneVisualConfiguration)this.getVisualConfiguration()).setCommandArea(null);
    }

    public void addTab(String markedTitle, JComponent component) {
        Preconditions.checkNotNull(component, "The %s must not be null.", "tab component");
        String plainTitle = MnemonicUtils.plainText(markedTitle);
        Preconditions.checkNotBlank(plainTitle, "The %s must not be null.", "plain tab title");
        JSDLCoreStyleChecker.getInstance().checkTabTitle(plainTitle);
        this.getTabbedPane().addTab(plainTitle, component);
        MnemonicUtils.configure(this.getTabbedPane(), this.getTabbedPane().getTabCount() - 1, markedTitle);
    }

    public SingleSelectionModel getTabModel() {
        return this.getTabbedPane().getModel();
    }

    protected JTabbedPane getTabbedPane() {
        return (JTabbedPane)this.getContent();
    }

    @Override
    protected String layoutGroup() {
        return "TabbedStyledPane";
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }
}

