/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.internal.DateUtils;
import java.text.Format;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

public final class ConverterFactory {
    private ConverterFactory() {
    }

    public static ConverterValueModel<Boolean, Boolean> createBooleanNegator(ValueModel booleanSource) {
        return new ConverterValueModel<Boolean, Boolean>(booleanSource, new BooleanNegator());
    }

    public static ConverterValueModel<Boolean, String> createBooleanToStringConverter(ValueModel booleanSubject, String trueText, String falseText) {
        return ConverterFactory.createBooleanToStringConverter(booleanSubject, trueText, falseText, "");
    }

    public static ConverterValueModel<Boolean, String> createBooleanToStringConverter(ValueModel booleanSource, String trueText, String falseText, String nullText) {
        return new ConverterValueModel<Boolean, String>(booleanSource, new BooleanToStringConverter(trueText, falseText, nullText));
    }

    public static ConverterValueModel<Double, Double> createDoubleConverter(ValueModel doubleSource, double multiplier) {
        return new ConverterValueModel<Double, Double>(doubleSource, new DoubleConverter(multiplier));
    }

    public static ConverterValueModel<Double, Integer> createDoubleToIntegerConverter(ValueModel doubleSource) {
        return ConverterFactory.createDoubleToIntegerConverter(doubleSource, 1);
    }

    public static ConverterValueModel<Double, Integer> createDoubleToIntegerConverter(ValueModel doubleSource, int multiplier) {
        return new ConverterValueModel<Double, Integer>(doubleSource, new DoubleToIntegerConverter(multiplier));
    }

    public static ConverterValueModel<Float, Float> createFloatConverter(ValueModel floatSource, float multiplier) {
        return new ConverterValueModel<Float, Float>(floatSource, new FloatConverter(multiplier));
    }

    public static ConverterValueModel<Float, Integer> createFloatToIntegerConverter(ValueModel floatSource) {
        return ConverterFactory.createFloatToIntegerConverter(floatSource, 1);
    }

    public static ConverterValueModel<Float, Integer> createFloatToIntegerConverter(ValueModel floatSource, int multiplier) {
        return new ConverterValueModel<Float, Integer>(floatSource, new FloatToIntegerConverter(multiplier));
    }

    public static ConverterValueModel<Integer, Integer> createIntegerConverter(ValueModel integerSource, double multiplier) {
        return new ConverterValueModel<Integer, Integer>(integerSource, new IntegerConverter(multiplier));
    }

    public static ConverterValueModel<Integer, Double> createIntegerToDoubleConverter(ValueModel integerSource, double multiplier) {
        return new ConverterValueModel<Integer, Double>(integerSource, new IntegerToDoubleConverter(multiplier));
    }

    public static ConverterValueModel<Long, Long> createLongConverter(ValueModel longSource, double multiplier) {
        return new ConverterValueModel<Long, Long>(longSource, new LongConverter(multiplier));
    }

    public static ConverterValueModel<Long, Integer> createLongToIntegerConverter(ValueModel longSubject) {
        return ConverterFactory.createLongToIntegerConverter(longSubject, 1);
    }

    public static ConverterValueModel<Long, Integer> createLongToIntegerConverter(ValueModel longSource, int multiplier) {
        return new ConverterValueModel<Long, Integer>(longSource, new LongToIntegerConverter(multiplier));
    }

    public static ConverterValueModel<Object, String> createStringConverter(ValueModel source, Format format) {
        return new ConverterValueModel<Object, String>(source, new StringConverter(format));
    }

    public static final class BooleanNegator
    implements BindingConverter<Boolean, Boolean> {
        @Override
        public Boolean targetValue(Boolean sourceValue) {
            return BooleanNegator.negate(sourceValue);
        }

        @Override
        public Boolean sourceValue(Boolean targetValue) {
            return BooleanNegator.negate(targetValue);
        }

        private static Boolean negate(Boolean value) {
            return value == null ? null : Boolean.valueOf(value == false);
        }
    }

    public static final class BooleanToStringConverter
    implements BindingConverter<Boolean, String> {
        private final String trueText;
        private final String falseText;
        private final String nullText;

        public BooleanToStringConverter(String trueText, String falseText, String nullText) {
            this.trueText = Preconditions.checkNotNull(trueText, "The %s must not be null.", "trueText");
            this.falseText = Preconditions.checkNotNull(falseText, "The %s must not be null.", "falseText");
            this.nullText = Preconditions.checkNotNull(nullText, "The %s must not be null.", "nullText");
            Preconditions.checkArgument(!trueText.equals(falseText), "The trueText and falseText must be different.");
        }

        @Override
        public String targetValue(Boolean sourceValue) {
            if (sourceValue == null) {
                return this.nullText;
            }
            return sourceValue != false ? this.trueText : this.falseText;
        }

        @Override
        public Boolean sourceValue(String targetValue) {
            if (this.trueText.equalsIgnoreCase(targetValue)) {
                return Boolean.TRUE;
            }
            if (this.falseText.equalsIgnoreCase(targetValue)) {
                return Boolean.FALSE;
            }
            if (this.nullText.equalsIgnoreCase(targetValue)) {
                return null;
            }
            throw new IllegalArgumentException("The new value must be one of: " + this.trueText + '/' + this.falseText + '/' + this.nullText);
        }
    }

    public static final class DoubleConverter
    implements BindingConverter<Double, Double> {
        private final double multiplier;

        public DoubleConverter(double multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Double targetValue(Double sourceValue) {
            return sourceValue * this.multiplier;
        }

        @Override
        public Double sourceValue(Double targetValue) {
            return targetValue / this.multiplier;
        }
    }

    public static final class DoubleToIntegerConverter
    implements BindingConverter<Double, Integer> {
        private final int multiplier;

        public DoubleToIntegerConverter(int multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Integer targetValue(Double sourceValue) {
            double doubleValue = sourceValue;
            if (this.multiplier != 1) {
                doubleValue *= (double)this.multiplier;
            }
            return (int)Math.round(doubleValue);
        }

        @Override
        public Double sourceValue(Integer targetValue) {
            double doubleValue = targetValue.doubleValue();
            if (this.multiplier != 1) {
                doubleValue /= (double)this.multiplier;
            }
            return doubleValue;
        }
    }

    public static final class FloatConverter
    implements BindingConverter<Float, Float> {
        private final float multiplier;

        public FloatConverter(float multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Float targetValue(Float sourceValue) {
            float floatValue = sourceValue.floatValue();
            return Float.valueOf(floatValue * this.multiplier);
        }

        @Override
        public Float sourceValue(Float targetValue) {
            float floatValue = targetValue.floatValue();
            return Float.valueOf(floatValue / this.multiplier);
        }
    }

    public static final class FloatToIntegerConverter
    implements BindingConverter<Float, Integer> {
        private final int multiplier;

        public FloatToIntegerConverter(int multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Integer targetValue(Float sourceValue) {
            float floatValue = sourceValue.floatValue();
            if (this.multiplier != 1) {
                floatValue *= (float)this.multiplier;
            }
            return Math.round(floatValue);
        }

        @Override
        public Float sourceValue(Integer sourceValue) {
            float floatValue = sourceValue.floatValue();
            if (this.multiplier != 1) {
                floatValue /= (float)this.multiplier;
            }
            return Float.valueOf(floatValue);
        }
    }

    public static final class IntegerConverter
    implements BindingConverter<Integer, Integer> {
        private final double multiplier;

        public IntegerConverter(double multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Integer targetValue(Integer sourceValue) {
            double doubleValue = sourceValue.doubleValue();
            return (int)(doubleValue * this.multiplier);
        }

        @Override
        public Integer sourceValue(Integer targetValue) {
            double doubleValue = targetValue.doubleValue();
            return (int)(doubleValue / this.multiplier);
        }
    }

    public static final class IntegerToDoubleConverter
    implements BindingConverter<Integer, Double> {
        private final double multiplier;

        public IntegerToDoubleConverter(double multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Double targetValue(Integer sourceValue) {
            int intValue = sourceValue;
            return (double)intValue * this.multiplier;
        }

        @Override
        public Integer sourceValue(Double targetValue) {
            double doubleValue = targetValue;
            return (int)(doubleValue / this.multiplier);
        }
    }

    public static final class LocalDateTimeToDateConverter
    implements BindingConverter<LocalDateTime, Date> {
        @Override
        public LocalDateTime sourceValue(Date targetValue) {
            return DateUtils.toLocalDateTime(targetValue);
        }

        @Override
        public Date targetValue(LocalDateTime sourceValue) {
            return DateUtils.toDate(sourceValue);
        }
    }

    public static final class LocalDateToDateConverter
    implements BindingConverter<LocalDate, Date> {
        @Override
        public LocalDate sourceValue(Date targetValue) {
            return DateUtils.toLocalDate(targetValue);
        }

        @Override
        public Date targetValue(LocalDate sourceValue) {
            return DateUtils.toDate(sourceValue);
        }
    }

    public static final class LongConverter
    implements BindingConverter<Long, Long> {
        private final double multiplier;

        public LongConverter(double multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Long targetValue(Long sourceValue) {
            double doubleValue = sourceValue.doubleValue();
            return (long)(doubleValue * this.multiplier);
        }

        @Override
        public Long sourceValue(Long targetValue) {
            double doubleValue = targetValue.doubleValue();
            return (long)(doubleValue / this.multiplier);
        }
    }

    public static final class LongToIntegerConverter
    implements BindingConverter<Long, Integer> {
        private final int multiplier;

        public LongToIntegerConverter(int multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Integer targetValue(Long sourceValue) {
            int intValue = sourceValue.intValue();
            if (this.multiplier != 1) {
                intValue *= this.multiplier;
            }
            return intValue;
        }

        @Override
        public Long sourceValue(Integer targetValue) {
            long longValue = targetValue.longValue();
            if (this.multiplier != 1) {
                longValue /= (long)this.multiplier;
            }
            return longValue;
        }
    }

    public static final class StringConverter
    implements BindingConverter<Object, String> {
        private final Format format;

        public StringConverter(Format format) {
            this.format = Preconditions.checkNotNull(format, "The %s must not be null.", "format");
        }

        @Override
        public String targetValue(Object sourceValue) {
            return this.format.format(sourceValue);
        }

        @Override
        public Object sourceValue(String targetValue) {
            try {
                return this.format.parseObject(targetValue);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Cannot parse the target value " + targetValue, e);
            }
        }
    }
}

