/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.application;

import com.jgoodies.application.Task;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.internal.EDTBean;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;

public final class TaskService
extends EDTBean {
    public static final String PROPERTY_TASKS = "tasks";
    private final String name;
    private final ExecutorService executorService;
    private final List<Task<?, ?>> tasks;
    private final PropertyChangeListener taskListUpdater;

    TaskService(String name) {
        this(name, new ThreadPoolExecutor(3, 10, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public TaskService(String name, ExecutorService executorService) {
        this.name = Preconditions.checkNotNull(name, "The %s must not be null.", "name");
        this.executorService = Preconditions.checkNotNull(executorService, "The %s must not be null.", "executorService");
        this.tasks = new ArrayList();
        this.taskListUpdater = this::onStateChanged;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task<?, ?> task) {
        List<Task<?, ?>> newTaskList;
        List<Task<?, ?>> oldTaskList;
        Preconditions.checkNotNull(task, "The %s must not be null.", "task");
        Preconditions.checkState(task.isPending(), "The task has already been executed.");
        List<Task<?, ?>> list = this.tasks;
        synchronized (list) {
            oldTaskList = this.copyTasksList();
            this.tasks.add(task);
            newTaskList = this.copyTasksList();
            task.addPropertyChangeListener(this.taskListUpdater);
        }
        this.firePropertyChange(PROPERTY_TASKS, oldTaskList, newTaskList);
        task.enqueue(this.executorService);
    }

    public List<Task<?, ?>> getTasks() {
        return this.copyTasksList();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Task<?, ?>> copyTasksList() {
        List<Task<?, ?>> list = this.tasks;
        synchronized (list) {
            if (this.tasks.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList(this.tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStateChanged(PropertyChangeEvent evt) {
        if (!"state".equals(evt.getPropertyName())) {
            return;
        }
        if (SwingWorker.StateValue.DONE != evt.getNewValue()) {
            return;
        }
        Task task = (Task)evt.getSource();
        if (task.isDone() || task.isCancelled()) {
            List<Task<?, ?>> newTaskList;
            List<Task<?, ?>> oldTaskList;
            List<Task<?, ?>> list = this.tasks;
            synchronized (list) {
                oldTaskList = this.copyTasksList();
                this.tasks.remove(task);
                task.removePropertyChangeListener(this.taskListUpdater);
                newTaskList = this.copyTasksList();
            }
            this.firePropertyChange(PROPERTY_TASKS, oldTaskList, newTaskList);
        }
    }
}

