---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, sciences, chimie, 
              représentation molécule, chimie organique, structure chimique
---

# Comment représenter des molécules avec l'extension <ctanpkg:chemfig> ?

Même si la syntaxe est différente, une connaissance basique de celle 
de l'extension <ctanpkg:tikz> peut faciliter la prise en main de l'extension
<ctanpkg:chemfig>.


## Principes de base 

### Liaisons et angles

Le principe de base est relativement aisé à comprendre. Cette extension fournit
une commande `\chemfig{}` dans laquelle vous décrivez la structure 
de la molécule.

Chaque liaison prend plusieurs paramètres optionnels et le premier est l’angle
de la liaison avec l’horizotale.
	
L’exemple ci-dessous indique comment peut être modifier l’angle d’une liaison.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemfig}

\begin{document}
\chemfig{CH_3 - CH_2 - CH_2 - CH_3}

\vspace{1.5cm}

\chemfig{CH_3 -[:30] CH_2 -[:-30] CH_2 -[:30] CH_3}
\end{document}
```

Les liaisons les plus courantes ont les notations suivantes :

| Liaison               | Notation de chemfig                           |
|-----------------------|-----------------------------------------------|
| Simple                | `-`                                           |
| Double                | `=`                                           |
| Triple                | `~`                                           |
| Cram vers l’avant     | <code><&#124;</code> ou <code>>&#124;</code>  |
| Cram vers l’arrière   | `<:` ou `>:`                                  |


Les arguments optionnels des liaisons sont indiqués entre crochets à la suite 
de la liaison de la même manière que l’exemple ci-dessus.
L’angle a été vu précédement et le coefficient permet de modifier la longueur
de la liaison. Notez que la modification des atomes de départ et d’arrivée 
peut être utile dans certains cas (voir l’exemple du 
[cyclohexane](#molécules-cycliques) ci-après). Les arguments optionnels
sont donc les suivants :

```{noedit}
[⟨angle⟩ , ⟨coeff⟩ , ⟨atome_de_départ⟩ , ⟨atome_arrivée⟩, ⟨code_tikz⟩ ]
```


### Angles prédéfinis

Les angles prédéfinis 0°, 45°, 90°, etc. peuvent être utilisés en indiquant 
0, 1 ou 2 dans l’argument optionnels des liaisons. Vous pouvez d'ailleurs noter
dans l’exemple suivant l’absence des `:` avant la valeur de l’angle.


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemfig}

\begin{document}
\chemfig{CH_3 -[1] CH_2 -[-1] CH_2 -[1] CH_3}
\end{document}
```


### Représentations topologiques

Pour la représentation topologique, il suffit tout simplement 
de ne pas indiquer les atomes de carbone et d’hydrogène :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemfig}

\begin{document}
\chemfig{-[1]-[-1]-[1]-[-1]OH}
\end{document}
```


## Ramifications

Les ramifications sont indiquées à l’aide de parenthèses. **Attention** 
cependant à bien indiquer la valeur de l’angle pour la liaison correspondant.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemfig}

\begin{document}
\chemfig{CH_3 - CH (-[2] CH_2 - CH_3) - CH_2 - CH_3}
\end{document}
```


## Molécules cycliques

Vous pouvez dessiner les molécules cycliques manuellemment, mais l'extension
fournit une syntaxe simple et rapide.

```{noedit}
\chemfig{ ⟨atome de départ⟩ * ⟨nb de côtés⟩ (liaisons et atomes aux sommets) }
```

L’atome de départ est nécessairement l’atome situé "en bas à gauche" du cycle, 
qui est construit en tournant le sens horaire.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{subcaption}
  \usepackage{chemfig}

\begin{document}
\begin{figure}[ht!]
  \centering
  \subcaptionbox{Le cyclohexane}[.3\textwidth]{%
    \chemfig{HC*6(-CH=CH-CH=CH-HC=[,,2,1])}
    }
  \subcaptionbox{Le cyclohexanol}[.3\textwidth]{%
    \chemfig{HC*6(-CH=CH-CH=CH(-[2]OH)-HC=[,,2,1])}
  }
  \caption{Ne pas confondre !}
\end{figure}
\end{document}
```

Dans l'exemple ci-dessus, nous avons dû imposer les atomes de départ 
et d’arrivée de la dernière liaison du cycle, cette dernière n'étant pas 
satisfaisante. Pour mieux comprendre ce point, vous pouvez retirer 
ces arguments et observer le résultat.

Dans un tout autre registre, nous avons également utilisé pour la gestion 
des sous-figures l'extension <ctanpkg:subcaption> évoquée à la question 
"[](/3_composition/flottants/positionnement/placer_des_figures_cote_a_cote)".


## Charges

Pour indiquer la charge d'un atome, il faut placer la commande suivante 
dans le code de la molécule.

```{noedit}
\charge{⟨angle⟩ = ⟨valeur⟩}{atome}
```

En voici un exemple.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemfig}

\begin{document}
\chemfig{CH_3 - C (=[2]O) - \charge{45=$\ominus$}{O}}
\end{document}
```

Vous pouvez ajuster la position de la charge en indiquant un décalage 
après la valeur de l’angle.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemfig}

\begin{document}
\chemfig{CH_3 - C (=[2]O) - \charge{45:3pt=$\ominus$}{O}}
\end{document}
```


## Représentation de Lewis

:::{warning} 
Les commandes `\Lewis` ou `lewis` ne doivent plus être utlisées 
depuis la version 1.5 du 05/03/2020. L’auteur précise qu’il faut utiliser
maintenant la commande `\charge`. 
:::

La commande `\charge` est également utilisée pour représenter les doublets 
non liants dans la représentation de Lewis. Il suffit d’utiliser comme valeur
la commande `\|`. En voici un exemple.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemfig}

\begin{document}
\chemfig{
	CH_3 - C (=[2] \charge{135=\|, 45=\|}{O}) 
		 - \charge{45:5pt=$\ominus$, 90=\|, 0=\|, -90=\|}{O}
}
\end{document}
```

Notez que :
- la commande `\|` permet au "doublet" de pivoter en fonction de sa position
  autour de l’atome porteur. Si vous utilisez seulement `|` comme valeur 
  de la charge, cela ne sera pas le cas ;
- il ne doit pas y avoir d’espace entre la valeur de l’angle et celle 
  de la charge.


## Ajout du nom des molécules

Pour ajouter le nom d’une espèce chimique, vous pouvez bien entendu la mettre
dans une figure et utiliser la commande `\caption`, mais pour en nommer
plusieurs, cela devient plus complexe. L'extension <ctanpkg:chemfig> propose
une commande permettant de le faire de manière simple.

```{noedit}
\chemname{\chemfig{⟨code de l’entité chimique⟩}}{⟨nom⟩}
```

Voici un exemple avec l’acide éthanoïque. 

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{chemfig}

\begin{document}
\chemname{\chemfig{CH_3 - C (=[2]O) - OH}}{Acide éthanoïque}
\end{document}
```


:::{sources}
- [documentation](texdoc:chemfig) de l'extension <ctanpkg:chemfig>
:::