---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, listes, énumérations, numérotation, enumerate
---

# Comment changer le style de numérotation d'une liste `enumerate` ?

## Avec les commandes de base

Un code de Timothy Murphy, présenté dans l'exemple suivant, 
permet de remplacer les numéros de l'environnement `enumerate` par des lettres grecques 
(et peut être librement adapté pour d'autres styles).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \makeatletter
  \def\greek#1{\expandafter\@greek \csname c@#1\endcsname}
  \def\@greek#1{\ifcase#1%
    \or$\alpha$%
    \or$\beta$%
    \or$\gamma$% 
    \or$\delta$%
    \or$\epsilon$%
    \or$\zeta$%
    \or$\eta$% liste prolongeable autant que nécessaire
    \fi}
  \renewcommand{\theenumi}{\greek{enumi}}
  \makeatother

\begin{document}
Voici la liste des merveilles du monde antique :
\begin{enumerate}
   \item la statue chryséléphantine de Zeus, à Olympie ;
   \item le colosse de Rhodes, sur l'île du même nom ;
   \item les jardins suspendus de Babylone, en Mésopotamie ;
   \item le phare d'Alexandrie, en Égypte ;
   \item la grande pyramide de Gizeh, en Égypte ;
   \item l'Artémision à Éphèse, en Ionie ;
   \item le mausolée d'Halicarnasse, en Carie.
\end{enumerate}
\end{document}
```

Ce code peut être appliqué avec l'environnement `enumerate` modifié par l'extension <ctanpkg:enumerate>, 
décrite juste après.


## Avec les extensions <ctanpkg:enumerate>

L'extension <ctanpkg:enumerate> vous permet de contrôler le format du compteur d'énumération. 
Il ajoute ainsi un paramètre facultatif à l'environnement `enumerate` pour spécifier ce format. 
Ce paramètre contient un type d'énumération (`1` pour les chiffres arabes, 
`a` ou `A` pour l'énumération alphabétique et `i` ou `I` pour les chiffres romains) 
agrémenté d'autres éléments pour décorer l'énumération. 
L'exemple suivant permet d'obtenir une énumération commençant par **(a)**, **(b)**... 
puis une autre énumération commençant par **I/**, **II/**...

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{enumerate}

\begin{document}
Voici la liste des merveilles du monde antique :
\begin{enumerate}[(a)]
   \item la statue chryséléphantine de Zeus, à Olympie ;
   \item le colosse de Rhodes, sur l'île du même nom ;
   \item les jardins suspendus de Babylone, en Mésopotamie ;
   \item le phare d'Alexandrie, en Égypte ;
   \item la grande pyramide de Gizeh, en Égypte ;
   \item l'Artémision à Éphèse, en Ionie ;
   \item le mausolée d'Halicarnasse, en Carie.
\end{enumerate}
\end{document}
```


## Avec les extensions <ctanpkg:enumitem> et <ctanpkg:moreenum>

L'extension <ctanpkg:enumitem>, de Javier Bezos, 
permet de redéfinir le format de l'étiquette de l'environnement `enumerate`.
Elle ajoute un argument facultatif qui, parmi les paramètres disponibles, 
propose le champs `label` où une définition de l'étiquette peut être donnée, comme le montre l'exemple suivant.


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{enumitem}  

\begin{document}
Voici la liste des merveilles du monde antique :
\begin{enumerate}[label=\emph{\alph*})]
   \item la statue chryséléphantine de Zeus, à Olympie ;
   \item le colosse de Rhodes, sur l'île du même nom ;
   \item les jardins suspendus de Babylone, en Mésopotamie ;
   \item le phare d'Alexandrie, en Égypte ;
   \item la grande pyramide de Gizeh, en Égypte ;
   \item l'Artémision à Éphèse, en Ionie ;
   \item le mausolée d'Halicarnasse, en Carie.
\end{enumerate}
\end{document}
```

Notez que la présence du caractère `*` qui représente dans ce cas le compteur de liste à ce niveau. 


Vous pouvez également, avec cette extension, modifier le format des références aux étiquettes d'éléments de liste. 
Dans l'exemple ci-dessous, la référence au sixième élément est mise sous la forme de chiffre romain minuscule :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{enumitem}

\begin{document}
Voici la liste des merveilles du monde antique (dont on remarquera 
tout particulièrement le point \ref{test}) :
\begin{enumerate}[label=\emph{\Roman*}, ref=\roman{*}]
   \item la statue chryséléphantine de Zeus, à Olympie ;
   \item le colosse de Rhodes, sur l'île du même nom ;
   \item les jardins suspendus de Babylone, en Mésopotamie ; 
   \item le phare d'Alexandrie, en Égypte ;
   \item la grande pyramide de Gizeh, en Égypte ;
   \item l'Artémision à Éphèse, en Ionie ; \label{test}
   \item le mausolée d'Halicarnasse, en Carie.
\end{enumerate}
\end{document}
```

La [documentation](texdoc:enumitem) de l'extension propose même des variantes 
avec de la couleur et des symboles spéciaux. 
Elle permet également d'avoir des numérations qui dépendent du niveau de l'énumération 
(par exemple de la forme 1., 1.1., 1.1.1.).

Malgré la grande flexibilité de cette extension, 
certaines possibilités de format d'énumération restent délicates à obtenir.
L'extension <ctanpkg:moreenum>, de Seamus Bradley, 
ajoute des commandes pour gérer quelques formats de plus avec <ctanpkg:enumitem>.
Sont données par exemple des énumérations avec des lettres grecques 
(minuscules avec `\greek`, majuscules avec `\Greek`), du binaire (`\enumbinary`), 
de l'hexadécimal (minuscule avec `\enumhex` , majuscule avec `\enumHex`).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{enumitem}  
  \usepackage{moreenum}   

\begin{document}
Voici la liste des merveilles du monde antique :
\begin{enumerate}[label=\greek*]
   \item la statue chryséléphantine de Zeus, à Olympie ;
   \item le colosse de Rhodes, sur l'île du même nom ;
   \item les jardins suspendus de Babylone, en Mésopotamie ;
   \item le phare d'Alexandrie, en Égypte ;
   \item la grande pyramide de Gizeh, en Égypte ;
   \item l'Artémision à Éphèse, en Ionie ;
   \item le mausolée d'Halicarnasse, en Carie.
\end{enumerate}
\end{document}
```


## Avec l'extension <ctanpkg:paralist>

L'extension <ctanpkg:paralist>, dont le but principal est 
[le compactage de listes](/3_composition/texte/listes/ajuster_l_espacement_dans_les_listes), 
fournit les mêmes fonctionnalités simples que <ctanpkg:enumerate> pour les environnements de type `enumerate`.


## Avec la classe <ctanpkg:memoir>

La classe <ctanpkg:memoir> inclut des fonctions qui correspondent à celles de l'extension <ctanpkg:enumerate>. 
Elle propose également des fonctionnalités similaires pour les listes de l'environnement `itemize`.


:::{sources}
- [Fancy enumeration lists](faquk:FAQ-enumerate)
- [Problem with enumeration using greek letters](https://tex.stackexchange.com/q/342498), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/) ;
:::