---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, références, 
              références bibliographiques, références numériques, 
              trier et compacter les références bibliographiques, 
              ordonner les références
---

# Comment grouper des références bibliographiques multiples ?

Prenons un exemple :

```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{\jobname.bib}
  @book{sylda,
    title = {La Syldavie},
    author = {Remi, Georges},
    year = {1938}              }
  @book{bordu,
    title = {La Bordurie},
    author = {Remi, Georges},
    year = {1938}              }
  @book{polde,
    title = {La Poldévie},
    author = {Remi, Georges},
    year = {1935}              }
  @book{saori,
    title = {Le Sao Rico},
    author = {Remi, Georges},
    year = {1941}              }
  @book{gopal,
    title = {Le Gopal},
    author = {Remi, Georges},
    year = {1939}              }
  \end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Nous devons à Georges \textsc{Remi} de nombreux ouvrages incontournables, 
tout particulièrement \cite{sylda,bordu,polde,saori}.
\bibliographystyle{plain-fr}
\nocite{*}
\bibliography{\jobname}
\end{document}
```

Vous pourrez noter que vous allez obtenir les références dans l'ordre 
de leur entrée, ce qui n'est pas très heureux. Bien sûr, vous pourriez
vous amuser à trier les références dans la commande `\cite`, mais cette
tâche manuelle devrait être éventuellement refaite si le fichier `.bib`
change... et le résultat restera visuellement médiocre.


## Avec l'extension <ctanpkg:cite>

L'extension <ctanpkg:cite> trie les références par ordre numérique 
et détecte les séquences, ce qui donne un résulat plus élégant.

```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{\jobname.bib}
  @book{sylda,
    title = {La Syldavie},
    author = {Remi, Georges},
    year = {1938}              }
  @book{bordu,
    title = {La Bordurie},
    author = {Remi, Georges},
    year = {1938}              }
  @book{polde,
    title = {La Poldévie},
    author = {Remi, Georges},
    year = {1935}              }
  @book{saori,
    title = {Le Sao Rico},
    author = {Remi, Georges},
    year = {1941}              }
  @book{gopal,
    title = {Le Gopal},
    author = {Remi, Georges},
    year = {1939}              }
  \end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{cite}

\begin{document}
Nous devons à Georges \textsc{Remi} de nombreux ouvrages incontournables, 
tout particulièrement \cite{sylda,bordu,polde,saori}.
\bibliographystyle{plain-fr}
\nocite{*}
\bibliography{\jobname}
\end{document}
```


## Avec l'extension <ctanpkg:natbib>

L'extension <ctanpkg:natbib>, avec les options `numbers` et `sort&compress`,
fait la même chose quand elle est utilisée avec ses propres styles
bibliographiques (`plainnat.bst` et `unsrtnat.bst`).


```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{\jobname.bib}
  @book{sylda,
    title = {La Syldavie},
    author = {Remi, Georges},
    year = {1938}              }
  @book{bordu,
    title = {La Bordurie},
    author = {Remi, Georges},
    year = {1938}              }
  @book{polde,
    title = {La Poldévie},
    author = {Remi, Georges},
    year = {1935}              }
  @book{saori,
    title = {Le Sao Rico},
    author = {Remi, Georges},
    year = {1941}              }
  @book{gopal,
    title = {Le Gopal},
    author = {Remi, Georges},
    year = {1939}              }
  \end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[numbers, sort&compress]{natbib}

\begin{document}
Nous devons à Georges \textsc{Remi} de nombreux ouvrages incontournables, 
tout particulièrement \cite{sylda,bordu,polde,saori}.
\bibliographystyle{plainnat}
\nocite{*}
\bibliography{\jobname}
\end{document}
```


## Avec <ctanpkg:biblatex>

De son côté, <ctanpkg:biblatex> a un style intégré, `numeric-comp`, 
pour obtenir ce résultat.

``` 
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{\jobname.bib}
  @book{sylda,
    title = {La Syldavie},
    author = {Remi, Georges},
    year = {1938}              }
  @book{bordu,
    title = {La Bordurie},
    author = {Remi, Georges},
    year = {1938}              }
  @book{polde,
    title = {La Poldévie},
    author = {Remi, Georges},
    year = {1935}              }
  @book{saori,
    title = {Le Sao Rico},
    author = {Remi, Georges},
    year = {1941}              }
  @book{gopal,
    title = {Le Gopal},
    author = {Remi, Georges},
    year = {1939}              }
  \end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[style=numeric-comp]{biblatex}

  \addbibresource{\jobname.bib}

\begin{document}
Nous devons à Georges \textsc{Remi} de nombreux ouvrages incontournables, 
tout particulièrement \cite{sylda,bordu,polde,saori}.
\nocite{*}
\printbibliography
\end{document}
```


:::{sources}
- [Sorting and compressing citations](faquk:FAQ-citesort)
:::