---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, références, 
              style de références bibliographiques
---

# Comment configurer la commande `\cite` ?

## Avec l'extension <ctanpkg:cite>

L'extension <ctanpkg:cite> permet de configurer la commande `\cite`
à travers une série d'options. Certaines permettent par exemple de grouper
automatiquement les références multiples comme le montre la question 
"[](/3_composition/annexes/bibliographie/references/grouper_des_references_bibligraphiques_multiples)".

L'extension permet également de rédéfinir les symboles utilisés
par la commande `\cite`, comme le montre l'exemple suivant avec
quelques-unes de ces fonctions.

```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{\jobname.bib}
  @book{prevots,
    author = {de Lhomel, Georges},
    title = {Liste des prévôts de Montreuil et de leurs lieutenants 
             1280-1560 (Éd. 1899)},
    publisher = {Hachette Livre BnF},
    year = {2016},
  }
  @book{fiefs,
    author = {de Lhomel, Georges},
    title = {Éditions de fiefs et arrière-fiefs du comté de Ponthieu 
             situés dans l'arrondissement de Montreuil-sur-mer (Éd. 1887)},
    publisher = {Hachette Livre BnF},
    year = {2018},
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{cite}

  % Rédéfinitions rendues possibles par cite
  \renewcommand\citeleft{\{} % Accolade ouvrante au lieu d'un crochet
  \renewcommand\citeright{\}} % Accolade fermante au lieu d'un crochet
  \renewcommand\citepunct{; } % Ponctueation entre références

\begin{document}
Cet homme était remarquable. Mais il restait à déterminer si le
résultat de ses travaux\cite{prevots, fiefs} allait marquer durablement 
les siècles à venir.
\bibliographystyle{plain}
\bibliography{\jobname}
\end{document}
```


## Avec l'extension <ctanpkg:natbib>

L'extension <ctanpkg:natbib> permet de disposer de plusieurs styles 
de référence : par exemple, avec les noms des auteurs et les années 
ou juste les auteurs, au moyen de plusieurs commandes 
ayant des arguments optionnels. Elle est fournie avec des styles 
bibliographiques adaptés (`plainnat`, `unsrtnat`, `abbrnat`) qui reproduisent
les styles standards de BibTeX.

L'exemple ci-dessous présente une des commandes de référence alternative
proposée par <ctanpkg:natbib> : `\citep` qui fait, dans son utilisation 
la plus directe, une référence parenthésée donnant le nom du ou des auteurs 
et l'année de parution du document référencé. L'extension tient d'ailleurs
bien compte du fait que les deux références ont le même auteur 
mais pas la même année. 

```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{\jobname.bib}
  @book{prevots,
    author = {de Lhomel, Georges},
    title = {Liste des prévôts de Montreuil et de leurs lieutenants 
             1280-1560 (Éd. 1899)},
    publisher = {Hachette Livre BnF},
    year = {2016},
  }
  @book{fiefs,
    author = {de Lhomel, Georges},
    title = {Éditions de fiefs et arrière-fiefs du comté de Ponthieu 
             situés dans l'arrondissement de Montreuil-sur-mer (Éd. 1887)},
    publisher = {Hachette Livre BnF},
    year = {2018},
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{natbib}

\begin{document}
Cet homme était remarquable. Mais il restait à déterminer si le
résultat de ses travaux \citep{prevots, fiefs} allait marquer durablement 
les siècles à venir.
\bibliographystyle{plainnat}
\bibliography{\jobname}
\end{document}
```

L'extension présente bien d'autres possibilités (commandes `\citet`, 
`\citealt`, `\citeauthor`, `\citealt`...) toutes décrites et illustrées 
dans la [documentation](texdoc:natbib) de <ctanpkg:natbib>.

Les styles produits avec <ctanpkg:custom-bib> sont compatibles 
avec <ctanpkg:natbib>.


## Avec l'extension <ctanpkg:overcite>

De son côté, l'extension <ctanpkg:overcite> modifie le style des références 
en les plaçant en exposant.

```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}[nosearch,overwrite]{\jobname.bib}
  @book{prevots,
    author = {de Lhomel, Georges},
    title = {Liste des prévôts de Montreuil et de leurs lieutenants 
             1280-1560 (Éd. 1899)},
    publisher = {Hachette Livre BnF},
    year = {2016},
  }
  @book{fiefs,
    author = {de Lhomel, Georges},
    title = {Éditions de fiefs et arrière-fiefs du comté de Ponthieu 
             situés dans l'arrondissement de Montreuil-sur-mer (Éd. 1887)},
    publisher = {Hachette Livre BnF},
    year = {2018},
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{overcite}

\begin{document}
Cet homme était remarquable. Mais il restait à déterminer si le
résultat de ses travaux\cite{prevots, fiefs} allait marquer durablement 
les siècles à venir.
\bibliographystyle{plain}
\bibliography{\jobname}
\end{document}
```

Il est à noter que l'extension <ctanpkg:overcite> peut-être appelée 
avec l'extension <ctanpkg:cite> et son option `superscript` pour
obtenir le même effet :

```{noedit}
\usepackage[superscript]{cite}
```