/*
 * wxCHTDecoder
 * Copyright (C) 2004,2008 emuWorks
 * http://games.technoplaza.net/
 *
 * This file is part of wxCHTDecoder.
 *
 * wxCHTDecoder is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wxCHTDecoder is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with wxCHTDecoder; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// $Id: chtfiledroptarget.cc,v 1.3 2008/12/15 03:57:04 jdratlif Exp $

#ifdef HAVE_CONFIG_H
    #include <config.h>
#endif

#include <wx/wxprec.h>

#ifndef WX_PRECOMP
   #include <wx/wx.h>
#endif

#include "tools/chtfilereader.hh"
#include "view/chtfiledroptarget.hh"
#include "view/chttextcontrol.hh"

using namespace wxCHTDecoder;

bool CHTFileDropTarget::OnDropFiles(wxCoord, wxCoord,
                                    const wxArrayString &files) {
    int size = files.GetCount();

    if (size > 0) {
        wxString filename = files[0];
        owner->readCHTFile(filename);
    }

    return true;
}

