//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgimage?language=objc)
#[doc(alias = "CGImageRef")]
#[repr(C)]
pub struct CGImage {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGImage {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGImage"> for CGImage {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgimagealphainfo?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGImageAlphaInfo(pub u32);
impl CGImageAlphaInfo {
    #[doc(alias = "kCGImageAlphaNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "kCGImageAlphaPremultipliedLast")]
    pub const PremultipliedLast: Self = Self(1);
    #[doc(alias = "kCGImageAlphaPremultipliedFirst")]
    pub const PremultipliedFirst: Self = Self(2);
    #[doc(alias = "kCGImageAlphaLast")]
    pub const Last: Self = Self(3);
    #[doc(alias = "kCGImageAlphaFirst")]
    pub const First: Self = Self(4);
    #[doc(alias = "kCGImageAlphaNoneSkipLast")]
    pub const NoneSkipLast: Self = Self(5);
    #[doc(alias = "kCGImageAlphaNoneSkipFirst")]
    pub const NoneSkipFirst: Self = Self(6);
    #[doc(alias = "kCGImageAlphaOnly")]
    pub const Only: Self = Self(7);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGImageAlphaInfo {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGImageAlphaInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgimagecomponentinfo?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGImageComponentInfo(pub u32);
impl CGImageComponentInfo {
    #[doc(alias = "kCGImageComponentInteger")]
    pub const Integer: Self = Self(0 << 8);
    #[doc(alias = "kCGImageComponentFloat")]
    pub const Float: Self = Self(1 << 8);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGImageComponentInfo {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGImageComponentInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgimagebyteorderinfo?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGImageByteOrderInfo(pub u32);
impl CGImageByteOrderInfo {
    #[doc(alias = "kCGImageByteOrderMask")]
    #[deprecated]
    pub const OrderMask: Self = Self(0x7000);
    #[doc(alias = "kCGImageByteOrderDefault")]
    pub const OrderDefault: Self = Self(0 << 12);
    #[doc(alias = "kCGImageByteOrder16Little")]
    pub const Order16Little: Self = Self(1 << 12);
    #[doc(alias = "kCGImageByteOrder32Little")]
    pub const Order32Little: Self = Self(2 << 12);
    #[doc(alias = "kCGImageByteOrder16Big")]
    pub const Order16Big: Self = Self(3 << 12);
    #[doc(alias = "kCGImageByteOrder32Big")]
    pub const Order32Big: Self = Self(4 << 12);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGImageByteOrderInfo {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGImageByteOrderInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgimagepixelformatinfo?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGImagePixelFormatInfo(pub u32);
impl CGImagePixelFormatInfo {
    #[doc(alias = "kCGImagePixelFormatMask")]
    #[deprecated]
    pub const Mask: Self = Self(0xF0000);
    #[doc(alias = "kCGImagePixelFormatPacked")]
    pub const Packed: Self = Self(0 << 16);
    #[doc(alias = "kCGImagePixelFormatRGB555")]
    pub const RGB555: Self = Self(1 << 16);
    #[doc(alias = "kCGImagePixelFormatRGB565")]
    pub const RGB565: Self = Self(2 << 16);
    #[doc(alias = "kCGImagePixelFormatRGB101010")]
    pub const RGB101010: Self = Self(3 << 16);
    #[doc(alias = "kCGImagePixelFormatRGBCIF10")]
    pub const RGBCIF10: Self = Self(4 << 16);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGImagePixelFormatInfo {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGImagePixelFormatInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgbitmapinfo?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGBitmapInfo(pub u32);
bitflags::bitflags! {
    impl CGBitmapInfo: u32 {
        #[doc(alias = "kCGBitmapAlphaInfoMask")]
        const AlphaInfoMask = 0x1F;
        #[doc(alias = "kCGBitmapComponentInfoMask")]
        const ComponentInfoMask = 0xF00;
        #[doc(alias = "kCGBitmapByteOrderInfoMask")]
        const ByteOrderInfoMask = 0x7000;
        #[doc(alias = "kCGBitmapPixelFormatInfoMask")]
        const PixelFormatInfoMask = 0xF0000;
        #[doc(alias = "kCGBitmapFloatInfoMask")]
#[deprecated]
        const FloatInfoMask = CGBitmapInfo::ComponentInfoMask.0;
        #[doc(alias = "kCGBitmapByteOrderMask")]
#[deprecated]
        const ByteOrderMask = CGBitmapInfo::ByteOrderInfoMask.0;
        #[doc(alias = "kCGBitmapFloatComponents")]
#[deprecated]
        const FloatComponents = CGImageComponentInfo::Float.0;
        #[doc(alias = "kCGBitmapByteOrderDefault")]
#[deprecated]
        const ByteOrderDefault = CGImageByteOrderInfo::OrderDefault.0;
        #[doc(alias = "kCGBitmapByteOrder16Little")]
#[deprecated]
        const ByteOrder16Little = CGImageByteOrderInfo::Order16Little.0;
        #[doc(alias = "kCGBitmapByteOrder32Little")]
#[deprecated]
        const ByteOrder32Little = CGImageByteOrderInfo::Order32Little.0;
        #[doc(alias = "kCGBitmapByteOrder16Big")]
#[deprecated]
        const ByteOrder16Big = CGImageByteOrderInfo::Order16Big.0;
        #[doc(alias = "kCGBitmapByteOrder32Big")]
#[deprecated]
        const ByteOrder32Big = CGImageByteOrderInfo::Order32Big.0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGBitmapInfo {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGBitmapInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CGBitmapInfo {
    // TODO: pub fn CGBitmapInfoMake(alpha: CGImageAlphaInfo,component: CGImageComponentInfo,byte_order: CGImageByteOrderInfo,pixel_format: CGImagePixelFormatInfo,) -> CGBitmapInfo;
}

unsafe impl ConcreteType for CGImage {
    #[doc(alias = "CGImageGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGImageGetTypeID() -> CFTypeID;
        }
        unsafe { CGImageGetTypeID() }
    }
}

impl CGImage {
    /// # Safety
    ///
    /// `decode` must be a valid pointer or null.
    #[doc(alias = "CGImageCreate")]
    #[cfg(all(feature = "CGColorSpace", feature = "CGDataProvider"))]
    #[inline]
    pub unsafe fn new(
        width: usize,
        height: usize,
        bits_per_component: usize,
        bits_per_pixel: usize,
        bytes_per_row: usize,
        space: Option<&CGColorSpace>,
        bitmap_info: CGBitmapInfo,
        provider: Option<&CGDataProvider>,
        decode: *const CGFloat,
        should_interpolate: bool,
        intent: CGColorRenderingIntent,
    ) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageCreate(
                width: usize,
                height: usize,
                bits_per_component: usize,
                bits_per_pixel: usize,
                bytes_per_row: usize,
                space: Option<&CGColorSpace>,
                bitmap_info: CGBitmapInfo,
                provider: Option<&CGDataProvider>,
                decode: *const CGFloat,
                should_interpolate: bool,
                intent: CGColorRenderingIntent,
            ) -> Option<NonNull<CGImage>>;
        }
        let ret = unsafe {
            CGImageCreate(
                width,
                height,
                bits_per_component,
                bits_per_pixel,
                bytes_per_row,
                space,
                bitmap_info,
                provider,
                decode,
                should_interpolate,
                intent,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `decode` must be a valid pointer or null.
    #[doc(alias = "CGImageMaskCreate")]
    #[cfg(feature = "CGDataProvider")]
    #[inline]
    pub unsafe fn mask_create(
        width: usize,
        height: usize,
        bits_per_component: usize,
        bits_per_pixel: usize,
        bytes_per_row: usize,
        provider: Option<&CGDataProvider>,
        decode: *const CGFloat,
        should_interpolate: bool,
    ) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageMaskCreate(
                width: usize,
                height: usize,
                bits_per_component: usize,
                bits_per_pixel: usize,
                bytes_per_row: usize,
                provider: Option<&CGDataProvider>,
                decode: *const CGFloat,
                should_interpolate: bool,
            ) -> Option<NonNull<CGImage>>;
        }
        let ret = unsafe {
            CGImageMaskCreate(
                width,
                height,
                bits_per_component,
                bits_per_pixel,
                bytes_per_row,
                provider,
                decode,
                should_interpolate,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGImageCreateCopy")]
    #[inline]
    pub fn new_copy(image: Option<&CGImage>) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageCreateCopy(image: Option<&CGImage>) -> Option<NonNull<CGImage>>;
        }
        let ret = unsafe { CGImageCreateCopy(image) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `decode` must be a valid pointer or null.
    #[doc(alias = "CGImageCreateWithJPEGDataProvider")]
    #[cfg(all(feature = "CGColorSpace", feature = "CGDataProvider"))]
    #[inline]
    pub unsafe fn with_jpeg_data_provider(
        source: Option<&CGDataProvider>,
        decode: *const CGFloat,
        should_interpolate: bool,
        intent: CGColorRenderingIntent,
    ) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageCreateWithJPEGDataProvider(
                source: Option<&CGDataProvider>,
                decode: *const CGFloat,
                should_interpolate: bool,
                intent: CGColorRenderingIntent,
            ) -> Option<NonNull<CGImage>>;
        }
        let ret = unsafe {
            CGImageCreateWithJPEGDataProvider(source, decode, should_interpolate, intent)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `decode` must be a valid pointer or null.
    #[doc(alias = "CGImageCreateWithPNGDataProvider")]
    #[cfg(all(feature = "CGColorSpace", feature = "CGDataProvider"))]
    #[inline]
    pub unsafe fn with_png_data_provider(
        source: Option<&CGDataProvider>,
        decode: *const CGFloat,
        should_interpolate: bool,
        intent: CGColorRenderingIntent,
    ) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageCreateWithPNGDataProvider(
                source: Option<&CGDataProvider>,
                decode: *const CGFloat,
                should_interpolate: bool,
                intent: CGColorRenderingIntent,
            ) -> Option<NonNull<CGImage>>;
        }
        let ret =
            unsafe { CGImageCreateWithPNGDataProvider(source, decode, should_interpolate, intent) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGImageCreateWithImageInRect")]
    #[inline]
    pub fn with_image_in_rect(
        image: Option<&CGImage>,
        rect: CGRect,
    ) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageCreateWithImageInRect(
                image: Option<&CGImage>,
                rect: CGRect,
            ) -> Option<NonNull<CGImage>>;
        }
        let ret = unsafe { CGImageCreateWithImageInRect(image, rect) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGImageCreateWithMask")]
    #[inline]
    pub fn with_mask(
        image: Option<&CGImage>,
        mask: Option<&CGImage>,
    ) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageCreateWithMask(
                image: Option<&CGImage>,
                mask: Option<&CGImage>,
            ) -> Option<NonNull<CGImage>>;
        }
        let ret = unsafe { CGImageCreateWithMask(image, mask) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `components` must be a valid pointer or null.
    #[doc(alias = "CGImageCreateWithMaskingColors")]
    #[inline]
    pub unsafe fn with_masking_colors(
        image: Option<&CGImage>,
        components: *const CGFloat,
    ) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageCreateWithMaskingColors(
                image: Option<&CGImage>,
                components: *const CGFloat,
            ) -> Option<NonNull<CGImage>>;
        }
        let ret = unsafe { CGImageCreateWithMaskingColors(image, components) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGImageCreateCopyWithColorSpace")]
    #[cfg(feature = "CGColorSpace")]
    #[inline]
    pub fn new_copy_with_color_space(
        image: Option<&CGImage>,
        space: Option<&CGColorSpace>,
    ) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageCreateCopyWithColorSpace(
                image: Option<&CGImage>,
                space: Option<&CGColorSpace>,
            ) -> Option<NonNull<CGImage>>;
        }
        let ret = unsafe { CGImageCreateCopyWithColorSpace(image, space) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `decode` must be a valid pointer or null.
    #[doc(alias = "CGImageCreateWithContentHeadroom")]
    #[cfg(all(feature = "CGColorSpace", feature = "CGDataProvider"))]
    #[inline]
    pub unsafe fn with_content_headroom(
        headroom: c_float,
        width: usize,
        height: usize,
        bits_per_component: usize,
        bits_per_pixel: usize,
        bytes_per_row: usize,
        space: Option<&CGColorSpace>,
        bitmap_info: CGBitmapInfo,
        provider: Option<&CGDataProvider>,
        decode: *const CGFloat,
        should_interpolate: bool,
        intent: CGColorRenderingIntent,
    ) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageCreateWithContentHeadroom(
                headroom: c_float,
                width: usize,
                height: usize,
                bits_per_component: usize,
                bits_per_pixel: usize,
                bytes_per_row: usize,
                space: Option<&CGColorSpace>,
                bitmap_info: CGBitmapInfo,
                provider: Option<&CGDataProvider>,
                decode: *const CGFloat,
                should_interpolate: bool,
                intent: CGColorRenderingIntent,
            ) -> Option<NonNull<CGImage>>;
        }
        let ret = unsafe {
            CGImageCreateWithContentHeadroom(
                headroom,
                width,
                height,
                bits_per_component,
                bits_per_pixel,
                bytes_per_row,
                space,
                bitmap_info,
                provider,
                decode,
                should_interpolate,
                intent,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGImageCreateCopyWithContentHeadroom")]
    #[inline]
    pub fn new_copy_with_content_headroom(
        headroom: c_float,
        image: Option<&CGImage>,
    ) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageCreateCopyWithContentHeadroom(
                headroom: c_float,
                image: Option<&CGImage>,
            ) -> Option<NonNull<CGImage>>;
        }
        let ret = unsafe { CGImageCreateCopyWithContentHeadroom(headroom, image) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdefaulthdrimagecontentheadroom?language=objc)
    pub static kCGDefaultHDRImageContentHeadroom: c_float;
}

impl CGImage {
    #[doc(alias = "CGImageGetContentHeadroom")]
    #[inline]
    pub fn content_headroom(image: Option<&CGImage>) -> c_float {
        extern "C-unwind" {
            fn CGImageGetContentHeadroom(image: Option<&CGImage>) -> c_float;
        }
        unsafe { CGImageGetContentHeadroom(image) }
    }

    #[doc(alias = "CGImageCalculateContentHeadroom")]
    #[inline]
    pub fn calculate_content_headroom(image: Option<&CGImage>) -> c_float {
        extern "C-unwind" {
            fn CGImageCalculateContentHeadroom(image: Option<&CGImage>) -> c_float;
        }
        unsafe { CGImageCalculateContentHeadroom(image) }
    }

    #[doc(alias = "CGImageGetContentAverageLightLevel")]
    #[inline]
    pub fn content_average_light_level(image: Option<&CGImage>) -> c_float {
        extern "C-unwind" {
            fn CGImageGetContentAverageLightLevel(image: Option<&CGImage>) -> c_float;
        }
        unsafe { CGImageGetContentAverageLightLevel(image) }
    }

    #[doc(alias = "CGImageCalculateContentAverageLightLevel")]
    #[inline]
    pub fn calculate_content_average_light_level(image: Option<&CGImage>) -> c_float {
        extern "C-unwind" {
            fn CGImageCalculateContentAverageLightLevel(image: Option<&CGImage>) -> c_float;
        }
        unsafe { CGImageCalculateContentAverageLightLevel(image) }
    }

    #[doc(alias = "CGImageCreateCopyWithContentAverageLightLevel")]
    #[inline]
    pub fn new_copy_with_content_average_light_level(
        image: Option<&CGImage>,
        avll: c_float,
    ) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageCreateCopyWithContentAverageLightLevel(
                image: Option<&CGImage>,
                avll: c_float,
            ) -> Option<NonNull<CGImage>>;
        }
        let ret = unsafe { CGImageCreateCopyWithContentAverageLightLevel(image, avll) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGImageCreateCopyWithCalculatedHDRStats")]
    #[inline]
    pub fn new_copy_with_calculated_hdr_stats(
        image: Option<&CGImage>,
    ) -> Option<CFRetained<CGImage>> {
        extern "C-unwind" {
            fn CGImageCreateCopyWithCalculatedHDRStats(
                image: Option<&CGImage>,
            ) -> Option<NonNull<CGImage>>;
        }
        let ret = unsafe { CGImageCreateCopyWithCalculatedHDRStats(image) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGImageIsMask")]
    #[inline]
    pub fn is_mask(image: Option<&CGImage>) -> bool {
        extern "C-unwind" {
            fn CGImageIsMask(image: Option<&CGImage>) -> bool;
        }
        unsafe { CGImageIsMask(image) }
    }

    #[doc(alias = "CGImageGetWidth")]
    #[inline]
    pub fn width(image: Option<&CGImage>) -> usize {
        extern "C-unwind" {
            fn CGImageGetWidth(image: Option<&CGImage>) -> usize;
        }
        unsafe { CGImageGetWidth(image) }
    }

    #[doc(alias = "CGImageGetHeight")]
    #[inline]
    pub fn height(image: Option<&CGImage>) -> usize {
        extern "C-unwind" {
            fn CGImageGetHeight(image: Option<&CGImage>) -> usize;
        }
        unsafe { CGImageGetHeight(image) }
    }

    #[doc(alias = "CGImageGetBitsPerComponent")]
    #[inline]
    pub fn bits_per_component(image: Option<&CGImage>) -> usize {
        extern "C-unwind" {
            fn CGImageGetBitsPerComponent(image: Option<&CGImage>) -> usize;
        }
        unsafe { CGImageGetBitsPerComponent(image) }
    }

    #[doc(alias = "CGImageGetBitsPerPixel")]
    #[inline]
    pub fn bits_per_pixel(image: Option<&CGImage>) -> usize {
        extern "C-unwind" {
            fn CGImageGetBitsPerPixel(image: Option<&CGImage>) -> usize;
        }
        unsafe { CGImageGetBitsPerPixel(image) }
    }

    #[doc(alias = "CGImageGetBytesPerRow")]
    #[inline]
    pub fn bytes_per_row(image: Option<&CGImage>) -> usize {
        extern "C-unwind" {
            fn CGImageGetBytesPerRow(image: Option<&CGImage>) -> usize;
        }
        unsafe { CGImageGetBytesPerRow(image) }
    }

    #[doc(alias = "CGImageGetColorSpace")]
    #[cfg(feature = "CGColorSpace")]
    #[inline]
    pub fn color_space(image: Option<&CGImage>) -> Option<CFRetained<CGColorSpace>> {
        extern "C-unwind" {
            fn CGImageGetColorSpace(image: Option<&CGImage>) -> Option<NonNull<CGColorSpace>>;
        }
        let ret = unsafe { CGImageGetColorSpace(image) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CGImageGetAlphaInfo")]
    #[inline]
    pub fn alpha_info(image: Option<&CGImage>) -> CGImageAlphaInfo {
        extern "C-unwind" {
            fn CGImageGetAlphaInfo(image: Option<&CGImage>) -> CGImageAlphaInfo;
        }
        unsafe { CGImageGetAlphaInfo(image) }
    }

    #[doc(alias = "CGImageGetDataProvider")]
    #[cfg(feature = "CGDataProvider")]
    #[inline]
    pub fn data_provider(image: Option<&CGImage>) -> Option<CFRetained<CGDataProvider>> {
        extern "C-unwind" {
            fn CGImageGetDataProvider(image: Option<&CGImage>) -> Option<NonNull<CGDataProvider>>;
        }
        let ret = unsafe { CGImageGetDataProvider(image) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CGImageGetDecode")]
    #[inline]
    pub fn decode(image: Option<&CGImage>) -> *const CGFloat {
        extern "C-unwind" {
            fn CGImageGetDecode(image: Option<&CGImage>) -> *const CGFloat;
        }
        unsafe { CGImageGetDecode(image) }
    }

    #[doc(alias = "CGImageGetShouldInterpolate")]
    #[inline]
    pub fn should_interpolate(image: Option<&CGImage>) -> bool {
        extern "C-unwind" {
            fn CGImageGetShouldInterpolate(image: Option<&CGImage>) -> bool;
        }
        unsafe { CGImageGetShouldInterpolate(image) }
    }

    #[doc(alias = "CGImageGetRenderingIntent")]
    #[cfg(feature = "CGColorSpace")]
    #[inline]
    pub fn rendering_intent(image: Option<&CGImage>) -> CGColorRenderingIntent {
        extern "C-unwind" {
            fn CGImageGetRenderingIntent(image: Option<&CGImage>) -> CGColorRenderingIntent;
        }
        unsafe { CGImageGetRenderingIntent(image) }
    }

    #[doc(alias = "CGImageGetBitmapInfo")]
    #[inline]
    pub fn bitmap_info(image: Option<&CGImage>) -> CGBitmapInfo {
        extern "C-unwind" {
            fn CGImageGetBitmapInfo(image: Option<&CGImage>) -> CGBitmapInfo;
        }
        unsafe { CGImageGetBitmapInfo(image) }
    }

    #[doc(alias = "CGImageGetByteOrderInfo")]
    #[inline]
    pub fn byte_order_info(image: Option<&CGImage>) -> CGImageByteOrderInfo {
        extern "C-unwind" {
            fn CGImageGetByteOrderInfo(image: Option<&CGImage>) -> CGImageByteOrderInfo;
        }
        unsafe { CGImageGetByteOrderInfo(image) }
    }

    #[doc(alias = "CGImageGetPixelFormatInfo")]
    #[inline]
    pub fn pixel_format_info(image: Option<&CGImage>) -> CGImagePixelFormatInfo {
        extern "C-unwind" {
            fn CGImageGetPixelFormatInfo(image: Option<&CGImage>) -> CGImagePixelFormatInfo;
        }
        unsafe { CGImageGetPixelFormatInfo(image) }
    }

    #[doc(alias = "CGImageShouldToneMap")]
    #[inline]
    pub fn should_tone_map(image: Option<&CGImage>) -> bool {
        extern "C-unwind" {
            fn CGImageShouldToneMap(image: Option<&CGImage>) -> bool;
        }
        unsafe { CGImageShouldToneMap(image) }
    }

    #[doc(alias = "CGImageContainsImageSpecificToneMappingMetadata")]
    #[inline]
    pub fn contains_image_specific_tone_mapping_metadata(image: Option<&CGImage>) -> bool {
        extern "C-unwind" {
            fn CGImageContainsImageSpecificToneMappingMetadata(image: Option<&CGImage>) -> bool;
        }
        unsafe { CGImageContainsImageSpecificToneMappingMetadata(image) }
    }

    #[doc(alias = "CGImageGetUTType")]
    #[inline]
    pub fn ut_type(image: Option<&CGImage>) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CGImageGetUTType(image: Option<&CGImage>) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CGImageGetUTType(image) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }
}

#[cfg(all(feature = "CGColorSpace", feature = "CGDataProvider"))]
#[deprecated = "renamed to `CGImage::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CGImageCreate(
    width: usize,
    height: usize,
    bits_per_component: usize,
    bits_per_pixel: usize,
    bytes_per_row: usize,
    space: Option<&CGColorSpace>,
    bitmap_info: CGBitmapInfo,
    provider: Option<&CGDataProvider>,
    decode: *const CGFloat,
    should_interpolate: bool,
    intent: CGColorRenderingIntent,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreate(
            width: usize,
            height: usize,
            bits_per_component: usize,
            bits_per_pixel: usize,
            bytes_per_row: usize,
            space: Option<&CGColorSpace>,
            bitmap_info: CGBitmapInfo,
            provider: Option<&CGDataProvider>,
            decode: *const CGFloat,
            should_interpolate: bool,
            intent: CGColorRenderingIntent,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe {
        CGImageCreate(
            width,
            height,
            bits_per_component,
            bits_per_pixel,
            bytes_per_row,
            space,
            bitmap_info,
            provider,
            decode,
            should_interpolate,
            intent,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CGDataProvider")]
#[deprecated = "renamed to `CGImage::mask_create`"]
#[inline]
pub unsafe extern "C-unwind" fn CGImageMaskCreate(
    width: usize,
    height: usize,
    bits_per_component: usize,
    bits_per_pixel: usize,
    bytes_per_row: usize,
    provider: Option<&CGDataProvider>,
    decode: *const CGFloat,
    should_interpolate: bool,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageMaskCreate(
            width: usize,
            height: usize,
            bits_per_component: usize,
            bits_per_pixel: usize,
            bytes_per_row: usize,
            provider: Option<&CGDataProvider>,
            decode: *const CGFloat,
            should_interpolate: bool,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe {
        CGImageMaskCreate(
            width,
            height,
            bits_per_component,
            bits_per_pixel,
            bytes_per_row,
            provider,
            decode,
            should_interpolate,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGImage::new_copy`"]
#[inline]
pub extern "C-unwind" fn CGImageCreateCopy(image: Option<&CGImage>) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateCopy(image: Option<&CGImage>) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateCopy(image) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CGColorSpace", feature = "CGDataProvider"))]
#[deprecated = "renamed to `CGImage::with_jpeg_data_provider`"]
#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateWithJPEGDataProvider(
    source: Option<&CGDataProvider>,
    decode: *const CGFloat,
    should_interpolate: bool,
    intent: CGColorRenderingIntent,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateWithJPEGDataProvider(
            source: Option<&CGDataProvider>,
            decode: *const CGFloat,
            should_interpolate: bool,
            intent: CGColorRenderingIntent,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret =
        unsafe { CGImageCreateWithJPEGDataProvider(source, decode, should_interpolate, intent) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CGColorSpace", feature = "CGDataProvider"))]
#[deprecated = "renamed to `CGImage::with_png_data_provider`"]
#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateWithPNGDataProvider(
    source: Option<&CGDataProvider>,
    decode: *const CGFloat,
    should_interpolate: bool,
    intent: CGColorRenderingIntent,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateWithPNGDataProvider(
            source: Option<&CGDataProvider>,
            decode: *const CGFloat,
            should_interpolate: bool,
            intent: CGColorRenderingIntent,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret =
        unsafe { CGImageCreateWithPNGDataProvider(source, decode, should_interpolate, intent) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGImage::with_image_in_rect`"]
#[inline]
pub extern "C-unwind" fn CGImageCreateWithImageInRect(
    image: Option<&CGImage>,
    rect: CGRect,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateWithImageInRect(
            image: Option<&CGImage>,
            rect: CGRect,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateWithImageInRect(image, rect) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGImage::with_mask`"]
#[inline]
pub extern "C-unwind" fn CGImageCreateWithMask(
    image: Option<&CGImage>,
    mask: Option<&CGImage>,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateWithMask(
            image: Option<&CGImage>,
            mask: Option<&CGImage>,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateWithMask(image, mask) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGImage::with_masking_colors`"]
#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateWithMaskingColors(
    image: Option<&CGImage>,
    components: *const CGFloat,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateWithMaskingColors(
            image: Option<&CGImage>,
            components: *const CGFloat,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateWithMaskingColors(image, components) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CGColorSpace")]
#[deprecated = "renamed to `CGImage::new_copy_with_color_space`"]
#[inline]
pub extern "C-unwind" fn CGImageCreateCopyWithColorSpace(
    image: Option<&CGImage>,
    space: Option<&CGColorSpace>,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateCopyWithColorSpace(
            image: Option<&CGImage>,
            space: Option<&CGColorSpace>,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateCopyWithColorSpace(image, space) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CGColorSpace", feature = "CGDataProvider"))]
#[deprecated = "renamed to `CGImage::with_content_headroom`"]
#[inline]
pub unsafe extern "C-unwind" fn CGImageCreateWithContentHeadroom(
    headroom: c_float,
    width: usize,
    height: usize,
    bits_per_component: usize,
    bits_per_pixel: usize,
    bytes_per_row: usize,
    space: Option<&CGColorSpace>,
    bitmap_info: CGBitmapInfo,
    provider: Option<&CGDataProvider>,
    decode: *const CGFloat,
    should_interpolate: bool,
    intent: CGColorRenderingIntent,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateWithContentHeadroom(
            headroom: c_float,
            width: usize,
            height: usize,
            bits_per_component: usize,
            bits_per_pixel: usize,
            bytes_per_row: usize,
            space: Option<&CGColorSpace>,
            bitmap_info: CGBitmapInfo,
            provider: Option<&CGDataProvider>,
            decode: *const CGFloat,
            should_interpolate: bool,
            intent: CGColorRenderingIntent,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe {
        CGImageCreateWithContentHeadroom(
            headroom,
            width,
            height,
            bits_per_component,
            bits_per_pixel,
            bytes_per_row,
            space,
            bitmap_info,
            provider,
            decode,
            should_interpolate,
            intent,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGImage::new_copy_with_content_headroom`"]
#[inline]
pub extern "C-unwind" fn CGImageCreateCopyWithContentHeadroom(
    headroom: c_float,
    image: Option<&CGImage>,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateCopyWithContentHeadroom(
            headroom: c_float,
            image: Option<&CGImage>,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateCopyWithContentHeadroom(headroom, image) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGImage::content_headroom`"]
#[inline]
pub extern "C-unwind" fn CGImageGetContentHeadroom(image: Option<&CGImage>) -> c_float {
    extern "C-unwind" {
        fn CGImageGetContentHeadroom(image: Option<&CGImage>) -> c_float;
    }
    unsafe { CGImageGetContentHeadroom(image) }
}

#[deprecated = "renamed to `CGImage::calculate_content_headroom`"]
#[inline]
pub extern "C-unwind" fn CGImageCalculateContentHeadroom(image: Option<&CGImage>) -> c_float {
    extern "C-unwind" {
        fn CGImageCalculateContentHeadroom(image: Option<&CGImage>) -> c_float;
    }
    unsafe { CGImageCalculateContentHeadroom(image) }
}

#[deprecated = "renamed to `CGImage::content_average_light_level`"]
#[inline]
pub extern "C-unwind" fn CGImageGetContentAverageLightLevel(image: Option<&CGImage>) -> c_float {
    extern "C-unwind" {
        fn CGImageGetContentAverageLightLevel(image: Option<&CGImage>) -> c_float;
    }
    unsafe { CGImageGetContentAverageLightLevel(image) }
}

#[deprecated = "renamed to `CGImage::calculate_content_average_light_level`"]
#[inline]
pub extern "C-unwind" fn CGImageCalculateContentAverageLightLevel(
    image: Option<&CGImage>,
) -> c_float {
    extern "C-unwind" {
        fn CGImageCalculateContentAverageLightLevel(image: Option<&CGImage>) -> c_float;
    }
    unsafe { CGImageCalculateContentAverageLightLevel(image) }
}

#[deprecated = "renamed to `CGImage::new_copy_with_content_average_light_level`"]
#[inline]
pub extern "C-unwind" fn CGImageCreateCopyWithContentAverageLightLevel(
    image: Option<&CGImage>,
    avll: c_float,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateCopyWithContentAverageLightLevel(
            image: Option<&CGImage>,
            avll: c_float,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateCopyWithContentAverageLightLevel(image, avll) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGImage::new_copy_with_calculated_hdr_stats`"]
#[inline]
pub extern "C-unwind" fn CGImageCreateCopyWithCalculatedHDRStats(
    image: Option<&CGImage>,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGImageCreateCopyWithCalculatedHDRStats(
            image: Option<&CGImage>,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret = unsafe { CGImageCreateCopyWithCalculatedHDRStats(image) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGImage::is_mask`"]
#[inline]
pub extern "C-unwind" fn CGImageIsMask(image: Option<&CGImage>) -> bool {
    extern "C-unwind" {
        fn CGImageIsMask(image: Option<&CGImage>) -> bool;
    }
    unsafe { CGImageIsMask(image) }
}

#[deprecated = "renamed to `CGImage::width`"]
#[inline]
pub extern "C-unwind" fn CGImageGetWidth(image: Option<&CGImage>) -> usize {
    extern "C-unwind" {
        fn CGImageGetWidth(image: Option<&CGImage>) -> usize;
    }
    unsafe { CGImageGetWidth(image) }
}

#[deprecated = "renamed to `CGImage::height`"]
#[inline]
pub extern "C-unwind" fn CGImageGetHeight(image: Option<&CGImage>) -> usize {
    extern "C-unwind" {
        fn CGImageGetHeight(image: Option<&CGImage>) -> usize;
    }
    unsafe { CGImageGetHeight(image) }
}

#[deprecated = "renamed to `CGImage::bits_per_component`"]
#[inline]
pub extern "C-unwind" fn CGImageGetBitsPerComponent(image: Option<&CGImage>) -> usize {
    extern "C-unwind" {
        fn CGImageGetBitsPerComponent(image: Option<&CGImage>) -> usize;
    }
    unsafe { CGImageGetBitsPerComponent(image) }
}

#[deprecated = "renamed to `CGImage::bits_per_pixel`"]
#[inline]
pub extern "C-unwind" fn CGImageGetBitsPerPixel(image: Option<&CGImage>) -> usize {
    extern "C-unwind" {
        fn CGImageGetBitsPerPixel(image: Option<&CGImage>) -> usize;
    }
    unsafe { CGImageGetBitsPerPixel(image) }
}

#[deprecated = "renamed to `CGImage::bytes_per_row`"]
#[inline]
pub extern "C-unwind" fn CGImageGetBytesPerRow(image: Option<&CGImage>) -> usize {
    extern "C-unwind" {
        fn CGImageGetBytesPerRow(image: Option<&CGImage>) -> usize;
    }
    unsafe { CGImageGetBytesPerRow(image) }
}

#[cfg(feature = "CGColorSpace")]
#[deprecated = "renamed to `CGImage::color_space`"]
#[inline]
pub extern "C-unwind" fn CGImageGetColorSpace(
    image: Option<&CGImage>,
) -> Option<CFRetained<CGColorSpace>> {
    extern "C-unwind" {
        fn CGImageGetColorSpace(image: Option<&CGImage>) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGImageGetColorSpace(image) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CGImage::alpha_info`"]
#[inline]
pub extern "C-unwind" fn CGImageGetAlphaInfo(image: Option<&CGImage>) -> CGImageAlphaInfo {
    extern "C-unwind" {
        fn CGImageGetAlphaInfo(image: Option<&CGImage>) -> CGImageAlphaInfo;
    }
    unsafe { CGImageGetAlphaInfo(image) }
}

#[cfg(feature = "CGDataProvider")]
#[deprecated = "renamed to `CGImage::data_provider`"]
#[inline]
pub extern "C-unwind" fn CGImageGetDataProvider(
    image: Option<&CGImage>,
) -> Option<CFRetained<CGDataProvider>> {
    extern "C-unwind" {
        fn CGImageGetDataProvider(image: Option<&CGImage>) -> Option<NonNull<CGDataProvider>>;
    }
    let ret = unsafe { CGImageGetDataProvider(image) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CGImage::decode`"]
#[inline]
pub extern "C-unwind" fn CGImageGetDecode(image: Option<&CGImage>) -> *const CGFloat {
    extern "C-unwind" {
        fn CGImageGetDecode(image: Option<&CGImage>) -> *const CGFloat;
    }
    unsafe { CGImageGetDecode(image) }
}

#[deprecated = "renamed to `CGImage::should_interpolate`"]
#[inline]
pub extern "C-unwind" fn CGImageGetShouldInterpolate(image: Option<&CGImage>) -> bool {
    extern "C-unwind" {
        fn CGImageGetShouldInterpolate(image: Option<&CGImage>) -> bool;
    }
    unsafe { CGImageGetShouldInterpolate(image) }
}

#[cfg(feature = "CGColorSpace")]
#[deprecated = "renamed to `CGImage::rendering_intent`"]
#[inline]
pub extern "C-unwind" fn CGImageGetRenderingIntent(
    image: Option<&CGImage>,
) -> CGColorRenderingIntent {
    extern "C-unwind" {
        fn CGImageGetRenderingIntent(image: Option<&CGImage>) -> CGColorRenderingIntent;
    }
    unsafe { CGImageGetRenderingIntent(image) }
}

#[deprecated = "renamed to `CGImage::bitmap_info`"]
#[inline]
pub extern "C-unwind" fn CGImageGetBitmapInfo(image: Option<&CGImage>) -> CGBitmapInfo {
    extern "C-unwind" {
        fn CGImageGetBitmapInfo(image: Option<&CGImage>) -> CGBitmapInfo;
    }
    unsafe { CGImageGetBitmapInfo(image) }
}

#[deprecated = "renamed to `CGImage::byte_order_info`"]
#[inline]
pub extern "C-unwind" fn CGImageGetByteOrderInfo(image: Option<&CGImage>) -> CGImageByteOrderInfo {
    extern "C-unwind" {
        fn CGImageGetByteOrderInfo(image: Option<&CGImage>) -> CGImageByteOrderInfo;
    }
    unsafe { CGImageGetByteOrderInfo(image) }
}

#[deprecated = "renamed to `CGImage::pixel_format_info`"]
#[inline]
pub extern "C-unwind" fn CGImageGetPixelFormatInfo(
    image: Option<&CGImage>,
) -> CGImagePixelFormatInfo {
    extern "C-unwind" {
        fn CGImageGetPixelFormatInfo(image: Option<&CGImage>) -> CGImagePixelFormatInfo;
    }
    unsafe { CGImageGetPixelFormatInfo(image) }
}

#[deprecated = "renamed to `CGImage::should_tone_map`"]
#[inline]
pub extern "C-unwind" fn CGImageShouldToneMap(image: Option<&CGImage>) -> bool {
    extern "C-unwind" {
        fn CGImageShouldToneMap(image: Option<&CGImage>) -> bool;
    }
    unsafe { CGImageShouldToneMap(image) }
}

#[deprecated = "renamed to `CGImage::contains_image_specific_tone_mapping_metadata`"]
#[inline]
pub extern "C-unwind" fn CGImageContainsImageSpecificToneMappingMetadata(
    image: Option<&CGImage>,
) -> bool {
    extern "C-unwind" {
        fn CGImageContainsImageSpecificToneMappingMetadata(image: Option<&CGImage>) -> bool;
    }
    unsafe { CGImageContainsImageSpecificToneMappingMetadata(image) }
}

#[deprecated = "renamed to `CGImage::ut_type`"]
#[inline]
pub extern "C-unwind" fn CGImageGetUTType(image: Option<&CGImage>) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CGImageGetUTType(image: Option<&CGImage>) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CGImageGetUTType(image) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}
