// Copyright (c) ppy Pty Ltd <contact@ppy.sh>. Licensed under the MIT Licence.
// See the LICENCE file in the repository root for full licence text.

using System;
using osu.Game.Rulesets.Edit.Tools;
using osu.Game.Screens.Edit.Components.RadioButtons;

namespace osu.Game.Rulesets.Edit
{
    public class HitObjectCompositionToolButton : RadioButton
    {
        public CompositionTool Tool { get; }

        public HitObjectCompositionToolButton(CompositionTool tool, Action? action)
            : base(tool.Name, action, tool.CreateIcon)
        {
            Tool = tool;

            TooltipText = tool.TooltipText;
        }
    }
}
