/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.config;

import java.util.Collections;
import java.util.Locale;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleConnectionRole;
import org.jkiss.dbeaver.ext.oracle.ui.internal.OracleUIMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class OracleAuthDatabaseNativeConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private Combo userRoleCombo;

    public void createControl(@NotNull Composite parent, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        Label usernameLabel = UIUtils.createLabel((Composite)parent, (String)UIConnectionMessages.dialog_connection_auth_label_username);
        usernameLabel.setLayoutData((Object)new GridData(32));
        Composite userGroup = UIUtils.createComposite((Composite)parent, (int)3);
        userGroup.setLayoutData((Object)new GridData(768));
        this.createUserNameControls(userGroup, propertyChangeListener);
        Label userRoleLabel = UIUtils.createControlLabel((Composite)userGroup, (String)OracleUIMessages.dialog_connection_role);
        userRoleLabel.setLayoutData((Object)new GridData(128));
        this.userRoleCombo = new Combo(userGroup, 12);
        GridData gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.userRoleCombo) * 10;
        this.userRoleCombo.setLayoutData((Object)gd);
        this.userRoleCombo.add(OracleConnectionRole.NORMAL.getTitle());
        this.userRoleCombo.add(OracleConnectionRole.SYSDBA.getTitle());
        this.userRoleCombo.add(OracleConnectionRole.SYSOPER.getTitle());
        this.userRoleCombo.select(0);
        this.createPasswordControls(parent, propertyChangeListener);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        String roleName = dataSource.getConnectionConfiguration().getAuthProperty("oracle.logon-as");
        if (CommonUtils.isEmpty((String)roleName)) {
            roleName = dataSource.getConnectionConfiguration().getProviderProperty("@dbeaver-internal-logon@");
        }
        if (roleName != null) {
            this.userRoleCombo.setText(roleName.toUpperCase(Locale.ENGLISH));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        if (this.userRoleCombo.getSelectionIndex() > 0) {
            dataSource.getConnectionConfiguration().setAuthProperties(Collections.singletonMap("oracle.logon-as", this.userRoleCombo.getText().toLowerCase(Locale.ENGLISH)));
        } else {
            dataSource.getConnectionConfiguration().setAuthProperties(Collections.emptyMap());
        }
        dataSource.getConnectionConfiguration().removeProviderProperty("@dbeaver-internal-logon@");
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.resetSettings(dataSource);
    }
}

