/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jkiss.dbeaver.ui.editors.json.JSONSourceViewerConfiguration;
import org.jkiss.utils.CommonUtils;

public class JSONFormattingStrategy
extends ContextBasedFormattingStrategy {
    private ISourceViewer sourceViewer;
    private JSONSourceViewerConfiguration svConfig;
    public static Gson GSON_FORMATTED = new GsonBuilder().serializeNulls().disableHtmlEscaping().setPrettyPrinting().setStrictness(Strictness.LENIENT).create();
    public static Gson GSON_UNFORMATTED = new GsonBuilder().serializeNulls().disableHtmlEscaping().setStrictness(Strictness.LENIENT).create();

    JSONFormattingStrategy(ISourceViewer sourceViewer, JSONSourceViewerConfiguration svConfig) {
        this.sourceViewer = sourceViewer;
        this.svConfig = svConfig;
    }

    public void formatterStarts(String initialIndentation) {
    }

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        if (CommonUtils.isEmpty((String)content)) {
            return content;
        }
        JsonElement jsonElement = JsonParser.parseString((String)content);
        return GSON_FORMATTED.toJson(jsonElement);
    }

    public void formatterStops() {
    }
}

