
/*
 * de.unkrig.commons - A general-purpose Java class library
 *
 * Copyright (c) 2019, Arno Unkrig
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
 * following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
 *       following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
 *       following disclaimer in the documentation and/or other materials provided with the distribution.
 *    3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package de.unkrig.commons.lang.protocol;

import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.nullanalysis.Nullable;

/**
 * A container for two elements
 *
 * @param <T1> Type of the first element
 * @param <T2> Type of the second element
 */
public final
class Tuple2<T1, T2> {

    /**
     * The first element of the tuple.
     */
    public final T1 first;

    /**
     * The second element of the tuple.
     */
    public final T2 second;

    public
    Tuple2(T1 first, T2 second) {
        this.first  = first;
        this.second = second;
    }

    @Override public boolean
    equals(@Nullable Object obj) {
        if (!(obj instanceof Tuple2)) return false;
        @SuppressWarnings("unchecked") Tuple2<T1, T2> that = (Tuple2<T1, T2>) obj;
        return ObjectUtil.equals(this.first, that.first) && ObjectUtil.equals(this.second, that.second);
    }

    @Override public int
    hashCode() { return ObjectUtil.hashCode(this.first) + ObjectUtil.hashCode(this.second); }

    @Override public String
    toString() {
        return this.first + ":" + this.second;
    }
}
