/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging.filter;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.Expression;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.util.logging.LogUtil;
import java.util.logging.Filter;
import java.util.logging.LogRecord;

public class ByExpressionFilter
implements Filter {
    private Expression condition;

    public ByExpressionFilter() throws ParseException {
        this((String)null);
    }

    public ByExpressionFilter(@Nullable String propertyNamePrefix) throws ParseException {
        if (propertyNamePrefix == null) {
            propertyNamePrefix = this.getClass().getName();
        }
        try {
            this.condition = LogUtil.parseLoggingProperty(propertyNamePrefix + ".condition", "name", "level", "class", "method", "message", "params");
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw pe;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
    }

    public ByExpressionFilter(@Nullable Expression condition) {
        if (condition == null) {
            throw new NullPointerException("condition");
        }
        this.condition = condition;
    }

    @Override
    @NotNullByDefault(value=false)
    public boolean isLoggable(LogRecord record) {
        try {
            return ExpressionEvaluator.toBoolean(this.condition.evaluate("name", record.getLoggerName(), "level", record.getLevel().getName(), "class", record.getSourceClassName(), "method", record.getSourceMethodName(), "message", record.getMessage(), "params", record.getParameters()));
        }
        catch (EvaluationException e) {
            return false;
        }
    }
}

