/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.TransformingFilterReader;
import de.unkrig.commons.io.TransformingFilterWriter;
import de.unkrig.commons.lang.protocol.Function;
import de.unkrig.commons.lang.protocol.FunctionWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.pattern.Substitutor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PatternUtil {
    public static final Function<MatchResult, String> SYSTEM_PROPERTY_MATCH_REPLACER = new Function<MatchResult, String>(){

        @Override
        @Nullable
        public String call(@Nullable MatchResult matchResult) {
            assert (matchResult != null);
            return System.getProperty(matchResult.group(1));
        }
    };

    private PatternUtil() {
    }

    @Deprecated
    public static Function<MatchResult, String> constantReplacer(@Nullable String string) {
        return PatternUtil.constantMatchReplacer(string);
    }

    public static Function<MatchResult, String> constantMatchReplacer(final @Nullable String string) {
        return new Function<MatchResult, String>(){

            @Override
            @Nullable
            public String call(@Nullable MatchResult matchResult) {
                return string;
            }
        };
    }

    @Deprecated
    public static <EX extends Throwable> FunctionWhichThrows<MatchResult, String, ? extends EX> replacementStringReplacer(String replacementString) {
        return PatternUtil.replacementStringMatchReplacer(replacementString);
    }

    public static <EX extends Throwable> FunctionWhichThrows<MatchResult, String, ? extends EX> replacementStringMatchReplacer(final String replacementString) {
        return new FunctionWhichThrows<MatchResult, String, EX>(){

            @Override
            @Nullable
            public String call(@Nullable MatchResult matchResult) {
                assert (matchResult != null);
                StringBuffer result = new StringBuffer();
                int idx = 0;
                while (idx < replacementString.length()) {
                    char c = replacementString.charAt(idx);
                    if (c == '\\') {
                        result.append(replacementString.charAt(++idx));
                        ++idx;
                        continue;
                    }
                    if (c == '$') {
                        String group;
                        int nextDigit;
                        int referenceNumber;
                        if ((referenceNumber = replacementString.charAt(++idx) - 48) < 0 || referenceNumber > 9) {
                            throw new IllegalArgumentException("Illegal group reference");
                        }
                        ++idx;
                        while (idx < replacementString.length() && (nextDigit = replacementString.charAt(idx) - 48) >= 0 && nextDigit <= 9) {
                            int newRefNum = referenceNumber * 10 + nextDigit;
                            if (matchResult.groupCount() < newRefNum) break;
                            referenceNumber = newRefNum;
                            ++idx;
                        }
                        if ((group = matchResult.group(referenceNumber)) == null) continue;
                        result.append(group);
                        continue;
                    }
                    result.append(c);
                    ++idx;
                }
                return result.toString();
            }
        };
    }

    @Deprecated
    public static Function<MatchResult, String> systemPropertyReplacer() {
        return SYSTEM_PROPERTY_MATCH_REPLACER;
    }

    public static long replaceAll(Reader in, Pattern pattern, String replacementString, Appendable out) throws IOException {
        return PatternUtil.replaceSome(in, pattern, PatternUtil.replacementStringMatchReplacer(replacementString), out, 8192);
    }

    public static long replaceSystemProperties(Reader in, Appendable out) throws IOException {
        return PatternUtil.replaceSome(in, Pattern.compile("\\$\\{([^}]+)}", 8), SYSTEM_PROPERTY_MATCH_REPLACER, out, 4096);
    }

    public static <EX extends Throwable> String replaceSome(Matcher matcher, FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends EX> matchReplacer) throws EX {
        matcher.reset();
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        while (result) {
            CharSequence replacement = matchReplacer.call(matcher);
            if (replacement != null) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement.toString()));
            }
            result = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static <EX extends Throwable> int replaceSome(Reader in, Pattern pattern, FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends EX> matchReplacer, Appendable out, int bufferCapacity) throws IOException, EX {
        Substitutor<EX> substitutor = Substitutor.create(pattern, matchReplacer);
        IoUtil.copyAndTransform(in, substitutor, out, bufferCapacity);
        return substitutor.substitutionCount();
    }

    public static Reader replaceAllFilterReader(Reader delegate, Pattern pattern, FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends IOException> matchReplacer) {
        return TransformingFilterReader.create(delegate, Substitutor.create(pattern, matchReplacer));
    }

    public static Writer replaceAllFilterWriter(Pattern pattern, FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends IOException> matchReplacer, Appendable delegate) {
        return TransformingFilterWriter.create(Substitutor.create(pattern, matchReplacer), delegate);
    }

    public static <EX extends Throwable> Substitutor<EX> substitutor(Pattern pattern, String replacementString) {
        return Substitutor.create(pattern, PatternUtil.replacementStringMatchReplacer(replacementString));
    }
}

